/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.ui.crypto;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.softforum.sample.R;
import com.softforum.xecure.ui.crypto.ActivityData;
import com.softforum.xecure.util.BlockerActivityResult;
import com.softforum.xecure.util.BlockerActivityUtil;
import com.softforum.xecure.util.CallBack;
import com.softforum.xecure.util.XCoreUtil;
import com.softforum.xecure.util.XUtil;

public class PKCS11Password
extends Activity {
    public static final int mPKCS11Pas_swor_dID = 90000;
    public static final int RESULT_TOKEN_LOCKED = 100;
    private int m_P_assW_ordTryCount = 0;
    private CallBack mCallBack = null;
    private BlockerActivityResult mBlockerParam = null;

    public void onCreate(Bundle savedInstanceState) {
        String aParamKey;
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.pkcs11_password);
        Button aOKButton = (Button)this.findViewById(R.id.input_password_ok_btn);
        Button aCancelButton = (Button)this.findViewById(R.id.input_password_cancel_btn);
        aOKButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PKCS11Password.this.onOKButtonClick(v);
            }
        });
        aCancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PKCS11Password.this.mBlockerParam == null) {
                    PKCS11Password.this.setResult(0);
                } else {
                    PKCS11Password.this.mBlockerParam.setBlockerResult(0);
                }
                PKCS11Password.this.finish();
            }
        });
        Intent receivedIntent = this.getIntent();
        String aCallBackKey = receivedIntent.getStringExtra("callback");
        if (aCallBackKey != null) {
            this.mCallBack = (CallBack)ActivityData.parameters.get(aCallBackKey);
            ActivityData.parameters.remove(aCallBackKey);
        }
        if ((aParamKey = receivedIntent.getStringExtra("activity_data_param_key")) != null) {
            this.mBlockerParam = BlockerActivityUtil.getParam((Context)this, (Intent)receivedIntent);
        }
        if (XCoreUtil.getInstance().isSoftwareTokenPINLocked()) {
            final PKCS11Password _this = this;
            new AlertDialog.Builder((Context)this).setTitle(R.string.xecure_smart_cert_mgr_confirm_caution).setPositiveButton(R.string.xecure_smart_cert_mgr_confirm_ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    String aMessage = "";
                    int aResult = XCoreUtil.getInstance().initSoftwareToken();
                    aMessage = aResult == 0 ? PKCS11Password.this.getString(R.string.pkcs11_initialized) : PKCS11Password.this.getString(R.string.pkcs11_init_failed);
                    new AlertDialog.Builder((Context)_this).setTitle(R.string.xecure_smart_cert_mgr_confirm_caution).setPositiveButton(R.string.xecure_smart_cert_mgr_confirm_ok, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                        }
                    }).setMessage((CharSequence)aMessage).show();
                }
            }).setNegativeButton(R.string.xecure_smart_cert_mgr_confirm_cancel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    PKCS11Password.this.setResult(100);
                    PKCS11Password.this.finish();
                }
            }).setMessage((CharSequence)this.getString(R.string.pkcs11_token_is_locked)).show();
            return;
        }
    }

    public void finish() {
        if (this.mBlockerParam != null) {
            BlockerActivityUtil.finishBlockerActivity((Object)this.mBlockerParam);
        }
        super.finish();
    }

    private void onOKButtonClick(View v) {
        String aPassword = ((TextView)this.findViewById(R.id.input_password_edittext)).getText().toString();
        if (aPassword.length() > 0) {
            if (XUtil.checkPasswordFormat((String)aPassword) == 0 && XCoreUtil.getInstance().loginPKCS11("Softforum PKCS#11", aPassword) == 0) {
                if (this.mCallBack != null) {
                    this.mCallBack.onCallBack();
                }
                if (this.mBlockerParam == null) {
                    this.setResult(-1);
                } else {
                    this.mBlockerParam.setBlockerResult(-1);
                }
                this.finish();
            } else {
                if (this.mBlockerParam == null) {
                    this.setResult(0);
                } else {
                    this.mBlockerParam.setBlockerResult(0);
                }
                if (++this.m_P_assW_ordTryCount == 3) {
                    XCoreUtil.getInstance().lockSoftwareTokenPIN();
                    new AlertDialog.Builder((Context)this).setTitle(R.string.xecure_smart_cert_mgr_confirm_caution).setPositiveButton(R.string.xecure_smart_cert_mgr_confirm_ok, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            PKCS11Password.this.setResult(100);
                            PKCS11Password.this.finish();
                        }
                    }).setMessage(R.string.pkcs11_will_be_locked).show();
                    return;
                }
                new AlertDialog.Builder((Context)this).setTitle(R.string.xecure_smart_cert_mgr_confirm_caution).setPositiveButton(R.string.xecure_smart_cert_mgr_confirm_ok, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        ((TextView)PKCS11Password.this.findViewById(R.id.input_password_edittext)).setText((CharSequence)"");
                    }
                }).setMessage((CharSequence)this.getString(R.string.pkcs11_incorrect_password)).show();
            }
        }
    }
}

