/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.ui.crypto;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.softforum.sample.R;
import com.softforum.xecure.XecureSmart;
import com.softforum.xecure.crypto.XSFileSign;
import com.softforum.xecure.util.BlockerActivityResult;
import com.softforum.xecure.util.BlockerActivityUtil;
import com.softforum.xecure.util.XSLog;

public class XecureSmartFileSign
extends Activity {
    public static final String mSessionIDKey = "session_id_key";
    public static final String mXaddrKey = "xaddr_key";
    public static final String mInFilePathKey = "infile_path_key";
    public static final String mOutDirKey = "out_dir_key";
    public static final String mSignOptionKey = "sign_option_key";
    public static final String mMediaIDKey = "media_id_key";
    public static final String mSubjectDNKey = "subject_dn_key";
    public static final String m_P_assW_ordKey = "password_key";
    public static final String mResultKey = "result_key";
    private static final int mStatusStartProgress = 1;
    private static final int mStatusOnProgress = 2;
    private static final int mStatusDone = 3;
    private static final int mStatusCanceled = 4;
    private boolean mStopProgressFlag = false;
    private long mSessionID;
    private int mSignOption;
    private String mXaddr;
    private String mInFilePath;
    private String mOutFilePath;
    private int mMediaID;
    private String mSubjectDN;
    private byte[] m_P_assW_ord;
    private String mResult = "";
    private BlockerActivityResult mBlockerParam;
    private XSFileSign mXSFileSign;
    private TextView mTextViewMsg;
    private ProgressBar mProgressBar;
    private TextView mTextViewFileName;
    private TextView mTextViewPercent;
    private Button mCancelButton;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Thread statusThread = new Thread(new setProgressRunnable());
                    statusThread.start();
                    break;
                }
                case 2: {
                    if (XecureSmartFileSign.this.mXSFileSign.getProgressStatus() == 1) {
                        XecureSmartFileSign.this.mTextViewMsg.setText(R.string.file_sign_progress_make_digest);
                    } else if (XecureSmartFileSign.this.mXSFileSign.getProgressStatus() == 2) {
                        XecureSmartFileSign.this.mTextViewMsg.setText(R.string.file_sign_progress_save_file);
                    }
                    XecureSmartFileSign.this.mTextViewFileName.setText((CharSequence)XecureSmartFileSign.this.mXSFileSign.getFileName());
                    int aPercent = XecureSmartFileSign.this.mXSFileSign.getPercent();
                    XecureSmartFileSign.this.mProgressBar.setProgress(aPercent);
                    XecureSmartFileSign.this.mTextViewPercent.setText((CharSequence)(String.valueOf(aPercent) + "%"));
                    break;
                }
                case 3: {
                    XecureSmartFileSign.this.finish(-1);
                }
                case 4: {
                    XecureSmartFileSign.this.finish(0);
                }
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.file_progress_dialog);
        Intent receivedIntent = this.getIntent();
        this.mBlockerParam = BlockerActivityUtil.getParam((Context)this, (Intent)receivedIntent);
        this.mSessionID = receivedIntent.getLongExtra(mSessionIDKey, -1L);
        this.mXaddr = receivedIntent.getStringExtra(mXaddrKey);
        this.mInFilePath = receivedIntent.getStringExtra(mInFilePathKey);
        this.mOutFilePath = receivedIntent.getStringExtra(mOutDirKey);
        this.mMediaID = receivedIntent.getIntExtra(mMediaIDKey, XecureSmart.mDefaultMediaID);
        this.mSubjectDN = receivedIntent.getStringExtra(mSubjectDNKey);
        this.m_P_assW_ord = receivedIntent.getByteArrayExtra(m_P_assW_ordKey);
        this.mXSFileSign = new XSFileSign(this.mSessionID);
        this.mTextViewMsg = (TextView)this.findViewById(R.id.file_progress_msg);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.file_progress_bar);
        this.mProgressBar.setMax(100);
        this.mProgressBar.setProgress(0);
        this.mTextViewFileName = (TextView)this.findViewById(R.id.file_progress_name);
        this.mTextViewPercent = (TextView)this.findViewById(R.id.file_progress_percent);
        this.mCancelButton = (Button)this.findViewById(R.id.file_progress_cancel_btn);
        this.mCancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XecureSmartFileSign.this.onCancelButtonClick(v);
            }
        });
        this.runFileSign();
    }

    public void finish(int activityResult) {
        this.mStopProgressFlag = true;
        Intent aIntent = new Intent((Context)this, XecureSmartFileSign.class);
        aIntent.putExtra(mResultKey, this.mResult);
        this.mBlockerParam.setBlockerResult(activityResult, aIntent);
        BlockerActivityUtil.finishBlockerActivity((Object)this.mBlockerParam);
        super.finish();
    }

    private void runFileSign() {
        Thread signThread = new Thread(new FileSignRunnable());
        signThread.start();
    }

    private void onCancelButtonClick(View v) {
        this.mXSFileSign.cancel();
    }

    private class setProgressRunnable
    implements Runnable {
        private setProgressRunnable() {
        }

        @Override
        public void run() {
            while (!XecureSmartFileSign.this.mStopProgressFlag) {
                XecureSmartFileSign.this.mHandler.sendEmptyMessage(2);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    XSLog.e((String)"InterruptedException in progress");
                }
            }
        }
    }

    private class FileSignRunnable
    implements Runnable {
        private FileSignRunnable() {
        }

        @Override
        public void run() {
            XecureSmartFileSign.this.mHandler.sendEmptyMessage(1);
            XecureSmartFileSign.this.mResult = XecureSmartFileSign.this.mXSFileSign.fileSign(XecureSmartFileSign.this.mSignOption, XecureSmartFileSign.this.mXaddr, XecureSmartFileSign.this.mInFilePath, XecureSmartFileSign.this.mOutFilePath, XecureSmartFileSign.this.mMediaID, XecureSmartFileSign.this.mSubjectDN, XecureSmartFileSign.this.m_P_assW_ord);
            if (XecureSmartFileSign.this.mResult.equals("CANCEL")) {
                XecureSmartFileSign.this.mHandler.sendEmptyMessage(4);
            } else {
                XecureSmartFileSign.this.mHandler.sendEmptyMessage(3);
            }
        }
    }
}

