/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.ui.transkey;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import android.widget.Toast;
import com.consortium.smartusim.SmartUsim;
import com.consortium.smartusim.SmartUsimListener;
import com.consortium.smartusim.SmartUsimResultCode;
import com.softforum.sample.R;
import com.softforum.xecure.core.CoreWrapper;
import com.softforum.xecure.crypto.CertMgr;
import com.softforum.xecure.ui.XTopView;
import com.softforum.xecure.ui.transkey.TransKeyResultInterface;
import com.softforum.xecure.ui.transkey.TransKeyUtil;
import com.softforum.xecure.util.EnvironmentConfig;
import com.softforum.xecure.util.ImageTextSpinnerAdapter;
import com.softforum.xecure.util.XCoreUtil;
import com.softforum.xecure.util.XDetailData;
import com.softforum.xecure.util.XSLog;
import com.softforum.xecure.util.XUtil;
import java.util.ArrayList;
import java.util.HashMap;

public class CopyCertToUsimWithTranskey
extends Activity
implements TransKeyResultInterface {
    public static final int mXecureSmartCopyCertoUsimID = 130000;
    private SmartUsim mSmartUsim = null;
    private int m_P_assW_ordTryCount;
    private XDetailData mSelectedData;
    private byte[] m_P_assW_ord = null;
    private byte[] mSmartPassword = null;
    private int mSrcMediaID;
    public Handler mHandler = new Handler();
    private final String mServerAddress = "58.229.178.45";
    private final int mServerPort = 25189;
    private final int END_BIND = 101;
    private final int flag_JOIN = 102;
    public static final int RESULT_PASSWD_FAIL = 2;
    public static final String mMediaIDKey = "sign_cert_password_media_id_key";
    public static final String mSelectedCertDataKey = "sign_cert_password_selected_cert_data_key";
    public static final String m_P_assW_ordKey = "sign_cert_password_password_key";
    private byte[] mCertificateDER = null;
    private byte[] mKeyDER = null;
    private XCoreUtil mCoreUtil = new XCoreUtil();
    protected static final int PINCODE_LOCK_ERROR = 0;
    private TransKeyUtil mTransKeyUtil = new TransKeyUtil();
    private final int MEDIA_DREAMSECURITY_USIM = 0;
    private final int MEDIA_RAONSECURE_USIM = 1;
    private int SELECT_BENDER;
    private final int DREAMSECURE = 0;
    private final int RAONSECURE = 1;
    private final int[] mTransKeyTextIds = new int[]{R.id.smart_password_edittext, R.id.password_edittext};
    private final int[] mTransKeyTextStrings = new int[]{R.string.smart_password, R.string.cert_password};
    private final int[] mTransKeyMaxLength = new int[]{150, 150};
    public SmartUsimListener mSmartUsimListener = new SmartUsimListener(){

        public void onSmartUsimResult(int requestCode, SmartUsimResultCode resultCode) {
            switch (requestCode) {
                case 3: {
                    if (resultCode.getResultCode() == 0) {
                        CopyCertToUsimWithTranskey.this.mSmartUsim.bindService("58.229.178.45", 25189);
                        break;
                    }
                    CopyCertToUsimWithTranskey.this.showToast("\uc2a4\ub9c8\ud2b8\uc778\uc99d\uc571\uc774 \uc124\uce58\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.\n\ud655\uc778 \ud6c4 \uc774\uc6a9\ud574 \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.\n[" + resultCode.getResultCode() + "]");
                    break;
                }
                case 1: {
                    if (resultCode.getResultCode() == 0) {
                        new AlertDialog.Builder((Context)CopyCertToUsimWithTranskey.this).setTitle((CharSequence)"\uc54c\ub9bc").setMessage((CharSequence)"\uc120\ud0dd\ud558\uc2e0 \uc778\uc99d\uc11c\ub97c USIM\uc5d0 \uc800\uc7a5\ud569\ub2c8\ub2e4. \uacc4\uc18d\ud558\uc2dc\uaca0\uc2b5\ub2c8\uae4c?").setPositiveButton((CharSequence)"YES", new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                                CopyCertToUsimWithTranskey.this.copyCertToUsim();
                            }
                        }).setNegativeButton((CharSequence)"NO", null).show();
                        break;
                    }
                    CopyCertToUsimWithTranskey.this.showToast("\ubc14\uc778\ub4dc \uc2e4\ud328\uacf5\ud1b5 /Vendor \ucf54\ub4dc : " + resultCode.getResultCode() + "(" + resultCode.getResultCodeVendor() + ")");
                }
            }
        }
    };

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.usim_cert_copy);
        this.m_P_assW_ordTryCount = 0;
        this.mSrcMediaID = this.getIntent().getIntExtra("mSrcMediaID", 1);
        this.mSelectedData = new XDetailData(this.getIntent().getStringArrayExtra(mSelectedCertDataKey), 0);
        ImageView aIcon = (ImageView)this.findViewById(R.id.icon);
        TextView aMainMsg = (TextView)this.findViewById(R.id.main_msg);
        TextView aSubMsg1 = (TextView)this.findViewById(R.id.sub_msg1);
        TextView aSubMsg2 = (TextView)this.findViewById(R.id.sub_msg2);
        if ("0".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_normal);
        } else if ("1".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_update);
        } else if ("2".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_revoke);
        }
        aMainMsg.setText((CharSequence)XUtil.getCNFromRDN((String)this.mSelectedData.getValue(7)));
        aSubMsg1.setText((CharSequence)(this.mSelectedData.getKeyText(4) + " : " + this.mSelectedData.getValue(4)));
        aSubMsg2.setText((CharSequence)(this.mSelectedData.getKeyText(6) + " : " + this.mSelectedData.getValue(6)));
        if (EnvironmentConfig.mUsimUse) {
            this.setSpinner();
        } else {
            View aView = this.findViewById(R.id.select_media);
            aView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, 0));
            aView.setVisibility(4);
        }
        this.mTransKeyUtil.setMTransKey(this, this.mTransKeyTextIds, this.mTransKeyTextStrings, this.mTransKeyMaxLength, null);
        Button aOKButton = (Button)this.findViewById(R.id.top_right_button);
        aOKButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CopyCertToUsimWithTranskey.this.onOKButtonClick(v);
            }
        });
    }

    private void setSpinner() {
        Spinner aSelectStorage = null;
        ImageTextSpinnerAdapter aSpinnerAdapter = null;
        HashMap<String, Object> aItem = null;
        ArrayList<HashMap<String, Object>> aItemList = null;
        aSelectStorage = (Spinner)this.findViewById(R.id.select_media);
        aItemList = new ArrayList<HashMap<String, Object>>();
        aItem = new HashMap<String, Object>();
        aItem.put("image", R.drawable.usim_dream);
        aItem.put("text", "\uc720\uc2ec(\ub4dc\ub9bc)");
        aItemList.add(aItem);
        aSpinnerAdapter = new ImageTextSpinnerAdapter((Context)this, aItemList);
        aSelectStorage.setAdapter((SpinnerAdapter)aSpinnerAdapter);
        aSelectStorage.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                switch (position) {
                    case 0: {
                        CopyCertToUsimWithTranskey.this.SELECT_BENDER = 0;
                        break;
                    }
                    case 1: {
                        CopyCertToUsimWithTranskey.this.SELECT_BENDER = 1;
                    }
                }
            }

            public void onNothingSelected(AdapterView<?> arg0) {
            }
        });
    }

    private void onOKButtonClick(View v) {
        boolean aIsMember = false;
        boolean aIsInstall = false;
        CertMgr aCertMgr = null;
        XTopView aTopView = null;
        SmartUsimResultCode aResultCode = null;
        EditText aPasswordEditText = null;
        EditText aSmartPasswordEditText = null;
        this.mCoreUtil.resetError();
        aTopView = (XTopView)this.findViewById(R.id.top_view);
        aPasswordEditText = (EditText)this.findViewById(R.id.password_edittext);
        aSmartPasswordEditText = (EditText)this.findViewById(R.id.smart_password_edittext);
        if (this.m_P_assW_ord == null || this.m_P_assW_ord.length == 0 || this.mSmartPassword == null || this.mSmartPassword.length == 0) {
            aTopView.setDescription(this.getString(R.string.plugin_input_nothing));
            return;
        }
        aCertMgr = CertMgr.getInstance();
        if (aCertMgr.verifyPassword(this.mSrcMediaID, 14, this.mSelectedData.getValue(7), this.m_P_assW_ord) != 0) {
            aTopView.setDescription(this.mCoreUtil.lastErrMsg());
            this.m_P_assW_ord = null;
            this.mSmartPassword = null;
            aPasswordEditText.setText((CharSequence)"");
            aSmartPasswordEditText.setText((CharSequence)"");
            if (++this.m_P_assW_ordTryCount >= 3) {
                this.setResult(2);
                this.finish();
            }
            return;
        }
        if (this.mSmartUsim != null) {
            this.endUnBind();
            this.mSmartUsim = null;
        }
        if (this.SELECT_BENDER == 0) {
            this.mSmartUsim = SmartUsim.getInstance((Context)this, (SmartUsimListener)this.mSmartUsimListener, (String)"www.softforum.com", (String)"cpCode", (int)2);
        } else if (this.SELECT_BENDER == 1) {
            this.mSmartUsim = SmartUsim.getInstance((Context)this, (SmartUsimListener)this.mSmartUsimListener, (String)"www.softforum.com", (String)"cpCode", (int)1);
        }
        aIsMember = this.mSmartUsim.isMember();
        if (!aIsMember && (aResultCode = this.mSmartUsim.getLastError()).getResultCode() != 2001) {
            this.showToast("\uc11c\ube44\uc2a4 \ubd88\uac00\ub2a5 \uc0ac\uc6a9\uc790" + aResultCode.getResultCode() + "/" + aResultCode.getResultCodeVendor());
            return;
        }
        aIsInstall = this.mSmartUsim.isInstalled();
        if (!aIsInstall) {
            this.mSmartUsim.install();
            return;
        }
        this.mSmartUsim.bindService("58.229.178.45", 25189);
    }

    private void showToast(final String message) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                Toast.makeText((Context)CopyCertToUsimWithTranskey.this, (CharSequence)message, (int)1).show();
            }
        });
    }

    private void copyCertToUsim() {
        boolean aIsPossible = false;
        String aSubjectRDN = null;
        Intent aIntent = null;
        XTopView aTopView = null;
        SmartUsimResultCode aResultCode = null;
        aTopView = (XTopView)this.findViewById(R.id.top_view);
        aIntent = new Intent();
        aIsPossible = this.mSmartUsim.isPossibleService();
        if (aIsPossible) {
            aSubjectRDN = this.mSelectedData.getValue(7);
            this.mCertificateDER = CoreWrapper.getExportRawSignCert((int)this.mSrcMediaID, (String)aSubjectRDN);
            this.mKeyDER = CoreWrapper.getExportRawSignKey((int)this.mSrcMediaID, (String)aSubjectRDN);
            if (this.mCertificateDER.length < 1 || this.mKeyDER.length < 1) {
                aTopView.setDescription("\uc778\uc99d\uc11c \ud30c\uc77c \uc77d\uae30\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4.");
                this.setResult(2, aIntent);
            }
            if ((aResultCode = this.mSmartUsim.writeCertUsim(this.mSmartPassword, this.mCertificateDER, this.mKeyDER, this.m_P_assW_ord)).getResultCode() != 0) {
                if (aResultCode.getResultCode() == 5001) {
                    aTopView.setDescription(this.getString(R.string.message_password_pin_incorrect));
                    return;
                }
                if (aResultCode.getResultCode() == 5002) {
                    aIntent.putExtra("xecure_smart_cert_mgr_result_key", 4);
                } else if (aResultCode.getResultCode() == 5003) {
                    aIntent.putExtra("xecure_smart_cert_mgr_result_key", 5);
                } else {
                    aIntent.putExtra("xecure_smart_cert_mgr_result_key", 7);
                }
            } else {
                aIntent.putExtra("xecure_smart_cert_mgr_result_key", 6);
            }
            this.setResult(-1, aIntent);
            this.endUnBind();
            this.finish();
        } else {
            aResultCode = this.mSmartUsim.getLastError();
            if (aResultCode.getResultCodeVendor() == 3001) {
                this.mSmartUsim.joinService(102);
            } else if (aResultCode.getResultCode() == 3002) {
                this.endUnBind();
                this.showToast("\uc2a4\ub9c8\ud2b8\uacf5\uc778\uc778\uc99d \uc571 \uc5c5\ub370\uc774\ud2b8\uac00 \ud544\uc694\ud569\ub2c8\ub2e4.(" + aResultCode.getResultCodeVendor() + ")");
                this.mSmartUsim.install();
            } else if (aResultCode.getResultCode() == 3001) {
                this.showToast("\ud5c8\uac00\ub418\uc9c0 \uc54a\uc740 \uc571\uc774 \uc811\uadfc\ud558\uc600\uc2b5\ub2c8\ub2e4." + aResultCode.getResultCode() + "(" + aResultCode.getResultCodeVendor() + ")");
                this.endUnBind();
            } else {
                this.showToast(aResultCode.getResultCode() + "(" + aResultCode.getResultCodeVendor() + ")");
                this.endUnBind();
            }
        }
    }

    private void endUnBind() {
        try {
            this.mSmartUsim.unbindService();
        }
        catch (Exception e) {
            XSLog.e((String)"XecureSmart", (String)e.getMessage());
        }
    }

    public void finish() {
        XUtil.resetByteArray((byte[][])new byte[][]{this.mSmartPassword});
        XUtil.resetByteArray((byte[][])new byte[][]{this.m_P_assW_ord});
        super.finish();
    }

    public void onBackPressed() {
        if (this.mSmartUsim != null) {
            this.endUnBind();
        }
        XUtil.resetByteArray((byte[][])new byte[][]{this.mSmartPassword});
        XUtil.resetByteArray((byte[][])new byte[][]{this.m_P_assW_ord});
        super.onBackPressed();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.mTransKeyUtil.transKeyActivityResult(this, requestCode, resultCode, data, this.mTransKeyTextIds);
        switch (requestCode) {
            case 101: {
                this.endUnBind();
                break;
            }
            case 102: {
                if (resultCode != -1) break;
                this.copyCertToUsim();
            }
        }
    }

    @Override
    public void setTransKeyResult(int index, byte[] result) {
        switch (index) {
            case 0: {
                if (result == null) break;
                this.mSmartPassword = (byte[])result.clone();
                break;
            }
            case 1: {
                if (result == null) break;
                this.m_P_assW_ord = (byte[])result.clone();
            }
        }
    }

    @Override
    public void setTransKeyResult(int pIndex, String pEncryptedData) {
        switch (pIndex) {
            case 0: {
                if (this.mTransKeyUtil.getDecryptCipherData() == null) break;
                this.mSmartPassword = (byte[])this.mTransKeyUtil.getDecryptCipherData().clone();
                break;
            }
            case 1: {
                if (this.mTransKeyUtil.getDecryptCipherData() == null) break;
                this.m_P_assW_ord = (byte[])this.mTransKeyUtil.getDecryptCipherData().clone();
            }
        }
    }

    @Override
    public void doNext() {
        boolean aExistResult = false;
        aExistResult = this.mTransKeyUtil.isResultsNotEmpty(this.mSmartPassword, this.m_P_assW_ord);
        if (aExistResult) {
            this.onOKButtonClick(null);
        }
    }
}

