/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.ui.transkey;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import com.softforum.sample.R;
import com.softforum.xecure.crypto.CertMgr;
import com.softforum.xecure.ui.XTopView;
import com.softforum.xecure.ui.crypto.XecureSmartCertMgrUser;
import com.softforum.xecure.ui.transkey.TransKeyResultInterface;
import com.softforum.xecure.ui.transkey.TransKeyUtil;
import com.softforum.xecure.util.EnvironmentConfig;
import com.softforum.xecure.util.XCoreUtil;
import com.softforum.xecure.util.XDetailData;
import com.softforum.xecure.util.XUtil;
import java.security.SecureRandom;

public class XecureSmartChangePasswordWithTransKey
extends Activity
implements TransKeyResultInterface {
    public static final int mXecureSmartChangePasswordID = 78000;
    public static final String mMediaIDKey = "xecure_smart_changepw_media_id_key";
    public static final String mSelectedCertDataKey = "xecure_smart_changepw_data_key";
    public static final String mNewPasswordKey = "sign_cert_password_password_key";
    public static final String mOldPasswordKey = "old_cert_password_password_key";
    public static final int RESULT_PASSWD_FAIL = 2;
    private int mMediaID;
    private int m_P_assW_ordTryCount = 0;
    private XDetailData mSelectedData;
    private XCoreUtil mCoreUtil = new XCoreUtil();
    private TransKeyUtil mTransKeyUtil = new TransKeyUtil();
    private int mTransKeyComplete = -1;
    private byte[] mOldPassword;
    private byte[] mNewPassword;
    private byte[] mNewPasswordConfirm;
    private String mEncryptedData = null;
    private String mNewEncryptedData = null;
    private String mConfirmEncryptedData = null;
    private byte[] mRandomValue = new byte[20];
    private final int[] mTransKeyTextIds = new int[]{R.id.password_edittext, R.id.new_password_edittext, R.id.new_password_confirm_edittext};
    private final int[] mTransKeyTextStrings = new int[]{R.string.password, R.string.new_password, R.string.new_password_confirm};
    private final int[] mTransKeyMaxLength = new int[]{150, 150, 150};
    private String mCallMode;
    private int mDetailDataType = 0;
    private int mDetailDataCertSubjectKey = 7;
    private int mDetailDataCertIssuerKey = 4;
    private int mDetailDataCertToKey = 6;
    private final int mResultForNotExistPassword = 10;
    private final int mResultForVerifyPasswordFail = 11;
    private final int mResultForNotCorrectPassword = 12;
    private final int mResultForEqualPassword = 13;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.crypto_xecure_smart_change_password);
        this.mMediaID = this.getIntent().getIntExtra(mMediaIDKey, -1);
        this.mCallMode = this.getIntent().getStringExtra("call_mode_key");
        if (this.mCallMode != null && this.mCallMode.equals("call_mode_renew")) {
            XTopView aTopView = (XTopView)this.findViewById(R.id.top_view);
            aTopView.setSubject(this.getString(R.string.renew_certificate_window_title));
            aTopView.setDescription(this.getString(R.string.renew_certificate_window_desc));
            this.mDetailDataType = 3;
            this.mDetailDataCertSubjectKey = 2;
            this.mDetailDataCertIssuerKey = 3;
            this.mDetailDataCertToKey = 4;
            TextView aAlertTextView = (TextView)this.findViewById(R.id.new_password_check_alert_textview);
            aAlertTextView.setVisibility(0);
        }
        this.mSelectedData = new XDetailData(this.getIntent().getStringArrayExtra(mSelectedCertDataKey), this.mDetailDataType);
        ImageView aIcon = (ImageView)this.findViewById(R.id.icon);
        TextView aMainMsg = (TextView)this.findViewById(R.id.main_msg);
        TextView aSubMsg1 = (TextView)this.findViewById(R.id.sub_msg1);
        TextView aSubMsg2 = (TextView)this.findViewById(R.id.sub_msg2);
        if ("0".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_normal);
        } else if ("1".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_update);
        } else if ("2".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_revoke);
        }
        aMainMsg.setText((CharSequence)this.mSelectedData.getValue(this.mDetailDataCertSubjectKey));
        aSubMsg1.setText((CharSequence)(this.mSelectedData.getKeyText(this.mDetailDataCertIssuerKey) + " : " + this.mSelectedData.getValue(this.mDetailDataCertIssuerKey)));
        aSubMsg2.setText((CharSequence)(this.mSelectedData.getKeyText(this.mDetailDataCertToKey) + " : " + this.mSelectedData.getValue(this.mDetailDataCertToKey)));
        Button aOKButton = (Button)this.findViewById(R.id.top_right_button);
        aOKButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XecureSmartChangePasswordWithTransKey.this.onOKButtonClick(v);
            }
        });
        if (EnvironmentConfig.mMTransKeyEncryptionUsage) {
            SecureRandom aSecureRandom = new SecureRandom();
            aSecureRandom.nextBytes(this.mRandomValue);
            this.mTransKeyUtil.setRandomValue(this.mRandomValue);
        }
        this.mTransKeyUtil.setMTransKey(this, this.mTransKeyTextIds, this.mTransKeyTextStrings, this.mTransKeyMaxLength, null);
    }

    private int checkInputPassword() {
        int aIndex;
        int aResult = -1;
        int aErrorCode = 0;
        int aConfirmResult = 0;
        int aEqualResult = 0;
        CertMgr aCertMgr = CertMgr.getInstance();
        if (this.mOldPassword == null || this.mOldPassword.length == 0) {
            return 10;
        }
        aResult = aCertMgr.verifyPassword(this.mMediaID, 14, this.mSelectedData.getValue(this.mDetailDataCertSubjectKey), this.mOldPassword);
        if (aResult != 0 && (aErrorCode = this.mCoreUtil.lastErrCode()) != 22000015) {
            return 11;
        }
        if (this.mNewPassword == null || this.mNewPassword.length == 0) {
            return 10;
        }
        aResult = this.mCallMode != null && this.mCallMode.equals("call_mode_renew") ? XUtil.newCheckPasswordFormat((byte[])this.mNewPassword) : XUtil.checkPasswordFormat((byte[])this.mNewPassword);
        if (aResult != 0) {
            return aResult;
        }
        if (this.mNewPasswordConfirm == null || this.mNewPasswordConfirm.length == 0) {
            aConfirmResult = -1;
        } else if (this.mNewPassword.length == this.mNewPasswordConfirm.length) {
            for (aIndex = 0; aIndex < this.mNewPassword.length; ++aIndex) {
                if (this.mNewPassword[aIndex] == this.mNewPasswordConfirm[aIndex]) continue;
                aConfirmResult = -1;
                break;
            }
        } else {
            aConfirmResult = -1;
        }
        if (aConfirmResult != 0) {
            return 12;
        }
        if (this.mOldPassword.length == this.mNewPasswordConfirm.length) {
            for (aIndex = 0; aIndex < this.mNewPasswordConfirm.length; ++aIndex) {
                if (this.mOldPassword[aIndex] == this.mNewPasswordConfirm[aIndex]) continue;
                aEqualResult = -1;
                break;
            }
        }
        if (aEqualResult == 0) {
            return 13;
        }
        return aResult;
    }

    private int checkInputPasswordWithEncryption() {
        int aResult = -1;
        int aErrorCode = 0;
        int aConfirmResult = 0;
        String aSubjectDN = null;
        CertMgr aCertMgr = CertMgr.getInstance();
        if (this.mEncryptedData == null || this.mEncryptedData.length() == 0) {
            return 10;
        }
        aSubjectDN = this.mSelectedData.getValue(this.mDetailDataCertSubjectKey);
        aResult = aCertMgr.verifyPassword(this.mMediaID, aSubjectDN, this.mRandomValue, this.mEncryptedData);
        if (aResult != 0 && (aErrorCode = this.mCoreUtil.lastErrCode()) != 22000015) {
            return 11;
        }
        if (this.mNewEncryptedData == null || this.mNewEncryptedData.length() == 0) {
            return 10;
        }
        aResult = this.mCallMode != null && this.mCallMode.equals("call_mode_renew") ? XUtil.checkPassword((String)this.mNewEncryptedData, (byte[])this.mRandomValue, (int)2) : XUtil.checkPassword((String)this.mNewEncryptedData, (byte[])this.mRandomValue, (int)0);
        if (aResult != 0) {
            return aResult;
        }
        if (this.mConfirmEncryptedData == null || this.mConfirmEncryptedData.length() == 0) {
            aConfirmResult = -1;
        } else if (!this.mNewEncryptedData.equals(this.mConfirmEncryptedData)) {
            aConfirmResult = -1;
        }
        if (aConfirmResult != 0) {
            return 12;
        }
        if (this.mEncryptedData.equals(this.mConfirmEncryptedData)) {
            return 13;
        }
        return aResult;
    }

    private void onOKButtonClick(View v) {
        Intent aIntent = null;
        int aResult = 0;
        CertMgr aCertMgr = CertMgr.getInstance();
        String aSubjectDN = this.mSelectedData.getValue(this.mDetailDataCertSubjectKey);
        XTopView aTopView = (XTopView)this.findViewById(R.id.top_view);
        TextView aOldPasswordTextView = (TextView)this.findViewById(R.id.password_edittext);
        this.mCoreUtil.resetError();
        aResult = EnvironmentConfig.mMTransKeyEncryptionUsage ? this.checkInputPasswordWithEncryption() : this.checkInputPassword();
        switch (aResult) {
            case 10: {
                aTopView.setDescription(this.getString(R.string.plugin_input_nothing));
                return;
            }
            case 11: {
                aTopView.setDescription(this.mCoreUtil.lastErrMsg());
                this.mOldPassword = null;
                aOldPasswordTextView.setText((CharSequence)"");
                if (++this.m_P_assW_ordTryCount >= 3) {
                    this.setResult(2);
                    this.finish();
                }
                return;
            }
            case 12: {
                aTopView.setDescription(this.getString(R.string.incorrect_confirm_password));
                return;
            }
            case 13: {
                aTopView.setDescription(this.getString(R.string.password_renew_syntax_error));
                return;
            }
            case 1: {
                aTopView.setDescription(this.getString(R.string.password_length_error));
                return;
            }
            case 2: {
                aTopView.setDescription(this.getString(R.string.password_syntax_error));
                return;
            }
            case 3: {
                aTopView.setDescription(this.getString(R.string.newpassword_length_error));
                return;
            }
            case 4: {
                aTopView.setDescription(this.getString(R.string.newpassword_syntax_error));
                return;
            }
            case 5: {
                aTopView.setDescription(this.getString(R.string.newpassword_invalid_error));
                return;
            }
        }
        this.mTransKeyComplete = 0;
        if (this.mCallMode != null && this.mCallMode.equals("call_mode_renew")) {
            aIntent = new Intent();
            if (EnvironmentConfig.mMTransKeyEncryptionUsage) {
                aIntent.putExtra("sign_cert_password_random_value_key", this.mRandomValue);
                aIntent.putExtra("sign_cert_password_e_ncrypted_data_key", this.mEncryptedData);
                aIntent.putExtra("sign_cert_password_new_e_ncrypted_data_key", this.mNewEncryptedData);
            } else {
                aIntent.putExtra(mOldPasswordKey, this.mOldPassword);
                aIntent.putExtra(mNewPasswordKey, this.mNewPassword);
            }
            this.setResult(-1, aIntent);
            this.finish();
        } else {
            aIntent = new Intent((Context)this, XecureSmartCertMgrUser.class);
            aResult = EnvironmentConfig.mMTransKeyEncryptionUsage ? aCertMgr.changePassword(this.mMediaID, aSubjectDN, this.mRandomValue, this.mEncryptedData, this.mNewEncryptedData) : aCertMgr.changePassword(this.mMediaID, aSubjectDN, this.mOldPassword, this.mNewPassword);
            if (aResult == 0) {
                aIntent.putExtra("xecure_smart_cert_mgr_result_key", 1);
                this.setResult(-1, aIntent);
                this.finish();
            } else {
                this.setResult(2, aIntent);
            }
        }
        this.finish();
    }

    public void finish() {
        XUtil.resetByteArray((byte[][])new byte[][]{this.mNewPasswordConfirm});
        super.finish();
    }

    public void onBackPressed() {
        XUtil.resetByteArray((byte[][])new byte[][]{this.mOldPassword, this.mNewPassword, this.mNewPasswordConfirm, this.mRandomValue});
        super.onBackPressed();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.mTransKeyUtil.transKeyActivityResult(this, requestCode, resultCode, data, this.mTransKeyTextIds);
    }

    @Override
    public void setTransKeyResult(int index, byte[] result) {
        switch (index) {
            case 0: {
                if (result == null) break;
                this.mOldPassword = (byte[])result.clone();
                break;
            }
            case 1: {
                if (result == null) break;
                this.mNewPassword = (byte[])result.clone();
                break;
            }
            case 2: {
                if (result == null) break;
                this.mNewPasswordConfirm = (byte[])result.clone();
            }
        }
    }

    @Override
    public void setTransKeyResult(int pIndex, String pEncryptedData) {
        switch (pIndex) {
            case 0: {
                if (pEncryptedData == null) break;
                this.mEncryptedData = pEncryptedData;
                break;
            }
            case 1: {
                if (pEncryptedData == null) break;
                this.mNewEncryptedData = pEncryptedData;
                break;
            }
            case 2: {
                if (pEncryptedData == null) break;
                this.mConfirmEncryptedData = pEncryptedData;
            }
        }
    }

    @Override
    public void doNext() {
        boolean aExistResult = false;
        aExistResult = EnvironmentConfig.mMTransKeyEncryptionUsage ? this.mTransKeyUtil.isResultsNotEmpty(this.mEncryptedData, this.mNewEncryptedData, this.mConfirmEncryptedData) : this.mTransKeyUtil.isResultsNotEmpty(this.mOldPassword, this.mNewPassword, this.mNewPasswordConfirm);
        if (aExistResult) {
            this.onOKButtonClick(null);
        }
        if (this.mTransKeyComplete == 0) {
            XUtil.resetByteArray((byte[][])new byte[][]{this.mOldPassword, this.mNewPassword, this.mNewPasswordConfirm, this.mRandomValue});
        }
    }
}

