/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.usim;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import android.widget.Toast;
import com.consortium.smartusim.SmartUsim;
import com.consortium.smartusim.SmartUsimListener;
import com.consortium.smartusim.SmartUsimResultCode;
import com.softforum.sample.R;
import com.softforum.xecure.core.CoreWrapper;
import com.softforum.xecure.crypto.CertMgr;
import com.softforum.xecure.ui.XTopView;
import com.softforum.xecure.util.EnvironmentConfig;
import com.softforum.xecure.util.ImageTextSpinnerAdapter;
import com.softforum.xecure.util.XCoreUtil;
import com.softforum.xecure.util.XDetailData;
import com.softforum.xecure.util.XSLog;
import java.util.ArrayList;
import java.util.HashMap;

public class CopyCertToUsim
extends Activity {
    public static final int mXecureSmartCopyCertoUsimID = 130000;
    private SmartUsim mSmartUsim = null;
    private int m_P_assW_ordTryCount = 0;
    private XDetailData mSelectedData;
    private String m_P_assW_ord = null;
    private byte[] m_P_assW_ordByte = null;
    private byte[] mSmartPassword = null;
    private int mSrcMediaID;
    public Handler mHandler = new Handler();
    XTopView mTopView = null;
    private final String serverAddress = "58.229.178.45";
    private final int serverPort = 25189;
    private final int END_BIND = 101;
    private final int flag_JOIN = 102;
    public static final int RESULT_PASSWD_FAIL = 2;
    public static final String mMediaIDKey = "sign_cert_password_media_id_key";
    public static final String mSelectedCertDataKey = "sign_cert_password_selected_cert_data_key";
    public static final String m_P_assW_ordKey = "sign_cert_password_password_key";
    private int mDetailDataType = 0;
    private int mDetailDataCertSubjectKey = 7;
    private int mDetailDataCertIssuerKey = 4;
    private int mDetailDataCertToKey = 6;
    private static byte[] mCertificateDER = null;
    private static byte[] mKeyDER = null;
    private XCoreUtil mCoreUtil = new XCoreUtil();
    protected static final int PINCODE_LOCK_ERROR = 0;
    private int MEDIA_DREAMSECURITY_USIM;
    private int MEDIA_RAONSECURE_USIM;
    private int SELECT_BENDER;
    private final int DREAMSECURE = 0;
    private final int RAONSECURE = 1;
    public SmartUsimListener smartUsimListener = new SmartUsimListener(){

        public void onSmartUsimResult(int requestCode, SmartUsimResultCode resultCode) {
            switch (requestCode) {
                case 3: {
                    if (resultCode.getResultCode() == 0) {
                        CopyCertToUsim.this.mSmartUsim.bindService("58.229.178.45", 25189);
                        break;
                    }
                    CopyCertToUsim.this.showToast("\uc2a4\ub9c8\ud2b8\uc778\uc99d\uc571\uc774 \uc124\uce58\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.\n\ud655\uc778 \ud6c4 \uc774\uc6a9\ud574 \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.\n[" + resultCode.getResultCode() + "]");
                    break;
                }
                case 1: {
                    if (resultCode.getResultCode() == 0) {
                        new AlertDialog.Builder((Context)CopyCertToUsim.this).setTitle((CharSequence)"\uc54c\ub9bc").setMessage((CharSequence)"\uc120\ud0dd\ud558\uc2e0 \uc778\uc99d\uc11c\ub97c USIM\uc5d0 \uc800\uc7a5\ud569\ub2c8\ub2e4. \uacc4\uc18d\ud558\uc2dc\uaca0\uc2b5\ub2c8\uae4c?").setPositiveButton((CharSequence)"YES", new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                                CopyCertToUsim.this.copyCertToUsim();
                            }
                        }).setNegativeButton((CharSequence)"NO", new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                            }
                        }).show();
                        break;
                    }
                    CopyCertToUsim.this.showToast("\ubc14\uc778\ub4dc \uc2e4\ud328\uacf5\ud1b5 /Vendor \ucf54\ub4dc : " + resultCode.getResultCode() + "(" + resultCode.getResultCodeVendor() + ")");
                }
            }
        }
    };

    public void onCreate(Bundle savedInstanceState) {
        View aView;
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.usim_cert_copy);
        this.mSrcMediaID = this.getIntent().getIntExtra("mSrcMediaID", 1);
        this.mSelectedData = new XDetailData(this.getIntent().getStringArrayExtra(mSelectedCertDataKey), this.mDetailDataType);
        ImageView aIcon = (ImageView)this.findViewById(R.id.icon);
        TextView aMainMsg = (TextView)this.findViewById(R.id.main_msg);
        TextView aSubMsg1 = (TextView)this.findViewById(R.id.sub_msg1);
        TextView aSubMsg2 = (TextView)this.findViewById(R.id.sub_msg2);
        if ("0".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_normal);
        } else if ("1".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_update);
        } else if ("2".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_revoke);
        }
        aMainMsg.setText((CharSequence)this.mSelectedData.getValue(this.mDetailDataCertSubjectKey));
        aSubMsg1.setText((CharSequence)(this.mSelectedData.getKeyText(this.mDetailDataCertIssuerKey) + " : " + this.mSelectedData.getValue(this.mDetailDataCertIssuerKey)));
        aSubMsg2.setText((CharSequence)(this.mSelectedData.getKeyText(this.mDetailDataCertToKey) + " : " + this.mSelectedData.getValue(this.mDetailDataCertToKey)));
        if (EnvironmentConfig.mUsimUse) {
            aView = this.findViewById(R.id.select_media);
            aView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, 0));
            aView.setVisibility(4);
        } else {
            aView = this.findViewById(R.id.select_media);
            aView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, 0));
            aView.setVisibility(4);
        }
        Button aOKButton = (Button)this.findViewById(R.id.top_right_button);
        aOKButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CopyCertToUsim.this.onOKButtonClick(v);
            }
        });
    }

    private void setSpinner() {
        this.MEDIA_DREAMSECURITY_USIM = 0;
        this.MEDIA_RAONSECURE_USIM = 1;
        Spinner aSelectStorage = (Spinner)this.findViewById(R.id.select_media);
        ArrayList<HashMap<String, Object>> aItemList = new ArrayList<HashMap<String, Object>>();
        HashMap<String, Object> aItem = new HashMap<String, Object>();
        aItem.put("image", R.drawable.usim_dream);
        aItem.put("text", "\uc720\uc2ec(\ub4dc\ub9bc)");
        aItemList.add(aItem);
        ImageTextSpinnerAdapter aAdapter = new ImageTextSpinnerAdapter((Context)this, aItemList);
        aSelectStorage.setAdapter((SpinnerAdapter)aAdapter);
        aSelectStorage.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                if (position == CopyCertToUsim.this.MEDIA_DREAMSECURITY_USIM) {
                    CopyCertToUsim.this.SELECT_BENDER = 0;
                } else if (position == CopyCertToUsim.this.MEDIA_RAONSECURE_USIM) {
                    CopyCertToUsim.this.SELECT_BENDER = 1;
                }
            }

            public void onNothingSelected(AdapterView<?> arg0) {
            }
        });
    }

    private void onOKButtonClick(View v) {
        SmartUsimResultCode userResult;
        this.mTopView = (XTopView)this.findViewById(R.id.top_view);
        EditText aSmartPasswordEditText = (EditText)this.findViewById(R.id.smart_password_edittext);
        EditText aPasswordEditText = (EditText)this.findViewById(R.id.password_edittext);
        this.mCoreUtil.resetError();
        this.mSmartPassword = aSmartPasswordEditText.getText().toString().getBytes();
        this.m_P_assW_ord = aPasswordEditText.getText().toString();
        this.m_P_assW_ordByte = aPasswordEditText.getText().toString().getBytes();
        if (this.m_P_assW_ord.length() == 0 || this.mSmartPassword.length == 0) {
            this.mTopView.setDescription(this.getString(R.string.plugin_input_nothing));
            return;
        }
        CertMgr aCertMgr = CertMgr.getInstance();
        if (aCertMgr.verifyPassword(this.mSrcMediaID, 14, this.mSelectedData.getValue(this.mDetailDataCertSubjectKey), this.m_P_assW_ord) != 0) {
            this.mTopView.setDescription(this.mCoreUtil.lastErrMsg());
            this.m_P_assW_ord = "";
            aPasswordEditText.setText((CharSequence)"");
            if (++this.m_P_assW_ordTryCount >= 3) {
                this.setResult(2);
                this.finish();
            }
            return;
        }
        if (this.mSmartUsim != null) {
            this.endUnBind();
            this.mSmartUsim = null;
        }
        if (this.SELECT_BENDER == 0) {
            this.mSmartUsim = SmartUsim.getInstance((Context)this, (SmartUsimListener)this.smartUsimListener, (String)"www.softforum.com", (String)"cpCode", (int)2);
        } else if (this.SELECT_BENDER == 1) {
            this.mSmartUsim = SmartUsim.getInstance((Context)this, (SmartUsimListener)this.smartUsimListener, (String)"www.softforum.com", (String)"cpCode", (int)1);
        }
        boolean isMember = this.mSmartUsim.isMember();
        if (!isMember && (userResult = this.mSmartUsim.getLastError()).getResultCode() != 2001) {
            this.showToast("\uc11c\ube44\uc2a4 \ubd88\uac00\ub2a5 \uc0ac\uc6a9\uc790" + userResult.getResultCode() + "/" + userResult.getResultCodeVendor());
            return;
        }
        boolean isInstall = this.mSmartUsim.isInstalled();
        if (!isInstall) {
            this.mSmartUsim.install();
            return;
        }
        this.mSmartUsim.bindService("58.229.178.45", 25189);
    }

    public void showToast(final String message) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                Toast.makeText((Context)CopyCertToUsim.this, (CharSequence)message, (int)1).show();
            }
        });
    }

    private void copyCertToUsim() {
        boolean isPossible = false;
        isPossible = this.mSmartUsim.isPossibleService();
        Intent aIntent = new Intent();
        if (isPossible) {
            SmartUsimResultCode writeResult;
            String aSubjectRDN = this.mSelectedData.getValue(7);
            mCertificateDER = CoreWrapper.getExportRawSignCert((int)this.mSrcMediaID, (String)aSubjectRDN);
            mKeyDER = CoreWrapper.getExportRawSignKey((int)this.mSrcMediaID, (String)aSubjectRDN);
            if (mCertificateDER.length < 1 || mKeyDER.length < 1) {
                this.mTopView.setDescription("\uc778\uc99d\uc11c \ud30c\uc77c \uc77d\uae30\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4.");
                this.setResult(2, aIntent);
            }
            if ((writeResult = this.mSmartUsim.writeCertUsim(this.mSmartPassword, mCertificateDER, mKeyDER, this.m_P_assW_ordByte)).getResultCode() != 0) {
                if (writeResult.getResultCode() == 5001) {
                    this.mTopView.setDescription(this.getString(R.string.message_password_pin_incorrect));
                    return;
                }
                if (writeResult.getResultCode() == 5002) {
                    aIntent.putExtra("xecure_smart_cert_mgr_result_key", 4);
                    this.setResult(-1, aIntent);
                    this.endUnBind();
                    this.finish();
                } else if (writeResult.getResultCode() == 5003) {
                    aIntent.putExtra("xecure_smart_cert_mgr_result_key", 5);
                    this.setResult(-1, aIntent);
                    this.endUnBind();
                    this.finish();
                } else {
                    aIntent.putExtra("xecure_smart_cert_mgr_result_key", 7);
                    this.setResult(-1, aIntent);
                    this.endUnBind();
                    this.finish();
                }
            } else {
                aIntent.putExtra("xecure_smart_cert_mgr_result_key", 6);
                this.setResult(-1, aIntent);
                this.endUnBind();
                this.finish();
            }
        } else {
            SmartUsimResultCode suResult = this.mSmartUsim.getLastError();
            if (suResult.getResultCodeVendor() == 3001) {
                this.mSmartUsim.joinService(102);
            } else if (suResult.getResultCode() == 3002) {
                this.endUnBind();
                this.showToast("\uc2a4\ub9c8\ud2b8\uacf5\uc778\uc778\uc99d \uc571 \uc5c5\ub370\uc774\ud2b8\uac00 \ud544\uc694\ud569\ub2c8\ub2e4.(" + suResult.getResultCodeVendor() + ")");
                this.mSmartUsim.install();
            } else if (suResult.getResultCode() == 3001) {
                this.showToast("\ud5c8\uac00\ub418\uc9c0 \uc54a\uc740 \uc571\uc774 \uc811\uadfc\ud558\uc600\uc2b5\ub2c8\ub2e4." + suResult.getResultCode() + "(" + suResult.getResultCodeVendor() + ")");
                this.endUnBind();
            } else {
                this.showToast(suResult.getResultCode() + "(" + suResult.getResultCodeVendor() + ")");
                this.endUnBind();
            }
        }
    }

    private void endUnBind() {
        try {
            this.mSmartUsim.unbindService();
        }
        catch (Exception e) {
            XSLog.e((String)e.getMessage());
        }
    }

    public void onBackPressed() {
        if (this.mSmartUsim != null) {
            this.endUnBind();
        }
        this.finish();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 101: {
                this.endUnBind();
                break;
            }
            case 102: {
                if (resultCode != -1) break;
                this.copyCertToUsim();
            }
        }
    }
}

