/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.yessign;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.widget.Button;
import android.widget.Toast;
import com.softforum.sample.R;
import com.softforum.xecure.XApplication;
import com.softforum.xecure.crypto.CertMgr;
import com.softforum.xecure.util.EnvironmentConfig;
import com.softforum.xecure.util.XSLog;
import com.softforum.xecure.util.XUtil;
import com.softforum.xecure.yessign.ConnectToYessignApp;
import com.softforum.xecure.yessign.YessignApplicationUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class ImportCertificateToYessign
extends Activity {
    private static byte[] mCertificateDER = null;
    private static byte[] mKeyDER = null;
    private static byte[] mKMCertificateDER = null;
    private static byte[] mKMKeyDER = null;
    private static String mResult;
    private static int mMediaID;
    private Thread mImportCertificateThread;
    private ProgressDialog mProgressDialog;
    private String aProgressDialogMessage = "";
    Handler mViewControlHandler;
    private static Intent mIntent;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.import_certificate_to_yessign);
        XUtil.initializeXecureCoreConfig((Context)this.getApplicationContext(), (boolean)false);
        Button aImportButton = null;
        aImportButton = (Button)this.findViewById(R.id.top_right_button);
        aImportButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View pView) {
                if (ImportCertificateToYessign.this.getCallingActivity() == null) {
                    ImportCertificateToYessign.this.ShowProgressDialog(ImportCertificateToYessign.this.getString(R.string.message_fail_get_caller));
                }
                ImportCertificateToYessign.this.verifyReceivedIntent(ImportCertificateToYessign.this.getCallingPackage(), ImportCertificateToYessign.this.getIntent());
            }
        });
    }

    private void verifyReceivedIntent(String callingPackageName, Intent intent) {
        final String fCallingPackageName = callingPackageName;
        mIntent = intent;
        this.aProgressDialogMessage = "\uc778\uc99d\uc11c\ub97c \uc800\uc7a5\ud558\ub294 \uc911 \uc785\ub2c8\ub2e4.";
        this.ShowProgressDialog(this.aProgressDialogMessage);
        YessignApplicationUtil.queryTrustedApplicationList(this.getApplicationContext(), ConnectToYessignApp.testConfiguration, new YessignApplicationUtil.OnCompleteListener<byte[]>(){

            @Override
            public void onComplete(byte[] result, Exception exception) {
                if (exception != null) {
                    if (ImportCertificateToYessign.this.mProgressDialog != null) {
                        ImportCertificateToYessign.this.mProgressDialog.dismiss();
                    }
                    ImportCertificateToYessign.this.ErrorMessage(exception.getMessage());
                    return;
                }
                boolean integrity = YessignApplicationUtil.checkReceivedIntent(ImportCertificateToYessign.this.getApplicationContext(), result, fCallingPackageName, mIntent);
                if (!integrity) {
                    if (ImportCertificateToYessign.this.mProgressDialog != null) {
                        ImportCertificateToYessign.this.mProgressDialog.dismiss();
                    }
                    ImportCertificateToYessign.this.ErrorMessage(ImportCertificateToYessign.this.getString(R.string.message_not_registered_caller));
                    return;
                }
                if (ImportCertificateToYessign.this.mProgressDialog != null) {
                    ImportCertificateToYessign.this.mProgressDialog.dismiss();
                }
                ImportCertificateToYessign.this.processReceivedIntent(mIntent);
            }
        });
    }

    private void processReceivedIntent(Intent intent) {
        YessignApplicationUtil.printIntent("BANK-RECV-REQ", intent);
        mCertificateDER = intent.getExtras().getByteArray("cert");
        mKeyDER = intent.getExtras().getByteArray("key");
        mKMCertificateDER = intent.getExtras().getByteArray("kmcert");
        mKMKeyDER = intent.getExtras().getByteArray("kmkey");
        mResult = intent.getExtras().getString("result");
        if (mCertificateDER.length < 1 && mKMCertificateDER.length < 1) {
            this.ErrorMessage("\uc778\uc99d\uc11c \uc800\uc7a5\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        this.importCertificate();
        mIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)"yessign-cert-gw://localhost/certpush"));
    }

    private void ShowProgressDialog(String pProgressDialogMessage) {
        this.mViewControlHandler = new Handler();
        if (this.mProgressDialog == null) {
            this.mProgressDialog = ProgressDialog.show((Context)this, (CharSequence)"Waiting", (CharSequence)pProgressDialogMessage, (boolean)true, (boolean)false);
            this.mProgressDialog.setCanceledOnTouchOutside(false);
        }
    }

    protected void importCertificate() {
        this.mImportCertificateThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block33: {
                    try {
                        File aTempDir = null;
                        File aTempUserCert = null;
                        File aTempUserKey = null;
                        File aTempUserKmCert = null;
                        File aTempUserKmKey = null;
                        FileOutputStream aCert = null;
                        FileOutputStream aKey = null;
                        FileOutputStream aKMCert = null;
                        FileOutputStream aKMKey = null;
                        String aCertPath = null;
                        String aKeyPath = null;
                        String aKmCertPath = null;
                        String aKmKeyPath = null;
                        String aSofoPath = null;
                        aSofoPath = XApplication.getContext().getFilesDir() + "/temp";
                        aCertPath = aSofoPath + "/SignCert.der";
                        aKeyPath = aSofoPath + "/SignPri.key";
                        aKmCertPath = aSofoPath + "/KmSignCert.der";
                        aKmKeyPath = aSofoPath + "/KmSignPri.key";
                        if ((mCertificateDER == null || mKeyDER == null) && (mKMCertificateDER == null || mKMKeyDER == null)) break block33;
                        try {
                            int aResult = 0;
                            aTempDir = new File(aSofoPath);
                            if (!aTempDir.exists()) {
                                boolean aMkdirResult = false;
                                aMkdirResult = aTempDir.mkdir();
                                XSLog.d((String)(this.getClass().getName() + "::Make directory result : " + aMkdirResult));
                                if (!aMkdirResult) {
                                    ImportCertificateToYessign.this.ErrorMessage("\uc778\uc99d\uc11c \uc800\uc7a5\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4.");
                                }
                            }
                            if (mCertificateDER != null && mKeyDER != null) {
                                aTempUserCert = new File(aSofoPath, "SignCert.der");
                                aTempUserKey = new File(aSofoPath, "SignPri.key");
                                aCert = new FileOutputStream(aTempUserCert);
                                aKey = new FileOutputStream(aTempUserKey);
                                aCert.write(mCertificateDER);
                                aKey.write(mKeyDER);
                            }
                            if (mKMCertificateDER != null && mKMKeyDER != null) {
                                aTempUserKmCert = new File(aSofoPath, "KmSignCert.der");
                                aTempUserKmKey = new File(aSofoPath, "KmSignPri.key");
                                aKMCert = new FileOutputStream(aTempUserKmCert);
                                aKMKey = new FileOutputStream(aTempUserKmKey);
                                aKMCert.write(mKMCertificateDER);
                                aKMKey.write(mKMKeyDER);
                            }
                            if (EnvironmentConfig.mSDCardOnlyUse) {
                                mMediaID = 101;
                            } else {
                                mMediaID = 1401;
                            }
                            if (mKMCertificateDER == null || mKMKeyDER == null) {
                                aResult = CertMgr.getInstance().importCert(mMediaID, null, null, null, aCertPath, aKeyPath, null, null);
                                aTempUserCert.delete();
                                aTempUserKey.delete();
                                aTempDir.delete();
                            } else if (mCertificateDER != null && mKMCertificateDER != null) {
                                aResult = CertMgr.getInstance().importCert(mMediaID, null, null, null, aCertPath, aKeyPath, aKmCertPath, aKmKeyPath);
                                aTempUserCert.delete();
                                aTempUserKey.delete();
                                aTempUserKmCert.delete();
                                aTempUserKmKey.delete();
                                aTempDir.delete();
                            }
                            if (aResult == -1) {
                                ImportCertificateToYessign.this.ErrorMessage("\uc778\uc99d\uc11c \uc800\uc7a5\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4.");
                            } else {
                                mIntent.putExtra("result", "00");
                                YessignApplicationUtil.printIntent("BANK-SEND-RESP", mIntent);
                                ImportCertificateToYessign.this.toastIntent("\uacf5\uc6a9\uc571\uc774 XecureSmart\ub85c \uc778\uc99d\uc11c \ub0b4\ubcf4\ub0b4\uae30(\uc694\uccad)", mResult, mCertificateDER, mKMCertificateDER);
                                if (ImportCertificateToYessign.this.mProgressDialog != null) {
                                    ImportCertificateToYessign.this.mProgressDialog.dismiss();
                                }
                                ImportCertificateToYessign.this.setResult(-1, mIntent);
                                ImportCertificateToYessign.this.finish();
                            }
                        }
                        catch (FileNotFoundException e) {
                            ImportCertificateToYessign.this.ErrorMessage("\uc778\uc99d\uc11c \uc800\uc7a5\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4.");
                        }
                        catch (IOException e) {
                            ImportCertificateToYessign.this.ErrorMessage("\uc778\uc99d\uc11c \uc800\uc7a5\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4.");
                        }
                        finally {
                            try {
                                if (aCert != null) {
                                    aCert.close();
                                }
                                if (aKey != null) {
                                    aKey.close();
                                }
                                if (aKMCert != null) {
                                    aKMCert.close();
                                }
                                if (aKMKey != null) {
                                    aKMKey.close();
                                }
                            }
                            catch (IOException e) {
                                ImportCertificateToYessign.this.ErrorMessage("\uc778\uc99d\uc11c \uc800\uc7a5\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4.");
                            }
                        }
                    }
                    catch (NullPointerException e) {
                        ImportCertificateToYessign.this.ErrorMessage("\uc778\uc99d\uc11c \uc800\uc7a5\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4.");
                    }
                }
            }
        });
        this.mImportCertificateThread.start();
    }

    private void ErrorMessage(final String pMessage) {
        this.mViewControlHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    new AlertDialog.Builder((Context)ImportCertificateToYessign.this).setMessage((CharSequence)pMessage).setPositiveButton((CharSequence)"\ud655\uc778", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            mIntent.putExtra("result", "11");
                            YessignApplicationUtil.printIntent("BANK-SEND-RESP", mIntent);
                            if (ImportCertificateToYessign.this.mProgressDialog != null) {
                                ImportCertificateToYessign.this.mProgressDialog.dismiss();
                            }
                            ImportCertificateToYessign.this.setResult(-1, mIntent);
                            ImportCertificateToYessign.this.finish();
                        }
                    }).show();
                }
                catch (NullPointerException e) {
                    XSLog.e((String)e.getMessage());
                }
            }
        });
    }

    private void toastIntent(final String pMessage, final String pResult, final byte[] mCertificateDER, final byte[] mKMCertificateDER) {
        this.mViewControlHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    StringBuilder builder = new StringBuilder();
                    builder.append(pMessage);
                    if (pResult != null) {
                        builder.append("\n").append("\uacb0\uacfc:").append(pResult);
                    }
                    if (mCertificateDER != null && mCertificateDER.length > 1) {
                        builder.append("\n").append("\uc11c\uba85\uc6a9\uc778\uc99d\uc11c:").append(YessignApplicationUtil.getCertSubjectDn(mCertificateDER));
                    } else {
                        builder.append("\n").append("\uc11c\uba85\uc6a9\uc778\uc99d\uc11c:").append(YessignApplicationUtil.getCertSubjectDn(mKMCertificateDER));
                    }
                    Toast.makeText((Context)ImportCertificateToYessign.this, (CharSequence)builder.toString(), (int)1).show();
                }
                catch (NullPointerException e) {
                    XSLog.e((String)e.getMessage());
                }
            }
        });
    }

    public void onBackPressed() {
        if (mIntent != null) {
            mIntent.putExtra("result", "11");
            YessignApplicationUtil.printIntent("BANK-SEND-RESP", mIntent);
            if (this.mProgressDialog != null) {
                this.mProgressDialog.dismiss();
            }
            this.setResult(-1, mIntent);
        }
        this.finish();
    }

    static {
        mIntent = null;
    }
}

