/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.yessign;

import android.app.Activity;
import android.app.ListActivity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import com.softforum.sample.R;
import com.softforum.xecure.XecureSmart;
import com.softforum.xecure.crypto.CertMgr;
import com.softforum.xecure.keypad.SignCertPasswordWindowWithXK;
import com.softforum.xecure.ui.crypto.SignCertPasswordWindow;
import com.softforum.xecure.ui.transkey.SignCertPasswordWindowWithTransKey;
import com.softforum.xecure.util.EnvironmentConfig;
import com.softforum.xecure.util.ImageTextSpinnerAdapter;
import com.softforum.xecure.util.XDetailData;
import com.softforum.xecure.util.XDetailDataParser;
import com.softforum.xecure.util.XDetailDataRowAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class SelectExportCertificateList
extends ListActivity {
    public static final int mExportCertificateID = 72800;
    private int mMediaID = XecureSmart.mDefaultMediaID;
    public static final int MEDIA_SDCARD = 0;
    public static final int MEDIA_APPDATA = 1;
    public static int mCallMode = -1;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.crypto_xecure_smart_cert_mgr_user);
        mCallMode = this.getIntent().getIntExtra("ChoiceAction", -1);
        if (EnvironmentConfig.mSDCardOnlyUse) {
            this.mMediaID = 101;
        } else if (EnvironmentConfig.mAppDataOnlyUse) {
            this.mMediaID = 1401;
        }
        this.setSpinner();
        if (!EnvironmentConfig.mSDCardAppDataUse) {
            this.setUserCertItems(this.mMediaID);
            View aView = this.findViewById(R.id.media_and_copy_layout);
            aView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, 0));
            aView.setVisibility(4);
        }
    }

    private void setSpinner() {
        if (EnvironmentConfig.mSDCardOnlyUse || EnvironmentConfig.mAppDataOnlyUse) {
            View aView = this.findViewById(R.id.select_media);
            aView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, 0));
            aView.setVisibility(4);
        } else {
            Spinner aSelectStorage = (Spinner)this.findViewById(R.id.select_media);
            ArrayList<HashMap<String, Object>> aItemList = new ArrayList<HashMap<String, Object>>();
            HashMap<String, Object> aItem = new HashMap<String, Object>();
            aItem.put("image", R.drawable.sdcard);
            aItem.put("text", "SDCard");
            aItemList.add(aItem);
            aItem = new HashMap();
            aItem.put("image", R.drawable.icon);
            aItem.put("text", "\uc571\ub370\uc774\ud130");
            aItemList.add(aItem);
            ImageTextSpinnerAdapter aAdapter = new ImageTextSpinnerAdapter((Context)this, aItemList);
            aSelectStorage.setAdapter((SpinnerAdapter)aAdapter);
            final SelectExportCertificateList aContext = this;
            aSelectStorage.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

                public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                    switch (position) {
                        case 0: {
                            SelectExportCertificateList.this.mMediaID = 101;
                            break;
                        }
                        case 1: {
                            SelectExportCertificateList.this.mMediaID = 1401;
                        }
                    }
                    aContext.setUserCertItems(SelectExportCertificateList.this.mMediaID);
                }

                public void onNothingSelected(AdapterView<?> arg0) {
                }
            });
        }
    }

    private void setUserCertItems(int pMediaID) {
        int aMediaID = 0;
        String aCertList = null;
        String aMediaList = null;
        StringTokenizer aMediaListTokenizer = null;
        ArrayList<XDetailData> aXCertDataList = new ArrayList<XDetailData>();
        int aSearchCondition = 0;
        aMediaID = pMediaID;
        aSearchCondition = 0;
        if (EnvironmentConfig.mExcludeExpiredCert) {
            aSearchCondition = 25;
        }
        CertMgr aCertMgr = CertMgr.getInstance();
        aMediaList = aCertMgr.getMediaList(aMediaID - 1, 1, 1);
        aMediaListTokenizer = new StringTokenizer(aMediaList, "\t\n");
        while (aMediaListTokenizer.hasMoreTokens()) {
            aMediaID = Integer.parseInt(aMediaListTokenizer.nextToken());
            aCertList = aCertMgr.getCertTree(aMediaID, 2, aSearchCondition, 5, "", null);
            aXCertDataList.addAll(XDetailDataParser.parse((String)aCertList, (int)3, (int)aMediaID));
        }
        this.setListAdapter((ListAdapter)new XDetailDataRowAdapter((Activity)this, aXCertDataList));
    }

    protected void onListItemClick(ListView l, View v, int position, long id2) {
        int aMediaID = 0;
        String aCertList = null;
        String aMediaList = null;
        StringTokenizer aMediaListTokenizer = null;
        XDetailData aSelectedCert = null;
        ArrayList aXCertDataList = new ArrayList();
        int aSearchCondition = 0;
        super.onListItemClick(l, v, position, id2);
        aMediaID = this.mMediaID;
        aSearchCondition = 0;
        if (EnvironmentConfig.mExcludeExpiredCert) {
            aSearchCondition = 25;
        }
        CertMgr aCertMgr = CertMgr.getInstance();
        aMediaList = aCertMgr.getMediaList(aMediaID - 1, 1, 1);
        aMediaListTokenizer = new StringTokenizer(aMediaList, "\t\n");
        while (aMediaListTokenizer.hasMoreTokens()) {
            aMediaID = Integer.parseInt(aMediaListTokenizer.nextToken());
            aCertList = aCertMgr.getCertTree(aMediaID, 2, aSearchCondition, 5, "", null);
            aXCertDataList.addAll(XDetailDataParser.parse((String)aCertList, (int)3, (int)aMediaID));
        }
        aSelectedCert = (XDetailData)aXCertDataList.get(position);
        Intent aIntent = null;
        if (EnvironmentConfig.mBasicKeyUsage) {
            aIntent = new Intent((Context)this, SignCertPasswordWindow.class);
        } else if (EnvironmentConfig.mMTransKeyUsage) {
            aIntent = new Intent((Context)this, SignCertPasswordWindowWithTransKey.class);
        } else if (EnvironmentConfig.mXecureKeypadFullViewUsage || EnvironmentConfig.mXecureKeypadNormalViewUsage) {
            aIntent = new Intent((Context)this, SignCertPasswordWindowWithXK.class);
        }
        aIntent.putExtra("sign_cert_password_media_id_key", this.mMediaID);
        aIntent.putExtra("sign_cert_password_selected_cert_data_key", aSelectedCert.getValueArray());
        if (mCallMode == 0) {
            aIntent.putExtra("call_mode_key", "call_mode_export_certificate");
        } else if (mCallMode == 2) {
            aIntent.putExtra("call_mode_key", "call_mode_export_certificate_ex");
        }
        this.startActivityForResult(aIntent, 70510);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == -1) {
            Intent aIntent = this.getIntent();
            aIntent.putExtra("xecure_smart_result_key", 12);
            this.setResult(-1, aIntent);
            this.finish();
        } else if (3 == resultCode) {
            Intent aIntent = this.getIntent();
            aIntent.putExtra("xecure_smart_result_key", 1);
            this.setResult(-1, aIntent);
            this.finish();
        } else if (2 == resultCode) {
            Intent aIntent = this.getIntent();
            aIntent.putExtra("xecure_smart_result_key", 13);
            this.setResult(-1, aIntent);
            this.finish();
        } else if (resultCode == 6) {
            Intent aIntent = this.getIntent();
            aIntent.putExtra("xecure_smart_result_key", 13);
            this.setResult(-1, aIntent);
            this.finish();
        }
    }
}

