/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public final class JsonTreeWriter
extends JsonWriter {
    private static final Writer a = new Writer(){

        public void write(char[] buffer, int offset, int counter) {
            throw new AssertionError();
        }

        public void flush() throws IOException {
            throw new AssertionError();
        }

        public void close() throws IOException {
            throw new AssertionError();
        }
    };
    private static final JsonPrimitive b = new JsonPrimitive("closed");
    private final List<JsonElement> c = new ArrayList<JsonElement>();
    private String d;
    private JsonElement e = JsonNull.INSTANCE;

    public JsonTreeWriter() {
        super(a);
    }

    public JsonElement get() {
        if (!this.c.isEmpty()) {
            throw new IllegalStateException("Expected one JSON element but was " + this.c);
        }
        return this.e;
    }

    private JsonElement a() {
        return this.c.get(this.c.size() - 1);
    }

    private void a(JsonElement value) {
        if (this.d != null) {
            if (!value.isJsonNull() || this.getSerializeNulls()) {
                JsonObject object = (JsonObject)this.a();
                object.add(this.d, value);
            }
            this.d = null;
        } else if (this.c.isEmpty()) {
            this.e = value;
        } else {
            JsonElement element = this.a();
            if (element instanceof JsonArray) {
                ((JsonArray)element).add(value);
            } else {
                throw new IllegalStateException();
            }
        }
    }

    public JsonWriter beginArray() throws IOException {
        JsonArray array = new JsonArray();
        this.a(array);
        this.c.add(array);
        return this;
    }

    public JsonWriter endArray() throws IOException {
        if (this.c.isEmpty() || this.d != null) {
            throw new IllegalStateException();
        }
        JsonElement element = this.a();
        if (element instanceof JsonArray) {
            this.c.remove(this.c.size() - 1);
            return this;
        }
        throw new IllegalStateException();
    }

    public JsonWriter beginObject() throws IOException {
        JsonObject object = new JsonObject();
        this.a(object);
        this.c.add(object);
        return this;
    }

    public JsonWriter endObject() throws IOException {
        if (this.c.isEmpty() || this.d != null) {
            throw new IllegalStateException();
        }
        JsonElement element = this.a();
        if (element instanceof JsonObject) {
            this.c.remove(this.c.size() - 1);
            return this;
        }
        throw new IllegalStateException();
    }

    public JsonWriter name(String name) throws IOException {
        if (this.c.isEmpty() || this.d != null) {
            throw new IllegalStateException();
        }
        JsonElement element = this.a();
        if (element instanceof JsonObject) {
            this.d = name;
            return this;
        }
        throw new IllegalStateException();
    }

    public JsonWriter value(String value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.a(new JsonPrimitive(value));
        return this;
    }

    public JsonWriter nullValue() throws IOException {
        this.a(JsonNull.INSTANCE);
        return this;
    }

    public JsonWriter value(boolean value) throws IOException {
        this.a(new JsonPrimitive(value));
        return this;
    }

    public JsonWriter value(double value) throws IOException {
        if (!this.isLenient() && (Double.isNaN(value) || Double.isInfinite(value))) {
            throw new IllegalArgumentException("JSON forbids NaN and infinities: " + value);
        }
        this.a(new JsonPrimitive(value));
        return this;
    }

    public JsonWriter value(long value) throws IOException {
        this.a(new JsonPrimitive(value));
        return this;
    }

    public JsonWriter value(Number value) throws IOException {
        double d;
        if (value == null) {
            return this.nullValue();
        }
        if (!this.isLenient() && (Double.isNaN(d = value.doubleValue()) || Double.isInfinite(d))) {
            throw new IllegalArgumentException("JSON forbids NaN and infinities: " + value);
        }
        this.a(new JsonPrimitive(value));
        return this;
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        if (!this.c.isEmpty()) {
            throw new IOException("Incomplete document");
        }
        this.c.add(b);
    }
}

