/*
 * Decompiled with CFR 0.152.
 */
package com.skp.smarttouch.sem.tools.dao.mtouch;

import android.os.Parcel;
import android.os.Parcelable;
import com.skp.smarttouch.sem.tools.dao.mtouch.MobileTouchCouponAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import kr.co.skplanet.utils.LOG;
import kr.co.skplanet.utils.Util;

public class MobileTouchCoupon
implements Parcelable {
    protected byte m_byPartnerID;
    protected byte m_byAffiliateID;
    protected byte[] m_baFranchiseID = new byte[10];
    protected String m_strCouponID;
    protected MobileTouchCouponAttribute m_oAttribute;
    protected Date m_oStartDate;
    protected Date m_oEndDate;
    protected String m_strCouponName;
    protected String m_strDiscountInfo;
    protected byte[] m_baAdjustmentID = new byte[3];
    protected byte m_byStatus;
    protected long m_lBasePaymentPee;
    protected byte m_byCanUsingCnt;
    protected byte[] m_baAuthCode = new byte[3];
    public static final Parcelable.Creator<MobileTouchCoupon> CREATOR = new Parcelable.Creator<MobileTouchCoupon>(){

        public MobileTouchCoupon a(Parcel in) {
            return new MobileTouchCoupon(in);
        }

        public MobileTouchCoupon[] a(int size) {
            return new MobileTouchCoupon[size];
        }

        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.a(parcel);
        }

        public /* synthetic */ Object[] newArray(int n) {
            return this.a(n);
        }
    };

    public MobileTouchCoupon() {
    }

    public MobileTouchCoupon(Parcel in) {
        this.a(in);
    }

    public static MobileTouchCoupon getParsingCouponObject(byte[] baCouponData) {
        LOG.info(">> getParsingCouponObject()");
        LOG.info("++ baCouponData : [%s]", Util.byteArrayToHexString(baCouponData));
        MobileTouchCoupon spCoupon = new MobileTouchCoupon();
        int nParsingIndex = 0;
        try {
            if (baCouponData == null || baCouponData.length == 0 || baCouponData[0] == -1) {
                throw new Exception("##### invaild baCouponData #####");
            }
            spCoupon.setPartnerID(baCouponData[nParsingIndex]);
            spCoupon.setAffiliateID(baCouponData[++nParsingIndex]);
            byte[] franchiseID = new byte[10];
            System.arraycopy(baCouponData, ++nParsingIndex, franchiseID, 0, 10);
            spCoupon.setFranchiseID(franchiseID);
            byte[] couponBCD = new byte[10];
            byte[] couponID = new byte[20];
            System.arraycopy(baCouponData, nParsingIndex += 10, couponBCD, 0, 10);
            Util.UnPackData(couponID, 0, couponBCD, 0, 10);
            spCoupon.setCouponID(new String(couponID));
            LOG.info("++ couponBCD : [%s]", Util.byteArrayToHexString(couponBCD));
            LOG.info("++ couponID : [%s]", Util.byteArrayToHexString(couponID));
            byte[] couponAttr = new byte[2];
            System.arraycopy(baCouponData, nParsingIndex += 10, couponAttr, 0, 2);
            spCoupon.setAttribute(couponAttr);
            nParsingIndex += 2;
            LOG.info("++ couponAttr : [%s]", Util.byteArrayToHexString(couponAttr));
            byte[] expireDateBCD = new byte[8];
            byte[] startDateData = new byte[8];
            byte[] endDateData = new byte[8];
            SimpleDateFormat format = new SimpleDateFormat("yyMMddHH");
            System.arraycopy(baCouponData, nParsingIndex, expireDateBCD, 0, 8);
            Util.UnPackData(startDateData, 0, expireDateBCD, 0, 4);
            Util.UnPackData(endDateData, 0, expireDateBCD, 4, 4);
            String startDateStr = new String(startDateData);
            String endDateStr = new String(endDateData);
            spCoupon.setStartDate(format.parse(startDateStr));
            spCoupon.setEndDate(format.parse(endDateStr));
            LOG.info("++ expireDateBCD : [%s]", Util.byteArrayToHexString(expireDateBCD));
            LOG.info("++ startDateData : [%s]", Util.byteArrayToHexString(startDateData));
            LOG.info("++ endDateData : [%s]", Util.byteArrayToHexString(endDateData));
            byte[] couponName = new byte[20];
            System.arraycopy(baCouponData, nParsingIndex += 8, couponName, 0, 20);
            if (Util.STRLEN(couponName) == 0) {
                spCoupon.setCouponName("SmartPay \ucfe0\ud3f0");
            } else {
                int len = Util.TrimRight(couponName, 0, ' ', 20);
                spCoupon.setCouponName(new String(couponName, 0, len, "KSC5601"));
            }
            LOG.info("++ couponName : [%s]", Util.byteArrayToHexString(couponName));
            byte[] paymentBCD = new byte[3];
            byte[] paymentData = new byte[6];
            System.arraycopy(baCouponData, nParsingIndex += 20, paymentBCD, 0, 3);
            Util.UnPackData(paymentData, 0, paymentBCD, 0, 3);
            spCoupon.setDiscountInfo(new String(paymentData));
            LOG.info("++ paymentBCD : [%s]", Util.byteArrayToHexString(paymentBCD));
            LOG.info("++ paymentData : [%s]", Util.byteArrayToHexString(paymentData));
            byte[] adjustmentID = new byte[3];
            System.arraycopy(baCouponData, nParsingIndex += 3, adjustmentID, 0, 3);
            spCoupon.setAdjustmentID(adjustmentID);
            LOG.info("++ adjustmentID : [%s]", Util.byteArrayToHexString(adjustmentID));
            byte[] baseBCD = new byte[4];
            byte[] baseData = new byte[8];
            System.arraycopy(baCouponData, nParsingIndex += 3, baseBCD, 0, 4);
            Util.UnPackData(baseData, 0, baseBCD, 0, 4);
            spCoupon.setBasePaymentPee(Long.valueOf(new String(baseData)));
            LOG.info("++ baseBCD : [%s]", Util.byteArrayToHexString(baseBCD));
            LOG.info("++ baseData : [%s]", Util.byteArrayToHexString(baseData));
            spCoupon.setStatus(baCouponData[nParsingIndex += 4]);
            spCoupon.setCanUsingCnt(baCouponData[++nParsingIndex]);
            byte[] couponAuth = new byte[3];
            System.arraycopy(baCouponData, ++nParsingIndex, couponAuth, 0, 3);
            spCoupon.setAuthCode(couponAuth);
            nParsingIndex += 3;
            LOG.info("++ couponAuth : [%s]", Util.byteArrayToHexString(couponAuth));
            ++nParsingIndex;
            ++nParsingIndex;
        }
        catch (Exception e) {
            LOG.error(e);
            spCoupon = null;
        }
        return spCoupon;
    }

    public void dumpToLogcat() {
        LOG.info("===========================================");
        LOG.info(" MobileTouchCoupon (" + this.m_strCouponID + ")");
        LOG.info("===========================================");
        LOG.info(" m_byPartnerID(HEX) : 0x" + Util.getHexChar(this.m_byPartnerID));
        LOG.info(" m_byAffiliateID(HEX) : 0x" + Util.getHexChar(this.m_byAffiliateID));
        LOG.info(" m_baFranchiseID(HEX) : " + Util.getHexString(this.m_baFranchiseID));
        LOG.info(" m_strCouponID : " + this.m_strCouponID);
        LOG.info(" m_oAttribute : ");
        this.m_oAttribute.dumpToLogcat();
        LOG.info(" m_oStartDate : " + this.m_oStartDate.toLocaleString());
        LOG.info(" m_oEndDate : " + this.m_oEndDate.toLocaleString());
        LOG.info(" m_strCouponName : " + this.m_strCouponName);
        LOG.info(" m_strDiscountInfo : " + this.m_strDiscountInfo);
        LOG.info(" m_baAdjustmentID(HEX) : " + Util.getHexString(this.m_baAdjustmentID));
        LOG.info(" m_byStatus : " + this.m_byStatus);
        LOG.info(" m_lBasePaymentPee : " + this.m_lBasePaymentPee);
        LOG.info(" m_byCanUsingCnt : " + this.m_byCanUsingCnt);
        LOG.info(" m_baAuthCode(HEX) : " + Util.getHexString(this.m_baAuthCode));
        LOG.info(" -------------- ");
        LOG.info(" SmartWallet Coupon ID : " + this.getSWCouponID());
        LOG.info(" -------------- ");
        LOG.info("===========================================");
    }

    public int describeContents() {
        LOG.info(">> describeContents()");
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByte(this.m_byPartnerID);
        dest.writeByte(this.m_byAffiliateID);
        dest.writeByteArray(this.m_baFranchiseID, 0, 10);
        dest.writeString(this.m_strCouponID);
        dest.writeParcelable((Parcelable)this.m_oAttribute, 1);
        dest.writeLong(this.m_oStartDate.getTime());
        dest.writeLong(this.m_oEndDate.getTime());
        dest.writeString(this.m_strCouponName);
        dest.writeString(this.m_strDiscountInfo);
        dest.writeByteArray(this.m_baAdjustmentID, 0, 3);
        dest.writeByte(this.m_byStatus);
        dest.writeLong(this.m_lBasePaymentPee);
        dest.writeByte(this.m_byCanUsingCnt);
        dest.writeByteArray(this.m_baAuthCode, 0, 3);
    }

    private void a(Parcel in) {
        LOG.info(">> readFromParcel()");
        LOG.info("++ in : [%s]", in);
        this.m_byPartnerID = in.readByte();
        this.m_byAffiliateID = in.readByte();
        byte[] franchiseID = in.createByteArray();
        System.arraycopy(franchiseID, 0, this.m_baFranchiseID, 0, 10);
        this.m_strCouponID = in.readString();
        ClassLoader loader = MobileTouchCouponAttribute.class.getClassLoader();
        this.m_oAttribute = (MobileTouchCouponAttribute)in.readParcelable(loader);
        this.m_oStartDate = new Date(in.readLong());
        this.m_oEndDate = new Date(in.readLong());
        this.m_strCouponName = in.readString();
        this.m_strDiscountInfo = in.readString();
        byte[] adjustmentID = in.createByteArray();
        System.arraycopy(adjustmentID, 0, this.m_baAdjustmentID, 0, 3);
        this.m_byStatus = in.readByte();
        this.m_lBasePaymentPee = in.readLong();
        this.m_byCanUsingCnt = in.readByte();
        byte[] authCode = in.createByteArray();
        System.arraycopy(authCode, 0, this.m_baAuthCode, 0, 3);
    }

    public byte getPartnerID() {
        return this.m_byPartnerID;
    }

    public void setPartnerID(byte mtPartnerID) {
        this.m_byPartnerID = mtPartnerID;
    }

    public byte getAffiliateID() {
        return this.m_byAffiliateID;
    }

    public void setAffiliateID(byte mtAffiliateID) {
        this.m_byAffiliateID = mtAffiliateID;
    }

    public byte[] getFranchiseID() {
        return this.m_baFranchiseID;
    }

    public void setFranchiseID(byte[] mtFranchiseID) {
        System.arraycopy(mtFranchiseID, 0, this.m_baFranchiseID, 0, 10);
    }

    public String getCouponID() {
        return this.m_strCouponID;
    }

    public void setCouponID(String mtCouponID) {
        this.m_strCouponID = mtCouponID;
    }

    public MobileTouchCouponAttribute getAttribute() {
        return this.m_oAttribute;
    }

    public void setAttribute(MobileTouchCouponAttribute mtAttribute) {
        this.m_oAttribute = mtAttribute;
    }

    public void setAttribute(byte[] baAttribute) {
        this.m_oAttribute = new MobileTouchCouponAttribute(baAttribute);
    }

    public Date getStartDate() {
        return this.m_oStartDate;
    }

    public void setStartDate(Date mtStartDate) {
        this.m_oStartDate = mtStartDate;
    }

    public Date getEndDate() {
        return this.m_oEndDate;
    }

    public void setEndDate(Date mtEndDate) {
        this.m_oEndDate = mtEndDate;
    }

    public String getCouponName() {
        return this.m_strCouponName;
    }

    public void setCouponName(String couponName) {
        this.m_strCouponName = couponName;
    }

    public String getDiscountInfo() {
        return this.m_strDiscountInfo;
    }

    public void setDiscountInfo(String mtDiscountInfo) {
        this.m_strDiscountInfo = mtDiscountInfo;
    }

    public byte[] getAdjustmentID() {
        return this.m_baAdjustmentID;
    }

    public void setAdjustmentID(byte[] mtAdjustmentID) {
        System.arraycopy(mtAdjustmentID, 0, this.m_baAdjustmentID, 0, 3);
    }

    public byte getStatus() {
        return this.m_byStatus;
    }

    public void setStatus(byte mtStatus) {
        this.m_byStatus = mtStatus;
    }

    public long getBasePaymentPee() {
        return this.m_lBasePaymentPee;
    }

    public void setBasePaymentPee(long mtBasePaymentPee) {
        this.m_lBasePaymentPee = mtBasePaymentPee;
    }

    public byte getCanUsingCnt() {
        return this.m_byCanUsingCnt;
    }

    public void setCanUsingCnt(byte mtCanUsingCnt) {
        this.m_byCanUsingCnt = mtCanUsingCnt;
    }

    public byte[] getAuthCode() {
        return this.m_baAuthCode;
    }

    public void setAuthCode(byte[] mtAuthCode) {
        System.arraycopy(mtAuthCode, 0, this.m_baAuthCode, 0, 3);
    }

    public int getSWCouponID() {
        if (this.m_strCouponID == null) {
            return -1;
        }
        return Integer.valueOf(this.m_strCouponID.substring(0, 6));
    }
}

