/*
 * Decompiled with CFR 0.152.
 */
package com.skp.smarttouch.sem.tools.network;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.SimpleTimeZone;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kr.co.skplanet.utils.LOG;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class Network {
    private static WifiManager.WifiLock b = null;
    static final HostnameVerifier a = new HostnameVerifier(){

        @Override
        public boolean verify(String arg0, SSLSession arg1) {
            return true;
        }
    };

    public static byte[] getIpAddress(Context context) {
        LOG.info(">> getIpAddress()");
        WifiManager wifiMgr = (WifiManager)context.getSystemService("wifi");
        if (wifiMgr == null || !wifiMgr.isWifiEnabled()) {
            return null;
        }
        WifiInfo wifiInfo = wifiMgr.getConnectionInfo();
        if (wifiInfo == null) {
            return null;
        }
        try {
            int nIP = wifiMgr.getConnectionInfo().getIpAddress();
            byte[] byteIp = new byte[]{(byte)(nIP & 0xFF), (byte)(nIP >> 8 & 0xFF), (byte)(nIP >> 16 & 0xFF), (byte)(nIP >> 24 & 0xFF)};
            return byteIp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] getMACAddress(Context context) {
        LOG.info(">> getMACAddress");
        byte[] byteMacAddr = new byte[6];
        WifiManager wifiMgr = (WifiManager)context.getSystemService("wifi");
        if (!wifiMgr.isWifiEnabled()) {
            return null;
        }
        String strMac = wifiMgr.getConnectionInfo().getMacAddress();
        strMac = strMac.replace(":", "");
        if ((strMac = strMac.replace(".", "")).length() < 12) {
            return null;
        }
        int i = 0;
        while (i < 6) {
            int nStart = i * 2;
            int nEnd = nStart + 2;
            byteMacAddr[i] = (byte)Integer.parseInt(strMac.substring(nStart, nEnd), 16);
            ++i;
        }
        return byteMacAddr;
    }

    public static String getServerMessage(String strUrl, String appKey) {
        LOG.info(">> getServerMessage()");
        return Network.getServerMessage(strUrl, appKey, null, null);
    }

    public static String getServerMessage(String strUrl, String appKey, String strRequestMsg) {
        LOG.info(">> getServerMessage()");
        return Network.getServerMessage(strUrl, appKey, strRequestMsg, null);
    }

    public static String getServerMessage(String strUrl, String appKey, String strRequestMsg, String method) {
        LOG.info(">> getServerMessage()");
        String strMessage = null;
        byte[] byteData = Network.getServerData(strUrl, appKey, strRequestMsg, method, 10, true);
        LOG.info(">> getServerMessage - byteData[" + byteData + "]");
        if (byteData == null) {
            LOG.warning(">> Retry getServerMessage - byteData is null");
            byteData = Network.getServerData(strUrl, appKey, strRequestMsg, method, 10, true);
            LOG.warning(">> Retry getServerMessage - byteData [" + byteData + "]");
        }
        if (byteData != null) {
            try {
                strMessage = new String(byteData);
            }
            catch (Exception e) {
                LOG.error(e);
            }
        }
        return strMessage;
    }

    public static boolean isAvailableInternet() {
        LOG.info(">> isAvailableInternet()");
        BasicHttpParams httpParam = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParam, (int)3000);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParam, (int)3000);
        DefaultHttpClient httpClient = new DefaultHttpClient((HttpParams)httpParam);
        URI uri = null;
        try {
            uri = new URI("http://www.google.com");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        HttpGet httpGet = new HttpGet(uri);
        try {
            httpClient.execute((HttpUriRequest)httpGet);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean isNetworkEnabled(Context context) {
        LOG.info(">> isNetworkEnabled()");
        ConnectivityManager connMgr = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo netInfo = connMgr.getActiveNetworkInfo();
        return netInfo != null;
    }

    public static boolean isWifiEnabled(Context context) {
        LOG.info(">> isWifiEnabled()");
        WifiManager wifiMgr = (WifiManager)context.getSystemService("wifi");
        WifiInfo wInfo = wifiMgr.getConnectionInfo();
        return wifiMgr.isWifiEnabled() && wInfo.getSSID() != null;
    }

    public static void setWifiEnabled(Context context, boolean bEnable) {
        LOG.info(">> setWifiEnabled()");
        WifiManager wifiMgr = (WifiManager)context.getSystemService("wifi");
        if (!bEnable) {
            LOG.info("++ bEnable=%d", bEnable);
            if (wifiMgr.isWifiEnabled()) {
                wifiMgr.setWifiEnabled(false);
            }
        } else {
            LOG.info("++ bEnable=%d", bEnable);
            wifiMgr.setWifiEnabled(true);
        }
    }

    public static void setWifiLock(Context context) {
        LOG.info(">> setWifiLock()");
        if (b != null) {
            return;
        }
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        b = wifiManager.createWifiLock(context.toString());
        b.setReferenceCounted(true);
        b.acquire();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] getServerData(String strUrl, String appKey, String strRequestMsg, String method, int nTimeout, boolean bTrustAll) {
        LOG.info(">> getServerData()");
        LOG.info("++ strUrl : [%s]", strUrl);
        LOG.info("++ appKey : [%s]", appKey);
        LOG.info("++ strRequestMsg : [%s]", strRequestMsg);
        LOG.info("++ method : [%s]", method);
        LOG.info("++ nTimeout : [%s]", nTimeout);
        LOG.info("++ bTrustAll : [%s]", bTrustAll);
        byte[] byteData = null;
        int nSize = 0;
        byte[] byteBuf = new byte[10240];
        InputStream is = null;
        ByteArrayOutputStream bos = null;
        try {
            URL downUrl = new URL(strUrl);
            if (strUrl.toLowerCase().indexOf("https://") == 0 && !bTrustAll) {
                HttpsURLConnection httpsUrlConnection = null;
                httpsUrlConnection = (HttpsURLConnection)downUrl.openConnection();
                httpsUrlConnection.setConnectTimeout(nTimeout * 1000);
                httpsUrlConnection.setReadTimeout(nTimeout * 1000);
                httpsUrlConnection.setUseCaches(false);
                httpsUrlConnection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                httpsUrlConnection.setRequestProperty("Accept", "application/json");
                SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.ENGLISH);
                format.setTimeZone(new SimpleTimeZone(0, "GMT"));
                format.format(System.currentTimeMillis());
                httpsUrlConnection.setRequestProperty("Date", format.format(System.currentTimeMillis()));
                httpsUrlConnection.setRequestProperty("Host", httpsUrlConnection.getURL().getHost());
                if (appKey != null) {
                    httpsUrlConnection.setRequestProperty("appKey", appKey);
                }
                if (method != null) {
                    httpsUrlConnection.setRequestMethod(method);
                }
                if (strRequestMsg != null) {
                    httpsUrlConnection.setRequestProperty("Content-Length", "" + strRequestMsg.getBytes().length);
                    httpsUrlConnection.setDoOutput(true);
                    httpsUrlConnection.connect();
                    OutputStream outStream = httpsUrlConnection.getOutputStream();
                    outStream.write(strRequestMsg.getBytes());
                    outStream.flush();
                    outStream.close();
                } else {
                    httpsUrlConnection.connect();
                }
                int nResCode = httpsUrlConnection.getResponseCode();
                if (nResCode != 200) {
                    String strResMsg = httpsUrlConnection.getResponseMessage();
                    LOG.warning("Http Response error:%d (%s)", nResCode, strResMsg);
                    if (appKey == null) {
                        return null;
                    }
                    is = httpsUrlConnection.getErrorStream();
                } else {
                    is = httpsUrlConnection.getInputStream();
                }
                bos = new ByteArrayOutputStream();
                nSize = httpsUrlConnection.getContentLength();
                if (nSize < 0) {
                    LOG.warning("Content-length is invalid");
                    int nLen = 0;
                    while ((nLen = is.read(byteBuf)) >= 0) {
                        bos.write(byteBuf, 0, nLen);
                    }
                    bos.flush();
                } else {
                    LOG.warning("nSize = " + nSize);
                    int nLen = 0;
                    int nRead = 0;
                    int nTotal = nSize;
                    while (nRead < nTotal) {
                        nLen = is.read(byteBuf);
                        nRead += nLen;
                        bos.write(byteBuf, 0, nLen);
                    }
                    bos.flush();
                }
                byteData = bos.toByteArray();
                bos.close();
                httpsUrlConnection.disconnect();
            } else {
                Network.a();
                HttpURLConnection httpUrlConnection = null;
                httpUrlConnection = (HttpURLConnection)downUrl.openConnection();
                if (strUrl.toLowerCase().indexOf("https://") == 0 && bTrustAll) {
                    LOG.info("++++++++++++++++++ DO_NOT_VERIFY");
                    ((HttpsURLConnection)httpUrlConnection).setHostnameVerifier(a);
                }
                httpUrlConnection.setConnectTimeout(nTimeout * 1000);
                httpUrlConnection.setReadTimeout(nTimeout * 1000);
                httpUrlConnection.setUseCaches(false);
                httpUrlConnection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                httpUrlConnection.setRequestProperty("Accept", "application/json");
                SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.ENGLISH);
                format.setTimeZone(new SimpleTimeZone(0, "GMT"));
                format.format(System.currentTimeMillis());
                httpUrlConnection.setRequestProperty("Date", format.format(System.currentTimeMillis()));
                httpUrlConnection.setRequestProperty("Host", httpUrlConnection.getURL().getHost());
                if (appKey != null) {
                    httpUrlConnection.setRequestProperty("appKey", appKey);
                }
                if (method != null) {
                    httpUrlConnection.setRequestMethod(method);
                }
                if (strRequestMsg != null) {
                    httpUrlConnection.setRequestProperty("Content-Length", "" + strRequestMsg.getBytes().length);
                    httpUrlConnection.setDoOutput(true);
                    httpUrlConnection.connect();
                    OutputStream outStream = httpUrlConnection.getOutputStream();
                    outStream.write(strRequestMsg.getBytes());
                    outStream.flush();
                    outStream.close();
                } else {
                    httpUrlConnection.connect();
                }
                int nResCode = httpUrlConnection.getResponseCode();
                if (nResCode != 200) {
                    String strResMsg = httpUrlConnection.getResponseMessage();
                    httpUrlConnection.getErrorStream();
                    LOG.warning("Http Response error:%d (%s)", nResCode, strResMsg);
                    if (appKey == null) {
                        return null;
                    }
                    is = httpUrlConnection.getErrorStream();
                } else {
                    is = httpUrlConnection.getInputStream();
                }
                bos = new ByteArrayOutputStream();
                nSize = httpUrlConnection.getContentLength();
                LOG.warning("+++++++++++++++++ nSize : [%s]", nSize);
                nSize = -1;
                if (nSize < 0) {
                    LOG.warning("Content-length is invalid");
                    int nLen = 0;
                    while (true) {
                        nLen = is.read(byteBuf);
                        LOG.warning("+++++++++++++++++ nLen : [%s]", nLen);
                        if (nLen < 0) break;
                        bos.write(byteBuf, 0, nLen);
                    }
                    bos.flush();
                } else {
                    LOG.warning("nSize = " + nSize);
                    int nLen = 0;
                    int nRead = 0;
                    int nTotal = nSize;
                    while (nRead < nTotal) {
                        nLen = is.read(byteBuf);
                        nRead += nLen;
                        bos.write(byteBuf, 0, nLen);
                    }
                    bos.flush();
                }
                byteData = bos.toByteArray();
                bos.close();
                if (is != null) {
                    is.close();
                }
                httpUrlConnection.disconnect();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return byteData;
    }

    public void setWifiUnlock() {
        LOG.info(">> Network::setWifiUnlock()");
        if (b == null) {
            return;
        }
        b.release();
        b = null;
    }

    private static void a() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static InputStream getInputStreamFromUrl(String url) {
        InputStream contentStream = null;
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpResponse response = httpclient.execute((HttpUriRequest)new HttpGet(url));
            contentStream = response.getEntity().getContent();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return contentStream;
    }

    public static String getStringFromUrl(String url) {
        BufferedReader br = new BufferedReader(new InputStreamReader(Network.getInputStreamFromUrl(url)));
        StringBuffer sb = new StringBuffer();
        try {
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }
}

