/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecurekeypad;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.softforum.xecurekeypad.XKCoreWrapper;
import com.softforum.xecurekeypad.XKEditText;
import com.softforum.xecurekeypad.XKKeypadTopLayout;
import com.softforum.xecurekeypad.XKNumberKeypad;
import com.softforum.xecurekeypad.XKQwertyKeypad;
import java.util.ArrayList;

public class XKKeypad
extends RelativeLayout {
    private int mXKType = 0;
    private int mXKViewType = 0;
    private int mLayoutIdentifier = 0;
    private XKQwertyKeypad mXKQwertyKeypad = null;
    private XKNumberKeypad mXKNumberKeypad = null;
    private XKKeypadTopLayout mXKKeypadTopLayout = null;
    private XKEditText mXKEditText = null;
    private XKCoreWrapper mXKCoreWrapper = null;
    private EditText mDummyEditText = null;
    private Drawable mXKBlankLogoImage = null;
    private Activity mCallerActivity = null;
    private Context mContext = null;
    private Activity mActivity = null;

    public XKKeypad(Context pContext) {
        super(pContext);
        this.mContext = pContext;
        this.mActivity = (Activity)this.mContext;
    }

    public XKKeypad(Context pContext, AttributeSet pAttributeSet) {
        super(pContext, pAttributeSet);
        this.mContext = pContext;
        this.mActivity = (Activity)this.mContext;
    }

    private void initKeypad() {
        this.mXKType = this.mXKEditText.getKeypadType();
        this.mXKViewType = this.mXKEditText.getKeypadViewType();
        if (this.mXKViewType == 0) {
            this.mLayoutIdentifier = this.mXKEditText.getLayoutIdentifier();
        }
        switch (this.mXKType) {
            case 0: {
                this.mXKNumberKeypad = new XKNumberKeypad(this.mContext);
                this.mXKNumberKeypad.setXKCoreWrapper(this.mXKCoreWrapper);
                this.mXKNumberKeypad.setXKEditText(this.mXKEditText, this.mDummyEditText);
                this.mXKNumberKeypad.setXKBlankLogoImage(this.mXKBlankLogoImage);
                this.mXKNumberKeypad.initKeypad();
                break;
            }
            case 1: {
                this.mXKQwertyKeypad = new XKQwertyKeypad(this.mContext);
                this.mXKQwertyKeypad.setXKCoreWrapper(this.mXKCoreWrapper);
                this.mXKQwertyKeypad.setXKEditText(this.mXKEditText, this.mDummyEditText);
                this.mXKQwertyKeypad.setXKBlankLogoImage(this.mXKBlankLogoImage);
                this.mXKQwertyKeypad.initKeypad();
            }
        }
    }

    private int makeXKKeypadIndex() {
        int aResult = 0;
        switch (this.mXKType) {
            case 0: {
                aResult = this.mXKNumberKeypad.makeXKKeypadIndex();
                break;
            }
            case 1: {
                aResult = this.mXKQwertyKeypad.makeXKKeypadIndex();
            }
        }
        return aResult;
    }

    private void setXKKeypadButtonImage() {
        switch (this.mXKType) {
            case 0: {
                this.mXKNumberKeypad.setXKKeypadButtonImage();
                break;
            }
            case 1: {
                this.mXKQwertyKeypad.setXKKeypadButtonImage();
            }
        }
    }

    private void setXKKeypad() {
        int aIndexCount = 0;
        ArrayList<LinearLayout> aXKKeypadLayoutList = null;
        switch (this.mXKType) {
            case 0: {
                this.mXKNumberKeypad.setXKKeypad();
                aXKKeypadLayoutList = this.mXKNumberKeypad.getXKKeypadLayoutList();
                break;
            }
            case 1: {
                this.mXKQwertyKeypad.setXKKeypad();
                aXKKeypadLayoutList = this.mXKQwertyKeypad.getXKKeypadLayoutList();
            }
        }
        aIndexCount = 0;
        while (aIndexCount < aXKKeypadLayoutList.size()) {
            this.addView((View)aXKKeypadLayoutList.get(aIndexCount));
            ++aIndexCount;
        }
        this.mXKKeypadTopLayout = (XKKeypadTopLayout)this.mActivity.findViewById(this.getResources().getIdentifier("xk_keypad_top_layout", "id", this.mActivity.getPackageName()));
        this.mXKKeypadTopLayout.resizeKeypadTopLayout();
        this.mXKKeypadTopLayout.setVisibility(0);
        this.mXKKeypadTopLayout.setEnabled(true);
        this.setVisibility(0);
        this.setEnabled(true);
    }

    private void resizeBackgroundLayout() {
        int[] aXKEditTextLocation = null;
        int aXKEditTextBottomMargin = 0;
        int aCallerLayoutSize = 0;
        int aXKKeypadLocation = 0;
        int aTopLayoutHeight = 0;
        int aTopMargin = 0;
        int aXKKeypadHeight = 0;
        ViewGroup.LayoutParams aTopLayoutParams = null;
        ViewGroup.MarginLayoutParams aXKEditTextLayoutParams = null;
        aXKEditTextLocation = new int[2];
        this.mXKEditText.getLocationInWindow(aXKEditTextLocation);
        aXKEditTextLayoutParams = (ViewGroup.MarginLayoutParams)this.mXKEditText.getLayoutParams();
        if (aXKEditTextLayoutParams == null) {
            return;
        }
        aXKEditTextBottomMargin = aXKEditTextLayoutParams.bottomMargin;
        switch (this.mXKType) {
            case 0: {
                aXKKeypadHeight = this.mXKNumberKeypad.getXKKeypadHeight();
                break;
            }
            case 1: {
                aXKKeypadHeight = this.mXKQwertyKeypad.getXKKeypadHeight();
            }
        }
        if (this.mXKKeypadTopLayout != null) {
            aTopLayoutParams = this.mXKKeypadTopLayout.getLayoutParams();
            aTopLayoutHeight = aTopLayoutParams.height;
        }
        if ((aTopMargin = (aCallerLayoutSize = this.mCallerActivity.getWindow().getDecorView().getRootView().getHeight() - aXKKeypadHeight - aTopLayoutHeight) - (aXKKeypadLocation = aXKEditTextLocation[1] + this.mXKEditText.getHeight() + this.mXKEditText.getPaddingBottom() + aXKEditTextBottomMargin + 4)) < 0) {
            this.mCallerActivity.findViewById(this.mLayoutIdentifier).layout(this.mCallerActivity.findViewById(this.mLayoutIdentifier).getLeft(), this.mCallerActivity.findViewById(this.mLayoutIdentifier).getTop() + aTopMargin, this.mCallerActivity.findViewById(this.mLayoutIdentifier).getRight(), this.mCallerActivity.findViewById(this.mLayoutIdentifier).getBottom() + aTopMargin);
        }
    }

    private void setFirstButtonFocus() {
        switch (this.mXKType) {
            case 0: {
                this.mXKNumberKeypad.setFirstButtonFocus();
                break;
            }
            case 1: {
                this.mXKQwertyKeypad.setFirstButtonFocus();
            }
        }
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        switch (this.mXKType) {
            case 0: {
                this.mXKNumberKeypad.changeConfiguration();
                break;
            }
            case 1: {
                this.mXKQwertyKeypad.changeConfiguration();
            }
        }
        if (this.mXKKeypadTopLayout != null) {
            this.mXKKeypadTopLayout.resizeKeypadTopLayout();
        }
        super.onConfigurationChanged(newConfig);
    }

    public void setXKEditText(XKEditText pXKEditText) {
        this.mXKEditText = pXKEditText;
    }

    public void setXKEditText(XKEditText pXKEditText, EditText pDummyEditText) {
        this.mXKEditText = pXKEditText;
        this.mDummyEditText = pDummyEditText;
    }

    public void setXKCoreWrapper(XKCoreWrapper pXKCoreWrapper) {
        this.mXKCoreWrapper = pXKCoreWrapper;
    }

    public void setCallerActivity(Activity pCallerActivity) {
        this.mCallerActivity = pCallerActivity;
    }

    public void setXKBlankLogoImage(Drawable pXKBlankLogoImage) {
        this.mXKBlankLogoImage = pXKBlankLogoImage;
    }

    public void showXKKeypad() {
        XKKeypadIndexTask aXKKeypadIndexTask = null;
        aXKKeypadIndexTask = new XKKeypadIndexTask();
        if (Build.VERSION.SDK_INT >= 11) {
            aXKKeypadIndexTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        } else {
            aXKKeypadIndexTask.execute(new Void[0]);
        }
    }

    private class XKKeypadIndexTask
    extends AsyncTask<Void, Void, Integer> {
        private ProgressDialog mProgressDialog = null;

        private XKKeypadIndexTask() {
        }

        protected void onPreExecute() {
            XKKeypad.this.initKeypad();
            this.mProgressDialog = new ProgressDialog(XKKeypad.this.mContext);
            this.mProgressDialog.setMessage((CharSequence)"\ubcf4\uc548\ud0a4\ud328\ub4dc\ub97c \uc0dd\uc131\uc911\uc785\ub2c8\ub2e4");
            this.mProgressDialog.setIndeterminate(true);
            this.mProgressDialog.setCanceledOnTouchOutside(false);
            this.mProgressDialog.setCancelable(true);
            this.mProgressDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialog) {
                    dialog.dismiss();
                    XKKeypadIndexTask.this.cancel(true);
                }
            });
            this.mProgressDialog.show();
            super.onPreExecute();
        }

        protected Integer doInBackground(Void ... params) {
            int aResult = 0;
            aResult = XKKeypad.this.makeXKKeypadIndex();
            return aResult;
        }

        protected void onPostExecute(Integer aResult) {
            Intent aIntent = null;
            if (aResult == 0) {
                XKKeypad.this.setXKKeypadButtonImage();
                XKKeypad.this.setXKKeypad();
                if (XKKeypad.this.mXKViewType == 0) {
                    XKKeypad.this.resizeBackgroundLayout();
                    XKKeypad.this.mCallerActivity.findViewById(XKKeypad.this.mLayoutIdentifier).getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                        public void onGlobalLayout() {
                            if (XKKeypad.this.isEnabled()) {
                                XKKeypad.this.resizeBackgroundLayout();
                            }
                        }
                    });
                }
            } else {
                aIntent = XKKeypad.this.mActivity.getIntent();
                XKKeypad.this.mActivity.setResult(200000, aIntent);
                XKKeypad.this.mActivity.finish();
            }
            this.mProgressDialog.dismiss();
            XKKeypad.this.setFirstButtonFocus();
            super.onPostExecute((Object)aResult);
        }

        protected void onCancelled() {
            Intent aIntent = null;
            this.mProgressDialog.dismiss();
            this.cancel(true);
            aIntent = XKKeypad.this.mActivity.getIntent();
            XKKeypad.this.mActivity.setResult(200000, aIntent);
            XKKeypad.this.mActivity.finish();
            super.onCancelled();
        }
    }
}

