/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.nfc.tech.IsoDep;
import android.webkit.JavascriptInterface;
import com.softforum.xecure.XApplication;
import com.softforum.xecure.crypto.BlockMgr;
import com.softforum.xecure.crypto.CMPMgr;
import com.softforum.xecure.crypto.CertMgr;
import com.softforum.xecure.crypto.ICCardMgr;
import com.softforum.xecure.crypto.ICCardMgr2;
import com.softforum.xecure.crypto.SessionMgr;
import com.softforum.xecure.crypto.SignEnvelopMgr;
import com.softforum.xecure.crypto.XSFileEnvelope;
import com.softforum.xecure.keypad.RequestCertificateWithXK;
import com.softforum.xecure.keypad.XecureSmartInputVIDWithXK;
import com.softforum.xecure.ui.crypto.CMPProgressDialog;
import com.softforum.xecure.ui.crypto.EnvelopInputPassword;
import com.softforum.xecure.ui.crypto.PKCS11Password;
import com.softforum.xecure.ui.crypto.RequestCertificate;
import com.softforum.xecure.ui.crypto.SignCertSelectWindow;
import com.softforum.xecure.ui.crypto.SignMessageConfirm;
import com.softforum.xecure.ui.crypto.TestICCardRequestCertificate;
import com.softforum.xecure.ui.crypto.XecureSmartFileDeenvelopWithCert;
import com.softforum.xecure.ui.crypto.XecureSmartFileDeenvelopWithPasswd;
import com.softforum.xecure.ui.crypto.XecureSmartFileDownload;
import com.softforum.xecure.ui.crypto.XecureSmartFileEnvelopWithCert;
import com.softforum.xecure.ui.crypto.XecureSmartFileEnvelopWithPEM;
import com.softforum.xecure.ui.crypto.XecureSmartFileEnvelopWithPasswd;
import com.softforum.xecure.ui.crypto.XecureSmartFileSign;
import com.softforum.xecure.ui.crypto.XecureSmartFileUpload;
import com.softforum.xecure.ui.crypto.XecureSmartInputVID;
import com.softforum.xecure.ui.transkey.RequestCertificateWithTransKey;
import com.softforum.xecure.ui.transkey.XecureSmartInputVIDWithTransKey;
import com.softforum.xecure.util.BlockerActivityResult;
import com.softforum.xecure.util.BlockerActivityUtil;
import com.softforum.xecure.util.EnvironmentConfig;
import com.softforum.xecure.util.XCoreUtil;
import com.softforum.xecure.util.XSLog;
import com.softforum.xecure.util.XUtil;
import java.io.File;
import java.util.StringTokenizer;

public class XecureSmart {
    public static int mDefaultMediaID = 1401;
    private static volatile XecureSmart mUniqueXecureSmartInstance;
    private BlockMgr mBlockMgr;
    private CMPMgr mCMPMgr;
    private CertMgr mCertMgr;
    private XSFileEnvelope mFileEnvelope;
    private SignEnvelopMgr mSignEnvelopMgr;
    private SessionMgr mSessionMgr;
    private XCoreUtil mCoreUtil;
    private long mSessionID;
    private Context mGlobalContext = XApplication.getContext();
    private BlockerActivityResult mBlockerActivityResult;
    public static final String mVidKey = "vid_key";
    private String mLanguage;
    private String mSecContext;
    private String mCertLocation;
    private String mSecOption;
    private String mSecDesc;
    private String mSecKeyStroke;
    private String mFuncLicense;
    private String mCSPProviders;
    private String mP11Providers;
    private String mLimitPinNum;
    private static final int XW_FVIEW_SIGNDATA_CONFIRM = 1;
    private static final int XW_FVIEW_CERT_LOGIN = 2;
    private static final int XW_FVIEW_CREATE_VID_FROM_IDN = 4;
    private static final int XW_FVIEW_CREATE_VID_FROM_WEB = 8;
    private static final int XW_FVIEW_CREATE_VID_NO_IDN = 16;
    private static final int XW_FVIEW_ENCODING_BASE64 = 256;
    private static final int XW_FVIEW_INCLUDE_SIGNATT = 512;
    private static final int XW_FVIEW_NO_CMS_ENCODING = 65536;
    private static final int XW_FVIEW_USE_CERT_SERIAL = 131072;
    private static final int XW_FVIEW_USE_DATA_EX = 262144;
    private static final int XW_FVIEW_USE_DATA_EX2 = 524288;
    private static final boolean RESULT = false;
    private static IsoDep isoDep;
    private static int mICCertificateIndex;

    public static void setmToken(IsoDep pIsoDep, int pICCertificateIndex) {
        isoDep = pIsoDep;
        mICCertificateIndex = pICCertificateIndex;
    }

    private XecureSmart() {
        this.mSessionID = this.hashCode();
        this.mBlockMgr = BlockMgr.getInstance();
        this.mCMPMgr = new CMPMgr();
        this.mCertMgr = CertMgr.getInstance();
        this.mFileEnvelope = new XSFileEnvelope(this.mSessionID);
        this.mSignEnvelopMgr = new SignEnvelopMgr();
        this.mSessionMgr = SessionMgr.getInstance();
        this.mCoreUtil = new XCoreUtil();
        if (EnvironmentConfig.mNfilterUsage) {
            this.SetAttribute("securekeypad_vendor", "nfilter");
        } else if (EnvironmentConfig.mMTransKeyUsage) {
            this.SetAttribute("securekeypad_vendor", "transkey");
        } else if (EnvironmentConfig.mXecureKeypadEncryptionUsage) {
            this.SetAttribute("securekeypad_vendor", "xkeypad");
        }
        mDefaultMediaID = EnvironmentConfig.mSDCardOnlyUse ? 101 : 1401;
    }

    public static synchronized XecureSmart getInstance() {
        if (null == mUniqueXecureSmartInstance) {
            mUniqueXecureSmartInstance = new XecureSmart();
        }
        return mUniqueXecureSmartInstance;
    }

    public void setBlockMgrCallersContext(Context context) {
    }

    @JavascriptInterface
    public String BlockEnc(String xaddr, String path, String plain, String method) {
        this.mCoreUtil.resetError();
        return this.BlockEncEx(xaddr, path, plain, method, "");
    }

    @JavascriptInterface
    public String BlockEncEx(String xaddr, String path, String plain, String method, String ca_name) {
        this.mCoreUtil.resetError();
        String result = this.mBlockMgr.blockEncEx(this.mSessionID, xaddr, path, plain, method, ca_name);
        return result;
    }

    @JavascriptInterface
    public String BlockEncBin(String xaddr, String path, byte[] bin, int binLength, String method, String ca_name) {
        this.mCoreUtil.resetError();
        String result = this.mBlockMgr.blockEncBin(this.mSessionID, xaddr, path, bin, binLength, method, ca_name);
        return result;
    }

    @JavascriptInterface
    public String BlockDec(String xaddr, String cipher_msg) {
        this.mCoreUtil.resetError();
        String aResult = this.mBlockMgr.blockDecEx(xaddr, cipher_msg, "");
        return aResult;
    }

    @JavascriptInterface
    public String BlockDecEx(String aXgateAddress, String aCipherText, String aCharacterSet) {
        String aResult = null;
        this.mCoreUtil.resetError();
        aResult = this.mBlockMgr.blockDecEx(aXgateAddress, aCipherText, aCharacterSet);
        return aResult;
    }

    @JavascriptInterface
    public byte[] BlockDecBin(String aXgateAddress, String aCipher) {
        byte[] aResult = null;
        this.mCoreUtil.resetError();
        aResult = this.mBlockMgr.blockDecBin(aXgateAddress, aCipher);
        return aResult;
    }

    @JavascriptInterface
    public String HashData(String aData, int aHashAlg) {
        this.mCoreUtil.resetError();
        return this.mBlockMgr.hashData(aData, aHashAlg);
    }

    private boolean isShowSelectCertWindow(long aSessionID, String aXgateAddr) {
        boolean aResult = true;
        String aSecOptionStr = this.mCoreUtil.getAttribute(this.mSessionID, "sec_option");
        XSLog.d((String)(this.getClass().getName() + "::SecOption" + aSecOptionStr));
        if (null == aSecOptionStr || "".equals(aSecOptionStr)) {
            return aResult;
        }
        String aSecOptionCode = aSecOptionStr.substring(0, aSecOptionStr.indexOf(58));
        try {
            if (aSecOptionCode.length() != 0 && (Integer.valueOf(aSecOptionCode) & 0x200) != 0) {
                XSLog.d((String)(this.getClass().getName() + "::SecOption" + aSecOptionStr));
                if (this.mCertMgr.hasCachedData(this.mSessionID, aXgateAddr) == 1) {
                    XSLog.d((String)(this.getClass().getName() + "::SecOption" + aSecOptionStr));
                    aResult = false;
                }
            }
        }
        catch (NumberFormatException e) {
            return true;
        }
        return aResult;
    }

    private void showCertSelectWindow(String aCallMode, long aSessionID, String aXaddr, int aMediaID, int aCertType, int aMediaType, String aSearchValue, String aCertSerial, int aPasswdTryLimit, String aData, int aOption) {
        Intent aIntent = null;
        aIntent = new Intent(this.mGlobalContext, SignCertSelectWindow.class);
        aIntent.putExtra("plugin_session_id_key", aSessionID);
        aIntent.putExtra("xaddr_key", aXaddr);
        aIntent.putExtra("media_id_key", aMediaID);
        aIntent.putExtra("cert_type_key", aCertType);
        aIntent.putExtra("media_type_key", aMediaType);
        aIntent.putExtra("search_value_key", aSearchValue);
        aIntent.putExtra("search_serial_key", aCertSerial);
        aIntent.putExtra("call_mode_key", aCallMode);
        aIntent.putExtra("sign_plain_text_data", aData);
        aIntent.putExtra("sign_option", aOption);
        this.mBlockerActivityResult = BlockerActivityUtil.startBlockerActivity((Context)this.mGlobalContext, (Intent)aIntent);
    }

    @JavascriptInterface
    public String SignDataCMS(String aXaddr, String aCaName, String aData, int aOption, String aDesc, int aPasswdTryLimit) {
        return this.SignDataCMSWithSerial(aXaddr, aCaName, "", 1, aData, aOption, aDesc, aPasswdTryLimit);
    }

    @JavascriptInterface
    public String SignFileInfoWithVID(String aXaddr, String aCaName, String aFileInfo, String aFileHash, int aOption, String aDesc, int aPasswdTryLimit, String aIdn, String aSvrCert, String aCallback) {
        int aMediaID = mDefaultMediaID;
        int aMediaType = 20;
        String aStrResult = null;
        String aSearchValue = aCaName;
        String aIssuerRDN = null;
        String aSubjectDN = null;
        String aCertSerial = null;
        String aCertInfo = null;
        byte[] aPassword = null;
        byte[] aRandomValue = null;
        String aEncryptedData = null;
        String aData = null;
        String aHashValue = null;
        Intent aIntent = null;
        byte[] aVid = null;
        byte[] aVIDRandomValue = null;
        String aVIDEncryptedData = null;
        int aSearchCondition = 14;
        this.mCoreUtil.resetError();
        aMediaID = EnvironmentConfig.mSDCardOnlyUse ? 101 : 1401;
        if ((aOption & 1) != 0) {
            aIntent = new Intent(this.mGlobalContext, SignMessageConfirm.class);
            aIntent.putExtra("sign_message_confirm_plain_message_key", aData);
            this.mBlockerActivityResult = BlockerActivityUtil.startBlockerActivity((Context)this.mGlobalContext, (Intent)aIntent);
            if (this.mBlockerActivityResult.getResultCode() == 0) {
                this.mCoreUtil.setError(0x989686);
                return "";
            }
        }
        this.showCertSelectWindow("call_mode_file_sign_info", this.mSessionID, aXaddr, aMediaID, 2, aMediaType, aSearchValue, aCertSerial, aPasswdTryLimit, aData, aOption);
        if (this.mBlockerActivityResult.getResultCode() == 0) {
            this.mCoreUtil.setError(0x989686);
            return "";
        }
        if (this.mBlockerActivityResult.getResultCode() == 2) {
            this.mCoreUtil.setError(10000013);
            return "";
        }
        if (this.mBlockerActivityResult.getResultCode() == 3) {
            this.mCoreUtil.setError(10000013);
            return "";
        }
        aMediaID = this.mBlockerActivityResult.getData().getIntExtra("media_id_key", 1);
        aIssuerRDN = this.mBlockerActivityResult.getData().getStringExtra("issuer_rdn_key");
        aCertSerial = this.mBlockerActivityResult.getData().getStringExtra("cert_serial_key");
        aCertInfo = this.mBlockerActivityResult.getData().getStringExtra("sign_file_cert_info");
        aSubjectDN = this.mBlockerActivityResult.getData().getStringExtra("subject_rdn_key");
        if (EnvironmentConfig.mMTransKeyEncryptionUsage || EnvironmentConfig.mXecureKeypadEncryptionUsage) {
            aRandomValue = this.mBlockerActivityResult.getData().getByteArrayExtra("random_value_key");
            aEncryptedData = this.mBlockerActivityResult.getData().getStringExtra("e_ncrypted_data_key");
        } else {
            aPassword = this.mBlockerActivityResult.getData().getByteArrayExtra("password_key");
        }
        aHashValue = XUtil.getSearchHashValue((String)aCertInfo, (String)aFileHash);
        if (aHashValue == null && aHashValue.length() <= 0) {
            return "";
        }
        aData = aFileInfo + "|" + aHashValue;
        if (aIdn != null && aIdn.length() > 1) {
            aVid = new byte[aIdn.length()];
            aVid = aIdn.getBytes();
            this.mSignEnvelopMgr.setIdNum(aVid);
        } else {
            if (EnvironmentConfig.mBasicKeyUsage) {
                aIntent = new Intent(this.mGlobalContext, XecureSmartInputVID.class);
            } else if (EnvironmentConfig.mMTransKeyUsage) {
                aIntent = new Intent(this.mGlobalContext, XecureSmartInputVIDWithTransKey.class);
            } else if (EnvironmentConfig.mXecureKeypadFullViewUsage || EnvironmentConfig.mXecureKeypadNormalViewUsage) {
                aIntent = new Intent(this.mGlobalContext, XecureSmartInputVIDWithXK.class);
            }
            aIntent.putExtra("xecure_smart_input_vid_key", aData);
            this.mBlockerActivityResult = BlockerActivityUtil.startBlockerActivity((Context)this.mGlobalContext, (Intent)aIntent);
            if (this.mBlockerActivityResult.getResultCode() == -1) {
                if (EnvironmentConfig.mMTransKeyEncryptionUsage || EnvironmentConfig.mXecureKeypadEncryptionUsage) {
                    aVIDRandomValue = this.mBlockerActivityResult.getData().getByteArrayExtra("random_value_key");
                    aVIDEncryptedData = this.mBlockerActivityResult.getData().getStringExtra("e_ncrypted_data_key");
                    this.mSignEnvelopMgr.setIdNum(aVIDRandomValue, aVIDEncryptedData);
                } else {
                    aVid = this.mBlockerActivityResult.getData().getByteArrayExtra(mVidKey);
                    this.mSignEnvelopMgr.setIdNum(aVid);
                }
            } else {
                this.mCoreUtil.setError(0x989686);
                return "";
            }
        }
        aStrResult = EnvironmentConfig.mMTransKeyEncryptionUsage || EnvironmentConfig.mXecureKeypadEncryptionUsage ? this.mSignEnvelopMgr.signFileInfo(this.mSessionID, aXaddr, aMediaID, aIssuerRDN, aCertSerial, aRandomValue, aEncryptedData, aData, aOption) : this.mSignEnvelopMgr.signFileInfo(this.mSessionID, aXaddr, aMediaID, aIssuerRDN, aCertSerial, aPassword, aData, aOption);
        if (EnvironmentConfig.mMTransKeyEncryptionUsage || EnvironmentConfig.mXecureKeypadEncryptionUsage) {
            int aResult = this.mSignEnvelopMgr.envelopIdNum(this.mSessionID, aXaddr, aMediaID, aSubjectDN, aRandomValue, aEncryptedData, aSvrCert);
        } else {
            int aResult = this.mSignEnvelopMgr.envelopIdNum(this.mSessionID, aXaddr, aMediaID, aSubjectDN, aPassword, aSearchCondition, aSvrCert);
        }
        return aStrResult;
    }

    @JavascriptInterface
    public String SignFileInfo(String aXaddr, String aCaName, String aFileInfo, String aFileHash, int aOption, String aDesc, int aPasswdTryLimit, String aCallback) {
        int aMediaID = mDefaultMediaID;
        int aMediaType = 20;
        String aResult = null;
        String aSearchValue = aCaName;
        String aIssuerRDN = null;
        String aCertSerial = null;
        String aCertInfo = null;
        byte[] aPassword = null;
        byte[] aRandomValue = null;
        String aEncryptedData = null;
        String aData = null;
        String aHashValue = null;
        this.mCoreUtil.resetError();
        aMediaID = EnvironmentConfig.mSDCardOnlyUse ? 101 : 1401;
        if ((aOption & 1) != 0) {
            Intent aIntent = new Intent(this.mGlobalContext, SignMessageConfirm.class);
            aIntent.putExtra("sign_message_confirm_plain_message_key", aData);
            this.mBlockerActivityResult = BlockerActivityUtil.startBlockerActivity((Context)this.mGlobalContext, (Intent)aIntent);
            if (this.mBlockerActivityResult.getResultCode() == 0) {
                this.mCoreUtil.setError(0x989686);
                return "";
            }
        }
        this.showCertSelectWindow("call_mode_file_sign_info", this.mSessionID, aXaddr, aMediaID, 2, aMediaType, aSearchValue, aCertSerial, aPasswdTryLimit, aData, aOption);
        if (this.mBlockerActivityResult.getResultCode() == 0) {
            this.mCoreUtil.setError(0x989686);
            return "";
        }
        if (this.mBlockerActivityResult.getResultCode() == 2) {
            this.mCoreUtil.setError(10000013);
            return "";
        }
        if (this.mBlockerActivityResult.getResultCode() == 3) {
            this.mCoreUtil.setError(10000013);
            return "";
        }
        aMediaID = this.mBlockerActivityResult.getData().getIntExtra("media_id_key", 1);
        aIssuerRDN = this.mBlockerActivityResult.getData().getStringExtra("issuer_rdn_key");
        aCertSerial = this.mBlockerActivityResult.getData().getStringExtra("cert_serial_key");
        aCertInfo = this.mBlockerActivityResult.getData().getStringExtra("sign_file_cert_info");
        aHashValue = XUtil.getSearchHashValue((String)aCertInfo, (String)aFileHash);
        if (aHashValue == null && aHashValue.length() <= 0) {
            return "";
        }
        aData = aFileInfo + "|" + aHashValue;
        if (EnvironmentConfig.mMTransKeyEncryptionUsage || EnvironmentConfig.mXecureKeypadEncryptionUsage) {
            aRandomValue = this.mBlockerActivityResult.getData().getByteArrayExtra("random_value_key");
            aEncryptedData = this.mBlockerActivityResult.getData().getStringExtra("e_ncrypted_data_key");
        } else {
            aPassword = this.mBlockerActivityResult.getData().getByteArrayExtra("password_key");
        }
        aResult = EnvironmentConfig.mMTransKeyEncryptionUsage || EnvironmentConfig.mXecureKeypadEncryptionUsage ? this.mSignEnvelopMgr.signFileInfo(this.mSessionID, aXaddr, aMediaID, aIssuerRDN, aCertSerial, aRandomValue, aEncryptedData, aData, aOption) : this.mSignEnvelopMgr.signFileInfo(this.mSessionID, aXaddr, aMediaID, aIssuerRDN, aCertSerial, aPassword, aData, aOption);
        return aResult;
    }

    @JavascriptInterface
    public String GetVidInfo() {
        this.mCoreUtil.resetError();
        return this.mSignEnvelopMgr.getVidInfo();
    }

    @JavascriptInterface
    public String SignDataWithVID(String aXaddr, String aAcceptCert, String aData, String aCert, int aOption, String aDesc, int aPasswdTryLimit) {
        Intent aIntent;
        int aMediaID = mDefaultMediaID;
        int aMediaType = 20;
        String aSearchValue = aAcceptCert;
        int aSearchCondition = 14;
        byte[] aPassword = null;
        byte[] aRandomValue = null;
        String aEncryptedData = null;
        String aSubjectDN = "";
        byte[] aVid = null;
        byte[] aVIDRandomValue = null;
        String aVIDEncryptedData = null;
        int aResult = 0;
        String aStrResult = "";
        this.mCoreUtil.resetError();
        aMediaID = EnvironmentConfig.mSDCardOnlyUse ? 101 : 1401;
        if ((aOption & 1) != 0) {
            aIntent = new Intent(this.mGlobalContext, SignMessageConfirm.class);
            aIntent.putExtra("sign_message_confirm_plain_message_key", aData);
            this.mBlockerActivityResult = BlockerActivityUtil.startBlockerActivity((Context)this.mGlobalContext, (Intent)aIntent);
            if (this.mBlockerActivityResult.getResultCode() == 0) {
                this.mCoreUtil.setError(0x989686);
                return "";
            }
        }
        if ((aOption & 2) != 0) {
            aMediaID = this.mSessionMgr.getSessionClientMedia(aXaddr);
            aMediaType = 14;
            aSearchValue = this.mSessionMgr.getSessionClientRDN(aXaddr);
        }
        if (this.isShowSelectCertWindow(this.mSessionID, aXaddr)) {
            this.showCertSelectWindow("call_mode_sign", this.mSessionID, aXaddr, aMediaID, 2, aMediaType, aSearchValue, "", aPasswdTryLimit, aData, aOption);
            if (this.mBlockerActivityResult.getResultCode() == 0) {
                this.mCoreUtil.setError(0x989686);
                return "";
            }
            if (this.mBlockerActivityResult.getResultCode() == 2) {
                this.mCoreUtil.setError(10000013);
                return "";
            }
            if (this.mBlockerActivityResult.getResultCode() == 3) {
                this.mCoreUtil.setError(10000013);
                return "";
            }
            aMediaID = this.mBlockerActivityResult.getData().getIntExtra("media_id_key", 1);
            aSubjectDN = this.mBlockerActivityResult.getData().getStringExtra("subject_rdn_key");
            if (EnvironmentConfig.mMTransKeyEncryptionUsage || EnvironmentConfig.mXecureKeypadEncryptionUsage) {
                aRandomValue = this.mBlockerActivityResult.getData().getByteArrayExtra("random_value_key");
                aEncryptedData = this.mBlockerActivityResult.getData().getStringExtra("e_ncrypted_data_key");
            } else {
                aPassword = this.mBlockerActivityResult.getData().getByteArrayExtra("password_key");
            }
        }
        if ((aOption & 8) != 0 || (aOption & 0x10) != 0) {
            if ((aOption & 0x10) != 0 && (aResult = this.mSignEnvelopMgr.setIdNum("")) != 0) {
                return "";
            }
        } else {
            aIntent = null;
            if (EnvironmentConfig.mBasicKeyUsage) {
                aIntent = new Intent(this.mGlobalContext, XecureSmartInputVID.class);
            } else if (EnvironmentConfig.mMTransKeyUsage) {
                aIntent = new Intent(this.mGlobalContext, XecureSmartInputVIDWithTransKey.class);
            } else if (EnvironmentConfig.mXecureKeypadFullViewUsage || EnvironmentConfig.mXecureKeypadNormalViewUsage) {
                aIntent = new Intent(this.mGlobalContext, XecureSmartInputVIDWithXK.class);
            }
            aIntent.putExtra("xecure_smart_input_vid_key", aData);
            this.mBlockerActivityResult = BlockerActivityUtil.startBlockerActivity((Context)this.mGlobalContext, (Intent)aIntent);
            if (this.mBlockerActivityResult.getResultCode() == -1) {
                if (EnvironmentConfig.mMTransKeyEncryptionUsage || EnvironmentConfig.mXecureKeypadEncryptionUsage) {
                    aVIDRandomValue = this.mBlockerActivityResult.getData().getByteArrayExtra("random_value_key");
                    aVIDEncryptedData = this.mBlockerActivityResult.getData().getStringExtra("e_ncrypted_data_key");
                    this.mSignEnvelopMgr.setIdNum(aVIDRandomValue, aVIDEncryptedData);
                } else {
                    aVid = this.mBlockerActivityResult.getData().getByteArrayExtra(mVidKey);
                    this.mSignEnvelopMgr.setIdNum(aVid);
                }
            } else {
                this.mCoreUtil.setError(0x989686);
                return "";
            }
        }
        aStrResult = aMediaID == 901 || aMediaID == 902 ? this.mBlockerActivityResult.getData().getStringExtra("usim_sign_cert_result") : (EnvironmentConfig.mMTransKeyEncryptionUsage || EnvironmentConfig.mXecureKeypadEncryptionUsage ? this.mSignEnvelopMgr.signDataCMS(this.mSessionID, aXaddr, aMediaID, aSubjectDN, aRandomValue, aEncryptedData, aData, aOption) : this.mSignEnvelopMgr.signDataCMS(this.mSessionID, aXaddr, aMediaID, aSubjectDN, aPassword, aData, aSearchCondition, aOption));
        if ((aOption & 4) != 0) {
            aResult = EnvironmentConfig.mMTransKeyEncryptionUsage || EnvironmentConfig.mXecureKeypadEncryptionUsage ? this.mSignEnvelopMgr.envelopIdNum(this.mSessionID, aXaddr, aMediaID, aSubjectDN, aRandomValue, aEncryptedData, aCert) : this.mSignEnvelopMgr.envelopIdNum(this.mSessionID, aXaddr, aMediaID, aSubjectDN, aPassword, aSearchCondition, aCert);
        }
        return aStrResult;
    }

    @JavascriptInterface
    public String SignDataWithVID_Serial(String aXaddr, String aAcceptCert, String aCertSerial, int aCertLocation, String aData, String aCert, int aOption, String aDesc, int aPasswdTryLimit) {
        Intent aIntent;
        int aMediaID = mDefaultMediaID;
        int aMediaType = 20;
        String aSearchValue = aAcceptCert;
        int aSearchCondition = 14;
        String aPassword = "";
        String aSubjectDN = "";
        String aVid = "";
        int aResult = 0;
        String aStrResult = "";
        this.mCoreUtil.resetError();
        aMediaID = EnvironmentConfig.mSDCardOnlyUse ? 101 : 1401;
        if ((aOption & 1) != 0) {
            aIntent = new Intent(this.mGlobalContext, SignMessageConfirm.class);
            aIntent.putExtra("sign_message_confirm_plain_message_key", aData);
            this.mBlockerActivityResult = BlockerActivityUtil.startBlockerActivity((Context)this.mGlobalContext, (Intent)aIntent);
            if (this.mBlockerActivityResult.getResultCode() == 0) {
                this.mCoreUtil.setError(0x989686);
                return "";
            }
        }
        if ((aOption & 2) != 0) {
            aMediaID = this.mSessionMgr.getSessionClientMedia(aXaddr);
            aMediaType = 14;
            aSearchValue = this.mSessionMgr.getSessionClientRDN(aXaddr);
        }
        if (this.isShowSelectCertWindow(this.mSessionID, aXaddr)) {
            this.showCertSelectWindow("call_mode_sign", this.mSessionID, aXaddr, aMediaID, 2, aMediaType, aSearchValue, aCertSerial, aPasswdTryLimit, "", 0);
            if (this.mBlockerActivityResult.getResultCode() == 0) {
                this.mCoreUtil.setError(0x989686);
                return "";
            }
            if (this.mBlockerActivityResult.getResultCode() == 2) {
                this.mCoreUtil.setError(10000013);
                return "";
            }
            aMediaID = this.mBlockerActivityResult.getData().getIntExtra("media_id_key", 1);
            aPassword = this.mBlockerActivityResult.getData().getStringExtra("password_key");
            aSubjectDN = this.mBlockerActivityResult.getData().getStringExtra("subject_rdn_key");
            aPassword = this.mBlockerActivityResult.getData().getStringExtra("password_key");
        }
        if ((aOption & 8) != 0 || (aOption & 0x10) != 0) {
            if ((aOption & 0x10) != 0 && (aResult = this.mSignEnvelopMgr.setIdNum("")) != 0) {
                return "";
            }
        } else {
            aIntent = new Intent(this.mGlobalContext, XecureSmartInputVID.class);
            aIntent.putExtra("xecure_smart_input_vid_key", aData);
            this.mBlockerActivityResult = BlockerActivityUtil.startBlockerActivity((Context)this.mGlobalContext, (Intent)aIntent);
            if (this.mBlockerActivityResult.getResultCode() == -1) {
                aVid = this.mBlockerActivityResult.getData().getStringExtra(mVidKey);
                this.mSignEnvelopMgr.setIdNum(aVid);
            } else {
                this.mCoreUtil.setError(0x989686);
                return "";
            }
        }
        aStrResult = this.mSignEnvelopMgr.signDataCMS(this.mSessionID, aXaddr, aMediaID, aSubjectDN, aPassword, aData, aSearchCondition, aOption);
        if ((aOption & 4) != 0) {
            aResult = this.mSignEnvelopMgr.envelopIdNum(this.mSessionID, aXaddr, aMediaID, aSubjectDN, aPassword, aSearchCondition, aCert);
        }
        return aStrResult;
    }

    @JavascriptInterface
    public int SetIDNum(String aVid) {
        this.mCoreUtil.resetError();
        return this.mSignEnvelopMgr.setIdNum(aVid);
    }

    @JavascriptInterface
    @SuppressLint(value={"NewApi"})
    public String SignDataCMSWithSerial(String aXaddr, String aCaName, String aCertSerial, int aCertLocation, String aData, int aOption, String aDesc, int aPasswdTryLimit) {
        String aResultValue;
        int aMediaID = mDefaultMediaID;
        int aMediaType = 20;
        String aSearchValue = aCaName;
        int aSearchCondition = 14;
        byte[] aPassword = null;
        byte[] aRandomValue = null;
        String aEncryptedData = null;
        String aSubjectDN = "";
        String aResult = null;
        ICCardMgr aICCardMgr = new ICCardMgr();
        this.mCoreUtil.resetError();
        aMediaID = EnvironmentConfig.mSDCardOnlyUse ? 101 : 1401;
        if ((aOption & 1) != 0) {
            Intent aIntent = new Intent(this.mGlobalContext, SignMessageConfirm.class);
            aIntent.putExtra("sign_message_confirm_plain_message_key", aData);
            this.mBlockerActivityResult = BlockerActivityUtil.startBlockerActivity((Context)this.mGlobalContext, (Intent)aIntent);
            if (this.mBlockerActivityResult.getResultCode() == 0) {
                this.mCoreUtil.setError(0x989686);
                return "";
            }
        }
        if ((aOption & 2) != 0) {
            aMediaID = this.mSessionMgr.getSessionClientMedia(aXaddr);
            aMediaType = 14;
            aSearchValue = this.mSessionMgr.getSessionClientRDN(aXaddr);
        }
        if (this.isShowSelectCertWindow(this.mSessionID, aXaddr)) {
            this.showCertSelectWindow("call_mode_sign", this.mSessionID, aXaddr, aMediaID, 2, aMediaType, aSearchValue, aCertSerial, aPasswdTryLimit, aData, aOption);
            if (this.mBlockerActivityResult.getResultCode() == 0) {
                this.mCoreUtil.setError(0x989686);
                return "";
            }
            if (this.mBlockerActivityResult.getResultCode() == 2) {
                this.mCoreUtil.setError(10000013);
                return "";
            }
            if (this.mBlockerActivityResult.getResultCode() == 3) {
                this.mCoreUtil.setError(10000013);
                return "";
            }
            aMediaID = this.mBlockerActivityResult.getData().getIntExtra("media_id_key", 1);
            aSubjectDN = this.mBlockerActivityResult.getData().getStringExtra("subject_rdn_key");
            if (EnvironmentConfig.mMTransKeyEncryptionUsage || EnvironmentConfig.mXecureKeypadEncryptionUsage) {
                aRandomValue = this.mBlockerActivityResult.getData().getByteArrayExtra("random_value_key");
                aEncryptedData = this.mBlockerActivityResult.getData().getStringExtra("e_ncrypted_data_key");
            } else {
                aPassword = this.mBlockerActivityResult.getData().getByteArrayExtra("password_key");
            }
        }
        aResult = aMediaID == 901 || aMediaID == 902 ? this.mBlockerActivityResult.getData().getStringExtra("usim_sign_cert_result") : (aMediaID == 903 ? ((aResultValue = aICCardMgr.encodePKCS7(isoDep, mICCertificateIndex, XUtil.makeHashReturnByte((String)aData), (byte)64, (byte)1, aPassword)).startsWith("MI") ? ICCardMgr2.reMakePKCS7((String)aData, (String)aResultValue) : aResultValue) : (EnvironmentConfig.mMTransKeyEncryptionUsage || EnvironmentConfig.mXecureKeypadEncryptionUsage ? this.mSignEnvelopMgr.signDataCMS(this.mSessionID, aXaddr, aMediaID, aSubjectDN, aRandomValue, aEncryptedData, aData, aOption) : this.mSignEnvelopMgr.signDataCMS(this.mSessionID, aXaddr, aMediaID, aSubjectDN, aPassword, aData, aSearchCondition, aOption += 512)));
        XUtil.resetByteArray((byte[][])new byte[][]{aPassword, aRandomValue});
        return aResult;
    }

    @JavascriptInterface
    public String SignDataAdd(String aXaddr, String aCaName, String aData, int aOption, String aDesc, int aPasswdTryLimit) {
        int aMediaID = mDefaultMediaID;
        int aMediaType = 20;
        String aSearchValue = aCaName;
        int aSearchCondition = 14;
        String aPassword = "";
        String aSubjectDN = "";
        this.mCoreUtil.resetError();
        aMediaID = EnvironmentConfig.mSDCardOnlyUse ? 101 : 1401;
        if ((aOption & 1) != 0) {
            String[] aPlainData = new String[1];
            String[] aCertList = new String[1];
            if (this.mSignEnvelopMgr.getPlainData(aData, aPlainData, aCertList) != 0) {
                this.mCoreUtil.setError(0x989686);
                return "";
            }
            Intent aIntent = new Intent(this.mGlobalContext, SignMessageConfirm.class);
            aIntent.putExtra("sign_message_confirm_plain_message_key", aPlainData[0]);
            this.mBlockerActivityResult = BlockerActivityUtil.startBlockerActivity((Context)this.mGlobalContext, (Intent)aIntent);
            if (this.mBlockerActivityResult.getResultCode() == 0) {
                this.mCoreUtil.setError(0x989686);
                return "";
            }
        }
        if ((aOption & 2) != 0) {
            aMediaID = this.mSessionMgr.getSessionClientMedia(aXaddr);
            aSearchValue = this.mSessionMgr.getSessionClientRDN(aXaddr);
        }
        if (this.isShowSelectCertWindow(this.mSessionID, aXaddr)) {
            this.showCertSelectWindow("call_mode_sign", this.mSessionID, aXaddr, aMediaID, 2, aMediaType, aSearchValue, "", aPasswdTryLimit, "", 0);
            if (this.mBlockerActivityResult.getResultCode() == 0) {
                this.mCoreUtil.setError(0x989686);
                return "";
            }
            if (this.mBlockerActivityResult.getResultCode() == 2) {
                this.mCoreUtil.setError(10000013);
                return "";
            }
            aMediaID = this.mBlockerActivityResult.getData().getIntExtra("media_id_key", 1);
            aPassword = this.mBlockerActivityResult.getData().getStringExtra("password_key");
            aSubjectDN = this.mBlockerActivityResult.getData().getStringExtra("subject_rdn_key");
            aPassword = this.mBlockerActivityResult.getData().getStringExtra("password_key");
        }
        return this.mSignEnvelopMgr.signDataAdd(this.mSessionID, aXaddr, aMediaID, aSubjectDN, aPassword, aData, aSearchCondition, aOption);
    }

    @JavascriptInterface
    public String MultiSignData(String aXaddr, String aCaName, String aData, String aDelimiter, int aOption, String aDesc, int aPasswdTryLimit) {
        this.SetAttribute("sec_option", "512:hard:removable:iccard");
        this.SetAttribute("sec_context", "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");
        String aResult = "";
        StringTokenizer aDataList = new StringTokenizer(aData, aDelimiter);
        while (aDataList.hasMoreTokens()) {
            String aGetPlain = aDataList.nextToken();
            aResult = aResult + this.SignDataCMS(aXaddr, aCaName, aGetPlain, aOption, aDesc, aPasswdTryLimit);
            aResult = aResult + aDelimiter;
        }
        this.SetAttribute("sec_option", "0:hard:iccard");
        this.ClearCachedData(aXaddr, 0);
        return aResult;
    }

    @JavascriptInterface
    public String MultiSignDataVID(String aXaddr, String aCaName, String aData, String aPem, String aIDN, String aDelimiter, int aOption, String aDesc, int aPasswdTryLimit) {
        this.SetAttribute("sec_option", "512:hard:removable:iccard");
        this.SetAttribute("sec_context", "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");
        String aResult = "";
        String aVIDResult = "";
        StringTokenizer aDataList = new StringTokenizer(aData, aDelimiter);
        int x = 1;
        int count = aDataList.countTokens();
        while (aDataList.hasMoreTokens()) {
            String aGetPlain;
            if (x < count) {
                aGetPlain = aDataList.nextToken();
                aResult = aResult + this.SignDataCMS(aXaddr, aCaName, aGetPlain, aOption, aDesc, aPasswdTryLimit);
                aResult = aResult + aDelimiter;
                XSLog.d((String)(this.getClass().getName() + "::CMS : " + aResult));
            } else if (x >= count) {
                aGetPlain = aDataList.nextToken();
                int aSetIdNum = this.SetIDNum(aIDN);
                aResult = aResult + this.SignDataWithVID(aXaddr, aCaName, aGetPlain, aPem, aOption, aDesc, aPasswdTryLimit);
            }
            ++x;
        }
        this.SetAttribute("sec_option", "0:hard:iccard");
        this.ClearCachedData(aXaddr, 0);
        return aResult;
    }

    @JavascriptInterface
    public String VerifySignedData(String aData, int aVerifyOption, String aDirserver) {
        this.mCoreUtil.resetError();
        return this.mSignEnvelopMgr.verifySignedData(aData, aVerifyOption, aDirserver);
    }

    @JavascriptInterface
    public String EnvelopData(String aXgateAddr, String aCaName, String aData, int aEnvOption, String aPassword, String aCertPem, String aCertSerial, int aCertLocation, String aDesc, int aPasswordTryLimit) {
        int aMediaID = mDefaultMediaID;
        int aMediaType = 20;
        int aEnvType = 0;
        String aMediaIDList = "";
        String aSubjectDNList = "";
        String aSearchValue = aCaName;
        String aResult = "";
        this.mCoreUtil.resetError();
        aMediaID = EnvironmentConfig.mSDCardOnlyUse ? 101 : 1401;
        if (aEnvOption == 0) {
            aEnvOption = 2;
        }
        if ((aEnvOption & 1) != 0) {
            if (aCertPem.length() > 0) {
                aEnvType = 1;
            } else {
                aEnvType = 0;
                if ((aEnvOption & 0x100) != 0) {
                    aMediaID = this.mSessionMgr.getSessionClientMedia(aXgateAddr);
                    aMediaType = 14;
                    aSearchValue = this.mSessionMgr.getSessionClientRDN(aXgateAddr);
                }
                this.showCertSelectWindow("call_mode_envelop", this.mSessionID, aXgateAddr, aMediaID, 2, aMediaType, aSearchValue, aCertSerial, 0, "", 0);
                if (this.mBlockerActivityResult.getResultCode() == 0) {
                    this.mCoreUtil.setError(10000011);
                    return "";
                }
                if (this.mBlockerActivityResult.getResultCode() == 2) {
                    this.mCoreUtil.setError(10000011);
                    return "";
                }
                aMediaIDList = String.valueOf(this.mBlockerActivityResult.getData().getIntExtra("media_id_key", -1));
                aSubjectDNList = this.mBlockerActivityResult.getData().getStringExtra("subject_rdn_key");
            }
        } else {
            aEnvType = 2;
            if (aPassword.length() == 0) {
                Intent aIntent = new Intent(this.mGlobalContext, EnvelopInputPassword.class);
                this.mBlockerActivityResult = BlockerActivityUtil.startBlockerActivity((Context)this.mGlobalContext, (Intent)aIntent);
                if (this.mBlockerActivityResult.getResultCode() == -1) {
                    aPassword = this.mBlockerActivityResult.getData().getStringExtra("input_password_password_key");
                } else {
                    this.mCoreUtil.setError(10000011);
                    return "";
                }
            }
        }
        switch (aEnvType) {
            case 1: {
                aResult = this.mSignEnvelopMgr.envelopeDataWithPEM(aData, aEnvOption, aCertPem);
                break;
            }
            case 2: {
                aResult = this.mSignEnvelopMgr.envelopeDataWithPasswd(aData, aEnvOption, aPassword);
                break;
            }
            default: {
                aResult = this.mSignEnvelopMgr.envelopeDataWithCert(aData, aEnvOption, aMediaIDList, aSubjectDNList);
            }
        }
        return aResult;
    }

    @JavascriptInterface
    public String DeEnvelopData(String aXgateAddr, String aCaName, String aData, int aOption, String aPassword, String aDesc, int aPasswordTryLimit) {
        int[] aEnvType = new int[1];
        String[] aCertSerial = new String[1];
        String aSubjectDN = null;
        byte[] aCertPassword = null;
        byte[] aRandomValue = null;
        String aEncryptedData = null;
        String aDeEnvelopedData = null;
        int aMediaID = mDefaultMediaID;
        this.mCoreUtil.resetError();
        aMediaID = EnvironmentConfig.mSDCardOnlyUse ? 101 : 1401;
        this.mSignEnvelopMgr.getEnvelopeTypeAndCertSerial(aData, aEnvType, aCertSerial);
        if (aEnvType[0] == 1) {
            this.showCertSelectWindow("call_mode_decryption", this.mSessionID, aXgateAddr, aMediaID, 2, 20, aCaName, aCertSerial[0], 3, "", 0);
            if (this.mBlockerActivityResult.getResultCode() == 0) {
                this.mCoreUtil.setError(10000011);
                return "";
            }
            if (this.mBlockerActivityResult.getResultCode() == 2) {
                this.mCoreUtil.setError(10000013);
                return "";
            }
            aMediaID = this.mBlockerActivityResult.getData().getIntExtra("media_id_key", -1);
            aSubjectDN = this.mBlockerActivityResult.getData().getStringExtra("subject_rdn_key");
            if (EnvironmentConfig.mMTransKeyEncryptionUsage || EnvironmentConfig.mXecureKeypadEncryptionUsage) {
                aRandomValue = this.mBlockerActivityResult.getData().getByteArrayExtra("random_value_key");
                aEncryptedData = this.mBlockerActivityResult.getData().getStringExtra("e_ncrypted_data_key");
                aDeEnvelopedData = this.mSignEnvelopMgr.deEnvelopeDataWithCert(aData, aMediaID, aSubjectDN, aRandomValue, aEncryptedData);
            } else {
                aCertPassword = this.mBlockerActivityResult.getData().getByteArrayExtra("password_key");
                aDeEnvelopedData = this.mSignEnvelopMgr.deEnvelopeDataWithCert(aData, aMediaID, aSubjectDN, aCertPassword);
            }
            return aDeEnvelopedData;
        }
        if (aPassword.length() == 0) {
            Intent aIntent = new Intent(this.mGlobalContext, EnvelopInputPassword.class);
            this.mBlockerActivityResult = BlockerActivityUtil.startBlockerActivity((Context)this.mGlobalContext, (Intent)aIntent);
            if (this.mBlockerActivityResult.getResultCode() == -1) {
                aPassword = this.mBlockerActivityResult.getData().getStringExtra("input_password_password_key");
            } else {
                this.mCoreUtil.setError(10000011);
                return "";
            }
        }
        return this.mSignEnvelopMgr.deEnvelopeDataWithPasswd(aData, aPassword);
    }

    @JavascriptInterface
    public int RequestCertificate(int aCAport, String aCAaddr, String aRefNum, String aAuthCode, int aCaType) {
        return this.RequestCertificateEx(aCAport, aCAaddr, aRefNum, aAuthCode, aCaType, 0, "", "");
    }

    @JavascriptInterface
    public int RequestICCertificate(int aCAport, String aCAaddr, String aRefNum, String aAuthCode, int aCaType) {
        return this.RequestICCertificateEx(aCAport, aCAaddr, aRefNum, aAuthCode, aCaType, 0, "", "");
    }

    @JavascriptInterface
    public int RequestICCertificateEx(int aCAport, String aCAaddr, String aRefNum, String aAuthCode, int aCaType, int aRequestOption, String aCaName, String aRaName) {
        int aResult = -1;
        Intent aIntent = null;
        this.mCoreUtil.resetError();
        aIntent = new Intent(this.mGlobalContext, TestICCardRequestCertificate.class);
        aIntent.putExtra("ca_port_key", aCAport);
        aIntent.putExtra("ca_addr_key", aCAaddr);
        aIntent.putExtra("ref_num_key", aRefNum);
        aIntent.putExtra("auth_code_key", aAuthCode);
        aIntent.putExtra("option_key", aRequestOption);
        aIntent.putExtra("ca_name_key", aCaName);
        aIntent.putExtra("ra_name_key", aRaName);
        aIntent.putExtra("ca_type_key", aCaType);
        this.mBlockerActivityResult = BlockerActivityUtil.startBlockerActivity((Context)this.mGlobalContext, (Intent)aIntent);
        aResult = this.mBlockerActivityResult.getResultCode() == -1 ? 0 : -1;
        return aResult;
    }

    @JavascriptInterface
    public int RequestCertificateEx(int aCAport, String aCAaddr, String aRefNum, String aAuthCode, int aCaType, int aRequestOption, String aCaName, String aRaName) {
        int aResult = -1;
        int aMediaID = mDefaultMediaID;
        byte[] aPassword = null;
        byte[] aRandomValue = null;
        String aEncryptedData = null;
        Intent aIntent = null;
        this.mCoreUtil.resetError();
        aMediaID = EnvironmentConfig.mSDCardOnlyUse ? 101 : 1401;
        if (EnvironmentConfig.mMTransKeyUsage) {
            aIntent = new Intent(this.mGlobalContext, RequestCertificateWithTransKey.class);
            aIntent.putExtra("request_cert_window_mediaid_key", aMediaID);
        } else if (EnvironmentConfig.mBasicKeyUsage) {
            aIntent = new Intent(this.mGlobalContext, RequestCertificate.class);
            aIntent.putExtra("request_cert_window_mediaid_key", aMediaID);
        } else if (EnvironmentConfig.mXecureKeypadFullViewUsage || EnvironmentConfig.mXecureKeypadNormalViewUsage) {
            aIntent = new Intent(this.mGlobalContext, RequestCertificateWithXK.class);
            aIntent.putExtra("request_cert_window_mediaid_key", aMediaID);
        }
        this.mBlockerActivityResult = BlockerActivityUtil.startBlockerActivity((Context)this.mGlobalContext, (Intent)aIntent);
        if (this.mBlockerActivityResult.getResultCode() == -1) {
            aMediaID = this.mBlockerActivityResult.getData().getIntExtra("request_cert_window_mediaid_key", -1);
            if (EnvironmentConfig.mMTransKeyEncryptionUsage || EnvironmentConfig.mXecureKeypadEncryptionUsage) {
                aRandomValue = this.mBlockerActivityResult.getData().getByteArrayExtra("request_cert_window_password_key");
                aEncryptedData = this.mBlockerActivityResult.getData().getStringExtra("request_cert_window_e_ncrypted_data_key");
            } else {
                aPassword = this.mBlockerActivityResult.getData().getByteArrayExtra("request_cert_window_password_key");
            }
        } else {
            this.mCoreUtil.setError(10000010);
            return -1;
        }
        if (aMediaID == 401) {
            BlockerActivityResult anActivityResult = BlockerActivityUtil.startBlockerActivity((Context)this.mGlobalContext, (Intent)new Intent(this.mGlobalContext, PKCS11Password.class));
            if (anActivityResult.getResultCode() == 100) {
                XCoreUtil.getInstance().setError(10000141);
            }
            if (anActivityResult.getResultCode() != -1) {
                return -1;
            }
        }
        aIntent = new Intent(this.mGlobalContext, CMPProgressDialog.class);
        aIntent.putExtra("cmp_type_key", 0);
        aIntent.putExtra("ca_port_key", aCAport);
        aIntent.putExtra("ca_addr_key", aCAaddr);
        aIntent.putExtra("media_id_key", aMediaID);
        aIntent.putExtra("ref_num_key", aRefNum);
        aIntent.putExtra("auth_code_key", aAuthCode);
        aIntent.putExtra("ca_type_key", aCaType);
        aIntent.putExtra("option_key", aRequestOption);
        aIntent.putExtra("ca_name_key", aCaName);
        aIntent.putExtra("ra_name_key", aRaName);
        if (EnvironmentConfig.mMTransKeyEncryptionUsage || EnvironmentConfig.mXecureKeypadEncryptionUsage) {
            aIntent.putExtra("random_value_key", aRandomValue);
            aIntent.putExtra("e_ncrypted_data_key", aEncryptedData);
        } else {
            aIntent.putExtra("password_key", aPassword);
        }
        this.mBlockerActivityResult = BlockerActivityUtil.startBlockerActivity((Context)this.mGlobalContext, (Intent)aIntent);
        if (this.mBlockerActivityResult.getResultCode() == -1) {
            aResult = 0;
        }
        if (aMediaID == 401) {
            this.mCertMgr.getMediaList(400, 0, 1);
        }
        XUtil.resetByteArray((byte[][])new byte[][]{aPassword, aRandomValue});
        return aResult;
    }

    @JavascriptInterface
    public int ReissueCertificate(int aPort, String aAddress, String aReferenceNumber, String aAuthenticationCode, int aCAType) {
        int aResult = 0;
        int aMediaID = mDefaultMediaID;
        byte[] aPassword = null;
        byte[] aRandomValue = null;
        String aEncryptedData = null;
        Intent aReissueIntent = null;
        Intent aProgressIntent = null;
        this.mCoreUtil.resetError();
        aMediaID = EnvironmentConfig.mSDCardOnlyUse ? 101 : 1401;
        aMediaID = EnvironmentConfig.mSDCardOnlyUse ? 101 : 1401;
        if (EnvironmentConfig.mMTransKeyUsage) {
            aReissueIntent = new Intent(this.mGlobalContext, RequestCertificateWithTransKey.class);
            aReissueIntent.putExtra("request_cert_window_mediaid_key", aMediaID);
        } else {
            aReissueIntent = new Intent(this.mGlobalContext, RequestCertificate.class);
            aReissueIntent.putExtra("request_cert_window_mediaid_key", aMediaID);
        }
        this.mBlockerActivityResult = BlockerActivityUtil.startBlockerActivity((Context)this.mGlobalContext, (Intent)aReissueIntent);
        if (this.mBlockerActivityResult.getResultCode() != -1) {
            aResult = -1;
            this.mCoreUtil.setError(10000010);
            return aResult;
        }
        aMediaID = this.mBlockerActivityResult.getData().getIntExtra("request_cert_window_mediaid_key", -1);
        if (EnvironmentConfig.mMTransKeyEncryptionUsage || EnvironmentConfig.mXecureKeypadEncryptionUsage) {
            aRandomValue = this.mBlockerActivityResult.getData().getByteArrayExtra("request_cert_window_password_key");
            aEncryptedData = this.mBlockerActivityResult.getData().getStringExtra("request_cert_window_e_ncrypted_data_key");
        } else {
            aPassword = this.mBlockerActivityResult.getData().getByteArrayExtra("request_cert_window_password_key");
        }
        aProgressIntent = new Intent(this.mGlobalContext, CMPProgressDialog.class);
        aProgressIntent.putExtra("cmp_type_key", 2);
        aProgressIntent.putExtra("ca_port_key", aPort);
        aProgressIntent.putExtra("ca_addr_key", aAddress);
        aProgressIntent.putExtra("media_id_key", aMediaID);
        aProgressIntent.putExtra("ref_num_key", aReferenceNumber);
        aProgressIntent.putExtra("auth_code_key", aAuthenticationCode);
        aProgressIntent.putExtra("ca_type_key", aCAType);
        if (EnvironmentConfig.mMTransKeyEncryptionUsage || EnvironmentConfig.mXecureKeypadEncryptionUsage) {
            aProgressIntent.putExtra("random_value_key", aRandomValue);
            aProgressIntent.putExtra("e_ncrypted_data_key", aEncryptedData);
        } else {
            aProgressIntent.putExtra("password_key", aPassword);
        }
        this.mBlockerActivityResult = BlockerActivityUtil.startBlockerActivity((Context)this.mGlobalContext, (Intent)aProgressIntent);
        if (this.mBlockerActivityResult.getResultCode() != -1) {
            aResult = -1;
            return aResult;
        }
        XUtil.resetByteArray((byte[][])new byte[][]{aPassword, aRandomValue});
        return aResult;
    }

    @JavascriptInterface
    public int RenewCertificate(int aCAport, String aCAaddr, int aCAType, int aPasswdTryLimit) {
        return this.RenewCertificateEx(aCAport, aCAaddr, 0, aCAType, aPasswdTryLimit);
    }

    @JavascriptInterface
    public int RenewCertificateEx(int aCAport, String aCAaddr, int aRenewOption, int aCAType, int aPasswdTryLimit) {
        int aMediaID = mDefaultMediaID;
        int aMediaType = 0;
        String aSubjectDN = "";
        byte[] aOldPassword = null;
        byte[] aNewPassword = null;
        byte[] aRandomValue = null;
        String aEncryptedData = null;
        String aNewEncryptedData = null;
        int aResult = -1;
        this.mCoreUtil.resetError();
        aMediaID = EnvironmentConfig.mSDCardOnlyUse ? 101 : 1401;
        if (aCAType == 101) {
            aMediaType = 50;
        }
        this.showCertSelectWindow("call_mode_renew", this.mSessionID, "", aMediaID, 2, aMediaType, "", "", aPasswdTryLimit, "", 0);
        if (this.mBlockerActivityResult.getResultCode() == 0) {
            this.mCoreUtil.setError(10000007);
            return -1;
        }
        if (this.mBlockerActivityResult.getResultCode() == 2) {
            this.mCoreUtil.setError(10000013);
            return -1;
        }
        aMediaID = this.mBlockerActivityResult.getData().getIntExtra("media_id_key", -1);
        aSubjectDN = this.mBlockerActivityResult.getData().getStringExtra("subject_rdn_key");
        if (EnvironmentConfig.mMTransKeyEncryptionUsage || EnvironmentConfig.mXecureKeypadEncryptionUsage) {
            aRandomValue = this.mBlockerActivityResult.getData().getByteArrayExtra("random_value_key");
            aEncryptedData = this.mBlockerActivityResult.getData().getStringExtra("e_ncrypted_data_key");
            aNewEncryptedData = this.mBlockerActivityResult.getData().getStringExtra("new_e_ncrypted_data_key");
        } else {
            aOldPassword = this.mBlockerActivityResult.getData().getByteArrayExtra("old_password_key");
            aNewPassword = this.mBlockerActivityResult.getData().getByteArrayExtra("password_key");
        }
        Intent aIntent = new Intent(this.mGlobalContext, CMPProgressDialog.class);
        aIntent.putExtra("cmp_type_key", 1);
        aIntent.putExtra("ca_port_key", aCAport);
        aIntent.putExtra("ca_addr_key", aCAaddr);
        aIntent.putExtra("subject_dn_key", aSubjectDN);
        aIntent.putExtra("media_id_key", aMediaID);
        aIntent.putExtra("ca_type_key", aCAType);
        aIntent.putExtra("option_key", aRenewOption);
        if (EnvironmentConfig.mMTransKeyEncryptionUsage || EnvironmentConfig.mXecureKeypadEncryptionUsage) {
            aIntent.putExtra("random_value_key", aRandomValue);
            aIntent.putExtra("e_ncrypted_data_key", aEncryptedData);
            aIntent.putExtra("new_e_ncrypted_data_key", aNewEncryptedData);
        } else {
            aIntent.putExtra("old_password_key", aOldPassword);
            aIntent.putExtra("new_password_key", aNewPassword);
        }
        this.mBlockerActivityResult = BlockerActivityUtil.startBlockerActivity((Context)this.mGlobalContext, (Intent)aIntent);
        if (this.mBlockerActivityResult.getResultCode() == -1) {
            aResult = 0;
        }
        XUtil.resetByteArray((byte[][])new byte[][]{aNewPassword, aOldPassword});
        return aResult;
    }

    @JavascriptInterface
    public int RevokeCertificate(int aCAport, String aCAaddr, int aJobCode, int aRvkReason, int aCaType, int aPasswdTryLimit) {
        int aMediaID = mDefaultMediaID;
        int aMediaType = 0;
        String aSubjectDN = "";
        byte[] aPassword = null;
        byte[] aRandomValue = null;
        String aEncryptedData = null;
        int aResult = 0;
        this.mCoreUtil.resetError();
        aMediaID = EnvironmentConfig.mSDCardOnlyUse ? 101 : 1401;
        if (aCaType == 101) {
            aMediaType = 50;
        }
        this.showCertSelectWindow("call_mode_revoke", this.mSessionID, "", aMediaID, 2, aMediaType, "", "", aPasswdTryLimit, "", 0);
        if (this.mBlockerActivityResult.getResultCode() == 0) {
            this.mCoreUtil.setError(10000007);
            return -1;
        }
        if (this.mBlockerActivityResult.getResultCode() == 2) {
            this.mCoreUtil.setError(10000013);
            return -1;
        }
        aMediaID = this.mBlockerActivityResult.getData().getIntExtra("media_id_key", -1);
        aSubjectDN = this.mBlockerActivityResult.getData().getStringExtra("subject_rdn_key");
        if (EnvironmentConfig.mMTransKeyEncryptionUsage || EnvironmentConfig.mXecureKeypadEncryptionUsage) {
            aRandomValue = this.mBlockerActivityResult.getData().getByteArrayExtra("random_value_key");
            aEncryptedData = this.mBlockerActivityResult.getData().getStringExtra("e_ncrypted_data_key");
        } else {
            aPassword = this.mBlockerActivityResult.getData().getByteArrayExtra("password_key");
        }
        aResult = EnvironmentConfig.mMTransKeyEncryptionUsage || EnvironmentConfig.mXecureKeypadEncryptionUsage ? this.mCMPMgr.RevokeCertificate(aCAport, aCAaddr, aSubjectDN, aMediaID, aJobCode, aRvkReason, aCaType, aRandomValue, aEncryptedData) : this.mCMPMgr.RevokeCertificate(aCAport, aCAaddr, aSubjectDN, aMediaID, aJobCode, aRvkReason, aCaType, aPassword);
        return aResult;
    }

    @JavascriptInterface
    public String GetHWInfo(int aOption) {
        this.mCoreUtil.resetError();
        return XUtil.getHWInfo((Context)this.mGlobalContext, (int)aOption);
    }

    @JavascriptInterface
    public String GetUserHWInfo(int aOption, String aPEM) {
        String aInfo = this.GetHWInfo(aOption);
        this.mCoreUtil.resetError();
        return this.mSignEnvelopMgr.envelopeDataWithPEM(aInfo, 1, aPEM);
    }

    @JavascriptInterface
    public int PutCACert(String aName, String aUrl) {
        boolean aCERT_LOCATION_HDD = true;
        this.mCoreUtil.resetError();
        return this.mCertMgr.putCACert(1, aName, aUrl);
    }

    @JavascriptInterface
    public int ClearCachedData(String xaddr, int option) {
        this.mCoreUtil.resetError();
        return this.mCertMgr.clearCachedData(xaddr, option);
    }

    @JavascriptInterface
    public boolean HasCertificate(String aFullRDN) {
        this.mCoreUtil.resetError();
        return this.mCertMgr.hasCertificate(aFullRDN);
    }

    @JavascriptInterface
    public int DeleteCertificate(String aIssuerRDN, String aCertSerial) {
        this.mCoreUtil.resetError();
        return this.mCertMgr.deleteCertificate(mDefaultMediaID, 2, aIssuerRDN, aCertSerial);
    }

    @JavascriptInterface
    public int DeleteCertificateWithSubjectDN(String aSubjectDN) {
        this.mCoreUtil.resetError();
        return this.mCertMgr.deleteCertificateWithSubjectDN(mDefaultMediaID, 2, aSubjectDN);
    }

    public String GetExternalPath() {
        String aExternalPath = this.mCoreUtil.getExternalPath();
        if (null == aExternalPath || "".equals(aExternalPath)) {
            return "/sdcard";
        }
        return this.mCoreUtil.getExternalPath();
    }

    @JavascriptInterface
    public void SetExternalPath(String path) {
        if (null == path || path.equals("")) {
            path = "/sdcard";
        }
        this.mCoreUtil.setExternalPath(path);
        this.mCertMgr.getMediaList(100, 0, 1);
    }

    @JavascriptInterface
    public String GetCertInfo(String aSignedData, int aOpOption, int aInfoOption) {
        this.mCoreUtil.resetError();
        return this.mSignEnvelopMgr.getCertInfoEx(aSignedData, "", aOpOption, aInfoOption, 0);
    }

    @JavascriptInterface
    public String FileUpload(String aXaddr, String aPath, String aQueryString, String aHostName, int aPort, String aInFilePath, String aDesc) {
        String aResult = "";
        String aEncString = "";
        this.mCoreUtil.resetError();
        if (aXaddr == null || aXaddr.equals("") || aPath == null || aPath.equals("") || aHostName == null || aHostName.equals("") || aInFilePath == null || aInFilePath.equals("")) {
            this.mCoreUtil.setError(10000111);
            return aResult;
        }
        if (aXaddr.length() > 512 || aPath.length() > 1024 || aInFilePath.length() > 4096 || aDesc.length() > 4096) {
            this.mCoreUtil.setError(10000112);
            return aResult;
        }
        aEncString = this.mBlockMgr.blockEncEx(this.mSessionID, aXaddr, aPath, aQueryString, "GET", "");
        if (aEncString == null || aEncString.equals("")) {
            return aResult;
        }
        this.mCoreUtil.resetError();
        Intent aIntent = new Intent(this.mGlobalContext, XecureSmartFileUpload.class);
        aIntent.putExtra("session_id_key", this.mSessionID);
        aIntent.putExtra("xaddr_key", aXaddr);
        aIntent.putExtra("path_key", aPath);
        aIntent.putExtra("query_string_key", aQueryString);
        aIntent.putExtra("host_name_key", aHostName);
        aIntent.putExtra("port_key", aPort);
        aIntent.putExtra("infile_path_key", aInFilePath);
        aIntent.putExtra("en_c_string_key", aEncString);
        this.mBlockerActivityResult = BlockerActivityUtil.startBlockerActivity((Context)this.mGlobalContext, (Intent)aIntent);
        aResult = this.mBlockerActivityResult.getResultCode() == -1 ? this.mBlockerActivityResult.getData().getStringExtra("result_key") : "";
        return aResult;
    }

    @JavascriptInterface
    public String FileUpload(String aXaddr, String aPath, String aQueryString, String aHostName, int aPort, String aInFilePath, String aCookie, String aDesc) {
        String aResult = "";
        String aEncString = "";
        this.mCoreUtil.resetError();
        if (aXaddr == null || aXaddr.equals("") || aPath == null || aPath.equals("") || aHostName == null || aHostName.equals("") || aInFilePath == null || aInFilePath.equals("")) {
            this.mCoreUtil.setError(10000111);
            return aResult;
        }
        if (aXaddr.length() > 512 || aPath.length() > 1024 || aInFilePath.length() > 4096 || aDesc.length() > 4096) {
            this.mCoreUtil.setError(10000112);
            return aResult;
        }
        aEncString = this.mBlockMgr.blockEncEx(this.mSessionID, aXaddr, aPath, aQueryString, "GET", "");
        if (aEncString == null || aEncString.equals("")) {
            return aResult;
        }
        this.mCoreUtil.resetError();
        Intent aIntent = new Intent(this.mGlobalContext, XecureSmartFileUpload.class);
        aIntent.putExtra("session_id_key", this.mSessionID);
        aIntent.putExtra("xaddr_key", aXaddr);
        aIntent.putExtra("path_key", aPath);
        aIntent.putExtra("query_string_key", aQueryString);
        aIntent.putExtra("host_name_key", aHostName);
        aIntent.putExtra("port_key", aPort);
        aIntent.putExtra("infile_path_key", aInFilePath);
        aIntent.putExtra("en_c_string_key", aEncString);
        aIntent.putExtra("cookie_key", aCookie);
        this.mBlockerActivityResult = BlockerActivityUtil.startBlockerActivity((Context)this.mGlobalContext, (Intent)aIntent);
        aResult = this.mBlockerActivityResult.getResultCode() == -1 ? this.mBlockerActivityResult.getData().getStringExtra("result_key") : "";
        return aResult;
    }

    @JavascriptInterface
    public int FileEnvelopWithPasswd(String aInFilePath, String aOutFilePath) {
        int aResult = -1;
        byte[] aBytesPassword = null;
        this.mCoreUtil.resetError();
        Intent aIntent = new Intent(this.mGlobalContext, EnvelopInputPassword.class);
        this.mBlockerActivityResult = BlockerActivityUtil.startBlockerActivity((Context)this.mGlobalContext, (Intent)aIntent);
        if (this.mBlockerActivityResult.getResultCode() != -1) {
            this.mCoreUtil.setError(10000011);
            return aResult;
        }
        aBytesPassword = this.mBlockerActivityResult.getData().getStringExtra("input_password_password_key").getBytes();
        this.mCoreUtil.resetError();
        aIntent = new Intent(this.mGlobalContext, XecureSmartFileEnvelopWithPasswd.class);
        aIntent.putExtra("session_id_key", this.mSessionID);
        aIntent.putExtra("infile_path_key", aInFilePath);
        aIntent.putExtra("outfile_path_key", aOutFilePath);
        aIntent.putExtra("password_key", aBytesPassword);
        this.mBlockerActivityResult = BlockerActivityUtil.startBlockerActivity((Context)this.mGlobalContext, (Intent)aIntent);
        if (this.mBlockerActivityResult.getResultCode() != -1) {
            return aResult;
        }
        aResult = this.mBlockerActivityResult.getData().getIntExtra("result_key", -1);
        XUtil.resetByteArray((byte[][])new byte[][]{aBytesPassword});
        return aResult;
    }

    @JavascriptInterface
    public int FileEnvelopWithCert(String aXgateAddr, String aCaName, String aInFilePath, String aOutFilePath, int aCertLocation, String aCertSerial) {
        int aResult = -1;
        int aMediaID = mDefaultMediaID;
        int aMediaType = 20;
        String aMediaIDList = "";
        String aSubjectDNList = "";
        String aSearchValue = aCaName;
        this.mCoreUtil.resetError();
        aMediaID = EnvironmentConfig.mSDCardOnlyUse ? 101 : 1401;
        aMediaID = this.mSessionMgr.getSessionClientMedia(aXgateAddr);
        aMediaType = 14;
        aSearchValue = this.mSessionMgr.getSessionClientRDN(aXgateAddr);
        this.showCertSelectWindow("call_mode_envelop", this.mSessionID, aXgateAddr, aMediaID, 2, aMediaType, aSearchValue, aCertSerial, 0, "", 0);
        if (this.mBlockerActivityResult.getResultCode() == 0) {
            this.mCoreUtil.setError(10000011);
            return -1;
        }
        if (this.mBlockerActivityResult.getResultCode() == 2) {
            this.mCoreUtil.setError(10000011);
            return -1;
        }
        aMediaIDList = String.valueOf(this.mBlockerActivityResult.getData().getIntExtra("media_id_key", -1));
        aSubjectDNList = this.mBlockerActivityResult.getData().getStringExtra("subject_rdn_key");
        this.mCoreUtil.resetError();
        Intent aIntent = new Intent(this.mGlobalContext, XecureSmartFileEnvelopWithCert.class);
        aIntent.putExtra("session_id_key", this.mSessionID);
        aIntent.putExtra("infile_path_key", aInFilePath);
        aIntent.putExtra("outfile_path_key", aOutFilePath);
        aIntent.putExtra("media_id_list_key", aMediaIDList);
        aIntent.putExtra("subject_dn_list_key", aSubjectDNList);
        this.mBlockerActivityResult = BlockerActivityUtil.startBlockerActivity((Context)this.mGlobalContext, (Intent)aIntent);
        if (this.mBlockerActivityResult.getResultCode() != -1) {
            return aResult;
        }
        aResult = this.mBlockerActivityResult.getData().getIntExtra("result_key", -1);
        return aResult;
    }

    @JavascriptInterface
    public int FileEnvelopWithPEM(String aInFilePath, String aOutFilePath, String aPEMData, String aPEMFile) {
        int aResult = -1;
        this.mCoreUtil.resetError();
        Intent aIntent = new Intent(this.mGlobalContext, XecureSmartFileEnvelopWithPEM.class);
        aIntent.putExtra("session_id_key", this.mSessionID);
        aIntent.putExtra("infile_path_key", aInFilePath);
        aIntent.putExtra("outfile_path_key", aOutFilePath);
        aIntent.putExtra("pem_data_key", aPEMData);
        aIntent.putExtra("pem_file_key", aPEMFile);
        this.mBlockerActivityResult = BlockerActivityUtil.startBlockerActivity((Context)this.mGlobalContext, (Intent)aIntent);
        if (this.mBlockerActivityResult.getResultCode() != -1) {
            return aResult;
        }
        aResult = this.mBlockerActivityResult.getData().getIntExtra("result_key", -1);
        return aResult;
    }

    @JavascriptInterface
    public int FileDeEnvelop(String aXgateAddr, String aCaName, String aInFilePath, int aOption, String aDesc, int aPasswordTryLimit) {
        int aResult = -1;
        int[] aEnvType = new int[1];
        String[] aCertSerial = new String[1];
        String[] aOrgFileName = new String[1];
        byte[] aPassword = null;
        String aOutFilePath = "";
        this.mCoreUtil.resetError();
        if (!aInFilePath.startsWith(XApplication.getContext().getFilesDir() + "/") || aInFilePath.contains("..")) {
            return -1;
        }
        this.mFileEnvelope.getEnvelopedFileInfo(aInFilePath, aEnvType, aCertSerial, aOrgFileName);
        aOutFilePath = new File(aInFilePath).getParent() + "/" + aOrgFileName[0];
        if (aEnvType[0] == 1) {
            this.showCertSelectWindow("call_mode_decryption", this.mSessionID, aXgateAddr, mDefaultMediaID, 2, 20, aCaName, aCertSerial[0], 3, "", 0);
            if (this.mBlockerActivityResult.getResultCode() == 0) {
                this.mCoreUtil.setError(10000011);
                return aResult;
            }
            if (this.mBlockerActivityResult.getResultCode() == 2) {
                this.mCoreUtil.setError(10000013);
                return aResult;
            }
            aPassword = this.mBlockerActivityResult.getData().getByteArrayExtra("password_key");
            int aMediaID = this.mBlockerActivityResult.getData().getIntExtra("media_id_key", -1);
            String aSubjectDN = this.mBlockerActivityResult.getData().getStringExtra("subject_rdn_key");
            this.mCoreUtil.resetError();
            Intent aIntent = new Intent(this.mGlobalContext, XecureSmartFileDeenvelopWithCert.class);
            aIntent.putExtra("session_id_key", this.mSessionID);
            aIntent.putExtra("infile_path_key", aInFilePath);
            aIntent.putExtra("outfile_path_key", aOutFilePath);
            aIntent.putExtra("media_id_key", aMediaID);
            aIntent.putExtra("subject_dn_key", aSubjectDN);
            aIntent.putExtra("password_key", aPassword);
            this.mBlockerActivityResult = BlockerActivityUtil.startBlockerActivity((Context)this.mGlobalContext, (Intent)aIntent);
            if (this.mBlockerActivityResult.getResultCode() == -1) {
                aResult = this.mBlockerActivityResult.getData().getIntExtra("result_key", -1);
            }
        } else {
            Intent aIntent = new Intent(this.mGlobalContext, EnvelopInputPassword.class);
            this.mBlockerActivityResult = BlockerActivityUtil.startBlockerActivity((Context)this.mGlobalContext, (Intent)aIntent);
            if (this.mBlockerActivityResult.getResultCode() != -1) {
                return aResult;
            }
            aPassword = this.mBlockerActivityResult.getData().getStringExtra("input_password_password_key").getBytes();
            this.mCoreUtil.resetError();
            aIntent = new Intent(this.mGlobalContext, XecureSmartFileDeenvelopWithPasswd.class);
            aIntent.putExtra("session_id_key", this.mSessionID);
            aIntent.putExtra("infile_path_key", aInFilePath);
            aIntent.putExtra("outfile_path_key", aOutFilePath);
            aIntent.putExtra("password_key", aPassword);
            this.mBlockerActivityResult = BlockerActivityUtil.startBlockerActivity((Context)this.mGlobalContext, (Intent)aIntent);
            if (this.mBlockerActivityResult.getResultCode() == -1) {
                aResult = this.mBlockerActivityResult.getData().getIntExtra("result_key", -1);
            }
        }
        XUtil.resetByteArray((byte[][])new byte[][]{aPassword});
        return aResult;
    }

    @JavascriptInterface
    public String FileSign(String aXgateAddr, String aCaName, String aInFilePath, String aOutDir, int aSignOption, String aCert, String aCertSerial, int aMediaID, String aDesc, int aPasswordTryLimit) {
        String aResult = "";
        String aSubjectDN = "";
        byte[] aPassword = null;
        this.mCoreUtil.resetError();
        if (this.isShowSelectCertWindow(this.mSessionID, aXgateAddr)) {
            this.showCertSelectWindow("call_mode_decryption", this.mSessionID, aXgateAddr, aMediaID, 2, 20, aCaName, aCertSerial, aPasswordTryLimit, "", 0);
            if (this.mBlockerActivityResult.getResultCode() == 0) {
                this.mCoreUtil.setError(10000011);
                return aResult;
            }
            if (this.mBlockerActivityResult.getResultCode() == 2) {
                this.mCoreUtil.setError(10000013);
                return aResult;
            }
            aMediaID = this.mBlockerActivityResult.getData().getIntExtra("media_id_key", 1);
            aSubjectDN = this.mBlockerActivityResult.getData().getStringExtra("subject_rdn_key");
            aPassword = this.mBlockerActivityResult.getData().getByteArrayExtra("password_key");
        }
        this.mCoreUtil.resetError();
        Intent aIntent = new Intent(this.mGlobalContext, XecureSmartFileSign.class);
        aIntent.putExtra("session_id_key", this.mSessionID);
        aIntent.putExtra("sign_option_key", aSignOption);
        aIntent.putExtra("xaddr_key", aXgateAddr);
        aIntent.putExtra("infile_path_key", aInFilePath);
        aIntent.putExtra("out_dir_key", aOutDir);
        aIntent.putExtra("media_id_key", aMediaID);
        aIntent.putExtra("subject_dn_key", aSubjectDN);
        aIntent.putExtra("password_key", aPassword);
        this.mBlockerActivityResult = BlockerActivityUtil.startBlockerActivity((Context)this.mGlobalContext, (Intent)aIntent);
        if (this.mBlockerActivityResult.getResultCode() == -1) {
            aResult = this.mBlockerActivityResult.getData().getStringExtra("result_key");
        }
        XUtil.resetByteArray((byte[][])new byte[][]{aPassword});
        return aResult;
    }

    @JavascriptInterface
    public int SetIssuerConvertTable(String policy, String convertedPol, String comment, int language) {
        this.mCoreUtil.resetError();
        return this.mCertMgr.setIssuerConvertTable(policy, convertedPol, comment, language);
    }

    @JavascriptInterface
    public int LastErrCode() {
        return this.mCoreUtil.lastErrCode();
    }

    @JavascriptInterface
    public String LastErrMsg() {
        return this.mCoreUtil.lastErrMsg();
    }

    @JavascriptInterface
    public int EndSession(String aXaddr) {
        return this.mCoreUtil.endSession(aXaddr);
    }

    @JavascriptInterface
    public String GetAttribute(String aName) {
        return this.mCoreUtil.getAttribute(this.mSessionID, aName);
    }

    @JavascriptInterface
    public void SetAttribute(String aName, String aValue) {
        this.mCoreUtil.setAttribute(this.mSessionID, aName, aValue);
    }

    @JavascriptInterface
    public void SetHostName(String aHostName) {
        this.mCoreUtil.setHostName(this.mSessionID, aHostName);
    }

    @JavascriptInterface
    public String getVersion() {
        return XUtil.getVersion();
    }

    @JavascriptInterface
    public String getLanguage() {
        return this.mLanguage;
    }

    @JavascriptInterface
    public void setLanguage(String mLanguage) {
        this.mLanguage = mLanguage;
    }

    @JavascriptInterface
    public String getSecContext() {
        return this.mSecContext;
    }

    @JavascriptInterface
    public void setSecContext(String mSecContext) {
        this.mSecContext = mSecContext;
    }

    @JavascriptInterface
    public String getCertLocation() {
        return this.mCertLocation;
    }

    @JavascriptInterface
    public void setCertLocation(String mCertLocation) {
        this.mCertLocation = mCertLocation;
    }

    @JavascriptInterface
    public String getSecOption() {
        return this.mSecOption;
    }

    @JavascriptInterface
    public void setSecOption(String mSecOption) {
        this.mSecOption = mSecOption;
    }

    @JavascriptInterface
    public String getSecDesc() {
        return this.mSecDesc;
    }

    @JavascriptInterface
    public void setSecDesc(String mSecDesc) {
        this.mSecDesc = mSecDesc;
    }

    @JavascriptInterface
    public String getSecKeyStroke() {
        return this.mSecKeyStroke;
    }

    @JavascriptInterface
    public void setSecKeyStroke(String mSecKeyStroke) {
        this.mSecKeyStroke = mSecKeyStroke;
    }

    @JavascriptInterface
    public String getFuncLicense() {
        return this.mFuncLicense;
    }

    @JavascriptInterface
    public void setFuncLicense(String mFuncLicense) {
        this.mFuncLicense = mFuncLicense;
    }

    @JavascriptInterface
    public String getCSPProviders() {
        return this.mCSPProviders;
    }

    @JavascriptInterface
    public void setCSPProviders(String mCSPProviders) {
        this.mCSPProviders = mCSPProviders;
    }

    @JavascriptInterface
    public String getP11Providers() {
        return this.mP11Providers;
    }

    @JavascriptInterface
    public void setP11Providers(String mP11Providers) {
        this.mP11Providers = mP11Providers;
    }

    @JavascriptInterface
    public String getLimitPinNum() {
        return this.mLimitPinNum;
    }

    @JavascriptInterface
    public void setLimitPinNum(String mLimitPinNum) {
        this.mLimitPinNum = mLimitPinNum;
    }

    @JavascriptInterface
    public long getSessionID() {
        return this.mSessionID;
    }

    @JavascriptInterface
    public int FileDownload(String aXaddr, String aPath, String aQueryString, String aHostName, int aPort, String aTagetFilePath, String aDownloadPath) {
        int aResult = -1;
        String aEncString = this.mBlockMgr.blockEncEx(this.mSessionID, aXaddr, aPath, aQueryString = aQueryString + aQueryString + "&filename=" + aTagetFilePath, "GET", "");
        if (aEncString == null || aEncString.equals("")) {
            return -1;
        }
        this.mCoreUtil.resetError();
        Intent aIntent = new Intent(this.mGlobalContext, XecureSmartFileDownload.class);
        aIntent.putExtra("session_id_key", this.mSessionID);
        aIntent.putExtra("xaddr_key", aXaddr);
        aIntent.putExtra("path_key", aPath);
        aIntent.putExtra("query_string_key", aQueryString);
        aIntent.putExtra("host_name_key", aHostName);
        aIntent.putExtra("port_key", aPort);
        aIntent.putExtra("target_file_path_key", aTagetFilePath);
        aIntent.putExtra("download_file_path_key", aDownloadPath);
        aIntent.putExtra("en_c_string_key", aEncString);
        this.mBlockerActivityResult = BlockerActivityUtil.startBlockerActivity((Context)this.mGlobalContext, (Intent)aIntent);
        aResult = this.mBlockerActivityResult.getResultCode() == -1 ? 0 : -1;
        return aResult;
    }

    @JavascriptInterface
    public int FileDownload(String aXaddr, String aPath, String aQueryString, String aHostName, int aPort, String aTagetFilePath, String aDownloadPath, String aCookie) {
        int aResult = -1;
        String aEncString = this.mBlockMgr.blockEncEx(this.mSessionID, aXaddr, aPath, aQueryString = aQueryString + aQueryString + "&filename=" + aTagetFilePath, "GET", "");
        if (aEncString == null || aEncString.equals("")) {
            return -1;
        }
        this.mCoreUtil.resetError();
        Intent aIntent = new Intent(this.mGlobalContext, XecureSmartFileDownload.class);
        aIntent.putExtra("session_id_key", this.mSessionID);
        aIntent.putExtra("xaddr_key", aXaddr);
        aIntent.putExtra("path_key", aPath);
        aIntent.putExtra("query_string_key", aQueryString);
        aIntent.putExtra("host_name_key", aHostName);
        aIntent.putExtra("port_key", aPort);
        aIntent.putExtra("target_file_path_key", aTagetFilePath);
        aIntent.putExtra("download_file_path_key", aDownloadPath);
        aIntent.putExtra("en_c_string_key", aEncString);
        aIntent.putExtra("cookie_key", aCookie);
        this.mBlockerActivityResult = BlockerActivityUtil.startBlockerActivity((Context)this.mGlobalContext, (Intent)aIntent);
        aResult = this.mBlockerActivityResult.getResultCode() == -1 ? 0 : -1;
        return aResult;
    }

    static {
        mICCertificateIndex = 0;
    }
}

