/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.keypad;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import android.widget.Toast;
import com.consortium.smartusim.SmartUsim;
import com.consortium.smartusim.SmartUsimListener;
import com.consortium.smartusim.SmartUsimResultCode;
import com.softforum.sample.R;
import com.softforum.xecure.core.CoreWrapper;
import com.softforum.xecure.crypto.CertMgr;
import com.softforum.xecure.ui.XTopView;
import com.softforum.xecure.util.EnvironmentConfig;
import com.softforum.xecure.util.ImageTextSpinnerAdapter;
import com.softforum.xecure.util.XCoreUtil;
import com.softforum.xecure.util.XDetailData;
import com.softforum.xecure.util.XSLog;
import com.softforum.xecure.util.XUtil;
import com.softforum.xecurekeypad.XKConstants;
import com.softforum.xecurekeypad.XKEditText;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;

public class CopyCertToUsimWithXK
extends Activity {
    public static final int mXecureSmartCopyCertoUsimID = 130000;
    private SmartUsim mSmartUsim = null;
    private int m_P_assW_ordTryCount = 0;
    private XDetailData mSelectedData;
    private byte[] m_P_assW_ord = null;
    private byte[] mSmartPassword = null;
    private int mSrcMediaID;
    private Handler mHandler = new Handler();
    private final String mServerAddress = "58.229.178.45";
    private final int mServerPort = 25189;
    private final int END_BIND = 101;
    private final int flag_JOIN = 102;
    public static final int RESULT_PASSWD_FAIL = 2;
    public static final String mMediaIDKey = "sign_cert_password_media_id_key";
    public static final String mSelectedCertDataKey = "sign_cert_password_selected_cert_data_key";
    public static final String m_P_assW_ordKey = "sign_cert_password_password_key";
    private byte[] mCertificateDER = null;
    private byte[] mKeyDER = null;
    private XCoreUtil mCoreUtil = new XCoreUtil();
    protected static final int PINCODE_LOCK_ERROR = 0;
    private final int MEDIA_DREAMSECURITY_USIM = 0;
    private final int MEDIA_RAONSECURE_USIM = 1;
    private int SELECT_BENDER;
    private final int DREAMSECURE = 0;
    private final int RAONSECURE = 1;
    private XKEditText mSmartPasswordEditText = null;
    private XKEditText m_P_assW_ordEditText = null;
    private String mEncryptedData = null;
    private byte[] mRandomValue = new byte[20];
    public SmartUsimListener mSmartUsimListener = new SmartUsimListener(){

        public void onSmartUsimResult(int requestCode, SmartUsimResultCode resultCode) {
            switch (requestCode) {
                case 3: {
                    if (resultCode.getResultCode() == 0) {
                        CopyCertToUsimWithXK.this.mSmartUsim.bindService("58.229.178.45", 25189);
                        break;
                    }
                    CopyCertToUsimWithXK.this.showToast("\uc2a4\ub9c8\ud2b8\uc778\uc99d\uc571\uc774 \uc124\uce58\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.\n\ud655\uc778 \ud6c4 \uc774\uc6a9\ud574 \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.\n[" + resultCode.getResultCode() + "]");
                    break;
                }
                case 1: {
                    if (resultCode.getResultCode() == 0) {
                        new AlertDialog.Builder((Context)CopyCertToUsimWithXK.this).setTitle((CharSequence)"\uc54c\ub9bc").setMessage((CharSequence)"\uc120\ud0dd\ud558\uc2e0 \uc778\uc99d\uc11c\ub97c USIM\uc5d0 \uc800\uc7a5\ud569\ub2c8\ub2e4. \uacc4\uc18d\ud558\uc2dc\uaca0\uc2b5\ub2c8\uae4c?").setPositiveButton((CharSequence)"YES", new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                                CopyCertToUsimWithXK.this.copyCertToUsim();
                            }
                        }).setNegativeButton((CharSequence)"NO", new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                            }
                        }).show();
                        break;
                    }
                    CopyCertToUsimWithXK.this.showToast("\ubc14\uc778\ub4dc \uc2e4\ud328\uacf5\ud1b5 /Vendor \ucf54\ub4dc : " + resultCode.getResultCode() + "(" + resultCode.getResultCodeVendor() + ")");
                }
            }
        }
    };

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.usim_cert_copy_xk);
        this.mSrcMediaID = this.getIntent().getIntExtra("mSrcMediaID", 1);
        this.mSelectedData = new XDetailData(this.getIntent().getStringArrayExtra(mSelectedCertDataKey), 0);
        ImageView aIcon = (ImageView)this.findViewById(R.id.icon);
        TextView aMainMsg = (TextView)this.findViewById(R.id.main_msg);
        TextView aSubMsg1 = (TextView)this.findViewById(R.id.sub_msg1);
        TextView aSubMsg2 = (TextView)this.findViewById(R.id.sub_msg2);
        if ("0".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_normal);
        } else if ("1".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_update);
        } else if ("2".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_revoke);
        }
        aMainMsg.setText((CharSequence)XUtil.getCNFromRDN((String)this.mSelectedData.getValue(7)));
        aSubMsg1.setText((CharSequence)(this.mSelectedData.getKeyText(4) + " : " + this.mSelectedData.getValue(4)));
        aSubMsg2.setText((CharSequence)(this.mSelectedData.getKeyText(6) + " : " + this.mSelectedData.getValue(6)));
        if (EnvironmentConfig.mUsimUse) {
            this.setSpinner();
        } else {
            View aView = this.findViewById(R.id.select_media);
            aView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, 0));
            aView.setVisibility(4);
        }
        this.setKeyPad();
        Button aOKButton = (Button)this.findViewById(R.id.top_right_button);
        aOKButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CopyCertToUsimWithXK.this.onOKButtonClick(v);
            }
        });
    }

    private void setKeyPad() {
        int aKeypadType = 0;
        int aKeypadViewType = 0;
        this.m_P_assW_ordEditText = (XKEditText)this.findViewById(R.id.password_edittext);
        this.mSmartPasswordEditText = (XKEditText)this.findViewById(R.id.smart_password_edittext);
        if (EnvironmentConfig.mXecureKeypadFullViewUsage) {
            aKeypadViewType = 1;
            this.m_P_assW_ordEditText.setSubTitle("\uc778\uc99d\uc11c \ube44\ubc00\ubc88\ud638");
            this.mSmartPasswordEditText.setSubTitle("\uc2a4\ub9c8\ud2b8\uc778\uc99d \ube44\ubc00\ubc88\ud638");
        } else if (EnvironmentConfig.mXecureKeypadNormalViewUsage) {
            aKeypadViewType = 0;
            this.m_P_assW_ordEditText.setLayoutIdentifier(R.id.xk_keypad_root_layout);
            this.mSmartPasswordEditText.setLayoutIdentifier(R.id.xk_keypad_root_layout);
        }
        if (aKeypadViewType == 1) {
            this.m_P_assW_ordEditText.setUseInputButton(true);
            this.mSmartPasswordEditText.setUseInputButton(true);
            this.m_P_assW_ordEditText.setSubTitle(this.getString(R.string.password));
            this.mSmartPasswordEditText.setSubTitle(this.getString(R.string.smart_password));
        }
        aKeypadType = 1;
        this.m_P_assW_ordEditText.setXKViewType(aKeypadViewType);
        this.m_P_assW_ordEditText.setXKKeypadType(aKeypadType);
        this.mSmartPasswordEditText.setXKViewType(aKeypadViewType);
        this.mSmartPasswordEditText.setXKKeypadType(aKeypadType);
    }

    private void setSpinner() {
        Spinner aSelectStorage = null;
        ImageTextSpinnerAdapter aSpinnerAdapter = null;
        HashMap<String, Object> aItem = null;
        ArrayList<HashMap<String, Object>> aItemList = null;
        aSelectStorage = (Spinner)this.findViewById(R.id.select_media);
        aItemList = new ArrayList<HashMap<String, Object>>();
        aItem = new HashMap<String, Object>();
        aItem.put("image", R.drawable.usim_dream);
        aItem.put("text", "\uc720\uc2ec(\ub4dc\ub9bc)");
        aItemList.add(aItem);
        aSpinnerAdapter = new ImageTextSpinnerAdapter((Context)this, aItemList);
        aSelectStorage.setAdapter((SpinnerAdapter)aSpinnerAdapter);
        aSelectStorage.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                switch (position) {
                    case 0: {
                        CopyCertToUsimWithXK.this.SELECT_BENDER = 0;
                        break;
                    }
                    case 1: {
                        CopyCertToUsimWithXK.this.SELECT_BENDER = 1;
                    }
                }
            }

            public void onNothingSelected(AdapterView<?> arg0) {
            }
        });
    }

    private void onOKButtonClick(View v) {
        boolean aIsMember = false;
        boolean aIsInstall = false;
        CertMgr aCertMgr = null;
        XTopView aTopView = null;
        SmartUsimResultCode aResultCode = null;
        int aVerifyResult = 0;
        this.mCoreUtil.resetError();
        aTopView = (XTopView)this.findViewById(R.id.top_view);
        if (EnvironmentConfig.mXecureKeypadEncryptionUsage) {
            SecureRandom sr = new SecureRandom();
            sr.nextBytes(this.mRandomValue);
            this.mEncryptedData = this.m_P_assW_ordEditText.getEncryptedData(this.mRandomValue);
        } else {
            this.m_P_assW_ord = this.m_P_assW_ordEditText.getData().getBytes();
            this.mSmartPassword = this.mSmartPasswordEditText.getData().getBytes();
        }
        if (EnvironmentConfig.mXecureKeypadEncryptionUsage) {
            if (this.mEncryptedData == null || this.mEncryptedData.length() == 0 || this.mSmartPassword == null || this.mSmartPassword.length == 0) {
                aTopView.setDescription(this.getString(R.string.plugin_input_nothing));
                return;
            }
        } else if (this.m_P_assW_ord == null || this.m_P_assW_ord.length == 0 || this.mSmartPassword == null || this.mSmartPassword.length == 0) {
            aTopView.setDescription(this.getString(R.string.plugin_input_nothing));
            return;
        }
        aCertMgr = CertMgr.getInstance();
        if (EnvironmentConfig.mXecureKeypadEncryptionUsage) {
            if (this.mEncryptedData != null || this.mEncryptedData.length() != 0) {
                aVerifyResult = aCertMgr.verifyPassword(this.mSrcMediaID, this.mSelectedData.getValue(7), this.mRandomValue, this.mEncryptedData);
            }
        } else {
            aVerifyResult = aCertMgr.verifyPassword(this.mSrcMediaID, 14, this.mSelectedData.getValue(7), this.m_P_assW_ord);
        }
        if (aVerifyResult != 0) {
            aTopView.setDescription(this.mCoreUtil.lastErrMsg());
            if (++this.m_P_assW_ordTryCount >= 3) {
                this.setResult(2);
                XUtil.resetByteArray((byte[][])new byte[][]{this.m_P_assW_ord, this.mRandomValue});
                this.finish();
            }
            return;
        }
        if (this.mSmartUsim != null) {
            this.endUnBind();
            this.mSmartUsim = null;
        }
        if (this.SELECT_BENDER == 0) {
            this.mSmartUsim = SmartUsim.getInstance((Context)this, (SmartUsimListener)this.mSmartUsimListener, (String)"www.softforum.com", (String)"cpCode", (int)2);
        } else if (this.SELECT_BENDER == 1) {
            this.mSmartUsim = SmartUsim.getInstance((Context)this, (SmartUsimListener)this.mSmartUsimListener, (String)"www.softforum.com", (String)"cpCode", (int)1);
        }
        aIsMember = this.mSmartUsim.isMember();
        if (!aIsMember && (aResultCode = this.mSmartUsim.getLastError()).getResultCode() != 2001) {
            this.showToast("\uc11c\ube44\uc2a4 \ubd88\uac00\ub2a5 \uc0ac\uc6a9\uc790" + aResultCode.getResultCode() + "/" + aResultCode.getResultCodeVendor());
            return;
        }
        aIsInstall = this.mSmartUsim.isInstalled();
        if (!aIsInstall) {
            this.mSmartUsim.install();
            return;
        }
        this.mSmartUsim.bindService("58.229.178.45", 25189);
    }

    private void showToast(final String message) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                Toast.makeText((Context)CopyCertToUsimWithXK.this, (CharSequence)message, (int)1).show();
            }
        });
    }

    private void copyCertToUsim() {
        boolean aIsPossible = false;
        String aSubjectRDN = null;
        Intent aIntent = null;
        XTopView aTopView = null;
        SmartUsimResultCode aResultCode = null;
        aTopView = (XTopView)this.findViewById(R.id.top_view);
        aIntent = new Intent();
        aIsPossible = this.mSmartUsim.isPossibleService();
        if (aIsPossible) {
            aSubjectRDN = this.mSelectedData.getValue(7);
            this.mCertificateDER = CoreWrapper.getExportRawSignCert((int)this.mSrcMediaID, (String)aSubjectRDN);
            this.mKeyDER = CoreWrapper.getExportRawSignKey((int)this.mSrcMediaID, (String)aSubjectRDN);
            if (this.mCertificateDER.length < 1 || this.mKeyDER.length < 1) {
                aTopView.setDescription("\uc778\uc99d\uc11c \ud30c\uc77c \uc77d\uae30\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4.");
                this.setResult(2, aIntent);
            }
            if ((aResultCode = this.mSmartUsim.writeCertUsim(this.mSmartPassword, this.mCertificateDER, this.mKeyDER, this.m_P_assW_ord)).getResultCode() != 0) {
                if (aResultCode.getResultCode() == 5001) {
                    aTopView.setDescription(this.getString(R.string.message_password_pin_incorrect));
                    return;
                }
                if (aResultCode.getResultCode() == 5002) {
                    aIntent.putExtra("xecure_smart_cert_mgr_result_key", 4);
                } else if (aResultCode.getResultCode() == 5003) {
                    aIntent.putExtra("xecure_smart_cert_mgr_result_key", 5);
                } else {
                    aIntent.putExtra("xecure_smart_cert_mgr_result_key", 7);
                }
            } else {
                aIntent.putExtra("xecure_smart_cert_mgr_result_key", 6);
            }
            this.setResult(-1, aIntent);
            this.endUnBind();
            this.finish();
        } else {
            aResultCode = this.mSmartUsim.getLastError();
            if (aResultCode.getResultCodeVendor() == 3001) {
                this.mSmartUsim.joinService(102);
            } else if (aResultCode.getResultCode() == 3002) {
                this.endUnBind();
                this.showToast("\uc2a4\ub9c8\ud2b8\uacf5\uc778\uc778\uc99d \uc571 \uc5c5\ub370\uc774\ud2b8\uac00 \ud544\uc694\ud569\ub2c8\ub2e4.(" + aResultCode.getResultCodeVendor() + ")");
                this.mSmartUsim.install();
            } else if (aResultCode.getResultCode() == 3001) {
                this.showToast("\ud5c8\uac00\ub418\uc9c0 \uc54a\uc740 \uc571\uc774 \uc811\uadfc\ud558\uc600\uc2b5\ub2c8\ub2e4." + aResultCode.getResultCode() + "(" + aResultCode.getResultCodeVendor() + ")");
                this.endUnBind();
            } else {
                this.showToast(aResultCode.getResultCode() + "(" + aResultCode.getResultCodeVendor() + ")");
                this.endUnBind();
            }
        }
    }

    private void endUnBind() {
        try {
            this.mSmartUsim.unbindService();
        }
        catch (Exception e) {
            XSLog.e((String)e.getMessage());
        }
    }

    public void finish() {
        XUtil.resetByteArray((byte[][])new byte[][]{this.mRandomValue, this.m_P_assW_ord, this.mSmartPassword});
        super.finish();
    }

    public void onBackPressed() {
        if (this.mSmartUsim != null) {
            this.endUnBind();
        }
        XUtil.resetByteArray((byte[][])new byte[][]{this.mRandomValue, this.m_P_assW_ord, this.mSmartPassword});
        this.finish();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case 101: {
                this.endUnBind();
                break;
            }
            case 102: {
                if (resultCode != -1) break;
                this.copyCertToUsim();
            }
        }
        if ((requestCode != XKConstants.XKKeypadRequestCode || resultCode != 0) && requestCode == XKConstants.XKKeypadRequestCode && resultCode == 200000) {
            Toast.makeText((Context)this, (CharSequence)"\uc778\ub371\uc2a4 \uc0dd\uc131\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4.", (int)0).show();
        }
    }
}

