/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.keypad;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.Toast;
import com.softforum.sample.R;
import com.softforum.xecure.ui.XTopView;
import com.softforum.xecure.ui.browser.TBrowser;
import com.softforum.xecure.ui.crypto.XecureSmartCertMgrCopy;
import com.softforum.xecure.util.EnvironmentConfig;
import com.softforum.xecure.util.XUtil;
import com.softforum.xecurekeypad.XKConstants;
import com.softforum.xecurekeypad.XKEditText;

public class XecureSmartCertMgrInputVIDWithXK
extends Activity {
    public static final int mXecureSmartCertMgrInputVidID = 72600;
    public static final String mXecureSmartCertMgrInputVIDKey = "xecure_smart_cert_mgr_input_vid_key";
    private byte[] mVid = null;
    private XKEditText mVidTextView = null;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.crypto_xecure_smart_cert_mgr_input_vid_xk);
        this.setKeyPad();
        Button aOKButton = (Button)this.findViewById(R.id.top_right_button);
        aOKButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XecureSmartCertMgrInputVIDWithXK.this.onOKButtonClick(v);
            }
        });
    }

    private void setKeyPad() {
        int aKeypadType = 0;
        int aKeypadViewType = 0;
        this.mVidTextView = (XKEditText)this.findViewById(R.id.vid_edittext);
        if (EnvironmentConfig.mXecureKeypadFullViewUsage) {
            aKeypadViewType = 1;
            this.mVidTextView.setSubTitle("\uc8fc\ubbfc\ub4f1\ub85d\ubc88\ud638");
        } else if (EnvironmentConfig.mXecureKeypadNormalViewUsage) {
            aKeypadViewType = 0;
            this.mVidTextView.setLayoutIdentifier(R.id.xk_keypad_root_layout);
        }
        aKeypadType = 0;
        this.mVidTextView.setXKViewType(aKeypadViewType);
        this.mVidTextView.setXKKeypadType(aKeypadType);
        if (aKeypadViewType == 1) {
            this.mVidTextView.setUseInputButton(true);
            this.mVidTextView.setSubTitle(this.getString(R.string.identification_number));
        }
        this.mVidTextView.setXKKeypadMaxLength(13);
    }

    private void onOKButtonClick(View v) {
        Intent aIntent = null;
        XTopView aTopView = null;
        aTopView = (XTopView)this.findViewById(R.id.top_view);
        this.mVid = this.mVidTextView.getData().getBytes();
        if (this.mVid == null || this.mVid.length == 0) {
            aTopView.setDescription(this.getString(R.string.xecure_smart_cert_mgr_copy_wrong_vid));
        } else if (this.mVid.length < 13) {
            aTopView.setDescription(this.getString(R.string.xecure_smart_cert_mgr_copy_wrong_vid));
        } else {
            aIntent = new Intent((Context)this, XecureSmartCertMgrCopy.class);
            aIntent.putExtra("vid_key", new String(this.mVid));
            aIntent.addFlags(0x2000000);
            this.startActivity(aIntent);
            this.finish();
        }
        XUtil.resetByteArray((byte[][])new byte[][]{this.mVid});
    }

    public void onBackPressed() {
        super.onBackPressed();
        XUtil.resetByteArray((byte[][])new byte[][]{this.mVid});
        Intent aIntent = new Intent((Context)this, TBrowser.class);
        this.setResult(0, aIntent);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if ((requestCode != XKConstants.XKKeypadRequestCode || resultCode != 0) && requestCode == XKConstants.XKKeypadRequestCode && resultCode == 200000) {
            Toast.makeText((Context)this, (CharSequence)"\uc778\ub371\uc2a4 \uc0dd\uc131\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4.", (int)0).show();
        }
    }
}

