/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.ui.crypto;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.softforum.sample.R;
import com.softforum.xecure.ui.crypto.XecureSmartCertDetailInfo;
import com.softforum.xecure.util.BlockerActivityResult;
import com.softforum.xecure.util.BlockerActivityUtil;
import com.softforum.xecure.util.XDetailData;
import com.softforum.xecure.util.XDetailDataParser;

public class VerifyErrorWindow
extends Activity {
    public static final int mVerifyErrorWindowID = 70000;
    public static final String mCertInfoKey = "cert_info_key";
    public static final String mErrorMsgKey = "error_msg_key";
    public static final String mResultValueKey = "result_value_key";
    private String mCertInfo;
    private String mErrorMsg;
    private XDetailData mXDetailData;
    private TextView mCertNameTxtV;
    private TextView mIssuerNameTxtV;
    private TextView mErrMsgTxtV;
    private Button mSeeServerInfoBtn;
    private Button mContinueBtn;
    private Button mStopBtn;
    private BlockerActivityResult mBlockerParam;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(3);
        this.setContentView(R.layout.verify_error_window);
        this.setFeatureDrawable(3, this.getResources().getDrawable(R.drawable.cert_verify_error));
        this.initializeGUIComponent();
        Intent receivedIntent = this.getIntent();
        this.mCertInfo = receivedIntent.getStringExtra(mCertInfoKey);
        this.mErrorMsg = receivedIntent.getStringExtra(mErrorMsgKey);
        this.mXDetailData = (XDetailData)XDetailDataParser.parse((String)this.mCertInfo, (int)0).get(0);
        this.mBlockerParam = BlockerActivityUtil.getParam((Context)this, (Intent)receivedIntent);
        this.mCertNameTxtV.setText((CharSequence)this.mXDetailData.getValue(7));
        this.mIssuerNameTxtV.setText((CharSequence)this.mXDetailData.getValue(4));
        this.mErrMsgTxtV.setText((CharSequence)this.mErrorMsg);
    }

    private void initializeGUIComponent() {
        this.mSeeServerInfoBtn = (Button)this.findViewById(R.id.verify_error_window_see_server_btn);
        this.mContinueBtn = (Button)this.findViewById(R.id.verify_error_window_continue_btn);
        this.mStopBtn = (Button)this.findViewById(R.id.verify_error_window_stop_btn);
        this.mCertNameTxtV = (TextView)this.findViewById(R.id.verify_error_window_cert_name_txtv);
        this.mIssuerNameTxtV = (TextView)this.findViewById(R.id.verify_error_window_issuer_name_txtv);
        this.mErrMsgTxtV = (TextView)this.findViewById(R.id.verify_error_window_err_msg_txtv);
        this.mSeeServerInfoBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VerifyErrorWindow.this.onSeeServerBtnClick(v);
            }
        });
        this.mContinueBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VerifyErrorWindow.this.onContinueBtnClick(v);
                VerifyErrorWindow.this.finish();
            }
        });
        this.mStopBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VerifyErrorWindow.this.onStopBtnClick(v);
                VerifyErrorWindow.this.finish();
            }
        });
    }

    private void onSeeServerBtnClick(View v) {
        Intent aResultIntent = new Intent((Context)this, XecureSmartCertDetailInfo.class);
        aResultIntent.putExtra("parsed_xdetail_data_key", this.mXDetailData.getValueArray());
        this.startActivity(aResultIntent);
    }

    private void onContinueBtnClick(View v) {
        Intent aResultIntent = new Intent();
        aResultIntent.putExtra(mResultValueKey, 0);
        this.mBlockerParam.setBlockerResult(-1, aResultIntent);
    }

    private void onStopBtnClick(View v) {
        Intent aResultIntent = new Intent();
        aResultIntent.putExtra(mResultValueKey, -1);
        this.mBlockerParam.setBlockerResult(0, aResultIntent);
    }

    public void finish() {
        BlockerActivityUtil.finishBlockerActivity((Object)this.mBlockerParam);
        super.finish();
    }
}

