/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.ui.crypto;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.lumensoft.icrp.KSICRProtocol;
import com.softforum.sample.R;
import com.softforum.xecure.XApplication;
import com.softforum.xecure.crypto.CertMgr;
import com.softforum.xecure.util.XSLog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;

public class XecureSmartCertMgrCopySimple
extends Activity {
    public static final int mXecureSmartCertMgrCopySimpleID = 72700;
    private ProgressDialog mProgressDialog = null;
    private KSICRProtocol mKSICRProtocol = null;
    private Handler mHandler = null;
    private String mResultCode = null;
    private String mResultMessage = null;
    private String mCertificateNumber = null;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.crypto_xecure_smart_cert_mgr_copy_simple);
        Button aImportButton = null;
        this.mKSICRProtocol = new KSICRProtocol("211.32.131.182", 10500);
        aImportButton = (Button)this.findViewById(R.id.top_right_button);
        aImportButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View pView) {
                XecureSmartCertMgrCopySimple.this.importCertificate(pView);
            }
        });
        this.mHandler = new Handler(){

            public void handleMessage(Message pMessage) {
                Intent aIntent = XecureSmartCertMgrCopySimple.this.getIntent();
                if (pMessage.what == 2) {
                    aIntent.putExtra("xecure_smart_result_key", 2);
                    XecureSmartCertMgrCopySimple.this.setResult(-1, aIntent);
                    if (XecureSmartCertMgrCopySimple.this.mProgressDialog != null) {
                        XecureSmartCertMgrCopySimple.this.mProgressDialog.dismiss();
                    }
                    XecureSmartCertMgrCopySimple.this.finish();
                } else if (pMessage.what == 3) {
                    aIntent.putExtra("xecure_smart_result_key", 3);
                    XecureSmartCertMgrCopySimple.this.setResult(-1, aIntent);
                    if (XecureSmartCertMgrCopySimple.this.mProgressDialog != null) {
                        XecureSmartCertMgrCopySimple.this.mProgressDialog.dismiss();
                    }
                    XecureSmartCertMgrCopySimple.this.finish();
                } else if (pMessage.what == 4) {
                    aIntent.putExtra("xecure_smart_result_key", 5);
                    XecureSmartCertMgrCopySimple.this.setResult(-1, aIntent);
                    if (XecureSmartCertMgrCopySimple.this.mProgressDialog != null) {
                        XecureSmartCertMgrCopySimple.this.mProgressDialog.dismiss();
                    }
                    XecureSmartCertMgrCopySimple.this.finish();
                } else if (pMessage.what == 5) {
                    aIntent.putExtra("xecure_smart_result_key", 6);
                    XecureSmartCertMgrCopySimple.this.setResult(-1, aIntent);
                    if (XecureSmartCertMgrCopySimple.this.mProgressDialog != null) {
                        XecureSmartCertMgrCopySimple.this.mProgressDialog.dismiss();
                    }
                    XecureSmartCertMgrCopySimple.this.finish();
                } else if (pMessage.what == 6) {
                    aIntent.putExtra("xecure_smart_result_key", 7);
                    XecureSmartCertMgrCopySimple.this.setResult(-1, aIntent);
                    if (XecureSmartCertMgrCopySimple.this.mProgressDialog != null) {
                        XecureSmartCertMgrCopySimple.this.mProgressDialog.dismiss();
                    }
                    XecureSmartCertMgrCopySimple.this.finish();
                } else if (pMessage.what == 7) {
                    aIntent.putExtra("xecure_smart_result_key", 8);
                    XecureSmartCertMgrCopySimple.this.setResult(-1, aIntent);
                    if (XecureSmartCertMgrCopySimple.this.mProgressDialog != null) {
                        XecureSmartCertMgrCopySimple.this.mProgressDialog.dismiss();
                    }
                    XecureSmartCertMgrCopySimple.this.finish();
                }
            }
        };
        this.getCertificateNumber();
    }

    private void getCertificateNumber() {
        Hashtable aMessageHashtable = new Hashtable();
        TextView aTextView = (TextView)this.findViewById(R.id.simple_cnum);
        aMessageHashtable = this.mKSICRProtocol.import1();
        this.mResultCode = (String)aMessageHashtable.get("CODE");
        this.mResultMessage = (String)aMessageHashtable.get("MESSAGE");
        this.mCertificateNumber = (String)aMessageHashtable.get("RANDOMNUMBER");
        if (this.mResultCode.equals("SC200")) {
            XSLog.d((String)(((Object)((Object)this)).getClass().getName() + "::import1 (Create cnum) Success [ResultCode : ResultMsg] [" + this.mResultCode + " : " + this.mResultMessage + "]"));
            aTextView.setText((CharSequence)("\uc778\uc99d\ubc88\ud638 : " + this.mCertificateNumber));
        } else {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(7));
        }
    }

    private void importCertificate(View pView) {
        final Thread aImportThread = new Thread(new ImportRunnable());
        this.mProgressDialog = new ProgressDialog((Context)this);
        this.mProgressDialog.setTitle((CharSequence)this.getString(R.string.xecure_smart_cert_mgr_copy_copying));
        this.mProgressDialog.setMessage((CharSequence)("\uc778\uc99d\ubc88\ud638 : " + this.mCertificateNumber));
        this.mProgressDialog.setIndeterminate(true);
        this.mProgressDialog.setCancelable(true);
        this.mProgressDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                if (aImportThread.isAlive()) {
                    aImportThread.interrupt();
                }
            }
        });
        this.mProgressDialog.show();
        aImportThread.start();
    }

    private class ImportRunnable
    implements Runnable {
        private ImportRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            File aTempDir = null;
            File aTempUserCert = null;
            File aTempUserKey = null;
            FileOutputStream aCert = null;
            FileOutputStream aKey = null;
            String aCertPath = null;
            String aKeyPath = null;
            String aSofoPath = null;
            aSofoPath = XApplication.getContext().getFilesDir() + "/temp";
            aCertPath = aSofoPath + "/SignCert.der";
            aKeyPath = aSofoPath + "/SignPri.key";
            if (XecureSmartCertMgrCopySimple.this.mCertificateNumber != null) {
                try {
                    byte[] aUserCert = null;
                    byte[] aUserKey = null;
                    int aResult = 0;
                    Hashtable aMessageHashtable = new Hashtable();
                    aMessageHashtable = XecureSmartCertMgrCopySimple.this.mKSICRProtocol.import2();
                    XecureSmartCertMgrCopySimple.this.mResultCode = (String)aMessageHashtable.get("CODE");
                    XecureSmartCertMgrCopySimple.this.mResultMessage = (String)aMessageHashtable.get("MESSAGE");
                    if (!XecureSmartCertMgrCopySimple.this.mResultCode.equals("SC201")) {
                        XSLog.d((String)(this.getClass().getName() + "::import2 (Import Cert) Fail [ResultCode : ResultMsg] [" + XecureSmartCertMgrCopySimple.this.mResultCode + " : " + XecureSmartCertMgrCopySimple.this.mResultMessage + "]"));
                        XecureSmartCertMgrCopySimple.this.mHandler.sendMessage(XecureSmartCertMgrCopySimple.this.mHandler.obtainMessage(6));
                        return;
                    }
                    XSLog.d((String)(this.getClass().getName() + "::import2 (Import Cert) Success [ResultCode : ResultMsg] [" + XecureSmartCertMgrCopySimple.this.mResultCode + " : " + XecureSmartCertMgrCopySimple.this.mResultMessage + "]"));
                    aUserCert = (byte[])aMessageHashtable.get("CERT");
                    aUserKey = (byte[])aMessageHashtable.get("KEY");
                    aTempDir = new File(aSofoPath);
                    if (!aTempDir.exists()) {
                        boolean aMkdirResult = false;
                        aMkdirResult = aTempDir.mkdir();
                        XSLog.d((String)(this.getClass().getName() + "::Make directory result : " + aMkdirResult));
                        if (!aMkdirResult) {
                            XecureSmartCertMgrCopySimple.this.mHandler.sendMessage(XecureSmartCertMgrCopySimple.this.mHandler.obtainMessage(5));
                            return;
                        }
                    }
                    aTempUserCert = new File(aSofoPath, "SignCert.der");
                    aTempUserKey = new File(aSofoPath, "SignPri.key");
                    aCert = new FileOutputStream(aTempUserCert);
                    aKey = new FileOutputStream(aTempUserKey);
                    aCert.write(aUserCert);
                    aKey.write(aUserKey);
                    aResult = CertMgr.getInstance().importCert(101, null, null, null, aCertPath, aKeyPath, null, null);
                    XSLog.d((String)(this.getClass().getName() + "::importCert result : " + aResult));
                    if (aResult == -1) {
                        XecureSmartCertMgrCopySimple.this.mHandler.sendMessage(XecureSmartCertMgrCopySimple.this.mHandler.obtainMessage(3));
                    } else {
                        XecureSmartCertMgrCopySimple.this.mHandler.sendMessage(XecureSmartCertMgrCopySimple.this.mHandler.obtainMessage(2));
                    }
                    aTempUserCert.delete();
                    aTempUserKey.delete();
                    aTempDir.delete();
                }
                catch (IOException e) {
                    XSLog.e((String)"Could not write file");
                    XecureSmartCertMgrCopySimple.this.mHandler.sendMessage(XecureSmartCertMgrCopySimple.this.mHandler.obtainMessage(4));
                }
                finally {
                    try {
                        if (aCert != null) {
                            aCert.close();
                        }
                        if (aKey != null) {
                            aKey.close();
                        }
                    }
                    catch (IOException e) {
                        XSLog.e((String)"Could not close file");
                        XecureSmartCertMgrCopySimple.this.mHandler.sendMessage(XecureSmartCertMgrCopySimple.this.mHandler.obtainMessage(4));
                    }
                }
            }
        }
    }
}

