/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.ui.crypto;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import com.softforum.sample.R;
import com.softforum.xecure.crypto.CertMgr;
import com.softforum.xecure.ui.XTopView;
import com.softforum.xecure.ui.crypto.PKCS11Password;
import com.softforum.xecure.ui.crypto.XecureSmartCertMgrUser;
import com.softforum.xecure.util.XCoreUtil;
import com.softforum.xecure.util.XDetailData;

public class XecureSmartVerifyVid
extends Activity {
    public static final int mXecureSmartVerifyVidID = 79000;
    public static final String mMediaIDKey = "xecure_smart_verify_vid_media_id_key";
    public static final String mSelectedCertDataKey = "xecure_smart_verify_vid_data_key";
    private int mMediaID;
    private String mSubjectDN = "";
    private String m_P_assW_ord = "";
    private String mVid = "";
    private XDetailData mSelectedData;
    private XCoreUtil mCoreUtil = new XCoreUtil();

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.crypto_xecure_smart_verify_vid);
        this.mMediaID = this.getIntent().getIntExtra(mMediaIDKey, -1);
        this.mSelectedData = new XDetailData(this.getIntent().getStringArrayExtra(mSelectedCertDataKey), 0);
        if (this.mMediaID == 401) {
            this.findViewById(R.id.password_input_view).setVisibility(8);
        }
        ImageView aIcon = (ImageView)this.findViewById(R.id.icon);
        TextView aMainMsg = (TextView)this.findViewById(R.id.main_msg);
        TextView aSubMsg1 = (TextView)this.findViewById(R.id.sub_msg1);
        TextView aSubMsg2 = (TextView)this.findViewById(R.id.sub_msg2);
        if ("0".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_normal);
        } else if ("1".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_update);
        } else if ("2".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_revoke);
        }
        aMainMsg.setText((CharSequence)this.mSelectedData.getValue(7));
        aSubMsg1.setText((CharSequence)(this.mSelectedData.getValue(4) + " : " + this.mSelectedData.getValue(4)));
        aSubMsg2.setText((CharSequence)(this.mSelectedData.getKeyText(4) + " : " + this.mSelectedData.getValue(6)));
        Button aOKButton = (Button)this.findViewById(R.id.top_right_button);
        aOKButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XecureSmartVerifyVid.this.onOKButtonClick(v);
            }
        });
        TextView aSubjectText = (TextView)this.findViewById(R.id.top_subject_text);
        aSubjectText.setFocusableInTouchMode(true);
    }

    private void onOKButtonClick(View v) {
        CertMgr aCertMgr = CertMgr.getInstance();
        int aErrorCode = 0;
        XTopView aTopView = (XTopView)this.findViewById(R.id.top_view);
        TextView aPasswordTextView = (TextView)this.findViewById(R.id.password_edittext);
        TextView aVidTextView = (TextView)this.findViewById(R.id.vid_edittext);
        this.mSubjectDN = this.mSelectedData.getValue(7);
        this.m_P_assW_ord = aPasswordTextView.getText().toString();
        this.mCoreUtil.resetError();
        if (this.mMediaID != 401) {
            if (this.m_P_assW_ord.length() > 0) {
                if (aCertMgr.verifyPassword(this.mMediaID, 14, this.mSelectedData.getValue(7), this.m_P_assW_ord) != 0 && (aErrorCode = this.mCoreUtil.lastErrCode()) != 22000015) {
                    aTopView.setDescription(this.mCoreUtil.lastErrMsg());
                    aPasswordTextView.setText((CharSequence)"");
                    return;
                }
            } else {
                aTopView.setDescription(this.getString(R.string.plugin_input_nothing));
                return;
            }
        }
        this.mVid = aVidTextView.getText().toString();
        if (this.mVid.length() == 0) {
            aTopView.setDescription(this.getString(R.string.xecure_smart_cert_mgr_copy_wrong_vid));
            return;
        }
        if (this.mMediaID == 401) {
            this.startActivityForResult(new Intent((Context)this, PKCS11Password.class), 90000);
        } else {
            this.returnResult();
        }
    }

    void returnResult() {
        CertMgr aCertMgr = CertMgr.getInstance();
        int error = aCertMgr.verifyCertOwner(this.mMediaID, 14, this.mSubjectDN, this.m_P_assW_ord, this.mVid);
        Intent aIntent = new Intent((Context)this, XecureSmartCertMgrUser.class);
        if (error == 0) {
            aIntent.putExtra("xecure_smart_cert_mgr_result_key", 0);
            this.setResult(-1, aIntent);
            this.finish();
        } else {
            this.setResult(2, aIntent);
        }
        this.finish();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case 90000: {
                if (resultCode == -1) {
                    this.returnResult();
                    break;
                }
                if (resultCode == 100) {
                    this.setResult(resultCode);
                    this.finish();
                    break;
                }
                this.finish();
            }
        }
    }
}

