/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class JsonTreeReader
extends JsonReader {
    private static final Reader a = new Reader(){

        public int read(char[] buffer, int offset, int count) throws IOException {
            throw new AssertionError();
        }

        public void close() throws IOException {
            throw new AssertionError();
        }
    };
    private static final Object b = new Object();
    private final List<Object> c = new ArrayList<Object>();

    public JsonTreeReader(JsonElement element) {
        super(a);
        this.c.add(element);
    }

    public void beginArray() throws IOException {
        this.a(JsonToken.BEGIN_ARRAY);
        JsonArray array = (JsonArray)this.a();
        this.c.add(array.iterator());
    }

    public void endArray() throws IOException {
        this.a(JsonToken.END_ARRAY);
        this.b();
        this.b();
    }

    public void beginObject() throws IOException {
        this.a(JsonToken.BEGIN_OBJECT);
        JsonObject object = (JsonObject)this.a();
        this.c.add(object.entrySet().iterator());
    }

    public void endObject() throws IOException {
        this.a(JsonToken.END_OBJECT);
        this.b();
        this.b();
    }

    public boolean hasNext() throws IOException {
        JsonToken token = this.peek();
        return token != JsonToken.END_OBJECT && token != JsonToken.END_ARRAY;
    }

    public JsonToken peek() throws IOException {
        if (this.c.isEmpty()) {
            return JsonToken.END_DOCUMENT;
        }
        Object o = this.a();
        if (o instanceof Iterator) {
            boolean isObject = this.c.get(this.c.size() - 2) instanceof JsonObject;
            Iterator iterator = (Iterator)o;
            if (iterator.hasNext()) {
                if (isObject) {
                    return JsonToken.NAME;
                }
                this.c.add(iterator.next());
                return this.peek();
            }
            return isObject ? JsonToken.END_OBJECT : JsonToken.END_ARRAY;
        }
        if (o instanceof JsonObject) {
            return JsonToken.BEGIN_OBJECT;
        }
        if (o instanceof JsonArray) {
            return JsonToken.BEGIN_ARRAY;
        }
        if (o instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)o;
            if (primitive.isString()) {
                return JsonToken.STRING;
            }
            if (primitive.isBoolean()) {
                return JsonToken.BOOLEAN;
            }
            if (primitive.isNumber()) {
                return JsonToken.NUMBER;
            }
            throw new AssertionError();
        }
        if (o instanceof JsonNull) {
            return JsonToken.NULL;
        }
        if (o == b) {
            throw new IllegalStateException("JsonReader is closed");
        }
        throw new AssertionError();
    }

    private Object a() {
        return this.c.get(this.c.size() - 1);
    }

    private Object b() {
        return this.c.remove(this.c.size() - 1);
    }

    private void a(JsonToken expected) throws IOException {
        if (this.peek() != expected) {
            throw new IllegalStateException("Expected " + (Object)((Object)expected) + " but was " + (Object)((Object)this.peek()));
        }
    }

    public String nextName() throws IOException {
        this.a(JsonToken.NAME);
        Iterator i = (Iterator)this.a();
        Map.Entry entry = (Map.Entry)i.next();
        this.c.add(entry.getValue());
        return (String)entry.getKey();
    }

    public String nextString() throws IOException {
        JsonToken token = this.peek();
        if (token != JsonToken.STRING && token != JsonToken.NUMBER) {
            throw new IllegalStateException("Expected " + (Object)((Object)JsonToken.STRING) + " but was " + (Object)((Object)token));
        }
        return ((JsonPrimitive)this.b()).getAsString();
    }

    public boolean nextBoolean() throws IOException {
        this.a(JsonToken.BOOLEAN);
        return ((JsonPrimitive)this.b()).getAsBoolean();
    }

    public void nextNull() throws IOException {
        this.a(JsonToken.NULL);
        this.b();
    }

    public double nextDouble() throws IOException {
        JsonToken token = this.peek();
        if (token != JsonToken.NUMBER && token != JsonToken.STRING) {
            throw new IllegalStateException("Expected " + (Object)((Object)JsonToken.NUMBER) + " but was " + (Object)((Object)token));
        }
        double result = ((JsonPrimitive)this.a()).getAsDouble();
        if (!this.isLenient() && (Double.isNaN(result) || Double.isInfinite(result))) {
            throw new NumberFormatException("JSON forbids NaN and infinities: " + result);
        }
        this.b();
        return result;
    }

    public long nextLong() throws IOException {
        JsonToken token = this.peek();
        if (token != JsonToken.NUMBER && token != JsonToken.STRING) {
            throw new IllegalStateException("Expected " + (Object)((Object)JsonToken.NUMBER) + " but was " + (Object)((Object)token));
        }
        long result = ((JsonPrimitive)this.a()).getAsLong();
        this.b();
        return result;
    }

    public int nextInt() throws IOException {
        JsonToken token = this.peek();
        if (token != JsonToken.NUMBER && token != JsonToken.STRING) {
            throw new IllegalStateException("Expected " + (Object)((Object)JsonToken.NUMBER) + " but was " + (Object)((Object)token));
        }
        int result = ((JsonPrimitive)this.a()).getAsInt();
        this.b();
        return result;
    }

    public void close() throws IOException {
        this.c.clear();
        this.c.add(b);
    }

    public void skipValue() throws IOException {
        if (this.peek() == JsonToken.NAME) {
            this.nextName();
        } else {
            this.b();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public void promoteNameToValue() throws IOException {
        this.a(JsonToken.NAME);
        Iterator i = (Iterator)this.a();
        Map.Entry entry = (Map.Entry)i.next();
        this.c.add(entry.getValue());
        this.c.add(new JsonPrimitive((String)entry.getKey()));
    }
}

