/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.stream;

import com.google.gson.internal.JsonReaderInternalAccess;
import com.google.gson.internal.bind.JsonTreeReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.MalformedJsonException;
import com.google.gson.stream.a;
import com.google.gson.stream.b;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;

public class JsonReader
implements Closeable {
    private static final char[] a = ")]}'\n".toCharArray();
    private static final String b = "true";
    private static final String c = "false";
    private final b d = new b();
    private final Reader e;
    private boolean f = false;
    private final char[] g = new char[1024];
    private int h = 0;
    private int i = 0;
    private int j = 1;
    private int k = 1;
    private a[] l = new a[32];
    private int m = 0;
    private JsonToken n;
    private String o;
    private String p;
    private int q;
    private int r;
    private boolean s;

    public JsonReader(Reader in) {
        this.a(com.google.gson.stream.a.f);
        this.s = false;
        if (in == null) {
            throw new NullPointerException("in == null");
        }
        this.e = in;
    }

    public final void setLenient(boolean lenient) {
        this.f = lenient;
    }

    public final boolean isLenient() {
        return this.f;
    }

    public void beginArray() throws IOException {
        this.a(JsonToken.BEGIN_ARRAY);
    }

    public void endArray() throws IOException {
        this.a(JsonToken.END_ARRAY);
    }

    public void beginObject() throws IOException {
        this.a(JsonToken.BEGIN_OBJECT);
    }

    public void endObject() throws IOException {
        this.a(JsonToken.END_OBJECT);
    }

    private void a(JsonToken expected) throws IOException {
        this.peek();
        if (this.n != expected) {
            throw new IllegalStateException("Expected " + (Object)((Object)expected) + " but was " + (Object)((Object)this.peek()) + " at line " + this.e() + " column " + this.f());
        }
        this.b();
    }

    public boolean hasNext() throws IOException {
        this.peek();
        return this.n != JsonToken.END_OBJECT && this.n != JsonToken.END_ARRAY;
    }

    public JsonToken peek() throws IOException {
        if (this.n != null) {
            return this.n;
        }
        switch (this.l[this.m - 1]) {
            case f: {
                if (this.f) {
                    this.a();
                }
                this.l[this.m - 1] = com.google.gson.stream.a.g;
                JsonToken firstToken = this.d();
                if (!this.f && this.n != JsonToken.BEGIN_ARRAY && this.n != JsonToken.BEGIN_OBJECT) {
                    throw new IOException("Expected JSON document to start with '[' or '{' but was " + (Object)((Object)this.n) + " at line " + this.e() + " column " + this.f());
                }
                return firstToken;
            }
            case a: {
                return this.a(true);
            }
            case b: {
                return this.a(false);
            }
            case c: {
                return this.b(true);
            }
            case d: {
                return this.c();
            }
            case e: {
                return this.b(false);
            }
            case g: {
                int c2 = this.c(false);
                if (c2 == -1) {
                    return JsonToken.END_DOCUMENT;
                }
                --this.h;
                if (!this.f) {
                    throw this.b("Expected EOF");
                }
                return this.d();
            }
            case h: {
                throw new IllegalStateException("JsonReader is closed");
            }
        }
        throw new AssertionError();
    }

    private void a() throws IOException {
        this.c(true);
        --this.h;
        if (this.h + a.length > this.i && !this.a(a.length)) {
            return;
        }
        for (int i = 0; i < a.length; ++i) {
            if (this.g[this.h + i] == a[i]) continue;
            return;
        }
        this.h += a.length;
    }

    private JsonToken b() throws IOException {
        this.peek();
        JsonToken result = this.n;
        this.n = null;
        this.p = null;
        this.o = null;
        return result;
    }

    public String nextName() throws IOException {
        this.peek();
        if (this.n != JsonToken.NAME) {
            throw new IllegalStateException("Expected a name but was " + (Object)((Object)this.peek()) + " at line " + this.e() + " column " + this.f());
        }
        String result = this.o;
        this.b();
        return result;
    }

    public String nextString() throws IOException {
        this.peek();
        if (this.n != JsonToken.STRING && this.n != JsonToken.NUMBER) {
            throw new IllegalStateException("Expected a string but was " + (Object)((Object)this.peek()) + " at line " + this.e() + " column " + this.f());
        }
        String result = this.p;
        this.b();
        return result;
    }

    public boolean nextBoolean() throws IOException {
        this.peek();
        if (this.n != JsonToken.BOOLEAN) {
            throw new IllegalStateException("Expected a boolean but was " + (Object)((Object)this.n) + " at line " + this.e() + " column " + this.f());
        }
        boolean result = this.p == b;
        this.b();
        return result;
    }

    public void nextNull() throws IOException {
        this.peek();
        if (this.n != JsonToken.NULL) {
            throw new IllegalStateException("Expected null but was " + (Object)((Object)this.n) + " at line " + this.e() + " column " + this.f());
        }
        this.b();
    }

    public double nextDouble() throws IOException {
        this.peek();
        if (this.n != JsonToken.STRING && this.n != JsonToken.NUMBER) {
            throw new IllegalStateException("Expected a double but was " + (Object)((Object)this.n) + " at line " + this.e() + " column " + this.f());
        }
        double result = Double.parseDouble(this.p);
        if (result >= 1.0 && this.p.startsWith("0")) {
            throw new MalformedJsonException("JSON forbids octal prefixes: " + this.p + " at line " + this.e() + " column " + this.f());
        }
        if (!this.f && (Double.isNaN(result) || Double.isInfinite(result))) {
            throw new MalformedJsonException("JSON forbids NaN and infinities: " + this.p + " at line " + this.e() + " column " + this.f());
        }
        this.b();
        return result;
    }

    public long nextLong() throws IOException {
        long result;
        block4: {
            this.peek();
            if (this.n != JsonToken.STRING && this.n != JsonToken.NUMBER) {
                throw new IllegalStateException("Expected a long but was " + (Object)((Object)this.n) + " at line " + this.e() + " column " + this.f());
            }
            try {
                result = Long.parseLong(this.p);
            }
            catch (NumberFormatException ignored) {
                double asDouble = Double.parseDouble(this.p);
                result = (long)asDouble;
                if ((double)result == asDouble) break block4;
                throw new NumberFormatException("Expected a long but was " + this.p + " at line " + this.e() + " column " + this.f());
            }
        }
        if (result >= 1L && this.p.startsWith("0")) {
            throw new MalformedJsonException("JSON forbids octal prefixes: " + this.p + " at line " + this.e() + " column " + this.f());
        }
        this.b();
        return result;
    }

    public int nextInt() throws IOException {
        int result;
        block4: {
            this.peek();
            if (this.n != JsonToken.STRING && this.n != JsonToken.NUMBER) {
                throw new IllegalStateException("Expected an int but was " + (Object)((Object)this.n) + " at line " + this.e() + " column " + this.f());
            }
            try {
                result = Integer.parseInt(this.p);
            }
            catch (NumberFormatException ignored) {
                double asDouble = Double.parseDouble(this.p);
                result = (int)asDouble;
                if ((double)result == asDouble) break block4;
                throw new NumberFormatException("Expected an int but was " + this.p + " at line " + this.e() + " column " + this.f());
            }
        }
        if ((long)result >= 1L && this.p.startsWith("0")) {
            throw new MalformedJsonException("JSON forbids octal prefixes: " + this.p + " at line " + this.e() + " column " + this.f());
        }
        this.b();
        return result;
    }

    public void close() throws IOException {
        this.p = null;
        this.n = null;
        this.l[0] = com.google.gson.stream.a.h;
        this.m = 1;
        this.e.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void skipValue() throws IOException {
        this.s = true;
        try {
            int count = 0;
            do {
                JsonToken token;
                if ((token = this.b()) == JsonToken.BEGIN_ARRAY || token == JsonToken.BEGIN_OBJECT) {
                    ++count;
                    continue;
                }
                if (token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT) continue;
                --count;
            } while (count != 0);
        }
        finally {
            this.s = false;
        }
    }

    private void a(a newTop) {
        if (this.m == this.l.length) {
            a[] newStack = new a[this.m * 2];
            System.arraycopy(this.l, 0, newStack, 0, this.m);
            this.l = newStack;
        }
        this.l[this.m++] = newTop;
    }

    private JsonToken a(boolean firstElement) throws IOException {
        if (firstElement) {
            this.l[this.m - 1] = com.google.gson.stream.a.b;
        } else {
            switch (this.c(true)) {
                case 93: {
                    --this.m;
                    this.n = JsonToken.END_ARRAY;
                    return this.n;
                }
                case 59: {
                    this.g();
                }
                case 44: {
                    break;
                }
                default: {
                    throw this.b("Unterminated array");
                }
            }
        }
        switch (this.c(true)) {
            case 93: {
                if (firstElement) {
                    --this.m;
                    this.n = JsonToken.END_ARRAY;
                    return this.n;
                }
            }
            case 44: 
            case 59: {
                this.g();
                --this.h;
                this.p = "null";
                this.n = JsonToken.NULL;
                return this.n;
            }
        }
        --this.h;
        return this.d();
    }

    private JsonToken b(boolean firstElement) throws IOException {
        if (firstElement) {
            switch (this.c(true)) {
                case 125: {
                    --this.m;
                    this.n = JsonToken.END_OBJECT;
                    return this.n;
                }
            }
            --this.h;
        } else {
            switch (this.c(true)) {
                case 125: {
                    --this.m;
                    this.n = JsonToken.END_OBJECT;
                    return this.n;
                }
                case 44: 
                case 59: {
                    break;
                }
                default: {
                    throw this.b("Unterminated object");
                }
            }
        }
        int quote = this.c(true);
        switch (quote) {
            case 39: {
                this.g();
            }
            case 34: {
                this.o = this.a((char)quote);
                break;
            }
            default: {
                this.g();
                --this.h;
                this.o = this.d(false);
                if (this.o.length() != 0) break;
                throw this.b("Expected name");
            }
        }
        this.l[this.m - 1] = com.google.gson.stream.a.d;
        this.n = JsonToken.NAME;
        return this.n;
    }

    private JsonToken c() throws IOException {
        switch (this.c(true)) {
            case 58: {
                break;
            }
            case 61: {
                this.g();
                if (this.h >= this.i && !this.a(1) || this.g[this.h] != '>') break;
                ++this.h;
                break;
            }
            default: {
                throw this.b("Expected ':'");
            }
        }
        this.l[this.m - 1] = com.google.gson.stream.a.e;
        return this.d();
    }

    private JsonToken d() throws IOException {
        int c2 = this.c(true);
        switch (c2) {
            case 123: {
                this.a(com.google.gson.stream.a.c);
                this.n = JsonToken.BEGIN_OBJECT;
                return this.n;
            }
            case 91: {
                this.a(com.google.gson.stream.a.a);
                this.n = JsonToken.BEGIN_ARRAY;
                return this.n;
            }
            case 39: {
                this.g();
            }
            case 34: {
                this.p = this.a((char)c2);
                this.n = JsonToken.STRING;
                return this.n;
            }
        }
        --this.h;
        return this.j();
    }

    private boolean a(int minimum) throws IOException {
        int total;
        char[] buffer = this.g;
        int line = this.j;
        int column = this.k;
        int p = this.h;
        for (int i = 0; i < p; ++i) {
            if (buffer[i] == '\n') {
                ++line;
                column = 1;
                continue;
            }
            ++column;
        }
        this.j = line;
        this.k = column;
        if (this.i != this.h) {
            this.i -= this.h;
            System.arraycopy(buffer, this.h, buffer, 0, this.i);
        } else {
            this.i = 0;
        }
        this.h = 0;
        while ((total = this.e.read(buffer, this.i, buffer.length - this.i)) != -1) {
            this.i += total;
            if (this.j == 1 && this.k == 1 && this.i > 0 && buffer[0] == '\ufeff') {
                ++this.h;
                --this.k;
            }
            if (this.i < minimum) continue;
            return true;
        }
        return false;
    }

    private int e() {
        int result = this.j;
        for (int i = 0; i < this.h; ++i) {
            if (this.g[i] != '\n') continue;
            ++result;
        }
        return result;
    }

    private int f() {
        int result = this.k;
        for (int i = 0; i < this.h; ++i) {
            if (this.g[i] == '\n') {
                result = 1;
                continue;
            }
            ++result;
        }
        return result;
    }

    private int c(boolean throwOnEof) throws IOException {
        block14: {
            char c2;
            char[] buffer = this.g;
            int p = this.h;
            int l = this.i;
            block9: while (true) {
                if (p == l) {
                    this.h = p;
                    if (!this.a(1)) break block14;
                    p = this.h;
                    l = this.i;
                }
                c2 = buffer[p++];
                switch (c2) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        continue block9;
                    }
                    case '/': {
                        this.h = p;
                        if (p == l && !this.a(1)) {
                            return c2;
                        }
                        this.g();
                        char peek = buffer[this.h];
                        switch (peek) {
                            case '*': {
                                ++this.h;
                                if (!this.a("*/")) {
                                    throw this.b("Unterminated comment");
                                }
                                p = this.h + 2;
                                l = this.i;
                                continue block9;
                            }
                            case '/': {
                                ++this.h;
                                this.h();
                                p = this.h;
                                l = this.i;
                                continue block9;
                            }
                        }
                        return c2;
                    }
                    case '#': {
                        this.h = p;
                        this.g();
                        this.h();
                        p = this.h;
                        l = this.i;
                        continue block9;
                    }
                }
                break;
            }
            this.h = p;
            return c2;
        }
        if (throwOnEof) {
            throw new EOFException("End of input at line " + this.e() + " column " + this.f());
        }
        return -1;
    }

    private void g() throws IOException {
        if (!this.f) {
            throw this.b("Use JsonReader.setLenient(true) to accept malformed JSON");
        }
    }

    private void h() throws IOException {
        char c2;
        while ((this.h < this.i || this.a(1)) && (c2 = this.g[this.h++]) != '\r' && c2 != '\n') {
        }
    }

    private boolean a(String toFind) throws IOException {
        while (this.h + toFind.length() <= this.i || this.a(toFind.length())) {
            block3: {
                for (int c2 = 0; c2 < toFind.length(); ++c2) {
                    if (this.g[this.h + c2] == toFind.charAt(c2)) {
                        continue;
                    }
                    break block3;
                }
                return true;
            }
            ++this.h;
        }
        return false;
    }

    private String a(char quote) throws IOException {
        char[] buffer = this.g;
        StringBuilder builder = null;
        do {
            int p = this.h;
            int l = this.i;
            int start = p;
            while (p < l) {
                char c2;
                if ((c2 = buffer[p++]) == quote) {
                    this.h = p;
                    if (this.s) {
                        return "skipped!";
                    }
                    if (builder == null) {
                        return this.d.a(buffer, start, p - start - 1);
                    }
                    builder.append(buffer, start, p - start - 1);
                    return builder.toString();
                }
                if (c2 != '\\') continue;
                this.h = p;
                if (builder == null) {
                    builder = new StringBuilder();
                }
                builder.append(buffer, start, p - start - 1);
                builder.append(this.i());
                p = this.h;
                l = this.i;
                start = p;
            }
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append(buffer, start, p - start);
            this.h = p;
        } while (this.a(1));
        throw this.b("Unterminated string");
    }

    private String d(boolean assignOffsetsOnly) throws IOException {
        String result;
        StringBuilder builder = null;
        this.q = -1;
        this.r = 0;
        int i = 0;
        block4: while (true) {
            if (this.h + i < this.i) {
                switch (this.g[this.h + i]) {
                    case '#': 
                    case '/': 
                    case ';': 
                    case '=': 
                    case '\\': {
                        this.g();
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case ',': 
                    case ':': 
                    case '[': 
                    case ']': 
                    case '{': 
                    case '}': {
                        break block4;
                    }
                    default: {
                        ++i;
                        break;
                    }
                }
                continue;
            }
            if (i < this.g.length) {
                if (this.a(i + 1)) continue;
                this.g[this.i] = '\u0000';
                break;
            }
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append(this.g, this.h, i);
            this.r += i;
            this.h += i;
            i = 0;
            if (!this.a(1)) break;
        }
        if (assignOffsetsOnly && builder == null) {
            this.q = this.h;
            result = null;
        } else if (this.s) {
            result = "skipped!";
        } else if (builder == null) {
            result = this.d.a(this.g, this.h, i);
        } else {
            builder.append(this.g, this.h, i);
            result = builder.toString();
        }
        this.r += i;
        this.h += i;
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " near " + this.l();
    }

    private char i() throws IOException {
        if (this.h == this.i && !this.a(1)) {
            throw this.b("Unterminated escape sequence");
        }
        char escaped = this.g[this.h++];
        switch (escaped) {
            case 'u': {
                int i;
                if (this.h + 4 > this.i && !this.a(4)) {
                    throw this.b("Unterminated escape sequence");
                }
                char result = '\u0000';
                int end = i + 4;
                for (i = this.h; i < end; ++i) {
                    char c2 = this.g[i];
                    result = (char)(result << 4);
                    if (c2 >= '0' && c2 <= '9') {
                        result = (char)(result + (c2 - 48));
                        continue;
                    }
                    if (c2 >= 'a' && c2 <= 'f') {
                        result = (char)(result + (c2 - 97 + 10));
                        continue;
                    }
                    if (c2 >= 'A' && c2 <= 'F') {
                        result = (char)(result + (c2 - 65 + 10));
                        continue;
                    }
                    throw new NumberFormatException("\\u" + this.d.a(this.g, this.h, 4));
                }
                this.h += 4;
                return result;
            }
            case 't': {
                return '\t';
            }
            case 'b': {
                return '\b';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
        }
        return escaped;
    }

    private JsonToken j() throws IOException {
        this.p = this.d(true);
        if (this.r == 0) {
            throw this.b("Expected literal value");
        }
        this.n = this.k();
        if (this.n == JsonToken.STRING) {
            this.g();
        }
        return this.n;
    }

    private JsonToken k() throws IOException {
        if (this.q == -1) {
            return JsonToken.STRING;
        }
        if (!(this.r != 4 || 'n' != this.g[this.q] && 'N' != this.g[this.q] || 'u' != this.g[this.q + 1] && 'U' != this.g[this.q + 1] || 'l' != this.g[this.q + 2] && 'L' != this.g[this.q + 2] || 'l' != this.g[this.q + 3] && 'L' != this.g[this.q + 3])) {
            this.p = "null";
            return JsonToken.NULL;
        }
        if (!(this.r != 4 || 't' != this.g[this.q] && 'T' != this.g[this.q] || 'r' != this.g[this.q + 1] && 'R' != this.g[this.q + 1] || 'u' != this.g[this.q + 2] && 'U' != this.g[this.q + 2] || 'e' != this.g[this.q + 3] && 'E' != this.g[this.q + 3])) {
            this.p = b;
            return JsonToken.BOOLEAN;
        }
        if (!(this.r != 5 || 'f' != this.g[this.q] && 'F' != this.g[this.q] || 'a' != this.g[this.q + 1] && 'A' != this.g[this.q + 1] || 'l' != this.g[this.q + 2] && 'L' != this.g[this.q + 2] || 's' != this.g[this.q + 3] && 'S' != this.g[this.q + 3] || 'e' != this.g[this.q + 4] && 'E' != this.g[this.q + 4])) {
            this.p = c;
            return JsonToken.BOOLEAN;
        }
        this.p = this.d.a(this.g, this.q, this.r);
        return this.a(this.g, this.q, this.r);
    }

    private JsonToken a(char[] chars, int offset, int length) {
        int i = offset;
        char c2 = chars[i];
        if (c2 == '-') {
            c2 = chars[++i];
        }
        if (c2 == '0') {
            c2 = chars[++i];
        } else if (c2 >= '1' && c2 <= '9') {
            c2 = chars[++i];
            while (c2 >= '0' && c2 <= '9') {
                c2 = chars[++i];
            }
        } else {
            return JsonToken.STRING;
        }
        if (c2 == '.') {
            c2 = chars[++i];
            while (c2 >= '0' && c2 <= '9') {
                c2 = chars[++i];
            }
        }
        if (c2 == 'e' || c2 == 'E') {
            if ((c2 = chars[++i]) == '+' || c2 == '-') {
                c2 = chars[++i];
            }
            if (c2 >= '0' && c2 <= '9') {
                c2 = chars[++i];
                while (c2 >= '0' && c2 <= '9') {
                    c2 = chars[++i];
                }
            } else {
                return JsonToken.STRING;
            }
        }
        if (i == offset + length) {
            return JsonToken.NUMBER;
        }
        return JsonToken.STRING;
    }

    private IOException b(String message) throws IOException {
        throw new MalformedJsonException(message + " at line " + this.e() + " column " + this.f());
    }

    private CharSequence l() {
        StringBuilder snippet = new StringBuilder();
        int beforePos = Math.min(this.h, 20);
        snippet.append(this.g, this.h - beforePos, beforePos);
        int afterPos = Math.min(this.i - this.h, 20);
        snippet.append(this.g, this.h, afterPos);
        return snippet;
    }

    static {
        JsonReaderInternalAccess.INSTANCE = new JsonReaderInternalAccess(){

            public void promoteNameToValue(JsonReader reader) throws IOException {
                if (reader instanceof JsonTreeReader) {
                    ((JsonTreeReader)reader).promoteNameToValue();
                    return;
                }
                reader.peek();
                if (reader.n != JsonToken.NAME) {
                    throw new IllegalStateException("Expected a name but was " + (Object)((Object)reader.peek()) + " " + " at line " + reader.e() + " column " + reader.f());
                }
                reader.p = reader.o;
                reader.o = null;
                reader.n = JsonToken.STRING;
            }
        };
    }
}

