/*
 * Decompiled with CFR 0.152.
 */
package com.skp.smarttouch.sem.std;

import android.content.Context;
import com.skp.smarttouch.sem.AbstractSEM;
import com.skp.smarttouch.sem.GlobalRepository;
import com.skp.smarttouch.sem.SEManagerConnection;
import com.skp.smarttouch.sem.tools.common.APIResultCode;
import com.skp.smarttouch.sem.tools.common.APITypeCode;
import com.skp.smarttouch.sem.tools.common.STIllegarNopKeyException;
import com.skp.smarttouch.sem.tools.common.STIllegarSmartCardException;
import com.skp.smarttouch.sem.tools.common.STIllegarStateException;
import com.skp.smarttouch.sem.tools.network.AbstractWorker;
import com.skp.smarttouch.sem.tools.network.WorkerPoolExecutor;
import kr.co.skplanet.utils.BinaryUtil;
import kr.co.skplanet.utils.LOG;
import kr.co.skplanet.utils.Util;

public class TransportationWithoutRight
extends AbstractSEM
implements AbstractWorker.OnWorkerListener {
    public static final String COMPONENT_ID = "STD_TWR";
    private static TransportationWithoutRight a = null;
    private final String b = "com.ebcard.skcashbee";
    private static final byte[] c;
    private static final byte[] d;
    public static final int TYPE_OF_TMONEY = 1;
    public static final int TYPE_OF_CACHBEE = 2;
    private static final byte e = 28;
    private static final byte f = 36;

    static {
        byte[] byArray = new byte[7];
        byArray[0] = -44;
        byArray[1] = 16;
        byArray[4] = 3;
        byArray[6] = 1;
        c = byArray;
        byte[] byArray2 = new byte[7];
        byArray2[0] = -44;
        byArray2[1] = 16;
        byArray2[4] = 20;
        byArray2[6] = 1;
        d = byArray2;
    }

    private TransportationWithoutRight(Context context, String compId) {
        super(context, compId);
        LOG.info(">> TransportationWithoutRight()");
        LOG.info("++ context : [%s]", context);
        LOG.info("++ compId : [%s]", compId);
    }

    public static TransportationWithoutRight getInstance(Context context) {
        LOG.info(">> getInstance()");
        LOG.info("++ context : [%s]", context);
        if (a == null) {
            a = new TransportationWithoutRight(context, COMPONENT_ID);
        }
        return a;
    }

    @Override
    public void initialize(String appKey, String stId, SEManagerConnection connection) {
        LOG.info(">> initialize()");
        LOG.info("++ appKey : [%s]", appKey);
        LOG.info("++ stId : [%s]", stId);
        LOG.info("++ connection : [%s]", connection);
        int nState = 0;
        this.setState(nState);
        try {
            LOG.setLogTag("SecureElementManager");
            LOG.setReleaseMode(true);
            if (stId == null || stId.length() < 1) {
                LOG.info(">> initialize 0 - stId[" + stId + "]");
                throw new IllegalArgumentException("***** nopKey is invalid !!");
            }
            this.m_strAppKey = appKey;
            this.m_strNopKey = stId;
            nState = 0;
            this.setState(nState);
            this.m_onSEManagerConnection = connection;
            if (this.m_oGlobalRepository == null) {
                this.m_oGlobalRepository = GlobalRepository.getInstance(this.m_oContext);
            }
            this.m_oGlobalRepository.requestBindWithoutRight(this, this.m_strNopKey, connection);
        }
        catch (IllegalArgumentException e) {
            LOG.error(e);
            LOG.info(">> initialize 1 - stId[" + stId + "]");
            nState = stId == null ? -2 : -99;
            this.setState(nState);
            connection.onServiceDisconnected(this.getCompID(), nState);
        }
        catch (Exception e) {
            LOG.error(e);
            nState = -99;
            this.setState(nState);
            connection.onServiceDisconnected(this.getCompID(), nState);
        }
    }

    @Override
    public void finalize() {
        LOG.info(">> finalize()");
        super.finalize();
    }

    @Override
    public void onTerminateFromWorker(APITypeCode api, APIResultCode result, Object resultData) {
        LOG.info(">> onTerminateFromWorker()");
        LOG.info(new Object[]{"++ api : [%s]", api});
        LOG.info(new Object[]{"++ result : [%s]", result});
        LOG.info("++ resultData : [%s]", resultData);
    }

    @Override
    public void onDispatchFromWorker(APITypeCode api, String status, String message) {
        LOG.info(">> onDispatchFromWorker()");
        LOG.info(new Object[]{"++ api : [%s]", api});
        LOG.info("++ status : [%s]", status);
        LOG.info("++ message : [%s]", message);
    }

    public long getBalance(int type) {
        LOG.info(">> getBalance()");
        LOG.info("++ type : [%s]", type);
        long lBalance = -1L;
        try {
            if (this.m_strNopKey == null || this.m_strNopKey.length() < 1) {
                throw new STIllegarNopKeyException("***** invalid nopkey");
            }
            this.a();
            if (WorkerPoolExecutor.getInstance().isWorking()) {
                throw new Exception("***** smartcard is working");
            }
            switch (type) {
                case 1: {
                    lBalance = this.b();
                    break;
                }
                case 2: {
                    lBalance = this.c();
                    break;
                }
                default: {
                    throw new Exception("[ invalid parameter(type) ]");
                }
            }
        }
        catch (Exception e) {
            LOG.error(e);
        }
        return lBalance;
    }

    private void a() throws Exception {
        LOG.info(">> beforeExecute()");
        if (this.m_oGlobalRepository == null) {
            throw new STIllegarStateException("***** component state is not connected !!");
        }
        this.m_oSmartcard = this.m_oGlobalRepository.getISmartcard();
        if (this.getState() != 50) {
            throw new STIllegarStateException("***** component state is not connected !!");
        }
        if (this.m_oSmartcard == null) {
            throw new STIllegarSmartCardException("***** smartcard is not available !!");
        }
    }

    private long b() {
        LOG.info(">> getTmoneyBalance()");
        long balance = -1L;
        byte[] response = null;
        try {
            try {
                if (this.m_oSmartcard == null) {
                    throw new Exception("[ invalid SmartCard ]");
                }
                if (this.m_oSmartcard.connect() <= 0) {
                    throw new Exception("[ Smartcard connection failed ]");
                }
                byte[] byArray = new byte[4];
                byArray[1] = 112;
                byArray[2] = -128;
                byArray[3] = 3;
                byte[] CH3_CLOSE = byArray;
                this.m_oSmartcard.transmit(CH3_CLOSE);
                response = this.m_oSmartcard.cmdSELECT(COMPONENT_ID, c);
                if (!this.m_oSmartcard.isResponseSuccess(response)) {
                    throw new Exception("[ select failed ]");
                }
                byte[] byArray2 = new byte[5];
                byArray2[0] = -112;
                byArray2[1] = 76;
                byArray2[4] = 4;
                byte[] cmdReadBalanace = byArray2;
                response = this.m_oSmartcard.transmit(cmdReadBalanace);
                if (this.m_oSmartcard.isResponseSuccess(response)) {
                    balance = Util.BytesToIntByBidEndian(response, 0, 4);
                    LOG.info("++ balance : [%s]", balance);
                }
                response = null;
            }
            catch (Exception e) {
                LOG.error(e);
                if (this.m_oSmartcard != null) {
                    this.m_oSmartcard.disconnect();
                }
            }
        }
        finally {
            if (this.m_oSmartcard != null) {
                this.m_oSmartcard.disconnect();
            }
        }
        return balance;
    }

    private long c() {
        LOG.info(">> getCashbeeBalance()");
        long balance = -1L;
        byte[] response = null;
        try {
            try {
                if (this.m_oSmartcard == null) {
                    throw new Exception("[ invalid SmartCard ]");
                }
                if (this.m_oSmartcard.connect() <= 0) {
                    throw new Exception("[ Smartcard connection failed ]");
                }
                byte[] byArray = new byte[4];
                byArray[1] = 112;
                byArray[2] = -128;
                byArray[3] = 3;
                byte[] CH3_CLOSE = byArray;
                this.m_oSmartcard.transmit(CH3_CLOSE);
                response = this.m_oSmartcard.cmdSELECT(COMPONENT_ID, d);
                if (!this.m_oSmartcard.isResponseSuccess(response)) {
                    throw new Exception("[ select failed ]");
                }
                byte[] byArray2 = new byte[5];
                byArray2[0] = -112;
                byArray2[1] = 76;
                byArray2[4] = 4;
                byte[] cmdReadBalanace = byArray2;
                response = this.m_oSmartcard.transmit(cmdReadBalanace);
                if (this.m_oSmartcard.isResponseSuccess(response)) {
                    balance = Util.BytesToIntByBidEndian(response, 0, 4);
                    LOG.info("++ balance : [%s]", balance);
                    LOG.info("++ response : [%s]", BinaryUtil.toHexString(response, 0, response.length));
                }
                response = null;
            }
            catch (Exception e) {
                LOG.error(e);
                if (this.m_oSmartcard != null) {
                    this.m_oSmartcard.disconnect();
                }
            }
        }
        finally {
            if (this.m_oSmartcard != null) {
                this.m_oSmartcard.disconnect();
            }
        }
        return balance;
    }

    private byte[] a(int recodeNumber) {
        LOG.info(">> readRecordTrans()");
        LOG.info("++ recodeNumber : [%s]", recodeNumber);
        byte[] response = null;
        try {
            try {
                if (this.m_oSmartcard == null) {
                    throw new Exception("[ invalid SmartCard ]");
                }
                if (this.m_oSmartcard.connect() <= 0) {
                    throw new Exception("[ Smartcard connection failed ]");
                }
                response = this.m_oSmartcard.cmdSELECT(COMPONENT_ID, c);
                if (!this.m_oSmartcard.isResponseSuccess(response)) {
                    throw new Exception("[ select failed ]");
                }
                byte[] byArray = new byte[5];
                byArray[1] = -78;
                byArray[2] = (byte)recodeNumber;
                byArray[3] = 28;
                byArray[4] = 26;
                byte[] cmdReadBalanace = byArray;
                response = this.m_oSmartcard.transmit(cmdReadBalanace);
                if (!this.m_oSmartcard.isResponseSuccess(response)) {
                    throw new Exception("[ select failed ]");
                }
            }
            catch (Exception e) {
                LOG.error(e);
                if (this.m_oSmartcard != null) {
                    this.m_oSmartcard.disconnect();
                }
            }
        }
        finally {
            if (this.m_oSmartcard != null) {
                this.m_oSmartcard.disconnect();
            }
        }
        return response;
    }

    public byte[] readRecordPurse(int recodeNumber) {
        LOG.info(">> readRecordPurse()");
        LOG.info("++ recodeNumber : [%s]", recodeNumber);
        byte[] response = null;
        try {
            try {
                if (this.m_oSmartcard == null) {
                    throw new Exception("[ invalid SmartCard ]");
                }
                if (this.m_oSmartcard.connect() <= 0) {
                    throw new Exception("[ Smartcard connection failed ]");
                }
                response = this.m_oSmartcard.cmdSELECT(COMPONENT_ID, c);
                if (!this.m_oSmartcard.isResponseSuccess(response)) {
                    throw new Exception("[ select failed ]");
                }
                byte[] byArray = new byte[5];
                byArray[1] = -78;
                byArray[2] = (byte)recodeNumber;
                byArray[3] = 36;
                byArray[4] = 26;
                byte[] cmdReadBalanace = byArray;
                response = this.m_oSmartcard.transmit(cmdReadBalanace);
                if (!this.m_oSmartcard.isResponseSuccess(response)) {
                    throw new Exception("[ select failed ]");
                }
            }
            catch (Exception e) {
                LOG.error(e);
                if (this.m_oSmartcard != null) {
                    this.m_oSmartcard.disconnect();
                }
            }
        }
        finally {
            if (this.m_oSmartcard != null) {
                this.m_oSmartcard.disconnect();
            }
        }
        return response;
    }
}

