/*
 * Decompiled with CFR 0.152.
 */
package com.skp.smarttouch.sem.tools.network.ota;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.skp.smarttouch.sem.tools.common.OpCodeEnum;
import com.skp.smarttouch.sem.tools.dao.protocol.ota.BodyOfOta;
import com.skp.smarttouch.sem.tools.dao.protocol.ota.HeaderOfOta;
import com.skp.smarttouch.sem.tools.dao.protocol.ota.IOTAProtocol;
import com.skp.smarttouch.sem.tools.dao.protocol.ota.JobTitle;
import com.skp.smarttouch.sem.tools.dao.protocol.ota.OTAWorkerData;
import com.skp.smarttouch.sem.tools.dao.protocol.ota.OtaBody;
import com.skp.smarttouch.sem.tools.dao.protocol.ota.OtaHeader;
import com.skp.smarttouch.sem.tools.dao.protocol.ota.Rpdu;
import java.security.SignatureException;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kr.co.skplanet.utils.BinaryUtil;
import kr.co.skplanet.utils.LOG;
import kr.co.skplanet.utils.Telephone;

public class RequestBuilder {
    private static final String a = "BFC0C5B8C7C1B6F4BDC3";
    private static final String b = "EMUL";
    private static final String c = "PHONE";
    protected static final String MSG_TYPE_INITIATE = "1";
    protected static final String MSG_TYPE_REQUEST = "2";
    protected static final String MSG_TYPE_RESPONSE = "3";
    protected static final String MSG_TYPE_END = "4";
    private Context d = null;

    public RequestBuilder(Context context) {
        this.d = context;
    }

    public IOTAProtocol.Request buildInitiate(String seqNum, OTAWorkerData data) {
        LOG.info(">> buildInitiate()");
        IOTAProtocol.Request request = new IOTAProtocol.Request();
        HeaderOfOta header = new HeaderOfOta();
        BodyOfOta body = new BodyOfOta();
        OtaHeader otaHeader = new OtaHeader();
        OtaBody otaBody = new OtaBody();
        if (Telephone.isEmulator()) {
            header.setClientType(b);
        } else {
            header.setClientType(c);
        }
        header.setClientId(Telephone.getMdn(this.d));
        header.setPackageName(this.a());
        header.setComponentId(data.getCompId());
        header.setNopId(data.getNopId());
        otaHeader.setMsgType(MSG_TYPE_INITIATE);
        otaHeader.setIccid(data.getIccid());
        JobTitle jopTitle = new JobTitle();
        jopTitle.setInstanceAid(data.getInstanceAid());
        jopTitle.setAppletVersion(data.getAppletVersion());
        jopTitle.setOpCode(data.getOpCode().getCode());
        otaHeader.setJobTitle(jopTitle);
        otaHeader.setSeqNum(seqNum);
        if (OpCodeEnum.INSTALL.equals((Object)data.getOpCode()) || OpCodeEnum.DELETE.equals((Object)data.getOpCode()) || OpCodeEnum.LOCK.equals((Object)data.getOpCode()) || OpCodeEnum.UNLOCK.equals((Object)data.getOpCode()) || OpCodeEnum.ENABLE.equals((Object)data.getOpCode()) || OpCodeEnum.BLOCKING.equals((Object)data.getOpCode()) || OpCodeEnum.SETPPSE.equals((Object)data.getOpCode()) || OpCodeEnum.LOCKTRANS.equals((Object)data.getOpCode())) {
            otaHeader.setAccessToken(this.a(data.getTid(), a));
        } else if (OpCodeEnum.SETCONFIGDF.equals((Object)data.getOpCode())) {
            otaHeader.setAccessToken(this.a(data.getTid(), a));
            otaBody.setParamData(data.getParamData());
        } else {
            otaBody.setIssueType(data.getIssueType());
            otaBody.setIssueDel(data.getIssueDel());
            otaBody.setIssueData(data.getIssueData());
        }
        body.setTid(data.getTid());
        body.setOtaHeader(otaHeader);
        body.setOtaBody(otaBody);
        request.setHeader(header);
        request.setBody(body);
        return request;
    }

    public IOTAProtocol.Request buildRequest(String seqNum, String resultCode, String resultMsg, List<Rpdu> listRpdu, OTAWorkerData data) {
        return this.buildResponse(seqNum, resultCode, resultMsg, listRpdu, data);
    }

    public IOTAProtocol.Request buildResponse(String seqNum, String resultCode, String resultMsg, List<Rpdu> listRpdu, OTAWorkerData data) {
        IOTAProtocol.Request request = new IOTAProtocol.Request();
        HeaderOfOta header = new HeaderOfOta();
        BodyOfOta body = new BodyOfOta();
        OtaHeader otaHeader = new OtaHeader();
        OtaBody otaBody = new OtaBody();
        if (Telephone.isEmulator()) {
            header.setClientType(b);
        } else {
            header.setClientType(c);
        }
        header.setClientId(Telephone.getMdn(this.d));
        header.setPackageName(this.a());
        header.setComponentId(data.getCompId());
        header.setNopId(data.getNopId());
        header.setResultCode(resultCode);
        header.setResultMsg(resultMsg);
        otaHeader.setMsgType(MSG_TYPE_RESPONSE);
        otaHeader.setSeqNum(seqNum);
        otaBody.setRpduList(listRpdu);
        if (!(OpCodeEnum.INSTALL.equals((Object)data.getOpCode()) || OpCodeEnum.DELETE.equals((Object)data.getOpCode()) || OpCodeEnum.LOCK.equals((Object)data.getOpCode()) || OpCodeEnum.UNLOCK.equals((Object)data.getOpCode()) || OpCodeEnum.ENABLE.equals((Object)data.getOpCode()))) {
            if (OpCodeEnum.SETCONFIGDF.equals((Object)data.getOpCode())) {
                otaBody.setParamData(data.getParamData());
            } else {
                otaBody.setIssueType(data.getIssueType());
                otaBody.setIssueDel(data.getIssueDel());
                otaBody.setIssueData(data.getIssueData());
            }
        }
        body.setTid(data.getTid());
        body.setOtaHeader(otaHeader);
        body.setOtaBody(otaBody);
        request.setHeader(header);
        request.setBody(body);
        return request;
    }

    public IOTAProtocol.Request buildEnd(String seqNum, String resultCode, String resultMsg, List<Rpdu> listRpdu, OTAWorkerData data) {
        return this.buildResponse(seqNum, resultCode, resultMsg, listRpdu, data);
    }

    private String a(String data, String key) {
        LOG.info(">> makeAccessToken()");
        LOG.info("++ data : [%s]", data);
        LOG.info("++ key : [%s]", key);
        String accessToken = null;
        byte[] baAccessToken = null;
        try {
            data = data.replace("-", "");
            if (data.length() > 20) {
                data = data.substring(data.length() - 20);
                LOG.info("++ data : [%s]", data);
            }
            baAccessToken = this.b(data, key);
            accessToken = BinaryUtil.toHexString(baAccessToken);
        }
        catch (Exception e) {
            LOG.error(e);
        }
        return accessToken;
    }

    private byte[] b(String data, String key) throws SignatureException {
        byte[] rawHmac = null;
        try {
            SecretKeySpec signingKey = new SecretKeySpec(BinaryUtil.parseHexString(key), "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(signingKey);
            rawHmac = mac.doFinal(BinaryUtil.parseHexString(data));
        }
        catch (Exception e) {
            throw new SignatureException(e.getMessage());
        }
        return rawHmac;
    }

    private String a() {
        LOG.info(">> getPackageName()");
        PackageManager pm = null;
        PackageInfo info = null;
        try {
            pm = this.d.getPackageManager();
            info = pm.getPackageInfo(this.d.getPackageName(), 0);
        }
        catch (Exception e) {
            LOG.error(e);
        }
        return info.packageName;
    }
}

