/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecurekeypad;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.softforum.xecurekeypad.XKCoreWrapper;
import com.softforum.xecurekeypad.XKEditText;
import com.softforum.xecurekeypad.XKKeyButton;
import com.softforum.xecurekeypad.XKKeypadInterface;
import com.softforum.xecurekeypad.XKKeypadResources;
import com.softforum.xecurekeypad.XKKeypadTopLayout;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;

public class XKNumberKeypad {
    private final int NUMBER_KEYPAD_KEY_COUNT = 10;
    private final int NUMBER_KEYPAD_BLANK_COUNT = 2;
    private final int NUMBER_KEYPAD_FUNCTION_KEY_COUNT = 3;
    private int mXKViewType = 0;
    private int mKeypadRowCount = 0;
    private int mKeypadColumnCount = 0;
    private int[] mXKKeypadIndex = null;
    private int mXKKeypadHeight = 0;
    private int mXKKeyWidth = 0;
    private int mXKKeyHeight = 0;
    private int mXKKeyWidthMargin = 0;
    private int mXKKeyHeightMargin = 0;
    private String[] mXKKeypadIndexText = null;
    private ImageView mInputImageView = null;
    private Drawable mXKBlankLogoImage = null;
    private XKEditText mXKEditText = null;
    private XKCoreWrapper mXKCoreWrapper = null;
    private XKKeypadResources mXKKeypadResources = null;
    private XKKeypadInterface mXKKeypadInterface = null;
    private XKKeypadTopLayout mXKKeypadTopLayout = null;
    private Timer mInputKeyTimer = null;
    private EditText mDummyEditText = null;
    private StringBuffer mDummyBuffer = new StringBuffer();
    private ArrayList<LinearLayout> mKeypadLayoutList = null;
    private ArrayList<XKKeyButton> mXKKeyList = null;
    private XKKeyButton mDeleteButton = null;
    private XKKeyButton mRefreshButton = null;
    private XKKeyButton mCompleteButton = null;
    private Context mContext = null;
    private Activity mActivity = null;

    public XKNumberKeypad(Context pContext) {
        this.mContext = pContext;
        this.mActivity = (Activity)this.mContext;
    }

    public void initKeypad() {
        int aRowCount = 0;
        ImageButton aCancelButton = null;
        LinearLayout aKeypadRowLayout = null;
        RelativeLayout.LayoutParams aRowLayoutParams = null;
        this.mXKViewType = this.mXKEditText.getKeypadViewType();
        this.mXKKeypadResources = new XKKeypadResources(this.mActivity);
        this.mXKKeypadInterface = new XKKeypadInterface(this.mXKEditText, this.mXKCoreWrapper);
        this.mXKKeypadInterface.clearIndex();
        this.mXKKeypadTopLayout = (XKKeypadTopLayout)this.mActivity.findViewById(this.mActivity.getResources().getIdentifier("xk_keypad_top_layout", "id", this.mActivity.getPackageName()));
        if (this.mXKKeypadTopLayout != null) {
            this.mInputImageView = this.mXKKeypadTopLayout.getInputImageView();
            this.mInputImageView.setImageResource(this.mXKKeypadResources.getClickedSpaceImageID());
        }
        if (this.mXKViewType == 1 && (aCancelButton = (ImageButton)this.mActivity.findViewById(this.mActivity.getResources().getIdentifier("cancel_button", "id", this.mActivity.getPackageName()))) != null) {
            aCancelButton.setContentDescription((CharSequence)"\ub2eb\uae30");
            aCancelButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    XKNumberKeypad.this.inputCancel();
                }
            });
        }
        this.mKeypadLayoutList = new ArrayList();
        this.mKeypadRowCount = 2;
        this.mKeypadColumnCount = 12 / this.mKeypadRowCount;
        ++this.mKeypadRowCount;
        this.initKeypadButton();
        aRowCount = 0;
        while (aRowCount < this.mKeypadRowCount) {
            aKeypadRowLayout = new LinearLayout(this.mContext);
            aRowLayoutParams = new RelativeLayout.LayoutParams(-1, -2);
            if (aRowCount != 0) {
                aRowLayoutParams.addRule(3, this.mKeypadLayoutList.get(aRowCount - 1).getId());
            }
            aRowLayoutParams.topMargin = this.mXKKeyHeightMargin;
            aKeypadRowLayout.setId(aRowLayoutParams.hashCode());
            aKeypadRowLayout.setLayoutParams((ViewGroup.LayoutParams)aRowLayoutParams);
            if (aRowCount == this.mKeypadRowCount - 1) {
                aKeypadRowLayout.setPadding(this.mXKKeyWidthMargin, 0, this.mXKKeyWidthMargin, this.mXKKeyHeightMargin);
            } else {
                aKeypadRowLayout.setPadding(this.mXKKeyWidthMargin, 0, this.mXKKeyWidthMargin, 0);
            }
            this.mKeypadLayoutList.add(aKeypadRowLayout);
            ++aRowCount;
        }
    }

    private void initKeypadButton() {
        int aDeviceHeight = 0;
        int aDeviceWidth = 0;
        int aHeightPercent = 0;
        int aXKKeypadHeight = 0;
        int aXKKeypadWidth = 0;
        float aWidthMarginPercent = 0.0f;
        float aHeightMarginPercent = 0.0f;
        DisplayMetrics aDisplayMetrics = null;
        int aTotalKeySize = 0;
        int aKeyCount = 0;
        LinearLayout.LayoutParams aKeyButtonLayoutParams = null;
        LinearLayout.LayoutParams aFunctionKeyButtonLayoutParams = null;
        XKKeyButton aXKKeyButton = null;
        aWidthMarginPercent = 1.5f;
        aHeightMarginPercent = 1.0f;
        aHeightPercent = 30;
        aDisplayMetrics = new DisplayMetrics();
        this.mActivity.getWindowManager().getDefaultDisplay().getMetrics(aDisplayMetrics);
        aDeviceWidth = aDisplayMetrics.widthPixels;
        aDeviceHeight = aDisplayMetrics.heightPixels;
        this.mXKKeyWidthMargin = (int)((float)aDeviceWidth * aWidthMarginPercent) / 100;
        this.mXKKeyHeightMargin = (int)((float)aDeviceHeight * aHeightMarginPercent) / 100;
        this.mXKKeypadHeight = aXKKeypadHeight = aDeviceHeight * aHeightPercent / 100;
        this.mXKKeyHeight = (aXKKeypadHeight -= (this.mKeypadRowCount + 1) * this.mXKKeyHeightMargin) / this.mKeypadRowCount;
        aXKKeypadWidth = aDeviceWidth - (this.mKeypadColumnCount + 1) * this.mXKKeyWidthMargin;
        this.mXKKeyWidth = aXKKeypadWidth / this.mKeypadColumnCount;
        this.mXKKeyList = new ArrayList();
        aFunctionKeyButtonLayoutParams = new LinearLayout.LayoutParams(-2, this.mXKKeyHeight);
        aFunctionKeyButtonLayoutParams.weight = 1.0f;
        aFunctionKeyButtonLayoutParams.gravity = 17;
        this.mRefreshButton = new XKKeyButton(this.mContext);
        this.mDeleteButton = new XKKeyButton(this.mContext);
        this.mCompleteButton = new XKKeyButton(this.mContext);
        aFunctionKeyButtonLayoutParams.rightMargin = this.mXKKeyWidthMargin;
        this.mRefreshButton.setLayoutParams((ViewGroup.LayoutParams)aFunctionKeyButtonLayoutParams);
        this.mDeleteButton.setLayoutParams((ViewGroup.LayoutParams)aFunctionKeyButtonLayoutParams);
        aFunctionKeyButtonLayoutParams = new LinearLayout.LayoutParams(-2, this.mXKKeyHeight);
        aFunctionKeyButtonLayoutParams.weight = 1.0f;
        aFunctionKeyButtonLayoutParams.gravity = 17;
        aFunctionKeyButtonLayoutParams.rightMargin = 0;
        this.mCompleteButton.setLayoutParams((ViewGroup.LayoutParams)aFunctionKeyButtonLayoutParams);
        aTotalKeySize = 12;
        aKeyCount = 0;
        while (aKeyCount < aTotalKeySize) {
            aKeyButtonLayoutParams = new LinearLayout.LayoutParams(-2, this.mXKKeyHeight);
            aKeyButtonLayoutParams.weight = 1.0f;
            aKeyButtonLayoutParams.gravity = 17;
            aKeyButtonLayoutParams.leftMargin = aKeyCount % this.mKeypadColumnCount == 0 ? 0 : this.mXKKeyWidthMargin;
            aXKKeyButton = new XKKeyButton(this.mContext);
            aXKKeyButton.initKeyButton();
            aXKKeyButton.setLayoutParams((ViewGroup.LayoutParams)aKeyButtonLayoutParams);
            this.mXKKeyList.add(aXKKeyButton);
            ++aKeyCount;
        }
    }

    public void setXKKeypad() {
        int aRowCount = 0;
        int aIndexCount = 0;
        String aE2EURL = null;
        LinearLayout aKeypadRowLayout = null;
        aE2EURL = this.mXKEditText.getE2EURL();
        if (aE2EURL != null) {
            this.mXKKeypadTopLayout.refreshSessionTimer(this.mXKCoreWrapper.getE2ESessionTime());
        }
        while (aIndexCount < 12) {
            aKeypadRowLayout = this.mKeypadLayoutList.get(aRowCount);
            aKeypadRowLayout.addView((View)this.mXKKeyList.get(aIndexCount));
            if (++aIndexCount % this.mKeypadColumnCount != 0) continue;
            ++aRowCount;
        }
        aKeypadRowLayout = this.mKeypadLayoutList.get(this.mKeypadRowCount - 1);
        aKeypadRowLayout.addView((View)this.mRefreshButton);
        aKeypadRowLayout.addView((View)this.mDeleteButton);
        aKeypadRowLayout.addView((View)this.mCompleteButton);
    }

    private void setKeyIndex(int[] pKeyIndex) {
        int aKeyCount = 0;
        int aRealIndex = 0;
        int aIndex = 0;
        int[] aNumberBlankIndex = null;
        aNumberBlankIndex = new int[2];
        aKeyCount = 0;
        while (aKeyCount < this.mXKKeyList.size()) {
            this.mXKKeyList.get(aKeyCount).initKeyButton();
            ++aKeyCount;
        }
        this.mXKKeypadInterface.initRandom();
        aNumberBlankIndex[0] = this.mXKKeypadInterface.getRandom(0, 5);
        aNumberBlankIndex[1] = this.mXKKeypadInterface.getRandom(6, 11);
        aKeyCount = 0;
        while (aKeyCount < 12) {
            if (this.isBlankIndex(aNumberBlankIndex, 2, aKeyCount)) {
                aIndex = -1;
            } else {
                aIndex = pKeyIndex[aRealIndex];
                ++aRealIndex;
            }
            this.mXKKeyList.get(aKeyCount).setIndex(aIndex);
            ++aKeyCount;
        }
    }

    private boolean isBlankIndex(int[] aBlankIndexArray, int aArrayLength, int aValue) {
        boolean aIsBlank = false;
        int aBlankIndexCount = 0;
        aBlankIndexCount = 0;
        while (aBlankIndexCount < aArrayLength) {
            if (aBlankIndexArray[aBlankIndexCount] == aValue) {
                aIsBlank = true;
                break;
            }
            ++aBlankIndexCount;
        }
        return aIsBlank;
    }

    public void setXKKeypadButtonImage() {
        int aIndexCount = 0;
        int aRealIndex = 0;
        boolean aUseInputButton = false;
        int[] aNumberImagesIDs = null;
        int[] aClickedNumberImageIDs = null;
        int aFunctionButtonWidth = 0;
        int aDeviceWidth = 0;
        DisplayMetrics aDisplayMetrics = null;
        Drawable aNumberButtonDrawable = null;
        Drawable aBlankDrawable = null;
        Drawable aFunctionButtonDrawable = null;
        aUseInputButton = this.mXKEditText.getUseInputButton();
        if (this.mXKViewType == 1 && aUseInputButton) {
            this.setButtonLayout();
        }
        aNumberImagesIDs = this.mXKKeypadResources.getNumberImageIDs();
        aClickedNumberImageIDs = this.mXKKeypadResources.getClickedNumberImageIDs();
        aIndexCount = 0;
        while (aIndexCount < 12) {
            if (this.mXKKeyList.get(aIndexCount).getIndex() == -1) {
                aBlankDrawable = this.mXKBlankLogoImage != null ? this.mXKBlankLogoImage : this.resizeBackgroundImage(this.mXKKeypadResources.getNumberBlankImageID(), this.mXKKeyWidth, this.mXKKeyHeight);
                if (aBlankDrawable == null) {
                    this.mXKKeyList.get(aIndexCount).setWidth(this.mXKKeyWidth);
                    this.mXKKeyList.get(aIndexCount).setHeight(this.mXKKeyHeight);
                }
                this.mXKKeyList.get(aIndexCount).setBackgroundDrawable(aBlankDrawable);
                this.mXKKeyList.get(aIndexCount).setContentDescription(null);
            } else {
                aNumberButtonDrawable = this.resizeBackgroundImage(aNumberImagesIDs[aRealIndex], this.mXKKeyWidth, this.mXKKeyHeight);
                this.mXKKeyList.get(aIndexCount).setBackgroundDrawable(aNumberButtonDrawable);
                this.mXKKeyList.get(aIndexCount).setClickedImageID(aClickedNumberImageIDs[aRealIndex]);
                this.mXKKeyList.get(aIndexCount).setContentDescription(this.mXKKeypadIndexText[aRealIndex]);
                ++aRealIndex;
            }
            ++aIndexCount;
        }
        aDisplayMetrics = new DisplayMetrics();
        this.mActivity.getWindowManager().getDefaultDisplay().getMetrics(aDisplayMetrics);
        aDeviceWidth = aDisplayMetrics.widthPixels;
        aFunctionButtonWidth = aDeviceWidth / 3;
        aFunctionButtonDrawable = this.resizeBackgroundImage(this.mXKKeypadResources.getNumberRefreshImageID(), aFunctionButtonWidth, this.mXKKeyHeight);
        this.mRefreshButton.setBackgroundDrawable(aFunctionButtonDrawable);
        this.mRefreshButton.setContentDescription("\ub9ac\ud504\ub808\uc26c");
        aFunctionButtonDrawable = this.resizeBackgroundImage(this.mXKKeypadResources.getNumberDeleteImageID(), aFunctionButtonWidth, this.mXKKeyHeight);
        this.mDeleteButton.setBackgroundDrawable(aFunctionButtonDrawable);
        this.mDeleteButton.setContentDescription("\ubc31\uc2a4\ud398\uc774\uc2a4");
        aFunctionButtonDrawable = this.resizeBackgroundImage(this.mXKKeypadResources.getNumberCloseImageID(), aFunctionButtonWidth, this.mXKKeyHeight);
        this.mCompleteButton.setBackgroundDrawable(aFunctionButtonDrawable);
        this.mCompleteButton.setContentDescription("\uc5d4\ud130");
        this.setClickedEvent();
    }

    private void setButtonLayout() {
        View aBeforeLayout = null;
        Button aInputCompleteButton = null;
        Button aInputCancelButton = null;
        Configuration aConfiguration = null;
        LinearLayout aEditTextButtonLayout = null;
        LinearLayout aEditTextLayout = null;
        LinearLayout aInputButtonLayout = null;
        LinearLayout.LayoutParams aEditTextLayoutParams = null;
        LinearLayout.LayoutParams aInputButtonLayoutParams = null;
        LinearLayout.LayoutParams aButtonLayoutParams = null;
        aConfiguration = this.mActivity.getResources().getConfiguration();
        aEditTextButtonLayout = (LinearLayout)this.mActivity.findViewById(this.mActivity.getResources().getIdentifier("edittext_button_layout", "id", this.mActivity.getPackageName()));
        aBeforeLayout = aEditTextButtonLayout.findViewWithTag((Object)"input_button_layout");
        if (aBeforeLayout != null) {
            aEditTextButtonLayout.removeView(aBeforeLayout);
        }
        aEditTextLayout = (LinearLayout)this.mActivity.findViewById(this.mActivity.getResources().getIdentifier("edittext_layout", "id", this.mActivity.getPackageName()));
        aEditTextLayoutParams = (LinearLayout.LayoutParams)aEditTextLayout.getLayoutParams();
        aInputButtonLayout = new LinearLayout((Context)this.mActivity);
        aInputButtonLayout.setOrientation(0);
        aInputCompleteButton = new Button((Context)this.mActivity);
        aInputCancelButton = new Button((Context)this.mActivity);
        aInputCompleteButton.setTag((Object)"input_complete_button");
        aInputCancelButton.setTag((Object)"input_cancel_button");
        if (aConfiguration.orientation == 2) {
            aEditTextButtonLayout.setOrientation(0);
            aEditTextLayoutParams.width = 0;
            aEditTextLayoutParams.weight = 5.0f;
            aEditTextLayout.setLayoutParams((ViewGroup.LayoutParams)aEditTextLayoutParams);
            aInputButtonLayoutParams = new LinearLayout.LayoutParams(0, aEditTextLayoutParams.height, 2.0f);
            aInputButtonLayoutParams.rightMargin = aEditTextLayoutParams.rightMargin;
            aInputButtonLayout.setLayoutParams((ViewGroup.LayoutParams)aInputButtonLayoutParams);
            aInputButtonLayout.setGravity(17);
            aButtonLayoutParams = new LinearLayout.LayoutParams(0, -2, 1.0f);
            aInputCompleteButton.setLayoutParams((ViewGroup.LayoutParams)aButtonLayoutParams);
            aButtonLayoutParams = new LinearLayout.LayoutParams(0, -2, 1.0f);
            aButtonLayoutParams.leftMargin = (int)(5.0f * this.mActivity.getResources().getDisplayMetrics().density);
            aInputCancelButton.setLayoutParams((ViewGroup.LayoutParams)aButtonLayoutParams);
            aInputButtonLayout.addView((View)aInputCompleteButton);
            aInputButtonLayout.addView((View)aInputCancelButton);
        } else if (aConfiguration.orientation == 1) {
            aEditTextButtonLayout.setOrientation(1);
            aEditTextLayoutParams.width = -1;
            aEditTextLayoutParams.weight = 0.0f;
            aEditTextLayout.setLayoutParams((ViewGroup.LayoutParams)aEditTextLayoutParams);
            aInputButtonLayoutParams = new LinearLayout.LayoutParams(-1, aEditTextLayoutParams.height);
            aInputButtonLayoutParams.leftMargin = aEditTextLayoutParams.leftMargin;
            aInputButtonLayoutParams.rightMargin = aEditTextLayoutParams.rightMargin;
            aInputButtonLayoutParams.topMargin = (int)(20.0f * this.mActivity.getResources().getDisplayMetrics().density);
            aInputButtonLayout.setLayoutParams((ViewGroup.LayoutParams)aInputButtonLayoutParams);
            aInputButtonLayout.setGravity(5);
            aButtonLayoutParams = new LinearLayout.LayoutParams(-2, -2);
            aInputCompleteButton.setLayoutParams((ViewGroup.LayoutParams)aButtonLayoutParams);
            aButtonLayoutParams = new LinearLayout.LayoutParams(-2, -2);
            aButtonLayoutParams.leftMargin = (int)(5.0f * this.mActivity.getResources().getDisplayMetrics().density);
            aInputCancelButton.setLayoutParams((ViewGroup.LayoutParams)aButtonLayoutParams);
            aInputButtonLayout.addView((View)aInputCompleteButton);
            aInputButtonLayout.addView((View)aInputCancelButton);
        }
        aInputButtonLayout.setTag((Object)"input_button_layout");
        aEditTextButtonLayout.addView((View)aInputButtonLayout);
        this.setButtonImage(aInputCompleteButton, aInputCancelButton);
    }

    private void setButtonImage(Button pInputCompleteButton, Button pInputCancelButton) {
        int aButtonWidth = 0;
        int aButtonHeight = 0;
        int aDeviceWidth = 0;
        DisplayMetrics aDisplayMetrics = null;
        Drawable aInputCompleteDrawable = null;
        Drawable aInputCancelDrawable = null;
        Configuration aConfiguration = null;
        LinearLayout aEditTextLayout = null;
        LinearLayout.LayoutParams aEditTextLayoutParams = null;
        LinearLayout.LayoutParams aButtonLayoutParams = null;
        aEditTextLayout = (LinearLayout)this.mActivity.findViewById(this.mActivity.getResources().getIdentifier("edittext_layout", "id", this.mActivity.getPackageName()));
        aEditTextLayoutParams = (LinearLayout.LayoutParams)aEditTextLayout.getLayoutParams();
        aButtonHeight = aEditTextLayoutParams.height;
        aConfiguration = this.mActivity.getResources().getConfiguration();
        if (aConfiguration.orientation == 2) {
            aButtonLayoutParams = (LinearLayout.LayoutParams)pInputCancelButton.getLayoutParams();
            aDisplayMetrics = new DisplayMetrics();
            this.mActivity.getWindowManager().getDefaultDisplay().getMetrics(aDisplayMetrics);
            aDeviceWidth = aDisplayMetrics.widthPixels;
            aButtonWidth = aDeviceWidth * 2 / 7;
            aButtonWidth = aButtonWidth - aEditTextLayoutParams.leftMargin - aEditTextLayoutParams.rightMargin * 2 - aButtonLayoutParams.leftMargin;
            aButtonWidth /= 2;
        } else if (aConfiguration.orientation == 1) {
            aButtonWidth = (int)(100.0f * this.mActivity.getResources().getDisplayMetrics().density);
            aButtonHeight = aEditTextLayoutParams.height;
        }
        aInputCompleteDrawable = this.resizeBackgroundImage(this.mActivity.getResources().getIdentifier("fullview_ok", "drawable", this.mActivity.getPackageName()), aButtonWidth, aButtonHeight);
        if (aInputCompleteDrawable != null) {
            pInputCompleteButton.setBackgroundDrawable(aInputCompleteDrawable);
            pInputCompleteButton.setVisibility(0);
        } else {
            pInputCompleteButton.setVisibility(8);
        }
        aInputCancelDrawable = this.resizeBackgroundImage(this.mActivity.getResources().getIdentifier("fullview_cancel", "drawable", this.mActivity.getPackageName()), aButtonWidth, aButtonHeight);
        if (aInputCancelDrawable != null) {
            pInputCancelButton.setBackgroundDrawable(aInputCancelDrawable);
            pInputCancelButton.setVisibility(0);
        } else {
            pInputCancelButton.setVisibility(8);
        }
    }

    private void clearButtonFocus() {
        int aIndexCount = 0;
        XKKeyButton aXKKeyButton = null;
        aIndexCount = 0;
        while (aIndexCount < this.mXKKeyList.size()) {
            aXKKeyButton = this.mXKKeyList.get(aIndexCount);
            aXKKeyButton.clearFocus();
            ++aIndexCount;
        }
    }

    public void setFirstButtonFocus() {
        int aIndexCount = 0;
        XKKeyButton aXKKeyButton = null;
        aIndexCount = 0;
        while (aIndexCount < this.mXKKeyList.size()) {
            aXKKeyButton = this.mXKKeyList.get(aIndexCount);
            if (aXKKeyButton.getIndex() != -1) {
                aXKKeyButton.requestFocus();
                break;
            }
            ++aIndexCount;
        }
    }

    private void setClickedEvent() {
        int aIndexCount = 0;
        boolean aUseInputButton = false;
        Button aInputCompleteButton = null;
        Button aInputCancelButton = null;
        LinearLayout aEditTextButtonLayout = null;
        XKKeyButton aXKKeyButton = null;
        aUseInputButton = this.mXKEditText.getUseInputButton();
        if (this.mXKViewType == 1 && aUseInputButton) {
            aEditTextButtonLayout = (LinearLayout)this.mActivity.findViewById(this.mActivity.getResources().getIdentifier("edittext_button_layout", "id", this.mActivity.getPackageName()));
            aInputCompleteButton = (Button)aEditTextButtonLayout.findViewWithTag((Object)"input_complete_button");
            aInputCancelButton = (Button)aEditTextButtonLayout.findViewWithTag((Object)"input_cancel_button");
            if (aInputCompleteButton != null) {
                aInputCompleteButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        XKNumberKeypad.this.inputComplete();
                    }
                });
            }
            if (aInputCancelButton != null) {
                aInputCancelButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        XKNumberKeypad.this.inputCancel();
                    }
                });
            }
        }
        aIndexCount = 0;
        while (aIndexCount < this.mXKKeyList.size()) {
            aXKKeyButton = this.mXKKeyList.get(aIndexCount);
            if (aXKKeyButton.getIndex() == -1) {
                aXKKeyButton.setOnClickListener(null);
                aXKKeyButton.setFocusable(false);
                aXKKeyButton.setFocusableInTouchMode(false);
                aXKKeyButton.setClickable(false);
            } else {
                aXKKeyButton.setFocusable(true);
                aXKKeyButton.setFocusableInTouchMode(true);
                aXKKeyButton.setClickable(true);
                aXKKeyButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View pView) {
                        int aKeypadMaxLength = XKNumberKeypad.this.mXKEditText.getKeypadMaxLength();
                        TimerTask aInputKeyTimerTask = null;
                        final Handler aHandler = new Handler();
                        XKKeyButton aXKKeyButton = (XKKeyButton)pView;
                        if (XKNumberKeypad.this.mXKCoreWrapper.getIndexCount() == aKeypadMaxLength) {
                            return;
                        }
                        if (XKNumberKeypad.this.mInputKeyTimer != null) {
                            XKNumberKeypad.this.mInputKeyTimer.cancel();
                            XKNumberKeypad.this.mInputKeyTimer.purge();
                            XKNumberKeypad.this.mInputKeyTimer = null;
                        }
                        XKNumberKeypad.this.mInputKeyTimer = new Timer();
                        aInputKeyTimerTask = new TimerTask(){

                            @Override
                            public void run() {
                                aHandler.post(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (XKNumberKeypad.this.mXKKeypadTopLayout != null) {
                                            XKNumberKeypad.this.mInputImageView.setImageResource(XKNumberKeypad.this.mXKKeypadResources.getClickedSpaceImageID());
                                        }
                                    }
                                });
                            }
                        };
                        XKNumberKeypad.this.mInputKeyTimer.schedule(aInputKeyTimerTask, 5000L);
                        if (XKNumberKeypad.this.mXKKeypadTopLayout != null) {
                            XKNumberKeypad.this.mInputImageView.setImageResource(aXKKeyButton.getClickedImageID());
                        }
                        XKNumberKeypad.this.mXKKeypadInterface.getIndexData(aXKKeyButton);
                        if (XKNumberKeypad.this.mXKViewType == 1) {
                            XKNumberKeypad.this.mDummyBuffer.append("*");
                            XKNumberKeypad.this.mDummyEditText.setText((CharSequence)XKNumberKeypad.this.mDummyBuffer);
                        }
                    }
                });
                aXKKeyButton.setOnTouchListener(new View.OnTouchListener(){

                    public boolean onTouch(View pView, MotionEvent pMotionEvent) {
                        int aAction = 0;
                        XKKeyButton aXKKeyButton = (XKKeyButton)pView;
                        aAction = pMotionEvent.getAction();
                        if (pMotionEvent.getPointerCount() > 1) {
                            return false;
                        }
                        if (aAction == 1) {
                            aXKKeyButton.performClick();
                        }
                        return true;
                    }
                });
            }
            ++aIndexCount;
        }
        this.mRefreshButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String aE2EURL = null;
                if (XKNumberKeypad.this.mXKViewType == 1) {
                    XKNumberKeypad.this.mDummyBuffer.setLength(0);
                    XKNumberKeypad.this.mDummyEditText.setText((CharSequence)XKNumberKeypad.this.mDummyBuffer);
                }
                XKNumberKeypad.this.mXKKeypadInterface.clearIndex();
                XKNumberKeypad.this.makeXKKeypadIndex();
                XKNumberKeypad.this.setXKKeypadButtonImage();
                XKNumberKeypad.this.clearButtonFocus();
                XKNumberKeypad.this.setFirstButtonFocus();
                if (XKNumberKeypad.this.mXKKeypadTopLayout != null) {
                    XKNumberKeypad.this.mInputImageView.setImageResource(XKNumberKeypad.this.mXKKeypadResources.getClickedSpaceImageID());
                    aE2EURL = XKNumberKeypad.this.mXKEditText.getE2EURL();
                    if (aE2EURL != null) {
                        XKNumberKeypad.this.mXKKeypadTopLayout.refreshSessionTimer(XKNumberKeypad.this.mXKCoreWrapper.getE2ESessionTime());
                    }
                }
            }
        });
        this.mDeleteButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int aInputLength = 0;
                if (XKNumberKeypad.this.mXKViewType == 1 && (aInputLength = XKNumberKeypad.this.mDummyBuffer.length()) > 0) {
                    XKNumberKeypad.this.mDummyBuffer.deleteCharAt(aInputLength - 1);
                    XKNumberKeypad.this.mDummyEditText.setText((CharSequence)XKNumberKeypad.this.mDummyBuffer);
                }
                XKNumberKeypad.this.mXKKeypadInterface.deleteIndex();
                if (XKNumberKeypad.this.mXKKeypadTopLayout != null) {
                    XKNumberKeypad.this.mInputImageView.setImageResource(XKNumberKeypad.this.mXKKeypadResources.getClickedSpaceImageID());
                }
            }
        });
        this.mDeleteButton.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (XKNumberKeypad.this.mXKViewType == 1) {
                    XKNumberKeypad.this.mDummyBuffer.setLength(0);
                    XKNumberKeypad.this.mDummyEditText.setText((CharSequence)XKNumberKeypad.this.mDummyBuffer);
                }
                if (XKNumberKeypad.this.mXKKeypadTopLayout != null) {
                    XKNumberKeypad.this.mInputImageView.setImageResource(XKNumberKeypad.this.mXKKeypadResources.getClickedSpaceImageID());
                }
                XKNumberKeypad.this.mXKKeypadInterface.clearIndex();
                return false;
            }
        });
        this.mCompleteButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XKNumberKeypad.this.inputComplete();
            }
        });
    }

    private Drawable resizeBackgroundImage(int pImageID, int pWidth, int pHeight) {
        Bitmap aBitmapImage = null;
        Bitmap aResizedBitmap = null;
        BitmapFactory.Options aBitmapOption = null;
        BitmapDrawable aResizedDrawable = null;
        try {
            aBitmapOption = new BitmapFactory.Options();
            aBitmapOption.inPreferredConfig = Bitmap.Config.ARGB_8888;
            aBitmapImage = BitmapFactory.decodeResource((Resources)this.mActivity.getResources(), (int)pImageID, (BitmapFactory.Options)aBitmapOption);
            aResizedBitmap = Bitmap.createScaledBitmap((Bitmap)aBitmapImage, (int)pWidth, (int)pHeight, (boolean)true);
            aResizedDrawable = new BitmapDrawable(this.mActivity.getResources(), aResizedBitmap);
        }
        catch (IllegalArgumentException aException) {
            aResizedDrawable = null;
        }
        catch (NullPointerException aException) {
            aResizedDrawable = null;
        }
        return aResizedDrawable;
    }

    public void changeConfiguration() {
        int aDeviceHeight = 0;
        int aDeviceWidth = 0;
        int aHeightPercent = 0;
        int aXKKeypadHeight = 0;
        int aXKKeypadWidth = 0;
        int aIndexCount = 0;
        int aRowCount = 0;
        float aWidthMarginPercent = 0.0f;
        float aHeightMarginPercent = 0.0f;
        LinearLayout aKeypadRowLayout = null;
        DisplayMetrics aDisplayMetrics = null;
        LinearLayout.LayoutParams aXKButtonLayoutParams = null;
        RelativeLayout.LayoutParams aRowLayoutParams = null;
        aWidthMarginPercent = 1.5f;
        aHeightMarginPercent = 1.0f;
        aHeightPercent = 30;
        aDisplayMetrics = new DisplayMetrics();
        this.mActivity.getWindowManager().getDefaultDisplay().getMetrics(aDisplayMetrics);
        aDeviceWidth = aDisplayMetrics.widthPixels;
        aDeviceHeight = aDisplayMetrics.heightPixels;
        this.mXKKeyWidthMargin = (int)((float)aDeviceWidth * aWidthMarginPercent) / 100;
        this.mXKKeyHeightMargin = (int)((float)aDeviceHeight * aHeightMarginPercent) / 100;
        aXKKeypadHeight = aDeviceHeight * aHeightPercent / 100;
        this.mXKKeyHeight = (aXKKeypadHeight -= (this.mKeypadRowCount + 1) * this.mXKKeyHeightMargin) / this.mKeypadRowCount;
        aXKKeypadWidth = aDeviceWidth - (this.mKeypadColumnCount + 1) * this.mXKKeyWidthMargin;
        this.mXKKeyWidth = aXKKeypadWidth / this.mKeypadColumnCount;
        aRowCount = 0;
        while (aRowCount < this.mKeypadLayoutList.size()) {
            aKeypadRowLayout = this.mKeypadLayoutList.get(aRowCount);
            aRowLayoutParams = (RelativeLayout.LayoutParams)aKeypadRowLayout.getLayoutParams();
            aRowLayoutParams.topMargin = this.mXKKeyHeightMargin;
            aKeypadRowLayout.setLayoutParams((ViewGroup.LayoutParams)aRowLayoutParams);
            if (aRowCount == this.mKeypadRowCount - 1) {
                aKeypadRowLayout.setPadding(this.mXKKeyWidthMargin, 0, this.mXKKeyWidthMargin, this.mXKKeyHeightMargin);
            } else {
                aKeypadRowLayout.setPadding(this.mXKKeyWidthMargin, 0, this.mXKKeyWidthMargin, 0);
            }
            ++aRowCount;
        }
        aIndexCount = 0;
        while (aIndexCount < this.mXKKeyList.size()) {
            aXKButtonLayoutParams = (LinearLayout.LayoutParams)this.mXKKeyList.get(aIndexCount).getLayoutParams();
            aXKButtonLayoutParams.height = this.mXKKeyHeight;
            aXKButtonLayoutParams.leftMargin = aIndexCount % this.mKeypadColumnCount == 0 ? 0 : this.mXKKeyWidthMargin;
            this.mXKKeyList.get(aIndexCount).setLayoutParams((ViewGroup.LayoutParams)aXKButtonLayoutParams);
            ++aIndexCount;
        }
        aXKButtonLayoutParams = (LinearLayout.LayoutParams)this.mRefreshButton.getLayoutParams();
        aXKButtonLayoutParams.height = this.mXKKeyHeight;
        aXKButtonLayoutParams.rightMargin = this.mXKKeyWidthMargin;
        this.mRefreshButton.setLayoutParams((ViewGroup.LayoutParams)aXKButtonLayoutParams);
        aXKButtonLayoutParams = (LinearLayout.LayoutParams)this.mDeleteButton.getLayoutParams();
        aXKButtonLayoutParams.height = this.mXKKeyHeight;
        aXKButtonLayoutParams.rightMargin = this.mXKKeyWidthMargin;
        this.mDeleteButton.setLayoutParams((ViewGroup.LayoutParams)aXKButtonLayoutParams);
        aXKButtonLayoutParams = (LinearLayout.LayoutParams)this.mCompleteButton.getLayoutParams();
        aXKButtonLayoutParams.height = this.mXKKeyHeight;
        this.mCompleteButton.setLayoutParams((ViewGroup.LayoutParams)aXKButtonLayoutParams);
        this.setXKKeypadButtonImage();
    }

    public int makeXKKeypadIndex() {
        int aResult = 0;
        int aKeypadType = 0;
        int aXKKeypadIndexLength = 0;
        String aE2EURL = null;
        aKeypadType = 0;
        aXKKeypadIndexLength = 10;
        this.mXKKeypadIndex = new int[aXKKeypadIndexLength];
        aE2EURL = this.mXKEditText.getE2EURL();
        aResult = aE2EURL != null ? this.mXKKeypadInterface.makeIndexE2E(this.mXKKeypadIndex, aXKKeypadIndexLength, aKeypadType, aE2EURL) : this.mXKKeypadInterface.makeIndex(this.mXKKeypadIndex, aXKKeypadIndexLength, aKeypadType);
        if (aResult != 0) {
            return aResult;
        }
        this.setKeyIndex(this.mXKKeypadIndex);
        this.mXKKeypadIndexText = new String[aXKKeypadIndexLength];
        aResult = this.mXKKeypadInterface.getIndexText(this.mXKKeypadIndexText, aXKKeypadIndexLength, aKeypadType);
        return aResult;
    }

    private void inputComplete() {
        String aE2EURL = null;
        Intent aIntent = null;
        aE2EURL = this.mXKEditText.getE2EURL();
        if (this.mXKKeypadTopLayout != null && aE2EURL != null) {
            this.mXKKeypadTopLayout.endSessionTimer();
        }
        aIntent = this.mActivity.getIntent();
        this.mActivity.setResult(-1, aIntent);
        this.mActivity.finish();
    }

    private void inputCancel() {
        Intent aIntent = null;
        if (this.mInputKeyTimer != null) {
            this.mInputKeyTimer.cancel();
            this.mInputKeyTimer.purge();
            this.mInputKeyTimer = null;
        }
        this.mXKKeypadInterface.clearIndex();
        if (this.mXKEditText.getE2EURL() != null) {
            this.mXKKeypadTopLayout.endSessionTimer();
        }
        aIntent = this.mActivity.getIntent();
        this.mActivity.setResult(0, aIntent);
        this.mActivity.finish();
    }

    public int getXKKeypadHeight() {
        return this.mXKKeypadHeight;
    }

    public ArrayList<LinearLayout> getXKKeypadLayoutList() {
        return this.mKeypadLayoutList;
    }

    public void setXKEditText(XKEditText pXKEditText, EditText pDummyEditText) {
        this.mXKEditText = pXKEditText;
        this.mDummyEditText = pDummyEditText;
    }

    public void setXKCoreWrapper(XKCoreWrapper pXKCoreWrapper) {
        this.mXKCoreWrapper = pXKCoreWrapper;
    }

    public void setXKBlankLogoImage(Drawable pXKBlankLogoImage) {
        this.mXKBlankLogoImage = pXKBlankLogoImage;
    }
}

