/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.ui.crypto;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import android.widget.ImageButton;
import com.consortium.smartusim.SmartUsim;
import com.softforum.sample.R;
import com.softforum.xecure.crypto.CertMgr;
import com.softforum.xecure.keypad.CopyCertToUsimWithXK;
import com.softforum.xecure.keypad.UsimCertDeleteWithXK;
import com.softforum.xecure.keypad.UsimCertVerifyOwnerWithXK;
import com.softforum.xecure.keypad.XecureSmartChangePasswordWithXK;
import com.softforum.xecure.keypad.XecureSmartMoveCertificateToAppDataWithXK;
import com.softforum.xecure.keypad.XecureSmartVerifyVidWithXK;
import com.softforum.xecure.ui.crypto.ActivityData;
import com.softforum.xecure.ui.crypto.CopyCertToICCard;
import com.softforum.xecure.ui.crypto.CopyCertificate;
import com.softforum.xecure.ui.crypto.PKCS11Password;
import com.softforum.xecure.ui.crypto.XecureSmartCertDetailInfo;
import com.softforum.xecure.ui.crypto.XecureSmartCertMgrPublic;
import com.softforum.xecure.ui.crypto.XecureSmartCertMgrRoot;
import com.softforum.xecure.ui.crypto.XecureSmartCertMgrUser;
import com.softforum.xecure.ui.crypto.XecureSmartChangePassword;
import com.softforum.xecure.ui.crypto.XecureSmartMoveCertificateToAppData;
import com.softforum.xecure.ui.crypto.XecureSmartVerifyRoot;
import com.softforum.xecure.ui.crypto.XecureSmartVerifyVid;
import com.softforum.xecure.ui.menu.XSlideMenuPanel;
import com.softforum.xecure.ui.transkey.CopyCertToICCardWithTranskey;
import com.softforum.xecure.ui.transkey.CopyCertToUsimWithTranskey;
import com.softforum.xecure.ui.transkey.UsimCertDeleteWithTranskey;
import com.softforum.xecure.ui.transkey.UsimCertVerifyOwnerWithTranskey;
import com.softforum.xecure.ui.transkey.XecureSmartChangePasswordWithTransKey;
import com.softforum.xecure.ui.transkey.XecureSmartMoveCertificateToAppDataWithTransKey;
import com.softforum.xecure.ui.transkey.XecureSmartVerifyVidWithTransKey;
import com.softforum.xecure.usim.CopyCertToUsim;
import com.softforum.xecure.usim.SmartUsimParcelable;
import com.softforum.xecure.usim.UsimCertDelete;
import com.softforum.xecure.usim.UsimCertSeeDetailInfo;
import com.softforum.xecure.usim.UsimCertVerifyOwner;
import com.softforum.xecure.util.CallBack;
import com.softforum.xecure.util.EnvironmentConfig;
import com.softforum.xecure.util.XDetailData;
import com.softforum.xecure.util.XSLog;
import java.util.ArrayList;
import kr.or.kftc.mobiletoken_lib.device_control.TokenControl;

public class XecureSmartCertMgrMenu {
    private static volatile XecureSmartCertMgrMenu mUniqueXecureSmartCertMgrMenuInstance;
    private Activity mCallerContext;
    private final int mSeeDetail = 1;
    private final int mDelete = 2;
    private final int mVerifyOwner = 3;
    private final int mChangePassword = 4;
    private final int mExport = 5;
    private final int mImport = 6;
    private final int mVerifyRoot = 7;
    private final int mCertCopy = 8;
    private final int mMoveCert = 9;
    private final int mCopyCertToUsim = 10;
    private final int mSeeDetailUsim = 11;
    private final int mDeleteUsim = 12;
    private final int mVerifyOwnerUsim = 13;
    private final int mChangePasswordUsim = 14;
    private final int mCopyCertToICCard = 15;
    private SmartUsim mSmartUsim = null;
    private final int mDeleteICCard = 99;
    private static String errMsg;
    private TokenControl mToken;
    private int mPosition;
    private int mCertType;
    private int mMediaID;
    private XDetailData mPassedCertData;
    ArrayList<ImageButton> mPanelMenuList;

    private XecureSmartCertMgrMenu(Activity aContext) {
        this.mCallerContext = aContext;
    }

    public static synchronized XecureSmartCertMgrMenu getInstance(Activity aContext) {
        if (null == mUniqueXecureSmartCertMgrMenuInstance) {
            mUniqueXecureSmartCertMgrMenuInstance = new XecureSmartCertMgrMenu(aContext);
        }
        XecureSmartCertMgrMenu.mUniqueXecureSmartCertMgrMenuInstance.mCallerContext = aContext;
        return mUniqueXecureSmartCertMgrMenuInstance;
    }

    public void setCertOperationMenu(int aMediaID, XDetailData aCert, int certType, XSlideMenuPanel aXSlideMenuPanel) {
        this.mMediaID = aMediaID;
        this.mPassedCertData = aCert;
        this.mCertType = certType;
        this.initializePanelMenus(certType, aXSlideMenuPanel);
        aXSlideMenuPanel.setMenuItems(this.mPanelMenuList);
    }

    public void setICCertOperationMenu(int aMediaID, XDetailData aCert, int certType, XSlideMenuPanel aXSlideMenuPanel, TokenControl pToken) {
        this.mMediaID = aMediaID;
        this.mPassedCertData = aCert;
        this.mCertType = certType;
        this.mToken = pToken;
        this.initializePanelMenus(certType, aXSlideMenuPanel);
        aXSlideMenuPanel.setMenuItems(this.mPanelMenuList);
    }

    public void setUsimCertOperationMenu(int aMediaID, XDetailData aCert, int certType, XSlideMenuPanel aXSlideMenuPanel, int position, SmartUsim SmartUsim2) {
        this.mMediaID = aMediaID;
        this.mPassedCertData = aCert;
        this.mCertType = certType;
        this.mPosition = position;
        this.mSmartUsim = SmartUsim2;
        this.initializePanelMenus(certType, aXSlideMenuPanel);
        aXSlideMenuPanel.setMenuItems(this.mPanelMenuList);
    }

    private void initializePanelMenus(int aCertType, XSlideMenuPanel aXSlideMenuPanel) {
        if (null == this.mPanelMenuList) {
            this.mPanelMenuList = new ArrayList();
        } else {
            this.mPanelMenuList.clear();
        }
        if (0 == aCertType) {
            this.mPanelMenuList.add(this.addImageButton(1, aXSlideMenuPanel));
            this.mPanelMenuList.add(this.addImageButton(2, aXSlideMenuPanel));
            this.mPanelMenuList.add(this.addImageButton(3, aXSlideMenuPanel));
            this.mPanelMenuList.add(this.addImageButton(4, aXSlideMenuPanel));
            if (EnvironmentConfig.mSDCardAppDataUse) {
                this.mPanelMenuList.add(this.addImageButton(9, aXSlideMenuPanel));
            }
            if (EnvironmentConfig.mUsimUse) {
                this.mPanelMenuList.add(this.addImageButton(10, aXSlideMenuPanel));
            }
            if (EnvironmentConfig.mICCardUse) {
                this.mPanelMenuList.add(this.addImageButton(15, aXSlideMenuPanel));
            }
        } else if (3 == aCertType) {
            this.mPanelMenuList.add(this.addImageButton(1, aXSlideMenuPanel));
            this.mPanelMenuList.add(this.addImageButton(2, aXSlideMenuPanel));
            this.mPanelMenuList.add(this.addImageButton(3, aXSlideMenuPanel));
            this.mPanelMenuList.add(this.addImageButton(4, aXSlideMenuPanel));
            if (EnvironmentConfig.mUsimUse) {
                this.mPanelMenuList.add(this.addImageButton(10, aXSlideMenuPanel));
            }
            if (EnvironmentConfig.mICCardUse) {
                this.mPanelMenuList.add(this.addImageButton(15, aXSlideMenuPanel));
            }
        } else if (5 == aCertType) {
            this.mPanelMenuList.add(this.addImageButton(1, aXSlideMenuPanel));
            this.mPanelMenuList.add(this.addImageButton(99, aXSlideMenuPanel));
        } else if (4 == aCertType) {
            this.mPanelMenuList.add(this.addImageButton(11, aXSlideMenuPanel));
            this.mPanelMenuList.add(this.addImageButton(12, aXSlideMenuPanel));
            this.mPanelMenuList.add(this.addImageButton(13, aXSlideMenuPanel));
            this.mPanelMenuList.add(this.addImageButton(14, aXSlideMenuPanel));
        } else if (1 == aCertType) {
            this.mPanelMenuList.add(this.addImageButton(1, aXSlideMenuPanel));
            this.mPanelMenuList.add(this.addImageButton(2, aXSlideMenuPanel));
        } else if (2 == aCertType) {
            this.mPanelMenuList.add(this.addImageButton(1, aXSlideMenuPanel));
            this.mPanelMenuList.add(this.addImageButton(7, aXSlideMenuPanel));
        }
    }

    private ImageButton addImageButton(int aButtonType, final XSlideMenuPanel aXSlideMenuPanel) {
        ImageButton aResult = new ImageButton((Context)this.mCallerContext);
        if (1 == aButtonType) {
            aResult.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    XecureSmartCertMgrMenu.this.seeDetailCert();
                }
            });
            aResult.setImageResource(R.drawable.cert_detail);
            aResult.setContentDescription((CharSequence)"\uc790\uc138\ud788 \ubcf4\uae30");
        } else if (2 == aButtonType) {
            aResult.setImageResource(R.drawable.cert_delete);
            aResult.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    aXSlideMenuPanel.hide();
                    XecureSmartCertMgrMenu.this.deleteCert();
                }
            });
            aResult.setContentDescription((CharSequence)"\uc0ad\uc81c");
        } else if (99 == aButtonType) {
            aResult.setImageResource(R.drawable.cert_delete);
            aResult.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    aXSlideMenuPanel.hide();
                    XecureSmartCertMgrMenu.this.deleteCertICCard();
                }
            });
            aResult.setContentDescription((CharSequence)"IC\uce74\ub4dc \uc778\uc99d\uc11c \uc0ad\uc81c");
        } else if (15 == aButtonType) {
            aResult.setImageResource(R.drawable.cert_copy);
            aResult.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    aXSlideMenuPanel.hide();
                    XecureSmartCertMgrMenu.this.copyCertToICCard();
                }
            });
            aResult.setContentDescription((CharSequence)"IC\uce74\ub4dc\ub85c \uc778\uc99d\uc11c \ubcf5\uc0ac");
        } else if (3 == aButtonType) {
            aResult.setImageResource(R.drawable.cert_verify_vid);
            aResult.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    XecureSmartCertMgrMenu.this.verifyOwnerCert();
                }
            });
            aResult.setContentDescription((CharSequence)"\uc18c\uc720\uc790 \uac80\uc99d");
        } else if (4 == aButtonType) {
            aResult.setImageResource(R.drawable.cert_change_password);
            aResult.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    XecureSmartCertMgrMenu.this.changePasswordCert();
                }
            });
            aResult.setContentDescription((CharSequence)"\uc554\ud638\ubcc0\uacbd");
        } else if (5 == aButtonType) {
            aResult.setImageResource(R.drawable.cert_export);
            aResult.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    XecureSmartCertMgrMenu.this.alertNotSupport();
                }
            });
        } else if (9 == aButtonType) {
            aResult.setImageResource(R.drawable.cert_move);
            aResult.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    XecureSmartCertMgrMenu.this.moveCert();
                }
            });
        } else if (6 == aButtonType) {
            aResult.setImageResource(R.drawable.icon);
            aResult.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    XecureSmartCertMgrMenu.this.alertNotSupport();
                }
            });
        } else if (7 == aButtonType) {
            aResult.setImageResource(R.drawable.cert_verity_root);
            aResult.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    XecureSmartCertMgrMenu.this.verifyRoot();
                }
            });
            aResult.setContentDescription((CharSequence)"\ub8e8\ud2b8\uc778\uc99d\uae30\uad00\uac80\uc99d");
        } else if (8 == aButtonType) {
            aResult.setImageResource(R.drawable.cert_copy);
            aResult.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    XecureSmartCertMgrMenu.this.copyCert();
                }
            });
        } else if (10 == aButtonType) {
            aResult.setImageResource(R.drawable.cert_copy);
            aResult.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    XecureSmartCertMgrMenu.this.copyCertToUsim();
                }
            });
            aResult.setContentDescription((CharSequence)"USIM \uc73c\ub85c \uc778\uc99d\uc11c \ubcf5\uc0ac");
        } else if (11 == aButtonType) {
            aResult.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    XecureSmartCertMgrMenu.this.seeDetailUsimCert();
                }
            });
            aResult.setImageResource(R.drawable.cert_detail);
            aResult.setContentDescription((CharSequence)"USIM \uc778\uc99d\uc11c \uc790\uc138\ud788 \ubcf4\uae30");
        } else if (12 == aButtonType) {
            aResult.setImageResource(R.drawable.cert_delete);
            aResult.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    aXSlideMenuPanel.hide();
                    XecureSmartCertMgrMenu.this.deleteUsimCert();
                }
            });
            aResult.setContentDescription((CharSequence)"USIM \uc778\uc99d\uc11c \uc0ad\uc81c");
        } else if (13 == aButtonType) {
            aResult.setImageResource(R.drawable.cert_verify_vid);
            aResult.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    XecureSmartCertMgrMenu.this.verifyOwnerUsimCert();
                }
            });
            aResult.setContentDescription((CharSequence)"USIM \uc778\uc99d\uc11c \uc18c\uc720\uc790 \uac80\uc99d");
        } else if (14 == aButtonType) {
            aResult.setImageResource(R.drawable.cert_change_password);
            aResult.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    XecureSmartCertMgrMenu.this.changePasswordUsimCert();
                }
            });
            aResult.setContentDescription((CharSequence)"USIM \uc778\uc99d\uc11c \uc554\ud638\ubcc0\uacbd");
        }
        return aResult;
    }

    private void alertNotSupport() {
        AlertDialog.Builder aBuilder = new AlertDialog.Builder((Context)this.mCallerContext);
        aBuilder.setTitle(R.string.xecure_smart_cert_mgr_confirm_caution).setMessage(R.string.not_supported_function).setCancelable(false).setPositiveButton(R.string.xecure_smart_cert_mgr_confirm_ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).show();
    }

    private void seeDetailCert() {
        Intent aIntent = new Intent((Context)this.mCallerContext, XecureSmartCertDetailInfo.class);
        aIntent.putExtra("parsed_xdetail_data_key", this.mPassedCertData.getValueArray());
        aIntent.putExtra("cert_location_key", this.mMediaID);
        this.mCallerContext.startActivity(aIntent);
    }

    private void deleteCertICCard() {
        AlertDialog.Builder aBuilder = new AlertDialog.Builder((Context)this.mCallerContext);
        aBuilder.setTitle(R.string.xecure_smart_cert_mgr_confirm_caution).setMessage(R.string.xecure_smart_cert_mgr_confirm_window).setCancelable(false).setPositiveButton(R.string.xecure_smart_cert_mgr_confirm_ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                CallBack aCallBack = new CallBack(){

                    public void onCallBack() {
                        String aPinValue = "11111111";
                        Bundle requestBundle = new Bundle();
                        requestBundle.putString("REQUEST_ACTION", "GET_CERTIFICATE_LIST");
                        int aCertificateCount = 0;
                        Bundle responseBundle = new Bundle();
                        XecureSmartCertMgrMenu.this.mToken.Transmit(requestBundle, responseBundle);
                        if (responseBundle.getString("RESULT_CODE").equals("0000")) {
                            aCertificateCount = responseBundle.getInt("CERT_COUNT");
                        } else {
                            errMsg = responseBundle.getString("ERROR_MESSAGE");
                        }
                        if (aCertificateCount == 0) {
                            return;
                        }
                        int aDeleteLocate = aCertificateCount;
                        requestBundle.putString("REQUEST_ACTION", "VERIFY_PIN");
                        requestBundle.putByteArray("PIN", aPinValue.getBytes());
                        XecureSmartCertMgrMenu.this.mToken.Transmit(requestBundle, responseBundle);
                        if (responseBundle.getString("RESULT_CODE").equals("0000")) {
                            requestBundle.putString("REQUEST_ACTION", "DELETE_CERTIFICATE");
                            requestBundle.putInt("CERTIFICATE_INDEX", aDeleteLocate);
                            XecureSmartCertMgrMenu.this.mToken.Transmit(requestBundle, responseBundle);
                            if (responseBundle.getString("RESULT_CODE").equals("0000")) {
                                XecureSmartCertMgrMenu.this.mToken.Disconnect();
                                ((XecureSmartCertMgrUser)XecureSmartCertMgrMenu.this.mCallerContext).refreshCertList();
                            } else {
                                errMsg = responseBundle.getString("ERROR_MESSAGE");
                            }
                        } else {
                            errMsg = responseBundle.getString("ERROR_MESSAGE");
                        }
                    }
                };
                aCallBack.onCallBack();
            }
        }).setNegativeButton(R.string.xecure_smart_cert_mgr_confirm_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                dialog.cancel();
            }
        }).show();
    }

    private void deleteCert() {
        AlertDialog.Builder aBuilder = new AlertDialog.Builder((Context)this.mCallerContext);
        aBuilder.setTitle(R.string.xecure_smart_cert_mgr_confirm_caution).setMessage(R.string.xecure_smart_cert_mgr_confirm_window).setCancelable(false).setPositiveButton(R.string.xecure_smart_cert_mgr_confirm_ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                CallBack aCallBack = new CallBack(){

                    public void onCallBack() {
                        int aResult = 0;
                        aResult = CertMgr.getInstance().deleteCertificateWithSubjectDN(XecureSmartCertMgrMenu.this.mMediaID, 3, XecureSmartCertMgrMenu.this.mPassedCertData.getValue(7));
                        XSLog.d((String)(((Object)((Object)this)).getClass().getName() + "::DeleteCert result : " + aResult));
                        if (0 == aResult) {
                            switch (XecureSmartCertMgrMenu.this.mCertType) {
                                case 0: {
                                    ((XecureSmartCertMgrUser)XecureSmartCertMgrMenu.this.mCallerContext).refreshCertList();
                                    break;
                                }
                                case 3: {
                                    ((XecureSmartCertMgrUser)XecureSmartCertMgrMenu.this.mCallerContext).refreshCertList();
                                    break;
                                }
                                case 1: {
                                    ((XecureSmartCertMgrPublic)XecureSmartCertMgrMenu.this.mCallerContext).refreshCertList();
                                    break;
                                }
                                case 2: {
                                    ((XecureSmartCertMgrRoot)XecureSmartCertMgrMenu.this.mCallerContext).refreshCertList();
                                }
                            }
                        }
                    }
                };
                if (XecureSmartCertMgrMenu.this.mMediaID == 401) {
                    ActivityData.parameters.put(String.valueOf(aCallBack.hashCode()), aCallBack);
                    Intent aIntent = new Intent((Context)XecureSmartCertMgrMenu.this.mCallerContext, PKCS11Password.class);
                    aIntent.putExtra("callback", String.valueOf(aCallBack.hashCode()));
                    XecureSmartCertMgrMenu.this.mCallerContext.startActivityForResult(aIntent, 90000);
                } else {
                    aCallBack.onCallBack();
                }
            }
        }).setNegativeButton(R.string.xecure_smart_cert_mgr_confirm_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                dialog.cancel();
            }
        }).show();
    }

    private void verifyOwnerCert() {
        Intent aIntent = null;
        if (EnvironmentConfig.mBasicKeyUsage) {
            aIntent = new Intent((Context)this.mCallerContext, XecureSmartVerifyVid.class);
        } else if (EnvironmentConfig.mMTransKeyUsage) {
            aIntent = new Intent((Context)this.mCallerContext, XecureSmartVerifyVidWithTransKey.class);
        } else if (EnvironmentConfig.mXecureKeypadFullViewUsage || EnvironmentConfig.mXecureKeypadNormalViewUsage) {
            aIntent = new Intent((Context)this.mCallerContext, XecureSmartVerifyVidWithXK.class);
        }
        aIntent.putExtra("xecure_smart_verify_vid_media_id_key", this.mMediaID);
        aIntent.putExtra("xecure_smart_verify_vid_data_key", this.mPassedCertData.getValueArray());
        this.mCallerContext.startActivityForResult(aIntent, 79000);
    }

    private void changePasswordCert() {
        Intent aIntent = null;
        if (this.mMediaID == 401) {
            this.alertNotSupport();
            return;
        }
        if (EnvironmentConfig.mBasicKeyUsage) {
            aIntent = new Intent((Context)this.mCallerContext, XecureSmartChangePassword.class);
        } else if (EnvironmentConfig.mMTransKeyUsage) {
            aIntent = new Intent((Context)this.mCallerContext, XecureSmartChangePasswordWithTransKey.class);
        } else if (EnvironmentConfig.mXecureKeypadFullViewUsage || EnvironmentConfig.mXecureKeypadNormalViewUsage) {
            aIntent = new Intent((Context)this.mCallerContext, XecureSmartChangePasswordWithXK.class);
        }
        aIntent.putExtra("xecure_smart_changepw_media_id_key", this.mMediaID);
        aIntent.putExtra("xecure_smart_changepw_data_key", this.mPassedCertData.getValueArray());
        this.mCallerContext.startActivityForResult(aIntent, 78000);
    }

    private void verifyRoot() {
        String aSubjectRdn = this.mPassedCertData.getValue(7);
        Intent aIntent = new Intent((Context)this.mCallerContext, XecureSmartVerifyRoot.class);
        aIntent.putExtra("verify_root_cert_subject_rdn_key", aSubjectRdn);
        this.mCallerContext.startActivity(aIntent);
    }

    public void moveCert() {
        Intent aIntent = null;
        if (EnvironmentConfig.mBasicKeyUsage) {
            aIntent = new Intent((Context)this.mCallerContext, XecureSmartMoveCertificateToAppData.class);
        } else if (EnvironmentConfig.mMTransKeyUsage) {
            aIntent = new Intent((Context)this.mCallerContext, XecureSmartMoveCertificateToAppDataWithTransKey.class);
        } else if (EnvironmentConfig.mXecureKeypadFullViewUsage || EnvironmentConfig.mXecureKeypadNormalViewUsage) {
            aIntent = new Intent((Context)this.mCallerContext, XecureSmartMoveCertificateToAppDataWithXK.class);
        }
        aIntent.putExtra("mSrcMediaID", 101);
        aIntent.putExtra("mDstMediaID", 1401);
        aIntent.putExtra("sign_cert_password_selected_cert_data_key", this.mPassedCertData.getValueArray());
        this.mCallerContext.startActivityForResult(aIntent, 120000);
    }

    private void copyCert() {
        if (this.mMediaID == 401) {
            this.alertNotSupport();
            return;
        }
        Intent aIntent = new Intent((Context)this.mCallerContext, CopyCertificate.class);
        aIntent.putExtra("copy_cert_src_media_id_key", this.mMediaID);
        aIntent.putExtra("copy_cert_dst_media_id_key", this.mMediaID == 101 ? 401 : 101);
        aIntent.putExtra("copy_cert_selected_cert_data_key", this.mPassedCertData.getValueArray());
        this.mCallerContext.startActivityForResult(aIntent, 110000);
    }

    private void copyCertToICCard() {
        Intent aIntent = null;
        if (EnvironmentConfig.mBasicKeyUsage) {
            aIntent = new Intent((Context)this.mCallerContext, CopyCertToICCard.class);
            aIntent.putExtra("sign_cert_password_selected_cert_data_key", this.mPassedCertData.getValueArray());
            aIntent.putExtra("copy_cert_src_media_id_key", this.mMediaID);
            this.mCallerContext.startActivityForResult(aIntent, 170000);
        } else if (EnvironmentConfig.mMTransKeyUsage) {
            aIntent = new Intent((Context)this.mCallerContext, CopyCertToICCardWithTranskey.class);
            aIntent.putExtra("sign_cert_password_selected_cert_data_key", this.mPassedCertData.getValueArray());
            aIntent.putExtra("copy_cert_src_media_id_key", this.mMediaID);
            this.mCallerContext.startActivityForResult(aIntent, 170000);
        }
    }

    private void copyCertToUsim() {
        Intent aIntent = null;
        if (EnvironmentConfig.mBasicKeyUsage) {
            aIntent = new Intent((Context)this.mCallerContext, CopyCertToUsim.class);
            aIntent.putExtra("mSrcMediaID", this.mMediaID);
            aIntent.putExtra("sign_cert_password_selected_cert_data_key", this.mPassedCertData.getValueArray());
            this.mCallerContext.startActivityForResult(aIntent, 130000);
        } else if (EnvironmentConfig.mMTransKeyUsage) {
            aIntent = new Intent((Context)this.mCallerContext, CopyCertToUsimWithTranskey.class);
            aIntent.putExtra("mSrcMediaID", this.mMediaID);
            aIntent.putExtra("sign_cert_password_selected_cert_data_key", this.mPassedCertData.getValueArray());
            this.mCallerContext.startActivityForResult(aIntent, 130000);
        } else if (EnvironmentConfig.mXecureKeypadFullViewUsage || EnvironmentConfig.mXecureKeypadNormalViewUsage) {
            aIntent = new Intent((Context)this.mCallerContext, CopyCertToUsimWithXK.class);
            aIntent.putExtra("mSrcMediaID", this.mMediaID);
            aIntent.putExtra("sign_cert_password_selected_cert_data_key", this.mPassedCertData.getValueArray());
            this.mCallerContext.startActivityForResult(aIntent, 130000);
        }
    }

    private void seeDetailUsimCert() {
        Intent aIntent = null;
        aIntent = new Intent((Context)this.mCallerContext, UsimCertSeeDetailInfo.class);
        aIntent.putExtra("parsed_xdetail_data_key", this.mPassedCertData.getValueArray());
        this.mCallerContext.startActivity(aIntent);
    }

    private void deleteUsimCert() {
        Intent aIntent = null;
        SmartUsimParcelable aSmartUsimParcelable = null;
        aSmartUsimParcelable = new SmartUsimParcelable(this.mSmartUsim);
        if (EnvironmentConfig.mBasicKeyUsage) {
            aIntent = new Intent((Context)this.mCallerContext, UsimCertDelete.class);
            aIntent.putExtra("Position", this.mPosition);
            aIntent.putExtra("SmartUsim", (Parcelable)aSmartUsimParcelable);
            aIntent.putExtra("parsed_xdetail_data_key", this.mPassedCertData.getValueArray());
            this.mCallerContext.startActivityForResult(aIntent, 140000);
        } else if (EnvironmentConfig.mMTransKeyUsage) {
            aIntent = new Intent((Context)this.mCallerContext, UsimCertDeleteWithTranskey.class);
            aIntent.putExtra("Position", this.mPosition);
            aIntent.putExtra("SmartUsim", (Parcelable)aSmartUsimParcelable);
            aIntent.putExtra("parsed_xdetail_data_key", this.mPassedCertData.getValueArray());
            this.mCallerContext.startActivityForResult(aIntent, 140000);
        } else if (EnvironmentConfig.mXecureKeypadFullViewUsage || EnvironmentConfig.mXecureKeypadNormalViewUsage) {
            aIntent = new Intent((Context)this.mCallerContext, UsimCertDeleteWithXK.class);
            aIntent.putExtra("Position", this.mPosition);
            aIntent.putExtra("SmartUsim", (Parcelable)aSmartUsimParcelable);
            aIntent.putExtra("parsed_xdetail_data_key", this.mPassedCertData.getValueArray());
            this.mCallerContext.startActivityForResult(aIntent, 140000);
        }
    }

    private void verifyOwnerUsimCert() {
        Intent aIntent = null;
        SmartUsimParcelable aSmartUsimParcelable = null;
        aSmartUsimParcelable = new SmartUsimParcelable(this.mSmartUsim);
        if (EnvironmentConfig.mBasicKeyUsage) {
            aIntent = new Intent((Context)this.mCallerContext, UsimCertVerifyOwner.class);
            aIntent.putExtra("Position", this.mPosition);
            aIntent.putExtra("SmartUsim", (Parcelable)aSmartUsimParcelable);
            aIntent.putExtra("parsed_xdetail_data_key", this.mPassedCertData.getValueArray());
            this.mCallerContext.startActivityForResult(aIntent, 150000);
        } else if (EnvironmentConfig.mMTransKeyUsage) {
            aIntent = new Intent((Context)this.mCallerContext, UsimCertVerifyOwnerWithTranskey.class);
            aIntent.putExtra("Position", this.mPosition);
            aIntent.putExtra("SmartUsim", (Parcelable)aSmartUsimParcelable);
            aIntent.putExtra("parsed_xdetail_data_key", this.mPassedCertData.getValueArray());
            this.mCallerContext.startActivityForResult(aIntent, 150000);
        } else if (EnvironmentConfig.mXecureKeypadFullViewUsage || EnvironmentConfig.mXecureKeypadNormalViewUsage) {
            aIntent = new Intent((Context)this.mCallerContext, UsimCertVerifyOwnerWithXK.class);
            aIntent.putExtra("Position", this.mPosition);
            aIntent.putExtra("SmartUsim", (Parcelable)aSmartUsimParcelable);
            aIntent.putExtra("parsed_xdetail_data_key", this.mPassedCertData.getValueArray());
            this.mCallerContext.startActivityForResult(aIntent, 150000);
        }
    }

    private void changePasswordUsimCert() {
        ((XecureSmartCertMgrUser)this.mCallerContext).changePasswordUsimCert();
    }

    public static class CertMenuType {
        public static final int USER_SDCARD = 0;
        public static final int USER_APPDATA = 3;
        public static final int USER_USIM = 4;
        public static final int USER_ICCARD = 5;
        public static final int PUBLIC = 1;
        public static final int ROOT = 2;
    }
}

