/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.ui.crypto;

import android.app.Activity;
import android.app.ListActivity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.softforum.sample.R;
import com.softforum.xecure.crypto.SessionMgr;
import com.softforum.xecure.ui.crypto.XecureSmartCertDetailInfo;
import com.softforum.xecure.util.XDetailData;
import com.softforum.xecure.util.XDetailDataParser;

public class XecureSmartSessionDetail
extends ListActivity {
    public static final int mXecureSmartSessionDetailID = 71100;
    public static final String mXgateKey = "xgate_key";
    private static final String[] mMainMsg = new String[]{"\uc138\uc158 \uc0c1\ud0dc", "\uc5f0\uacb0 \uc2dc\uac04", "\uc11c\ubc84 \uc778\uc99d\uc11c", "\uc0ac\uc6a9\uc790 \uc778\uc99d\uc11c"};
    private TextView mSessionDetailView;
    private String[] mSessionDetailInfo;
    private XDetailData mXDetailData;
    private XDetailData mServerCertData;
    private XDetailData mClientCertData;
    private SessionMgr mSessionMgr;
    private String mCurXgateAddr;

    protected void onCreate(Bundle savedInstanceState) {
        this.mSessionMgr = SessionMgr.getInstance();
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.crypto_xecure_smart_session_detail);
        this.mSessionDetailView = (TextView)this.findViewById(R.id.xgate_addr);
        this.setDetailInfo();
        this.setListAdapter((ListAdapter)new SessionDetailInfoAdapter((Activity)this));
        final XecureSmartSessionDetail aContext = this;
        Button aImageButton = (Button)this.findViewById(R.id.top_right_button);
        aImageButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                aContext.onClickTopButton();
            }
        });
    }

    protected void onClickTopButton() {
        Intent aIntent = new Intent();
        int aResult = 0;
        aResult = this.mSessionMgr.deleteSession(this.mCurXgateAddr);
        if (0 == aResult) {
            aIntent.putExtra("is_delete_session_succeed_key", true);
            this.setResult(-1, aIntent);
        }
        this.finish();
    }

    public void setDetailInfo() {
        Intent aIntent = this.getIntent();
        this.mCurXgateAddr = aIntent.getStringExtra(mXgateKey);
        String aDetailInfo = this.mSessionMgr.getSessionDetail(this.mCurXgateAddr);
        this.mXDetailData = (XDetailData)XDetailDataParser.parse((String)aDetailInfo, (int)2).get(0);
        this.mSessionDetailView.setText((CharSequence)this.mCurXgateAddr);
        this.mSessionDetailInfo = new String[4];
        this.mSessionDetailInfo[0] = this.mXDetailData.getValue(0);
        this.mSessionDetailInfo[1] = this.mXDetailData.getValue(1);
        this.mSessionDetailInfo[2] = this.mXDetailData.getValue(2);
        this.mSessionDetailInfo[3] = this.mXDetailData.getValue(3);
        String aServerCert = this.mSessionMgr.getSessionServerCert(this.mCurXgateAddr);
        String aClientCert = this.mSessionMgr.getSessionServerCert(this.mCurXgateAddr);
        this.mServerCertData = (XDetailData)XDetailDataParser.parse((String)aServerCert, (int)0).get(0);
        this.mClientCertData = (XDetailData)XDetailDataParser.parse((String)aClientCert, (int)0).get(0);
    }

    public void onBackPressed() {
        this.setResult(0);
        this.finish();
    }

    protected void onListItemClick(ListView l, View v, int position, long id2) {
        Intent aResultIntent = new Intent((Context)this, XecureSmartCertDetailInfo.class);
        switch (position) {
            case 2: {
                aResultIntent.putExtra("parsed_xdetail_data_key", this.mServerCertData.getValueArray());
                this.startActivity(aResultIntent);
                break;
            }
            case 3: {
                if (this.mSessionDetailInfo[3].length() == 0) break;
                aResultIntent.putExtra("parsed_xdetail_data_key", this.mClientCertData.getValueArray());
                this.startActivity(aResultIntent);
            }
        }
    }

    private class SessionDetailInfoAdapter
    extends ArrayAdapter<String> {
        Activity mContext;

        public SessionDetailInfoAdapter(Activity context) {
            super((Context)context, R.layout.session_detail_data_row, (Object[])mMainMsg);
            this.mContext = context;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            View aRowView = convertView;
            SessionsRowItemHolder aSessionsRowItemHolder = null;
            if (null == aRowView) {
                LayoutInflater aInflater = this.mContext.getLayoutInflater();
                aRowView = aInflater.inflate(R.layout.session_detail_data_row, null);
                aSessionsRowItemHolder = new SessionsRowItemHolder();
                aSessionsRowItemHolder.aMainMsg = (TextView)aRowView.findViewById(R.id.main_msg);
                aSessionsRowItemHolder.aSubMsg = (TextView)aRowView.findViewById(R.id.sub_msg);
                aRowView.setTag((Object)aSessionsRowItemHolder);
            } else {
                aSessionsRowItemHolder = (SessionsRowItemHolder)aRowView.getTag();
            }
            aSessionsRowItemHolder.aMainMsg.setText((CharSequence)mMainMsg[position]);
            if (position == 0) {
                if ("0".equals(XecureSmartSessionDetail.this.mSessionDetailInfo[0])) {
                    aSessionsRowItemHolder.aSubMsg.setText(R.string.annonymous_ssl);
                } else {
                    aSessionsRowItemHolder.aSubMsg.setText(R.string.user_ssl);
                }
            } else {
                aSessionsRowItemHolder.aSubMsg.setText((CharSequence)XecureSmartSessionDetail.this.mSessionDetailInfo[position]);
            }
            return aRowView;
        }

        private class SessionsRowItemHolder {
            TextView aMainMsg;
            TextView aSubMsg;

            private SessionsRowItemHolder() {
            }
        }
    }
}

