/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.ui.crypto;

import android.app.Activity;
import android.app.ListActivity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.softforum.sample.R;
import com.softforum.xecure.crypto.SessionMgr;
import com.softforum.xecure.ui.crypto.XecureSmartSessionDetail;
import com.softforum.xecure.util.XDetailData;
import com.softforum.xecure.util.XDetailDataParser;
import java.util.ArrayList;

public class XecureSmartSessionList
extends ListActivity {
    public static final int mXecureSmartSessionListID = 71200;
    public static final String mIsDeleteSessionSucceedKey = "is_delete_session_succeed_key";
    private String[] mXgateAddr;
    private String[] mSessions;
    private String[] mUsers;
    private ListView mListView;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.crypto_xecure_smart_session_list);
        this.mListView = this.getListView();
        this.setSessionInfo();
    }

    public void setSessionInfo() {
        SessionMgr aSessionMgr = SessionMgr.getInstance();
        String aSessionList = aSessionMgr.getSessionList();
        if (!"".equals(aSessionList)) {
            ArrayList aXSessionData = XDetailDataParser.parse((String)aSessionList, (int)1);
            this.mSessions = new String[aXSessionData.size()];
            this.mUsers = new String[aXSessionData.size()];
            this.mXgateAddr = new String[aXSessionData.size()];
            for (int i = 0; i < aXSessionData.size(); ++i) {
                String aXgateAddr = ((XDetailData)aXSessionData.get(i)).getValue(0);
                String aCurSession = ((XDetailData)aXSessionData.get(i)).getValue(1);
                String aCurUser = ((XDetailData)aXSessionData.get(i)).getValue(2);
                this.mXgateAddr[i] = aXgateAddr;
                this.mSessions[i] = aCurSession;
                this.mUsers[i] = aCurUser;
            }
            this.setListAdapter((ListAdapter)new SessionListAdapter((Activity)this));
        }
    }

    protected void onListItemClick(ListView l, View v, int position, long id2) {
        String aSelectedMenuItem = (String)l.getItemAtPosition(position);
        if (aSelectedMenuItem.length() != 0) {
            Intent aIntent = new Intent((Context)this, XecureSmartSessionDetail.class);
            aIntent.putExtra("xgate_key", this.mXgateAddr[position]);
            this.startActivityForResult(aIntent, 71100);
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        boolean aIsDeleted = false;
        switch (requestCode) {
            case 71100: {
                if (-1 != resultCode || !(aIsDeleted = data.getBooleanExtra(mIsDeleteSessionSucceedKey, false))) break;
                this.mListView.removeAllViewsInLayout();
                this.setSessionInfo();
            }
        }
    }

    public void onBackPressed() {
        this.setResult(0);
        this.finish();
    }

    private class SessionListAdapter
    extends ArrayAdapter<String> {
        Activity mContext;

        public SessionListAdapter(Activity context) {
            super((Context)context, R.layout.session_data_row, (Object[])XecureSmartSessionList.this.mSessions);
            this.mContext = context;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            View aRowView = convertView;
            SessionsRowItemHolder aSessionsRowItemHolder = null;
            if (null == aRowView) {
                LayoutInflater aInflater = this.mContext.getLayoutInflater();
                aRowView = aInflater.inflate(R.layout.session_data_row, null);
                aSessionsRowItemHolder = new SessionsRowItemHolder();
                aSessionsRowItemHolder.aDN = (TextView)aRowView.findViewById(R.id.dn_value);
                aSessionsRowItemHolder.aCN = (TextView)aRowView.findViewById(R.id.user_value);
                aRowView.setTag((Object)aSessionsRowItemHolder);
            } else {
                aSessionsRowItemHolder = (SessionsRowItemHolder)aRowView.getTag();
            }
            aSessionsRowItemHolder.aDN.setText((CharSequence)XecureSmartSessionList.this.mSessions[position]);
            if (XecureSmartSessionList.this.mUsers[position].length() == 0 && XecureSmartSessionList.this.mSessions[position].length() != 0) {
                aSessionsRowItemHolder.aCN.setText(R.string.anonymous_user);
            } else {
                aSessionsRowItemHolder.aCN.setText((CharSequence)XecureSmartSessionList.this.mUsers[position]);
            }
            return aRowView;
        }

        private class SessionsRowItemHolder {
            TextView aDN;
            TextView aCN;

            private SessionsRowItemHolder() {
            }
        }
    }
}

