/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.ui.transkey;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import com.softforum.sample.R;
import com.softforum.xecure.ui.XTopView;
import com.softforum.xecure.ui.crypto.XecureSmartInputVID;
import com.softforum.xecure.ui.transkey.TransKeyResultInterface;
import com.softforum.xecure.ui.transkey.TransKeyUtil;
import com.softforum.xecure.util.BlockerActivityResult;
import com.softforum.xecure.util.BlockerActivityUtil;
import com.softforum.xecure.util.EnvironmentConfig;
import com.softforum.xecure.util.XUtil;
import java.security.SecureRandom;

public class XecureSmartInputVIDWithTransKey
extends Activity
implements TransKeyResultInterface {
    public static final int mXecureSmartInputVidID = 80000;
    public static final String mXecureSmartInputVidKey = "xecure_smart_input_vid_key";
    private BlockerActivityResult mBlockerParam;
    private byte[] mVid = null;
    private String mEncryptedData = null;
    private byte[] mRandomValue = new byte[20];
    private TransKeyUtil mTransKeyUtil = new TransKeyUtil();
    private final int[] mTransKeyTextIds = new int[]{R.id.vid_edittext};
    private final int[] mTransKeyTextStrings = new int[]{R.string.resident_registration_number};
    private final int[] mTransKeyMaxLength = new int[]{13};
    private final int[] mTransKeyTextKeypadTypes = new int[]{4};

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent receivedIntent = this.getIntent();
        this.mBlockerParam = BlockerActivityUtil.getParam((Context)this, (Intent)receivedIntent);
        this.setContentView(R.layout.crypto_xecure_smart_input_vid);
        Button aOKButton = (Button)this.findViewById(R.id.top_right_button);
        aOKButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XecureSmartInputVIDWithTransKey.this.onOKButtonClick(v);
            }
        });
        if (EnvironmentConfig.mMTransKeyEncryptionUsage) {
            SecureRandom aSecureRandom = new SecureRandom();
            aSecureRandom.nextBytes(this.mRandomValue);
            this.mTransKeyUtil.setRandomValue(this.mRandomValue);
        }
        this.mTransKeyUtil.setMTransKey(this, this.mTransKeyTextIds, this.mTransKeyTextStrings, this.mTransKeyMaxLength, this.mTransKeyTextKeypadTypes);
    }

    private void onOKButtonClick(View v) {
        boolean aIsEmpty = false;
        XTopView aTopView = (XTopView)this.findViewById(R.id.top_view);
        if (EnvironmentConfig.mMTransKeyEncryptionUsage) {
            if (this.mEncryptedData == null || this.mEncryptedData.length() == 0) {
                aIsEmpty = true;
            }
        } else if (this.mVid == null || this.mVid.length == 0) {
            aIsEmpty = true;
        }
        if (aIsEmpty) {
            aTopView.setDescription(this.getString(R.string.xecure_smart_cert_mgr_copy_wrong_vid));
            return;
        }
        Intent aIntent = new Intent((Context)this, XecureSmartInputVID.class);
        if (EnvironmentConfig.mMTransKeyEncryptionUsage) {
            aIntent.putExtra("random_value_key", this.mRandomValue);
            aIntent.putExtra("e_ncrypted_data_key", this.mEncryptedData);
        } else {
            aIntent.putExtra("vid_key", this.mVid);
        }
        this.mBlockerParam.setBlockerResult(-1, aIntent);
        this.finish();
    }

    public void onBackPressed() {
        super.onBackPressed();
        XUtil.resetByteArray((byte[][])new byte[][]{this.mVid, this.mRandomValue});
        Intent aIntent = new Intent((Context)this, XecureSmartInputVID.class);
        this.mBlockerParam.setBlockerResult(0, aIntent);
        this.finish();
    }

    public void finish() {
        XUtil.resetByteArray((byte[][])new byte[][]{this.mVid});
        BlockerActivityUtil.finishBlockerActivity((Object)this.mBlockerParam);
        super.finish();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.mTransKeyUtil.transKeyActivityResult(this, requestCode, resultCode, data, this.mTransKeyTextIds);
    }

    @Override
    public void setTransKeyResult(int index, byte[] result) {
        switch (index) {
            case 0: {
                if (result == null) break;
                this.mVid = (byte[])result.clone();
            }
        }
    }

    @Override
    public void setTransKeyResult(int pIndex, String pEncryptedData) {
        switch (pIndex) {
            case 0: {
                if (pEncryptedData == null) break;
                this.mEncryptedData = pEncryptedData;
            }
        }
    }

    @Override
    public void doNext() {
        boolean aExistResult = false;
        aExistResult = EnvironmentConfig.mMTransKeyEncryptionUsage ? this.mTransKeyUtil.isResultsNotEmpty(this.mEncryptedData) : this.mTransKeyUtil.isResultsNotEmpty(new byte[][]{this.mVid});
        if (aExistResult) {
            this.onOKButtonClick(null);
        }
        XUtil.resetByteArray((byte[][])new byte[][]{this.mVid, this.mRandomValue});
    }
}

