/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.ui.transkey;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import com.softforum.sample.R;
import com.softforum.xecure.core.CoreWrapper;
import com.softforum.xecure.crypto.CertMgr;
import com.softforum.xecure.ui.XTopView;
import com.softforum.xecure.ui.transkey.TransKeyResultInterface;
import com.softforum.xecure.ui.transkey.TransKeyUtil;
import com.softforum.xecure.util.EnvironmentConfig;
import com.softforum.xecure.util.XCoreUtil;
import com.softforum.xecure.util.XDetailData;
import com.softforum.xecure.util.XSLog;
import com.softforum.xecure.util.XUtil;
import java.security.SecureRandom;

public class XecureSmartMoveCertificateToAppDataWithTransKey
extends Activity
implements TransKeyResultInterface {
    public static final int mXecureSmartMoveCertofocateToAppDataID = 120000;
    public static final String mMediaIDKey = "sign_cert_password_media_id_key";
    public static final String mSelectedCertDataKey = "sign_cert_password_selected_cert_data_key";
    public static final String m_P_assW_ordKey = "sign_cert_password_password_key";
    public static final String mOldPasswordKey = "old_cert_password_password_key";
    public static final int RESULT_PASSWD_FAIL = 2;
    private int mSrcMediaID;
    private int mDstMediaID;
    private XDetailData mSelectedData;
    private byte[] m_P_assW_ord = null;
    private int m_P_assW_ordTryCount;
    private XCoreUtil mCoreUtil = new XCoreUtil();
    private TransKeyUtil mTransKeyUtil = new TransKeyUtil();
    private String mEncryptedData = null;
    private byte[] mRandomValue = new byte[20];
    private final int[] mTransKeyTextIds = new int[]{R.id.password_edittext};
    private final int[] mTransKeyTextStrings = new int[]{R.string.password};
    private final int[] mTransKeyMaxLength = new int[]{150};

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.crypto_sign_cert_password_window);
        this.m_P_assW_ordTryCount = 0;
        this.mSrcMediaID = this.getIntent().getIntExtra("mSrcMediaID", 1);
        this.mDstMediaID = this.getIntent().getIntExtra("mDstMediaID", 1);
        this.mSelectedData = new XDetailData(this.getIntent().getStringArrayExtra(mSelectedCertDataKey), 0);
        ImageView aIcon = (ImageView)this.findViewById(R.id.icon);
        TextView aMainMsg = (TextView)this.findViewById(R.id.main_msg);
        TextView aSubMsg1 = (TextView)this.findViewById(R.id.sub_msg1);
        TextView aSubMsg2 = (TextView)this.findViewById(R.id.sub_msg2);
        if ("0".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_normal);
        } else if ("1".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_update);
        } else if ("2".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_revoke);
        }
        aMainMsg.setText((CharSequence)XUtil.getCNFromRDN((String)this.mSelectedData.getValue(7)));
        aSubMsg1.setText((CharSequence)(this.mSelectedData.getKeyText(4) + " : " + this.mSelectedData.getValue(4)));
        aSubMsg2.setText((CharSequence)(this.mSelectedData.getKeyText(6) + " : " + this.mSelectedData.getValue(6)));
        if (EnvironmentConfig.mMTransKeyEncryptionUsage) {
            SecureRandom aSecureRandom = new SecureRandom();
            aSecureRandom.nextBytes(this.mRandomValue);
            this.mTransKeyUtil.setRandomValue(this.mRandomValue);
        }
        this.mTransKeyUtil.setMTransKey(this, this.mTransKeyTextIds, this.mTransKeyTextStrings, this.mTransKeyMaxLength, null);
        Button aOKButton = (Button)this.findViewById(R.id.top_right_button);
        aOKButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XecureSmartMoveCertificateToAppDataWithTransKey.this.onOKButtonClick(v);
            }
        });
    }

    private void onOKButtonClick(View v) {
        int aVerifyResult = 0;
        boolean aIsEmpty = false;
        String aSubjectRDN = null;
        CertMgr aCertMgr = null;
        XTopView aTopView = null;
        EditText aPasswordEditText = null;
        aTopView = (XTopView)this.findViewById(R.id.top_view);
        aPasswordEditText = (EditText)this.findViewById(R.id.password_edittext);
        this.mCoreUtil.resetError();
        if (EnvironmentConfig.mMTransKeyEncryptionUsage) {
            if (this.mEncryptedData == null || this.mEncryptedData.length() == 0) {
                aIsEmpty = true;
            }
        } else if (this.m_P_assW_ord == null || this.m_P_assW_ord.length == 0) {
            aIsEmpty = true;
        }
        if (aIsEmpty) {
            aTopView.setDescription(this.getString(R.string.plugin_input_nothing));
            return;
        }
        aCertMgr = CertMgr.getInstance();
        aSubjectRDN = this.mSelectedData.getValue(7);
        aVerifyResult = EnvironmentConfig.mMTransKeyEncryptionUsage ? aCertMgr.verifyPassword(this.mSrcMediaID, aSubjectRDN, this.mRandomValue, this.mEncryptedData) : aCertMgr.verifyPassword(this.mSrcMediaID, 14, aSubjectRDN, this.m_P_assW_ord);
        if (aVerifyResult != 0) {
            aTopView.setDescription(this.mCoreUtil.lastErrMsg());
            this.m_P_assW_ord = null;
            aPasswordEditText.setText((CharSequence)"");
            if (++this.m_P_assW_ordTryCount >= 3) {
                this.setResult(2);
                this.finish();
            }
        } else {
            new AlertDialog.Builder((Context)this).setTitle((CharSequence)"\uc8fc\uc758").setMessage((CharSequence)"APPDATA\ub85c \uc778\uc99d\uc11c\ub97c \uc774\ub3d9\uc2dc \uae30\uc874SDCARD\uc758 \uc778\uc99d\uc11c\ub294 \uc0ad\uc81c\ub429\ub2c8\ub2e4. \uacc4\uc18d\ud558\uc2dc\uaca0\uc2b5\ub2c8\uae4c?").setPositiveButton((CharSequence)"YES", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    XecureSmartMoveCertificateToAppDataWithTransKey.this.moveCertificate();
                }
            }).setNegativeButton((CharSequence)"NO", null).show();
        }
    }

    private void moveCertificate() {
        int aResult = 0;
        String aSubjectDN = null;
        CertMgr aCertMgr = null;
        XTopView aTopView = null;
        Intent aIntent = null;
        aCertMgr = CertMgr.getInstance();
        aSubjectDN = this.mSelectedData.getValue(7);
        aTopView = (XTopView)this.findViewById(R.id.top_view);
        aIntent = new Intent();
        aResult = EnvironmentConfig.mMTransKeyEncryptionUsage ? CoreWrapper.saveCertWithKDF((String)aSubjectDN, (byte[])this.mRandomValue, (String)this.mEncryptedData, (int)this.mSrcMediaID, (int)3, (int)14, (int)this.mDstMediaID) : CoreWrapper.saveCert((String)aSubjectDN, (byte[])this.m_P_assW_ord, (int)this.mSrcMediaID, (int)3, (int)14, (int)this.mDstMediaID);
        XSLog.d((String)(this.getClass().getName() + "::Save to APPDATA Cert result : " + aResult));
        if (aResult != 0) {
            aTopView.setDescription("APPDATA\ub85c \uc778\uc99d\uc11c \uc774\ub3d9\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4.");
            this.setResult(2, aIntent);
        } else {
            aResult = aCertMgr.deleteCertificateWithSubjectDN(this.mSrcMediaID, 3, aSubjectDN);
            XSLog.d((String)(this.getClass().getName() + "::DeleteCert result : " + aResult));
            if (aResult != 0) {
                aTopView.setDescription("\uc778\uc99d\uc11c \uc0ad\uc81c\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4.");
                this.setResult(2, aIntent);
            } else {
                aIntent.putExtra("xecure_smart_cert_mgr_result_key", 3);
                this.setResult(-1, aIntent);
                this.finish();
            }
        }
    }

    public void onBackPressed() {
        XUtil.resetByteArray((byte[][])new byte[][]{this.m_P_assW_ord, this.mRandomValue});
        super.onBackPressed();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.mTransKeyUtil.transKeyActivityResult(this, requestCode, resultCode, data, this.mTransKeyTextIds);
        Intent aIntent = new Intent();
        if (resultCode == 4) {
            this.setResult(-1, aIntent);
            this.finish();
        } else if (resultCode == 6) {
            this.setResult(6);
            this.finish();
        }
    }

    @Override
    public void setTransKeyResult(int index, byte[] result) {
        switch (index) {
            case 0: {
                if (result == null) break;
                this.m_P_assW_ord = (byte[])result.clone();
            }
        }
    }

    @Override
    public void setTransKeyResult(int pIndex, String pEncryptedData) {
        switch (pIndex) {
            case 0: {
                if (pEncryptedData == null) break;
                this.mEncryptedData = pEncryptedData;
            }
        }
    }

    @Override
    public void doNext() {
        boolean aExistResult = false;
        aExistResult = EnvironmentConfig.mMTransKeyEncryptionUsage ? this.mTransKeyUtil.isResultsNotEmpty(this.mEncryptedData) : this.mTransKeyUtil.isResultsNotEmpty(new byte[][]{this.m_P_assW_ord});
        if (aExistResult) {
            this.onOKButtonClick(null);
        }
        XUtil.resetByteArray((byte[][])new byte[][]{this.m_P_assW_ord, this.mRandomValue});
    }
}

