/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.yessign;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.widget.Button;
import android.widget.Toast;
import com.softforum.sample.R;
import com.softforum.xecure.core.CoreWrapper;
import com.softforum.xecure.util.XDetailData;
import com.softforum.xecure.util.XSLog;
import com.softforum.xecure.util.XUtil;
import com.softforum.xecure.yessign.ConnectToYessignApp;
import com.softforum.xecure.yessign.SelectExportCertificateList;
import com.softforum.xecure.yessign.YessignApplicationUtil;

public class ExportCertificateToYessign
extends Activity {
    public static final String mOperationResultKey = "xecure_smart_result_key";
    public static final int mResultForExportCertOK = 1;
    private static XDetailData mCertificateInfo = null;
    private static int mMediaID;
    private Thread mExportCertificateThread;
    private static byte[] mCertificateDER;
    private static byte[] mKeyDER;
    private static byte[] mKMCertificateDER;
    private static byte[] mKMKeyDER;
    private static Intent mIntent;
    private ProgressDialog mProgressDialog;
    private String aProgressDialogMessage = "";
    Handler mViewControlHandler;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.export_certificate_to_yessign);
        XUtil.initializeXecureCoreConfig((Context)this.getApplicationContext(), (boolean)false);
        mIntent = this.getIntent();
        Button aExportButton = null;
        aExportButton = (Button)this.findViewById(R.id.top_right_button);
        aExportButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View pView) {
                Intent aIntent = null;
                if (ExportCertificateToYessign.this.getCallingActivity() == null) {
                    ExportCertificateToYessign.this.ShowProgressDialog(ExportCertificateToYessign.this.getString(R.string.message_fail_get_caller));
                }
                ExportCertificateToYessign.this.verifyReceivedIntent(ExportCertificateToYessign.this.getCallingPackage());
                aIntent = new Intent((Context)ExportCertificateToYessign.this, SelectExportCertificateList.class);
                aIntent.putExtra("ChoiceAction", 2);
                ExportCertificateToYessign.this.startActivityForResult(aIntent, 72800);
            }
        });
    }

    private void ShowProgressDialog(String pProgressDialogMessage) {
        this.mViewControlHandler = new Handler();
        if (this.mProgressDialog == null) {
            this.mProgressDialog = ProgressDialog.show((Context)this, (CharSequence)"Waiting", (CharSequence)pProgressDialogMessage, (boolean)true, (boolean)false);
            this.mProgressDialog.setCanceledOnTouchOutside(false);
        }
    }

    private void verifyReceivedIntent(String callingPackageName) {
        final String fCallingPackageName = callingPackageName;
        this.aProgressDialogMessage = "\ud638\ucd9c\ud55c \uc571\uc774 \uc2e0\ub8b0\ud560\uc218 \uc788\ub294 \uc571\uc778\uc9c0 \uac80\uc99d\ud558\ub294 \uc911 \uc785\ub2c8\ub2e4.";
        this.ShowProgressDialog(this.aProgressDialogMessage);
        YessignApplicationUtil.queryTrustedApplicationList(this.getApplicationContext(), ConnectToYessignApp.testConfiguration, new YessignApplicationUtil.OnCompleteListener<byte[]>(){

            @Override
            public void onComplete(byte[] result, Exception exception) {
                if (exception != null) {
                    if (ExportCertificateToYessign.this.mProgressDialog != null) {
                        ExportCertificateToYessign.this.mProgressDialog.dismiss();
                    }
                    ExportCertificateToYessign.this.ErrorMessage(exception.getMessage());
                    return;
                }
                boolean integrity = YessignApplicationUtil.checkReceivedIntent(ExportCertificateToYessign.this.getApplicationContext(), result, fCallingPackageName, mIntent);
                if (!integrity) {
                    if (ExportCertificateToYessign.this.mProgressDialog != null) {
                        ExportCertificateToYessign.this.mProgressDialog.dismiss();
                    }
                    ExportCertificateToYessign.this.ErrorMessage(ExportCertificateToYessign.this.getString(R.string.message_not_registered_caller));
                    return;
                }
                if (ExportCertificateToYessign.this.mProgressDialog != null) {
                    ExportCertificateToYessign.this.mProgressDialog.dismiss();
                }
            }
        });
    }

    public static void setCertificate(XDetailData pCertificate, int pMediaID) {
        mCertificateInfo = pCertificate;
        mMediaID = pMediaID;
    }

    private void processReceivedIntent() {
        this.exportCertificate();
    }

    protected void exportCertificate() {
        this.aProgressDialogMessage = "\uc778\uc99d\uc11c\ub97c \uacf5\uc6a9\uc571\uc73c\ub85c \ub0b4\ubcf4\ub0b4\ub294 \uc911 \uc785\ub2c8\ub2e4.";
        this.ShowProgressDialog(this.aProgressDialogMessage);
        this.mExportCertificateThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String aSubjectRDN = mCertificateInfo.getValue(2);
                    ExportCertificateToYessign.access$602(CoreWrapper.getExportRawSignCert((int)mMediaID, (String)aSubjectRDN));
                    ExportCertificateToYessign.access$802(CoreWrapper.getExportRawSignKey((int)mMediaID, (String)aSubjectRDN));
                    ExportCertificateToYessign.access$902(CoreWrapper.getExportRawKmCert((int)mMediaID, (String)aSubjectRDN));
                    ExportCertificateToYessign.access$1002(CoreWrapper.getExportRawKmKey((int)mMediaID, (String)aSubjectRDN));
                    if (mCertificateDER.length < 1 && mKMCertificateDER.length < 1) {
                        ExportCertificateToYessign.this.ErrorMessage("\uc778\uc99d\uc11c \ub0b4\ubcf4\ub0b4\uae30\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4.");
                    }
                    ExportCertificateToYessign.this.toastIntent("\uacf5\uc6a9\uc571\uc774 XecureSmart\ub85c\ubd80\ud130 \uc778\uc99d\uc11c \uac00\uc838\uc624\uae30(\uc694\uccad)", "00", mCertificateDER, mKMCertificateDER);
                    Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)"yessign-cert-gw://localhost/certget"));
                    intent.putExtra("result", "00");
                    intent.putExtra("cert", mCertificateDER);
                    intent.putExtra("key", mKeyDER);
                    intent.putExtra("kmcert", mKMCertificateDER);
                    intent.putExtra("kmkey", mKMKeyDER);
                    if (ExportCertificateToYessign.this.mProgressDialog != null) {
                        ExportCertificateToYessign.this.mProgressDialog.dismiss();
                    }
                    YessignApplicationUtil.printIntent("BANK-RECV-REQ", mIntent);
                    ExportCertificateToYessign.this.setResult(-1, intent);
                    ExportCertificateToYessign.this.finish();
                }
                catch (NullPointerException e) {
                    ExportCertificateToYessign.this.ErrorMessage("\uc778\uc99d\uc11c \ub0b4\ubcf4\ub0b4\uae30\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4.");
                }
            }
        });
        this.mExportCertificateThread.start();
    }

    private void toastIntent(final String pMessage, final String pResult, final byte[] mCertificateDER, final byte[] mKMCertificateDER) {
        this.mViewControlHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    StringBuilder builder = new StringBuilder();
                    builder.append(pMessage);
                    if (pResult != null) {
                        builder.append("\n").append("\uacb0\uacfc:").append(pResult);
                    }
                    if (mCertificateDER != null && mCertificateDER.length > 1) {
                        builder.append("\n").append("\uc11c\uba85\uc6a9\uc778\uc99d\uc11c:").append(YessignApplicationUtil.getCertSubjectDn(mCertificateDER));
                    } else {
                        builder.append("\n").append("\uc11c\uba85\uc6a9\uc778\uc99d\uc11c:").append(YessignApplicationUtil.getCertSubjectDn(mKMCertificateDER));
                    }
                    Toast.makeText((Context)ExportCertificateToYessign.this, (CharSequence)builder.toString(), (int)1).show();
                }
                catch (NullPointerException e) {
                    XSLog.e((String)e.getMessage());
                }
            }
        });
    }

    private void ErrorMessage(final String pMessage) {
        this.mViewControlHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    new AlertDialog.Builder((Context)ExportCertificateToYessign.this).setMessage((CharSequence)pMessage).setPositiveButton((CharSequence)"\ud655\uc778", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            mIntent.putExtra("result", "11");
                            YessignApplicationUtil.printIntent("BANK-SEND-RESP", mIntent);
                            if (ExportCertificateToYessign.this.mProgressDialog != null) {
                                ExportCertificateToYessign.this.mProgressDialog.dismiss();
                            }
                            ExportCertificateToYessign.this.setResult(-1, mIntent);
                            ExportCertificateToYessign.this.finish();
                        }
                    }).show();
                }
                catch (NullPointerException e) {
                    XSLog.e((String)e.getMessage());
                }
            }
        });
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        int aResultFromThat = -1;
        if (data != null) {
            aResultFromThat = data.getIntExtra(mOperationResultKey, -1);
        }
        if (aResultFromThat == 1) {
            this.processReceivedIntent();
        } else {
            this.ErrorMessage("\uc778\uc99d\uc11c \ub0b4\ubcf4\ub0b4\uae30\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    static /* synthetic */ byte[] access$602(byte[] x0) {
        mCertificateDER = x0;
        return x0;
    }

    static /* synthetic */ byte[] access$802(byte[] x0) {
        mKeyDER = x0;
        return x0;
    }

    static /* synthetic */ byte[] access$902(byte[] x0) {
        mKMCertificateDER = x0;
        return x0;
    }

    static /* synthetic */ byte[] access$1002(byte[] x0) {
        mKMKeyDER = x0;
        return x0;
    }

    static {
        mCertificateDER = null;
        mKeyDER = null;
        mKMCertificateDER = null;
        mKMKeyDER = null;
        mIntent = null;
    }
}

