/*
 * Decompiled with CFR 0.152.
 */
package com.consortium.smartusim;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Build;
import android.os.IBinder;
import android.os.RemoteException;
import android.telephony.TelephonyManager;
import com.consortium.smartusim.SmartUsimListener;
import com.consortium.smartusim.SmartUsimResultCode;
import com.dreamsecurity.usim.smartcert3rd.SmartCertFilterType;
import com.dreamsecurity.usim.smartcert3rd.SmartCertInfoType;
import com.dreamsecurity.usim.smartcert3rd.SmartCertResult;
import com.dreamsecurity.usim.smartcert3rd.SmartCertSignOption;
import com.dreamsecurity.usim.smartcert3rd.SmartCertSignType;
import com.dreamsecurity.usim.smartcert3rd.client.SmartCertActivity;
import com.dreamsecurity.usim.smartcert3rd.client.SmartCertAidl;
import com.dreamsecurity.usim.smartcert3rd.client.SmartCertInstall;
import com.dreamsecurity.usim.smartcert3rd.client.SmartCertListener;
import com.raon.common.KSBase64;
import com.raon.common.KSHex;
import com.raonsecure.api.RaonException;
import com.raonsecure.api.RaonLogger;
import com.raonsecure.api.Raon_Usim_Api;
import com.raonsecure.service.GetCertList;
import com.raonsecure.service.GetCertList_Parcel;
import com.raonsecure.service.IRemoteInterface;
import com.raonsecure.service.KSCertificate;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class SmartUsim
implements SmartCertListener,
ServiceConnection {
    private static SmartUsim mThis = null;
    private Context mContext = null;
    private SmartUsimListener mSmartUsimListener = null;
    private SmartUsimResultCode mResultCode = null;
    private int mUsimMember = 11;
    private int mPossibleService = 1004;
    private boolean mIsUpdateApp = false;
    private Map<Integer, String> mMapFilterCert = new HashMap<Integer, String>();
    private int mServiceVendor = 0;
    private int mFlagFilterCert = 0;
    private int mSelectVendor = 0;
    private SmartCertInstall dream_Install = null;
    public SmartCertAidl dream_Aidl = null;
    private Boolean dream_bind = false;
    private String mSiteID = "";
    private IRemoteInterface mRemoteInterface = null;
    private Boolean flag_mBound = false;
    private String mCpCode = "";
    private int mcert_count = 0;
    private int[] roomlist = null;
    private GetCertList mgetcertlist = null;
    private boolean isNoMemberRaon = false;
    private final String[][] ISSUERTABLE = new String[][]{{"CROSSCERT", "\ud55c\uad6d\uc804\uc790\uc778\uc99d"}, {"KICA", "\ud55c\uad6d\uc815\ubcf4\uc778\uc99d"}, {"SIGNKOREA", "\ucf54\uc2a4\ucf64"}, {"TRADESIGN", "KT-NET"}, {"YESSIGN", "\uae08\uc735\uacb0\uc81c\uc6d0"}, {"CertRSA01", "KISA"}, {"KISA RootCA 1", "KISA"}, {"KISA RootCA 4", "KISA"}, {"yessignCA Class 1", "\uae08\uc735\uacb0\uc81c\uc6d0"}, {"yessignCA", "\uae08\uc735\uacb0\uc81c\uc6d0"}, {"SignKorea CA", "\ucf54\uc2a4\ucf64"}, {"signGATE CA", "\ud55c\uad6d\uc815\ubcf4\uc778\uc99d"}, {"signGATE CA2", "\ud55c\uad6d\uc815\ubcf4\uc778\uc99d"}, {"signGATE FTCA02", "\ud55c\uad6d\uc815\ubcf4\uc778\uc99d"}, {"CrossCertCA", "\ud55c\uad6d\uc804\uc790\uc778\uc99d"}, {"TradeSignCA", "KT-NET"}};

    public static synchronized SmartUsim getInstance(Context context, SmartUsimListener listener, String siteID, String cpCode, int selectVendor) {
        if (listener == null) {
            return null;
        }
        if (siteID == null || cpCode == null) {
            return null;
        }
        if (siteID.length() <= 0 || cpCode.length() <= 0) {
            return null;
        }
        if (selectVendor <= 0 || selectVendor > 2) {
            return null;
        }
        if (mThis == null) {
            mThis = new SmartUsim(context);
        }
        SmartUsim.mThis.mSiteID = siteID;
        SmartUsim.mThis.mCpCode = cpCode;
        SmartUsim.mThis.mSelectVendor = selectVendor;
        mThis.setListener(listener);
        return mThis;
    }

    private SmartUsim(Context context) {
        this.mContext = context;
        this.mResultCode = new SmartUsimResultCode();
    }

    private void setListener(SmartUsimListener listener) {
        this.mSmartUsimListener = listener;
    }

    public void onSmartCertIntalled(SmartCertResult result) {
        if (result.getResultCode() == 0) {
            this.mResultCode.setResultCode(0, result.getResultCode());
        } else {
            this.mResultCode.setResultCode(9002, result.getResultCode());
        }
        this.mSmartUsimListener.onSmartUsimResult(3, this.mResultCode);
    }

    public boolean isInstalled() {
        boolean bInstall = false;
        boolean isInstallRaon = false;
        boolean isInstallDream = false;
        isInstallRaon = this.isInstall_Raon();
        isInstallDream = this.isInstall_Dream();
        if (this.mUsimMember == 11) {
            this.isMember();
        }
        switch (this.mUsimMember) {
            case 12: {
                if (!(this.mServiceVendor == 1 && isInstallRaon || this.mServiceVendor == 2 && isInstallDream) && (!isInstallDream || !isInstallRaon)) break;
                bInstall = true;
                break;
            }
            case 13: {
                if (!(this.mServiceVendor == 1 && isInstallRaon || this.mServiceVendor == 2 && isInstallDream) && (!isInstallDream || !isInstallRaon)) break;
                bInstall = true;
                break;
            }
            case 14: {
                bInstall = false;
                break;
            }
        }
        return bInstall;
    }

    public void install() {
        if (this.mServiceVendor == 0 && this.mUsimMember == 11) {
            this.isMember();
        }
        if (this.mServiceVendor == 0 && this.mUsimMember == 14) {
            this.mSmartUsimListener.onSmartUsimResult(3, this.mResultCode);
            return;
        }
        switch (this.mServiceVendor) {
            case 1: {
                try {
                    if (!this.mIsUpdateApp && this.isInstall_Raon()) {
                        this.mResultCode.setResultCode(0, 1);
                        this.mSmartUsimListener.onSmartUsimResult(3, this.mResultCode);
                        return;
                    }
                    Raon_Usim_Api.Raon_Install_Package((Context)this.mContext);
                    this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)1), 1);
                }
                catch (RaonException e) {
                    this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)e.getCode()), e.getCode());
                }
                break;
            }
            case 2: {
                if (!this.mIsUpdateApp && this.isInstall_Dream()) {
                    this.mResultCode.setResultCode(0, 0);
                    this.mSmartUsimListener.onSmartUsimResult(3, this.mResultCode);
                    return;
                }
                if (this.dream_Install == null) {
                    this.dream_Install = new SmartCertInstall(this.mContext, (SmartCertListener)mThis);
                }
                this.dream_Install.installSmartCert();
            }
        }
    }

    public boolean isMember() {
        Map<String, Object> resMember;
        boolean bMember = false;
        int telecom = this.getTelecom();
        String phoneno = this.getPhoneNo();
        if (phoneno == null || telecom == -1) {
            return false;
        }
        if (this.mUsimMember != 12) {
            resMember = new HashMap();
            if (this.mSelectVendor == 1) {
                try {
                    resMember = Raon_Usim_Api.checkService((int)telecom, (String)phoneno);
                    this.mUsimMember = (Integer)resMember.get("usim_member");
                    this.mServiceVendor = (Integer)resMember.get("service_vender");
                }
                catch (RaonException raonException) {}
            } else {
                try {
                    if (this.dream_Install == null) {
                        this.dream_Install = new SmartCertInstall(this.mContext, (SmartCertListener)mThis);
                    }
                    resMember = this.dream_Install.isServiceState(this.mSiteID);
                    this.setMemberUseDreamAPI(resMember);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.mUsimMember == 15) {
            resMember = new HashMap();
            if (this.mSelectVendor == 1) {
                try {
                    if (this.dream_Install == null) {
                        this.dream_Install = new SmartCertInstall(this.mContext, (SmartCertListener)mThis);
                    }
                    resMember = this.dream_Install.isServiceState(this.mSiteID);
                    this.setMemberUseDreamAPI(resMember);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    resMember = Raon_Usim_Api.checkService((int)telecom, (String)phoneno);
                    this.mUsimMember = (Integer)resMember.get("usim_member");
                    this.mServiceVendor = (Integer)resMember.get("service_vender");
                }
                catch (RaonException e) {
                    e.printStackTrace();
                }
            }
        }
        switch (this.mUsimMember) {
            case 12: {
                bMember = true;
                this.mResultCode.setResultCode(0, 0);
                break;
            }
            case 13: {
                bMember = false;
                this.mResultCode.setResultCode(2001, 2001);
                break;
            }
            case 14: {
                bMember = false;
                this.mResultCode.setResultCode(2004, this.mUsimMember);
                break;
            }
        }
        return bMember;
    }

    public void bindService(String serverAddress, int serverPort) {
        switch (this.mServiceVendor) {
            case 1: {
                if (this.flag_mBound.booleanValue()) {
                    return;
                }
                this.mContext.getApplicationContext().bindService(new Intent("com.raonsecure.Usim_Mobile.SERVICE"), (ServiceConnection)mThis, 1);
                break;
            }
            case 2: {
                if (this.dream_Aidl == null) {
                    this.dream_Aidl = new SmartCertAidl(this.mContext, (SmartCertListener)mThis, serverAddress, serverPort);
                }
                this.dream_Aidl.disableVaccine();
                this.dream_Aidl.bindSmartCert(true);
                break;
            }
            default: {
                this.mResultCode.setResultCode(1001, 1002);
                this.mSmartUsimListener.onSmartUsimResult(1, this.mResultCode);
            }
        }
    }

    public void unbindService() {
        switch (this.mServiceVendor) {
            case 1: {
                this.flag_mBound = false;
                this.mContext.getApplicationContext().unbindService((ServiceConnection)mThis);
                break;
            }
            case 2: {
                this.dream_Aidl.unbindSmartCert();
                this.dream_Aidl = null;
            }
        }
    }

    public void onSmartCertBind(SmartCertResult result) {
        if (result.getResultCode() == 0) {
            this.dream_bind = true;
            this.mResultCode.setResultCode(0, result.getResultCode());
        } else {
            this.dream_bind = false;
            this.mResultCode.setResultCode(1002, result.getResultCode());
        }
        this.mSmartUsimListener.onSmartUsimResult(1, this.mResultCode);
    }

    public void onServiceConnected(ComponentName arg0, IBinder arg1) {
        switch (this.mServiceVendor) {
            case 1: {
                this.mRemoteInterface = IRemoteInterface.Stub.asInterface((IBinder)arg1);
                this.flag_mBound = this.mRemoteInterface == null ? Boolean.valueOf(false) : Boolean.valueOf(true);
                if (this.flag_mBound.booleanValue()) {
                    this.mResultCode.setResultCode(0, 1);
                } else {
                    this.mResultCode.setResultCode(1002, 1);
                }
                this.mSmartUsimListener.onSmartUsimResult(1, this.mResultCode);
                break;
            }
        }
    }

    public void onServiceDisconnected(ComponentName name) {
        switch (this.mServiceVendor) {
            case 1: {
                this.flag_mBound = false;
                break;
            }
        }
    }

    public SmartUsimResultCode getLastError() {
        return this.mResultCode;
    }

    public boolean isPossibleService() {
        boolean bPossibleService = false;
        switch (this.mServiceVendor) {
            case 1: {
                if (this.flag_mBound.booleanValue()) break;
                this.mResultCode.setResultCode(1002, 9002);
                return bPossibleService;
            }
            case 2: {
                if (this.dream_bind.booleanValue()) break;
                this.mResultCode.setResultCode(1002, 9002);
                return bPossibleService;
            }
        }
        if (!this.dream_bind.booleanValue() && !this.flag_mBound.booleanValue()) {
            this.mResultCode.setResultCode(1002, 9002);
            return bPossibleService;
        }
        switch (this.mServiceVendor) {
            case 1: {
                if (!this.flag_mBound.booleanValue()) {
                    this.mResultCode.setResultCode(1002, 9002);
                    return bPossibleService;
                }
                int check_version = 0;
                try {
                    check_version = Raon_Usim_Api.Raon_Check_Version((Context)this.mContext, (IRemoteInterface)this.mRemoteInterface);
                    this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)1), 1);
                }
                catch (RaonException e) {
                    bPossibleService = false;
                    this.mPossibleService = 0;
                    this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)e.getCode()), e.getCode());
                    return bPossibleService;
                }
                if (this.mUsimMember == 13) {
                    bPossibleService = false;
                    this.mResultCode.setResultCode(2001, 1);
                    this.mPossibleService = 0;
                    return bPossibleService;
                }
                if (check_version != 0) {
                    bPossibleService = false;
                    this.mIsUpdateApp = true;
                    this.mResultCode.setResultCode(3002, 1);
                    return bPossibleService;
                }
                if (check_version == 0) {
                    bPossibleService = true;
                }
                this.mResultCode.setResultCode(0, 1);
                break;
            }
            case 2: {
                if (!this.dream_bind.booleanValue()) {
                    this.mResultCode.setResultCode(1002, 9002);
                    return bPossibleService;
                }
                try {
                    boolean serviceStateREsult;
                    SmartCertResult scResult = this.dream_Aidl.isServiceValid();
                    int serviceResult = scResult.getResultCode();
                    if (serviceResult == 0 || serviceResult == 5004) {
                        bPossibleService = true;
                        SmartCertResult detailPossible = this.dream_Aidl.getResultCode();
                        this.mUsimMember = 12;
                        this.mResultCode.setResultCode(0, detailPossible.getResultCode());
                        break;
                    }
                    boolean memberStateResult = this.setMemberState(serviceResult);
                    if (memberStateResult || (serviceStateREsult = this.setPossibleState(serviceResult))) break;
                    this.mResultCode.setResultCode(7001, serviceResult);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    this.dream_bind = false;
                    this.mResultCode.setResultCode(9003, 9002);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.mResultCode.setResultCode(7001, 9999);
                }
                break;
            }
            default: {
                this.mResultCode.setResultCode(1001, 1001);
            }
        }
        if (bPossibleService || this.mResultCode.getResultCode() == 2001) {
            this.mPossibleService = 0;
        }
        return bPossibleService;
    }

    public SmartUsimResultCode joinService(int requestCode) {
        if (this.mServiceVendor == 0) {
            this.mResultCode.setResultCode(1001, 1003);
            this.mSmartUsimListener.onSmartUsimResult(4, this.mResultCode);
            return this.mResultCode;
        }
        if (this.mPossibleService == 1004) {
            this.mResultCode.setResultCode(1004, 1003);
            this.mSmartUsimListener.onSmartUsimResult(4, this.mResultCode);
            return this.mResultCode;
        }
        switch (this.mServiceVendor) {
            case 1: {
                if (!this.flag_mBound.booleanValue()) {
                    this.mResultCode.setResultCode(1002, 9002);
                    break;
                }
                try {
                    Raon_Usim_Api.Raon_Service_Join((Context)this.mContext, (String)"nh.smart.signone");
                    this.mResultCode.setResultCode(0, 1);
                    this.unbindService();
                    this.mResultCode.setResultCode(2, 1);
                    this.mSmartUsimListener.onSmartUsimResult(2, this.mResultCode);
                }
                catch (RaonException e) {
                    this.flag_mBound = false;
                    this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)e.getCode()), e.getCode());
                }
                break;
            }
            case 2: {
                if (!this.dream_bind.booleanValue()) {
                    this.mResultCode.setResultCode(1002, 9002);
                    break;
                }
                try {
                    this.dream_Aidl.startJoinMember(requestCode);
                    this.mResultCode.setResultCode(0, 0);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    this.dream_bind = false;
                    this.mResultCode.setResultCode(9003, 9002);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.mResultCode.setResultCode(1003, 9999);
                }
                break;
            }
            default: {
                this.mResultCode.setResultCode(7002, 1003);
                this.mSmartUsimListener.onSmartUsimResult(4, this.mResultCode);
            }
        }
        return this.mResultCode;
    }

    public String getTokenInfo() {
        String tokenInfo = "";
        if (!this.dream_bind.booleanValue() && !this.flag_mBound.booleanValue()) {
            this.mResultCode.setResultCode(1002, 9002);
            return tokenInfo;
        }
        if (this.mPossibleService == 1004) {
            this.mResultCode.setResultCode(1004, 1004);
            return tokenInfo;
        }
        switch (this.mServiceVendor) {
            case 1: {
                try {
                    tokenInfo = Raon_Usim_Api.Raon_GetToken((Context)this.mContext);
                    this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)1), 1);
                }
                catch (RaonException e) {
                    this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)e.getCode()), e.getCode());
                }
                break;
            }
            case 2: {
                try {
                    tokenInfo = this.dream_Aidl.getTokenInfo(SmartCertInfoType.INFO_USIM_ICCID);
                    SmartCertResult tokenResult = this.dream_Aidl.getResultCode();
                    if (tokenInfo == null) {
                        boolean setStateResult = this.setServiceState(tokenResult.getResultCode());
                        if (setStateResult) break;
                        this.mResultCode.setResultCode(7003, tokenResult.getResultCode());
                        break;
                    }
                    this.mResultCode.setResultCode(0, tokenResult.getResultCode());
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    tokenInfo = "";
                    this.dream_bind = false;
                    this.mResultCode.setResultCode(9003, 9002);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.mResultCode.setResultCode(7003, 9999);
                }
                break;
            }
            default: {
                this.mResultCode.setResultCode(1001, 1001);
            }
        }
        return tokenInfo;
    }

    public void setFilterCert(Integer key, String values) {
        if (!this.dream_bind.booleanValue() && !this.flag_mBound.booleanValue()) {
            this.mResultCode.setResultCode(1002, 9002);
            return;
        }
        if (this.mServiceVendor == 0) {
            this.mResultCode.setResultCode(1001, 1001);
            return;
        }
        if (this.mPossibleService == 1004) {
            this.mResultCode.setResultCode(1004, 1004);
            return;
        }
        if (key == 0) {
            this.mMapFilterCert.clear();
            this.mFlagFilterCert = 0;
            this.mResultCode.setResultCode(0, 0);
        } else {
            switch (key) {
                case 1: 
                case 8: 
                case 32: 
                case 64: {
                    this.mMapFilterCert.put(key, values);
                    this.mFlagFilterCert |= key.intValue();
                    this.mResultCode.setResultCode(0, 0);
                    break;
                }
                default: {
                    this.mResultCode.setResultCode(9001, 9001);
                }
            }
        }
    }

    public int getCertCount() {
        int nCertCount = -1;
        if (this.mPossibleService == 1004) {
            this.mResultCode.setResultCode(1004, 1004);
            return nCertCount;
        }
        switch (this.mServiceVendor) {
            case 1: {
                if (!this.flag_mBound.booleanValue()) {
                    this.mResultCode.setResultCode(1002, 9002);
                    break;
                }
                GetCertList getcertlist = null;
                Object bean = null;
                if (this.mFlagFilterCert == 0) {
                    try {
                        this.mcert_count = nCertCount = Raon_Usim_Api.Raon_GetCertcount((Context)this.mContext, (IRemoteInterface)this.mRemoteInterface);
                        this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)1), 1);
                        break;
                    }
                    catch (RaonException e) {
                        this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)e.getCode()), e.getCode());
                        return nCertCount;
                    }
                }
                if ((this.mFlagFilterCert & 8) == 8) {
                    try {
                        getcertlist = Raon_Usim_Api.Raon_GetCertlist_Filter_Serial((Context)this.mContext, (IRemoteInterface)this.mRemoteInterface, (String)this.mMapFilterCert.get(8));
                        nCertCount = getcertlist.certlist.size();
                        this.mgetcertlist = new GetCertList();
                        this.mgetcertlist = getcertlist;
                        this.mcert_count = nCertCount;
                        this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)1), 1);
                    }
                    catch (RaonException e) {
                        nCertCount = 0;
                        this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)e.getCode()), e.getCode());
                    }
                    if (this.roomlist != null) {
                        this.roomlist = null;
                    }
                }
                if ((this.mFlagFilterCert & 1) == 1) {
                    try {
                        getcertlist = Raon_Usim_Api.Raon_GetCertlist_Filter_OID((Context)this.mContext, (IRemoteInterface)this.mRemoteInterface, (String)this.mMapFilterCert.get(1));
                        nCertCount = getcertlist.certlist.size();
                        this.mgetcertlist = new GetCertList();
                        this.mgetcertlist = getcertlist;
                        this.mcert_count = nCertCount;
                        this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)1), 1);
                    }
                    catch (RaonException e) {
                        nCertCount = 0;
                        this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)e.getCode()), e.getCode());
                    }
                    if (this.roomlist != null) {
                        this.roomlist = null;
                    }
                }
                if ((this.mFlagFilterCert & 0x20) != 32) break;
                try {
                    getcertlist = Raon_Usim_Api.Raon_GetCertlist_Opt((Context)this.mContext, (IRemoteInterface)this.mRemoteInterface, (String)this.mMapFilterCert.get(32));
                    nCertCount = getcertlist.certlist.size();
                    this.mgetcertlist = new GetCertList();
                    this.mgetcertlist = getcertlist;
                    this.mcert_count = nCertCount;
                    this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)1), 1);
                }
                catch (RaonException e) {
                    nCertCount = 0;
                    this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)e.getCode()), e.getCode());
                }
                if (this.roomlist == null) break;
                this.roomlist = null;
                break;
            }
            case 2: {
                if (!this.dream_bind.booleanValue()) {
                    this.mResultCode.setResultCode(1002, 9002);
                    break;
                }
                try {
                    int filterResult = this.setDream_Filter();
                    if (filterResult != 0) {
                        boolean stateResult = this.setServiceState(filterResult);
                        if (stateResult) break;
                        this.mResultCode.setResultCode(7004, filterResult);
                        break;
                    }
                    nCertCount = this.dream_Aidl.getCertCount();
                    SmartCertResult countResult = this.dream_Aidl.getResultCode();
                    if (nCertCount == -1) {
                        boolean stateResult = this.setServiceState(countResult.getResultCode());
                        if (stateResult) break;
                        this.mResultCode.setResultCode(7005, countResult.getResultCode());
                        break;
                    }
                    this.mResultCode.setResultCode(0, countResult.getResultCode());
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    nCertCount = -1;
                    this.dream_bind = false;
                    this.mResultCode.setResultCode(9003, 9002);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.mResultCode.setResultCode(7005, 9999);
                }
                break;
            }
            default: {
                this.mResultCode.setResultCode(1001, 1001);
            }
        }
        return nCertCount;
    }

    public byte[] getCertificate(int index) {
        byte[] certficate = null;
        if (this.mPossibleService == 1004) {
            this.mResultCode.setResultCode(1004, 1004);
            return certficate;
        }
        switch (this.mServiceVendor) {
            case 1: {
                if (!this.flag_mBound.booleanValue()) {
                    this.mResultCode.setResultCode(1002, 9002);
                    break;
                }
                GetCertList getcertlist = null;
                try {
                    getcertlist = Raon_Usim_Api.Raon_GetCert((Context)this.mContext, (IRemoteInterface)this.mRemoteInterface, (int)index);
                    if (getcertlist != null) {
                        RaonLogger.printHex((String)"SmartUsim getCertificate getcertlist : ", (byte[])((GetCertList_Parcel)getcertlist.certlist.get((int)0)).cert);
                    }
                    if ((certficate = (byte[])((GetCertList_Parcel)getcertlist.certlist.get((int)0)).cert.clone()) != null) {
                        RaonLogger.printHex((String)"SmartUsim getCertificate certficate : ", (byte[])certficate);
                    }
                    this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)1), 1);
                }
                catch (RaonException e) {
                    this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)e.getCode()), e.getCode());
                }
                if (certficate != null) break;
                this.mResultCode.setResultCode(7006, -213);
                break;
            }
            case 2: {
                if (!this.dream_bind.booleanValue()) {
                    this.mResultCode.setResultCode(1002, 9002);
                    break;
                }
                try {
                    certficate = this.dream_Aidl.getCertificate(index);
                    SmartCertResult certResult = this.dream_Aidl.getResultCode();
                    if (certficate == null) {
                        boolean stateResult = this.setServiceState(certResult.getResultCode());
                        if (stateResult) break;
                        this.mResultCode.setResultCode(7006, certResult.getResultCode());
                        break;
                    }
                    this.mResultCode.setResultCode(0, certResult.getResultCode());
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    certficate = null;
                    this.dream_bind = false;
                    this.mResultCode.setResultCode(9003, 9002);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.mResultCode.setResultCode(7006, 9999);
                }
                break;
            }
            default: {
                this.mResultCode.setResultCode(1001, 1001);
            }
        }
        return certficate;
    }

    public String getCertAttributes(int index, int attribute) {
        String certAttribute = "";
        if (this.mPossibleService == 1004) {
            this.mResultCode.setResultCode(1004, 1004);
            return certAttribute;
        }
        block5 : switch (this.mServiceVendor) {
            case 1: {
                if (!this.flag_mBound.booleanValue()) {
                    this.mResultCode.setResultCode(1002, 9002);
                    break;
                }
                KSCertificate bean = null;
                if (this.mFlagFilterCert == 0) {
                    GetCertList getcertlist = null;
                    Object getcert = null;
                    int nCertCount = 0;
                    try {
                        nCertCount = Raon_Usim_Api.Raon_GetCertcount((Context)this.mContext, (IRemoteInterface)this.mRemoteInterface);
                    }
                    catch (RaonException e) {
                        this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)e.getCode()), e.getCode());
                        return certAttribute;
                    }
                    if (this.roomlist == null || this.roomlist.length != this.mcert_count || nCertCount != this.mcert_count) {
                        try {
                            getcertlist = Raon_Usim_Api.Raon_GetCertlist((Context)this.mContext, (IRemoteInterface)this.mRemoteInterface);
                            this.mgetcertlist = new GetCertList();
                            this.mgetcertlist = getcertlist;
                            if (getcertlist != null && getcertlist.certlist.size() > 0) {
                                this.roomlist = new int[getcertlist.certlist.size()];
                            }
                            int i = 0;
                            while (i < this.roomlist.length) {
                                this.roomlist[i] = Integer.parseInt(((GetCertList_Parcel)getcertlist.certlist.get((int)i)).certpath);
                                ++i;
                            }
                        }
                        catch (RaonException e) {
                            this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)e.getCode()), e.getCode());
                            return certAttribute;
                        }
                    }
                } else if (this.mgetcertlist == null || this.mcert_count != this.mgetcertlist.certlist.size()) {
                    this.getCertCount();
                }
                try {
                    bean = new KSCertificate(((GetCertList_Parcel)this.mgetcertlist.certlist.get((int)index)).cert, String.valueOf(((GetCertList_Parcel)this.mgetcertlist.certlist.get((int)index)).certpath));
                }
                catch (Exception e) {
                    this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)7006), -204);
                    return certAttribute;
                }
                if (bean == null) {
                    this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)7006), -204);
                    return certAttribute;
                }
                this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)7006), -204);
                try {
                    switch (attribute) {
                        case 1: {
                            certAttribute = bean.getSerialNumberInt();
                            this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)1), 1);
                            break block5;
                        }
                        case 2: {
                            certAttribute = bean.getIssuerDn();
                            this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)1), 1);
                            break block5;
                        }
                        case 3: {
                            certAttribute = bean.getNotBefore(1);
                            this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)1), 1);
                            break block5;
                        }
                        case 4: {
                            certAttribute = bean.getNotAfter(1);
                            this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)1), 1);
                            break block5;
                        }
                        case 5: {
                            certAttribute = bean.getSubjectDn();
                            this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)1), 1);
                            break block5;
                        }
                        case 6: {
                            certAttribute = bean.getPolicy();
                            this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)1), 1);
                            break block5;
                        }
                        case 7: {
                            certAttribute = bean.getIssuerName();
                            this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)1), 1);
                            break block5;
                        }
                        case 8: {
                            certAttribute = bean.getSubjectName();
                            this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)1), 1);
                            break block5;
                        }
                        case 9: {
                            certAttribute = bean.getPolicy();
                            this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)1), 1);
                            break block5;
                        }
                    }
                    this.mResultCode.setResultCode(9001, -231);
                }
                catch (UnsupportedEncodingException e1) {
                    this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)7006), -204);
                }
                catch (ParseException e) {
                    this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)7006), -204);
                }
                break;
            }
            case 2: {
                if (!this.dream_bind.booleanValue()) {
                    this.mResultCode.setResultCode(1002, 9002);
                    break;
                }
                try {
                    switch (attribute) {
                        case 1: {
                            certAttribute = this.dream_Aidl.getSerialNumber(index);
                            break;
                        }
                        case 2: {
                            certAttribute = this.dream_Aidl.getIssuerDN(index);
                            break;
                        }
                        case 3: {
                            String FromDate = this.dream_Aidl.getValidStartDate(index);
                            if (FromDate == null) break;
                            certAttribute = this.changeDateDREAMAPI(FromDate);
                            break;
                        }
                        case 4: {
                            String ToDate = this.dream_Aidl.getExpiredDate(index);
                            if (ToDate == null) break;
                            certAttribute = this.changeDateDREAMAPI(ToDate);
                            break;
                        }
                        case 5: {
                            certAttribute = this.dream_Aidl.getSubjectDN(index);
                            break;
                        }
                        case 6: {
                            certAttribute = this.dream_Aidl.getCertificatePolicy(index, true);
                            break;
                        }
                        case 7: {
                            String issuerDN = this.dream_Aidl.getIssuerDN(index);
                            if (issuerDN == null) break;
                            String[] splitDN = issuerDN.split(",");
                            certAttribute = this.parseISSUER(splitDN[0].substring(3));
                            break;
                        }
                        case 8: {
                            String altName = this.dream_Aidl.getSubjectAltName(index);
                            if (altName == null) {
                                String subDN = this.dream_Aidl.getSubjectDN(index);
                                certAttribute = this.CERT_GeCN(subDN);
                                break;
                            }
                            certAttribute = altName;
                            break;
                        }
                        case 9: {
                            certAttribute = this.dream_Aidl.getCertificatePolicy(index, false);
                            break;
                        }
                        default: {
                            this.mResultCode.setResultCode(9001, 9001);
                        }
                    }
                    if (certAttribute == null || certAttribute.equalsIgnoreCase("")) break;
                    SmartCertResult attributeResult = this.dream_Aidl.getResultCode();
                    if (attributeResult.getResultCode() != 0) {
                        if (attribute == 3 && attributeResult.getResultCode() == 9999) {
                            this.mResultCode.setResultCode(0, attributeResult.getResultCode());
                            break;
                        }
                        boolean stateResult = this.setServiceState(attributeResult.getResultCode());
                        if (!stateResult) {
                            this.mResultCode.setResultCode(7007, attributeResult.getResultCode());
                        }
                        certAttribute = "";
                        break;
                    }
                    this.mResultCode.setResultCode(0, attributeResult.getResultCode());
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    certAttribute = "";
                    this.dream_bind = false;
                    this.mResultCode.setResultCode(9003, 9002);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.mResultCode.setResultCode(7007, 9999);
                }
                break;
            }
            default: {
                this.mResultCode.setResultCode(1001, 1001);
            }
        }
        return certAttribute;
    }

    /*
     * Unable to fully structure code
     */
    public byte[] sign(int index, byte[] pin, int signType, byte[] tobeSignData, String signTime) {
        signedData = null;
        temp_pin = null;
        if (!this.dream_bind.booleanValue() && !this.flag_mBound.booleanValue()) {
            this.mResultCode.setResultCode(1002, 9002);
            return signedData;
        }
        if (this.mPossibleService == 1004) {
            this.mResultCode.setResultCode(1004, 1004);
            return signedData;
        }
        switch (this.mServiceVendor) {
            case 1: {
                result_signedData = null;
                bean = null;
                if (this.mFlagFilterCert == 0) {
                    getcertlist = null;
                    getcert = null;
                    nCertCount = 0;
                    try {
                        nCertCount = Raon_Usim_Api.Raon_GetCertcount((Context)this.mContext, (IRemoteInterface)this.mRemoteInterface);
                    }
                    catch (RaonException e) {
                        this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)e.getCode()), e.getCode());
                        return signedData;
                    }
                    if (this.roomlist == null || this.roomlist.length != this.mcert_count || nCertCount != this.mcert_count) {
                        try {
                            getcertlist = Raon_Usim_Api.Raon_GetCertlist((Context)this.mContext, (IRemoteInterface)this.mRemoteInterface);
                            this.mgetcertlist = new GetCertList();
                            this.mgetcertlist = getcertlist;
                            if (getcertlist != null && getcertlist.certlist.size() > 0) {
                                this.roomlist = new int[getcertlist.certlist.size()];
                            }
                            i = 0;
                            while (i < this.roomlist.length) {
                                this.roomlist[i] = Integer.parseInt(((GetCertList_Parcel)getcertlist.certlist.get((int)i)).certpath);
                                ++i;
                            }
                        }
                        catch (RaonException e) {
                            this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)e.getCode()), e.getCode());
                            return signedData;
                        }
                    }
                } else {
                    if (this.mgetcertlist == null || this.mcert_count != this.mgetcertlist.certlist.size()) {
                        this.getCertCount();
                    }
                    if (this.mgetcertlist != null && this.mgetcertlist.certlist.size() > 0) {
                        this.roomlist = new int[this.mgetcertlist.certlist.size()];
                    }
                    i = 0;
                    while (i < this.roomlist.length) {
                        this.roomlist[i] = Integer.parseInt(((GetCertList_Parcel)this.mgetcertlist.certlist.get((int)i)).certpath);
                        ++i;
                    }
                }
                try {
                    temp_pin = (byte[])pin.clone();
                    Raon_Usim_Api.Raon_CheckPin((Context)this.mContext, (IRemoteInterface)this.mRemoteInterface, (byte[])temp_pin);
                    i = 0;
                    while (i < temp_pin.length) {
                        temp_pin[i] = 0;
                        ++i;
                    }
                    this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)1), 1);
                    ** GOTO lbl74
                }
                catch (RaonException e) {
                    this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)e.getCode()), e.getCode());
                    i = 0;
                    ** while (i < temp_pin.length)
                }
lbl-1000:
                // 1 sources

                {
                    temp_pin[i] = 0;
                    ++i;
                    continue;
                }
lbl68:
                // 1 sources

                i = 0;
                while (i < pin.length) {
                    pin[i] = 0;
                    ++i;
                }
                return signedData;
lbl74:
                // 1 sources

                if (signTime == null) {
                    df = new SimpleDateFormat("yyMMddHHmmss");
                    cal = Calendar.getInstance(Locale.KOREA);
                    s = Long.toString(cal.getTimeInMillis());
                    signTime = new String(KSBase64.encode((byte[])s.getBytes()));
                }
                try {
                    temp_pin = (byte[])pin.clone();
                    result_signedData = Raon_Usim_Api.Raon_Sign_P7_AddTime((Context)this.mContext, (IRemoteInterface)this.mRemoteInterface, (byte[])tobeSignData, (int)this.roomlist[index], (byte[])temp_pin, (String)signTime);
                    this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)1), 1);
                    i = 0;
                    while (i < temp_pin.length) {
                        temp_pin[i] = 0;
                        ++i;
                    }
                    i = 0;
                    while (i < pin.length) {
                        pin[i] = 0;
                        ++i;
                    }
                    ** GOTO lbl102
                }
                catch (RaonException e) {
                    this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)e.getCode()), e.getCode());
                    i = 0;
                    ** while (i < pin.length)
                }
lbl-1000:
                // 1 sources

                {
                    pin[i] = 0;
                    ++i;
                    continue;
                }
lbl101:
                // 1 sources

                return signedData;
lbl102:
                // 1 sources

                signedData = KSBase64.decode((String)result_signedData);
                this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)1), 1);
                break;
            }
            case 2: {
                try {
                    loginResult = this.getDream_LoginResult(pin);
                    if (!loginResult) break;
                    dsSignType = this.getDream_SignType(signType);
                    signedData = this.dream_Aidl.getSignedData(index, dsSignType, SmartCertSignOption.OPTION_NONE, tobeSignData, signTime);
                    signResult = this.dream_Aidl.getResultCode();
                    if (signedData == null || signResult.getResultCode() != 0) {
                        stateResult = this.setServiceState(signResult.getResultCode());
                        if (!stateResult) {
                            this.mResultCode.setResultCode(7008, signResult.getResultCode());
                        }
                    } else {
                        this.mResultCode.setResultCode(0, signResult.getResultCode());
                    }
                    this.getDream_Logout();
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    this.dream_bind = false;
                    this.mResultCode.setResultCode(9003, 9002);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.mResultCode.setResultCode(7008, 9999);
                }
                break;
            }
            default: {
                this.mResultCode.setResultCode(1001, 1001);
            }
        }
        return signedData;
    }

    /*
     * Unable to fully structure code
     */
    public byte[] sign(int index, byte[] pin, int signType, byte[] tobeSignData, String signTime, int type_signTime) {
        signedData = null;
        if (!this.dream_bind.booleanValue() && !this.flag_mBound.booleanValue()) {
            this.mResultCode.setResultCode(1002, 9002);
            return signedData;
        }
        if (this.mPossibleService == 1004) {
            this.mResultCode.setResultCode(1004, 1004);
            return signedData;
        }
        switch (this.mServiceVendor) {
            case 1: {
                result_signedData = null;
                getcertlist = null;
                getcert = null;
                bean = null;
                roomlist = null;
                try {
                    getcertlist = Raon_Usim_Api.Raon_GetCertlist((Context)this.mContext, (IRemoteInterface)this.mRemoteInterface);
                    if (getcertlist != null && getcertlist.certlist.size() > 0) {
                        roomlist = new int[getcertlist.certlist.size()];
                    }
                    i = 0;
                    while (i < roomlist.length) {
                        roomlist[i] = Integer.parseInt(((GetCertList_Parcel)getcertlist.certlist.get((int)i)).certpath);
                        ++i;
                    }
                }
                catch (RaonException e) {
                    this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)e.getCode()), e.getCode());
                    return signedData;
                }
                try {
                    Raon_Usim_Api.Raon_CheckPin((Context)this.mContext, (IRemoteInterface)this.mRemoteInterface, (byte[])pin);
                    this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)1), 1);
                    ** GOTO lbl41
                }
                catch (RaonException e) {
                    this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)e.getCode()), e.getCode());
                    i = 0;
                    ** while (i < pin.length)
                }
lbl-1000:
                // 1 sources

                {
                    pin[i] = 0;
                    ++i;
                    continue;
                }
lbl40:
                // 1 sources

                return signedData;
lbl41:
                // 1 sources

                if (signTime == null) {
                    df = new SimpleDateFormat("yyMMddHHmmss");
                    cal = Calendar.getInstance(Locale.KOREA);
                    s = Long.toString(cal.getTimeInMillis());
                    signTime = new String(KSBase64.encode((byte[])s.getBytes()));
                }
                try {
                    result_signedData = Raon_Usim_Api.Raon_Sign_P7_AddTime((Context)this.mContext, (IRemoteInterface)this.mRemoteInterface, (byte[])tobeSignData, (int)roomlist[index], (byte[])pin, (String)signTime, (int)0);
                    i = 0;
                    while (i < pin.length) {
                        pin[i] = 0;
                        ++i;
                    }
                    this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)1), 1);
                    ** GOTO lbl63
                }
                catch (RaonException e) {
                    this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)e.getCode()), e.getCode());
                    i = 0;
                    ** while (i < pin.length)
                }
lbl-1000:
                // 1 sources

                {
                    pin[i] = 0;
                    ++i;
                    continue;
                }
lbl62:
                // 1 sources

                return signedData;
lbl63:
                // 1 sources

                signedData = KSBase64.decode((String)result_signedData);
                this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)1), 1);
                break;
            }
            case 2: {
                try {
                    loginResult = this.getDream_LoginResult(pin);
                    if (!loginResult) break;
                    dsSignType = this.getDream_SignType(signType);
                    signedData = this.dream_Aidl.getSignedData(index, dsSignType, SmartCertSignOption.OPTION_NONE, tobeSignData, signTime);
                    signResult = this.dream_Aidl.getResultCode();
                    if (signedData == null || signResult.getResultCode() != 0) {
                        stateResult = this.setServiceState(signResult.getResultCode());
                        if (!stateResult) {
                            this.mResultCode.setResultCode(7008, signResult.getResultCode());
                        }
                    } else {
                        this.mResultCode.setResultCode(0, signResult.getResultCode());
                    }
                    this.getDream_Logout();
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    this.dream_bind = false;
                    this.mResultCode.setResultCode(9003, 9002);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.mResultCode.setResultCode(7008, 9999);
                }
                break;
            }
            default: {
                this.mResultCode.setResultCode(1001, 1001);
            }
        }
        return signedData;
    }

    public byte[] addUnSignedAttributeSignedData(byte[] signedData, String oid, byte[] oidValue) {
        byte[] unSignedAttrubuteWithSignedData = null;
        if (!this.dream_bind.booleanValue() && !this.flag_mBound.booleanValue()) {
            this.mResultCode.setResultCode(1002, 9002);
            return unSignedAttrubuteWithSignedData;
        }
        if (this.mPossibleService == 1004) {
            this.mResultCode.setResultCode(1004, 1004);
            return unSignedAttrubuteWithSignedData;
        }
        switch (this.mServiceVendor) {
            case 1: {
                String result_signedData = null;
                try {
                    result_signedData = Raon_Usim_Api.Raon_Sign_P7_AddUnAuthAttr((Context)this.mContext, (IRemoteInterface)this.mRemoteInterface, (String)signedData.toString(), (String)oid, (byte[])oidValue);
                    unSignedAttrubuteWithSignedData = result_signedData.getBytes();
                    this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)1), 1);
                }
                catch (RaonException e) {
                    this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)e.getCode()), e.getCode());
                }
                break;
            }
            case 2: {
                try {
                    this.dream_Aidl.addUnSignedAttribute(oid, oidValue);
                    SmartCertResult addResult = this.dream_Aidl.getResultCode();
                    if (addResult.getResultCode() == 0) {
                        unSignedAttrubuteWithSignedData = this.dream_Aidl.addUnSignedAttributeWithSignedData(signedData);
                        SmartCertResult unSignedResult = this.dream_Aidl.getResultCode();
                        if (unSignedResult.getResultCode() == 0) {
                            boolean stateResult = this.setServiceState(unSignedResult.getResultCode());
                            if (stateResult) break;
                            this.mResultCode.setResultCode(0, unSignedResult.getResultCode());
                            break;
                        }
                        unSignedAttrubuteWithSignedData = null;
                        this.mResultCode.setResultCode(7009, unSignedResult.getResultCode());
                        break;
                    }
                    this.mResultCode.setResultCode(7009, addResult.getResultCode());
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    this.dream_bind = false;
                    this.mResultCode.setResultCode(9003, 9002);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.mResultCode.setResultCode(7009, 9999);
                }
                break;
            }
            default: {
                this.mResultCode.setResultCode(1001, 1001);
            }
        }
        return unSignedAttrubuteWithSignedData;
    }

    /*
     * Unable to fully structure code
     */
    public byte[] getVIDRandom(int index, byte[] pin) {
        vidRandom = null;
        if (!this.dream_bind.booleanValue() && !this.flag_mBound.booleanValue()) {
            this.mResultCode.setResultCode(1002, 9002);
            return vidRandom;
        }
        if (this.mPossibleService == 1004) {
            this.mResultCode.setResultCode(1004, 1004);
            return vidRandom;
        }
        switch (this.mServiceVendor) {
            case 1: {
                bean = null;
                if (this.mFlagFilterCert == 0) {
                    getcertlist = null;
                    getcert = null;
                    nCertCount = 0;
                    try {
                        nCertCount = Raon_Usim_Api.Raon_GetCertcount((Context)this.mContext, (IRemoteInterface)this.mRemoteInterface);
                    }
                    catch (RaonException e) {
                        this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)e.getCode()), e.getCode());
                        return vidRandom;
                    }
                    if (this.roomlist == null || this.roomlist.length != this.mcert_count || nCertCount != this.mcert_count) {
                        try {
                            getcertlist = Raon_Usim_Api.Raon_GetCertlist((Context)this.mContext, (IRemoteInterface)this.mRemoteInterface);
                            this.mgetcertlist = new GetCertList();
                            this.mgetcertlist = getcertlist;
                            if (getcertlist != null && getcertlist.certlist.size() > 0) {
                                this.roomlist = new int[getcertlist.certlist.size()];
                            }
                            i = 0;
                            while (i < this.roomlist.length) {
                                this.roomlist[i] = Integer.parseInt(((GetCertList_Parcel)getcertlist.certlist.get((int)i)).certpath);
                                ++i;
                            }
                        }
                        catch (RaonException e) {
                            this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)e.getCode()), e.getCode());
                            return vidRandom;
                        }
                    }
                } else {
                    if (this.mgetcertlist == null || this.mcert_count != this.mgetcertlist.certlist.size()) {
                        this.getCertCount();
                    }
                    if (this.mgetcertlist != null && this.mgetcertlist.certlist.size() > 0) {
                        this.roomlist = new int[this.mgetcertlist.certlist.size()];
                    }
                    i = 0;
                    while (i < this.roomlist.length) {
                        this.roomlist[i] = Integer.parseInt(((GetCertList_Parcel)this.mgetcertlist.certlist.get((int)i)).certpath);
                        ++i;
                    }
                }
                try {
                    vidRandom = Raon_Usim_Api.Raon_GetVidRandom((Context)this.mContext, (IRemoteInterface)this.mRemoteInterface, (int)this.roomlist[index], (byte[])pin);
                    this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)1), 1);
                    i = 0;
                    while (i < pin.length) {
                        pin[i] = 0;
                        ++i;
                    }
                    ** GOTO lbl65
                }
                catch (RaonException e) {
                    this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)e.getCode()), e.getCode());
                    i = 0;
                    ** while (i < pin.length)
                }
lbl-1000:
                // 1 sources

                {
                    pin[i] = 0;
                    ++i;
                    continue;
                }
lbl64:
                // 1 sources

                return vidRandom;
lbl65:
                // 1 sources

                this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)1), 1);
                break;
            }
            case 2: {
                try {
                    loginResult = this.getDream_LoginResult(pin);
                    if (!loginResult) break;
                    vidRandom = this.dream_Aidl.getVIDRandom(index);
                    vidResult = this.dream_Aidl.getResultCode();
                    if (vidRandom == null && vidResult.getResultCode() != 0) {
                        stateResult = this.setServiceState(vidResult.getResultCode());
                        if (!stateResult) {
                            this.mResultCode.setResultCode(7010, vidResult.getResultCode());
                        }
                    } else {
                        this.mResultCode.setResultCode(0, 0);
                    }
                    this.getDream_Logout();
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    this.dream_bind = false;
                    this.mResultCode.setResultCode(9003, 9002);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.mResultCode.setResultCode(7010, 9999);
                }
                break;
            }
            default: {
                this.mResultCode.setResultCode(1001, 1001);
            }
        }
        return vidRandom;
    }

    /*
     * Unable to fully structure code
     */
    public boolean verifyVID(int index, byte[] pin, byte[] ssn) {
        bVerify = false;
        if (!this.dream_bind.booleanValue() && !this.flag_mBound.booleanValue()) {
            this.mResultCode.setResultCode(1002, 9002);
            return bVerify;
        }
        if (this.mPossibleService == 1004) {
            this.mResultCode.setResultCode(1004, 1004);
            return bVerify;
        }
        block4 : switch (this.mServiceVendor) {
            case 1: {
                byteToString_idn = new String(ssn, 0, ssn.length);
                bean = null;
                if (this.mFlagFilterCert == 0) {
                    getcertlist = null;
                    getcert = null;
                    nCertCount = 0;
                    try {
                        nCertCount = Raon_Usim_Api.Raon_GetCertcount((Context)this.mContext, (IRemoteInterface)this.mRemoteInterface);
                    }
                    catch (RaonException e) {
                        this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)e.getCode()), e.getCode());
                        return bVerify;
                    }
                    if (this.roomlist == null || this.roomlist.length != this.mcert_count || nCertCount != this.mcert_count) {
                        try {
                            getcertlist = Raon_Usim_Api.Raon_GetCertlist((Context)this.mContext, (IRemoteInterface)this.mRemoteInterface);
                            this.mgetcertlist = new GetCertList();
                            this.mgetcertlist = getcertlist;
                            if (getcertlist != null && getcertlist.certlist.size() > 0) {
                                this.roomlist = new int[getcertlist.certlist.size()];
                            }
                            i = 0;
                            while (i < this.roomlist.length) {
                                this.roomlist[i] = Integer.parseInt(((GetCertList_Parcel)getcertlist.certlist.get((int)i)).certpath);
                                ++i;
                            }
                        }
                        catch (RaonException e) {
                            this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)e.getCode()), e.getCode());
                            return bVerify;
                        }
                    }
                } else {
                    if (this.mgetcertlist == null || this.mcert_count != this.mgetcertlist.certlist.size()) {
                        this.getCertCount();
                    }
                    if (this.mgetcertlist != null && this.mgetcertlist.certlist.size() > 0) {
                        this.roomlist = new int[this.mgetcertlist.certlist.size()];
                    }
                    i = 0;
                    while (i < this.roomlist.length) {
                        this.roomlist[i] = Integer.parseInt(((GetCertList_Parcel)this.mgetcertlist.certlist.get((int)i)).certpath);
                        ++i;
                    }
                }
                try {
                    bVerify = Raon_Usim_Api.Raon_VerifyVID((Context)this.mContext, (IRemoteInterface)this.mRemoteInterface, (int)this.roomlist[index], (byte[])pin, (String)byteToString_idn);
                    i = 0;
                    while (i < pin.length) {
                        pin[i] = 0;
                        ++i;
                    }
                    this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)1), 1);
                    break;
                }
                catch (RaonException e) {
                    this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)e.getCode()), e.getCode());
                    i = 0;
                    ** while (i < pin.length)
                }
lbl-1000:
                // 1 sources

                {
                    pin[i] = 0;
                    ++i;
                    continue;
lbl65:
                    // 1 sources

                    break block4;
                }
            }
            case 2: {
                try {
                    loginResult = this.getDream_LoginResult(pin);
                    if (!loginResult) break;
                    bVerify = this.dream_Aidl.verifyID(index, ssn);
                    verifyResult = this.dream_Aidl.getResultCode();
                    if (!bVerify && verifyResult.getResultCode() != 0) {
                        stateResult = this.setServiceState(verifyResult.getResultCode());
                        if (!stateResult) {
                            this.mResultCode.setResultCode(7011, verifyResult.getResultCode());
                        }
                    } else {
                        this.mResultCode.setResultCode(0, 0);
                    }
                    this.getDream_Logout();
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    this.dream_bind = false;
                    this.mResultCode.setResultCode(9003, 9002);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.mResultCode.setResultCode(7011, 9999);
                }
                break;
            }
            default: {
                this.mResultCode.setResultCode(1001, 1001);
            }
        }
        return bVerify;
    }

    public SmartUsimResultCode writeCertUsim(byte[] pin, byte[] certificate, byte[] priKey, byte[] priKeyPassword) {
        if (!this.dream_bind.booleanValue() && !this.flag_mBound.booleanValue()) {
            this.mResultCode.setResultCode(1002, 9002);
            return this.mResultCode;
        }
        if (this.mPossibleService == 1004) {
            this.mResultCode.setResultCode(1004, 1004);
            return this.mResultCode;
        }
        switch (this.mServiceVendor) {
            case 1: {
                boolean result_putcert = false;
                String byteToString_certificate = KSHex.encodeUpper((byte[])certificate);
                String byteToString_priKey = KSHex.encodeUpper((byte[])priKey);
                try {
                    Raon_Usim_Api.Raon_PutCert((Context)this.mContext, (IRemoteInterface)this.mRemoteInterface, (String)byteToString_certificate, (String)byteToString_priKey, (byte[])priKeyPassword, (byte[])pin);
                    this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)1), 1);
                    int i = 0;
                    while (i < pin.length) {
                        pin[i] = 0;
                        ++i;
                    }
                    i = 0;
                    while (i < priKeyPassword.length) {
                        priKeyPassword[i] = 0;
                        ++i;
                    }
                }
                catch (RaonException e) {
                    this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)e.getCode()), e.getCode());
                }
                break;
            }
            case 2: {
                try {
                    boolean loginResult = this.getDream_LoginResult(pin);
                    if (!loginResult) break;
                    SmartCertResult wrResult = this.dream_Aidl.writeCertAndPriKey(certificate, priKeyPassword, priKey);
                    if (wrResult.getResultCode() != 0) {
                        if (wrResult.getResultCode() == 6001) {
                            this.mResultCode.setResultCode(5005, wrResult.getResultCode());
                        } else {
                            boolean stateResult = this.setServiceState(wrResult.getResultCode());
                            if (!stateResult) {
                                this.mResultCode.setResultCode(7012, wrResult.getResultCode());
                            }
                        }
                    } else {
                        this.mResultCode.setResultCode(0, 0);
                    }
                    this.getDream_Logout();
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    this.dream_bind = false;
                    this.mResultCode.setResultCode(9003, 9002);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.mResultCode.setResultCode(7012, 9999);
                }
                break;
            }
            default: {
                this.mResultCode.setResultCode(1001, 1001);
            }
        }
        return this.mResultCode;
    }

    /*
     * Unable to fully structure code
     */
    public SmartUsimResultCode deleteCertUsim(int index, byte[] pin) {
        temp_pin = null;
        if (this.mPossibleService == 1004) {
            this.mResultCode.setResultCode(1004, 1004);
            return this.mResultCode;
        }
        switch (this.mServiceVendor) {
            case 1: {
                if (!this.flag_mBound.booleanValue()) {
                    this.mResultCode.setResultCode(1002, 9002);
                    break;
                }
                bean = null;
                if (this.mFlagFilterCert == 0) {
                    getcertlist = null;
                    getcert = null;
                    nCertCount = 0;
                    try {
                        nCertCount = Raon_Usim_Api.Raon_GetCertcount((Context)this.mContext, (IRemoteInterface)this.mRemoteInterface);
                    }
                    catch (RaonException e) {
                        this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)e.getCode()), e.getCode());
                        return this.mResultCode;
                    }
                    if (this.roomlist == null || this.roomlist.length != this.mcert_count || nCertCount != this.mcert_count) {
                        try {
                            getcertlist = Raon_Usim_Api.Raon_GetCertlist((Context)this.mContext, (IRemoteInterface)this.mRemoteInterface);
                            this.mgetcertlist = new GetCertList();
                            this.mgetcertlist = getcertlist;
                            if (getcertlist != null && getcertlist.certlist.size() > 0) {
                                this.roomlist = new int[getcertlist.certlist.size()];
                            }
                            i = 0;
                            while (i < this.roomlist.length) {
                                this.roomlist[i] = Integer.parseInt(((GetCertList_Parcel)getcertlist.certlist.get((int)i)).certpath);
                                ++i;
                            }
                        }
                        catch (RaonException e) {
                            this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)e.getCode()), e.getCode());
                            return this.mResultCode;
                        }
                    }
                } else {
                    if (this.mgetcertlist == null || this.mcert_count != this.mgetcertlist.certlist.size()) {
                        this.getCertCount();
                    }
                    if (this.mgetcertlist != null && this.mgetcertlist.certlist.size() > 0) {
                        this.roomlist = new int[this.mgetcertlist.certlist.size()];
                    }
                    i = 0;
                    while (i < this.roomlist.length) {
                        this.roomlist[i] = Integer.parseInt(((GetCertList_Parcel)this.mgetcertlist.certlist.get((int)i)).certpath);
                        ++i;
                    }
                }
                if (pin == null || pin.length != 8) {
                    this.mResultCode.setResultCode(5004, 5004);
                    return this.mResultCode;
                }
                try {
                    temp_pin = (byte[])pin.clone();
                    Raon_Usim_Api.Raon_CheckPin((Context)this.mContext, (IRemoteInterface)this.mRemoteInterface, (byte[])temp_pin);
                    i = 0;
                    while (i < temp_pin.length) {
                        temp_pin[i] = 0;
                        ++i;
                    }
                    this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)1), 1);
                    ** GOTO lbl70
                }
                catch (RaonException e) {
                    this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)e.getCode()), e.getCode());
                    i = 0;
                    ** while (i < temp_pin.length)
                }
lbl-1000:
                // 1 sources

                {
                    temp_pin[i] = 0;
                    ++i;
                    continue;
                }
lbl69:
                // 1 sources

                return this.mResultCode;
lbl70:
                // 1 sources

                try {
                    temp_pin = (byte[])pin.clone();
                    Raon_Usim_Api.Raon_Delete_Cert((Context)this.mContext, (IRemoteInterface)this.mRemoteInterface, (int)this.roomlist[index], (byte[])pin);
                    i = 0;
                    while (i < temp_pin.length) {
                        temp_pin[i] = 0;
                        ++i;
                    }
                    this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)1), 1);
                    i = 0;
                    while (i < pin.length) {
                        pin[i] = 0;
                        ++i;
                    }
                    break;
                }
                catch (RaonException e) {
                    this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)e.getCode()), e.getCode());
                    i = 0;
                    ** while (i < temp_pin.length)
                }
lbl-1000:
                // 1 sources

                {
                    temp_pin[i] = 0;
                    ++i;
                    continue;
                }
lbl93:
                // 1 sources

                i = 0;
                while (i < pin.length) {
                    pin[i] = 0;
                    ++i;
                }
                break;
            }
            case 2: {
                if (!this.dream_bind.booleanValue()) {
                    this.mResultCode.setResultCode(1002, 9002);
                    break;
                }
                try {
                    loginResult = this.getDream_LoginResult(pin);
                    if (!loginResult) break;
                    delResult = this.dream_Aidl.deleteCertAndPriKey(index);
                    if (delResult.getResultCode() != 0) {
                        stateResult = this.setServiceState(delResult.getResultCode());
                        if (!stateResult) {
                            this.mResultCode.setResultCode(7013, delResult.getResultCode());
                        }
                    } else {
                        this.mResultCode.setResultCode(0, 0);
                    }
                    this.getDream_Logout();
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    this.dream_bind = false;
                    this.mResultCode.setResultCode(9003, 9002);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.mResultCode.setResultCode(7013, 9999);
                }
                break;
            }
            default: {
                this.mResultCode.setResultCode(1001, 1001);
            }
        }
        return this.mResultCode;
    }

    public SmartUsimResultCode changePIN(int requestCode) {
        if (this.mPossibleService == 1004) {
            this.mResultCode.setResultCode(1004, 1004);
            return this.mResultCode;
        }
        switch (this.mServiceVendor) {
            case 1: {
                if (!this.flag_mBound.booleanValue()) {
                    this.mResultCode.setResultCode(1002, 9002);
                    break;
                }
                try {
                    Raon_Usim_Api.Raon_Edit_PinNum((Context)this.mContext);
                    this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)1), 1);
                }
                catch (RaonException e) {
                    e.printStackTrace();
                    this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)e.getCode()), e.getCode());
                }
                break;
            }
            case 2: {
                if (!this.dream_bind.booleanValue()) {
                    this.mResultCode.setResultCode(1002, 9002);
                    break;
                }
                try {
                    SmartCertActivity dreamChangePIN = new SmartCertActivity(this.mContext);
                    dreamChangePIN.startChangePIN(requestCode);
                    this.mResultCode.setResultCode(0, 0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.mResultCode.setResultCode(7016, 9999);
                }
                break;
            }
            default: {
                this.mResultCode.setResultCode(1001, 1001);
            }
        }
        return this.mResultCode;
    }

    public String[] getErrorStatusContact() {
        String[] retContact = new String[2];
        int i = 0;
        while (i < 2) {
            retContact[i] = null;
            ++i;
        }
        if (this.mPossibleService == 1004) {
            this.mResultCode.setResultCode(1004, 1004);
            return retContact;
        }
        switch (this.mServiceVendor) {
            case 1: {
                if (!this.flag_mBound.booleanValue()) {
                    this.mResultCode.setResultCode(1002, 9002);
                    break;
                }
                retContact[0] = "RAON";
                retContact[1] = "1644-5128";
                break;
            }
            case 2: {
                if (!this.dream_bind.booleanValue()) {
                    this.mResultCode.setResultCode(1002, 9002);
                    break;
                }
                retContact[0] = "DREAM";
                retContact[1] = "1688-0124";
                break;
            }
            default: {
                this.mResultCode.setResultCode(1001, 1001);
            }
        }
        return retContact;
    }

    public SmartUsimResultCode initPIN() {
        if (!this.dream_bind.booleanValue() && !this.flag_mBound.booleanValue()) {
            this.mResultCode.setResultCode(1002, 9002);
            return this.mResultCode;
        }
        if (this.mPossibleService == 1004) {
            this.mResultCode.setResultCode(1004, 1004);
            return this.mResultCode;
        }
        switch (this.mServiceVendor) {
            case 1: {
                if (!this.flag_mBound.booleanValue()) {
                    this.mResultCode.setResultCode(1002, 9002);
                    break;
                }
                try {
                    Raon_Usim_Api.Raon_Edit_PinNum((Context)this.mContext);
                    this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)1), 1);
                }
                catch (RaonException e) {
                    e.printStackTrace();
                    this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)e.getCode()), e.getCode());
                }
                break;
            }
            case 2: {
                try {
                    SmartCertActivity dreamChangePIN = new SmartCertActivity(this.mContext);
                    dreamChangePIN.startManageCert(72);
                    this.mResultCode.setResultCode(0, 0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.mResultCode.setResultCode(7017, 9999);
                }
                break;
            }
            default: {
                this.mResultCode.setResultCode(1001, 1001);
            }
        }
        return this.mResultCode;
    }

    private String getPhoneNo() {
        TelephonyManager telManager = (TelephonyManager)this.mContext.getSystemService("phone");
        String mPhoneNumber = telManager.getLine1Number();
        if (mPhoneNumber == null || mPhoneNumber.equals("")) {
            return null;
        }
        if (mPhoneNumber != null && mPhoneNumber.contains("+82")) {
            mPhoneNumber = mPhoneNumber.replace("+82", "0");
        }
        return mPhoneNumber;
    }

    private int getPhoneUser() {
        int lastNum;
        TelephonyManager telManager = (TelephonyManager)this.mContext.getSystemService("phone");
        String mPhoneNumber = telManager.getLine1Number();
        if (mPhoneNumber == null || mPhoneNumber.equals("")) {
            return -1;
        }
        if (mPhoneNumber != null && mPhoneNumber.contains("+82")) {
            mPhoneNumber = mPhoneNumber.replace("+82", "0");
        }
        if ((lastNum = Integer.parseInt(mPhoneNumber.substring(mPhoneNumber.length() - 1))) % 2 == 0) {
            return 1;
        }
        return 2;
    }

    private int getTelecom() {
        TelephonyManager tm = (TelephonyManager)this.mContext.getApplicationContext().getSystemService("phone");
        String operatorName = tm.getNetworkOperatorName();
        if (operatorName.toLowerCase().contains("SK".toLowerCase())) {
            return 2;
        }
        if (operatorName.toLowerCase().contains("KT".toLowerCase()) || operatorName.toLowerCase().contains("olleh".toLowerCase())) {
            return 3;
        }
        if (operatorName.toLowerCase().contains("LG".toLowerCase())) {
            return 1;
        }
        String phoneModel = Build.MODEL;
        if ((phoneModel = phoneModel.substring(phoneModel.length() - 1, phoneModel.length())).equalsIgnoreCase("S")) {
            return 2;
        }
        if (phoneModel.equalsIgnoreCase("K")) {
            return 3;
        }
        if (phoneModel.equalsIgnoreCase("L")) {
            return 1;
        }
        return -1;
    }

    private boolean isInstall_Raon() {
        int result = -1;
        boolean bInstall = false;
        try {
            result = Raon_Usim_Api.Raon_Check_Package((Context)this.mContext);
        }
        catch (RaonException e) {
            result = e.getCode();
        }
        bInstall = result == 1;
        return bInstall;
    }

    private boolean isInstall_Dream() {
        boolean bInstall = false;
        if (this.dream_Install == null) {
            this.dream_Install = new SmartCertInstall(this.mContext, (SmartCertListener)mThis);
        }
        bInstall = this.dream_Install.isSmartCertInstalled();
        return bInstall;
    }

    private boolean isMemberUseRaonAPI() {
        boolean user_yn = false;
        try {
            user_yn = Raon_Usim_Api.Raon_Check_User_NoneApp((Context)this.mContext, (String)" ");
            this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)1), 1);
            return user_yn;
        }
        catch (RaonException e) {
            this.mResultCode.setResultCode(Raon_Usim_Api.RaonHandleResultCode((int)e.getCode()), e.getCode());
            return false;
        }
    }

    private boolean isMemberUseDreamAPI() {
        boolean bMember = false;
        this.mResultCode.setResultCode(0, 0);
        if (this.dream_Install == null) {
            this.dream_Install = new SmartCertInstall(this.mContext, (SmartCertListener)mThis);
        }
        if (this.getTelecom() == 1) {
            this.mServiceVendor = 1;
            this.mUsimMember = 15;
            return false;
        }
        SmartCertResult scResult = this.dream_Install.isServiceVaild(this.mSiteID);
        int userResult = scResult.getResultCode();
        if (userResult == 0) {
            this.mServiceVendor = 2;
            this.mUsimMember = 12;
            bMember = true;
        } else {
            boolean setMemberResult = this.setMemberState(userResult);
            if (!setMemberResult) {
                this.mResultCode.setResultCode(2004, userResult);
                this.mUsimMember = 14;
            } else if (userResult == 3001) {
                switch (this.getTelecom()) {
                    case 2: {
                        this.mServiceVendor = this.getPhoneUser();
                        break;
                    }
                    case 3: {
                        this.mServiceVendor = 2;
                        break;
                    }
                    case 1: {
                        this.mServiceVendor = 1;
                    }
                }
                this.mUsimMember = 13;
            } else if (userResult == 3002) {
                this.mServiceVendor = 1;
                this.mUsimMember = 12;
                bMember = true;
            }
        }
        return bMember;
    }

    private boolean isPossibleState(String msg) {
        boolean isPossible = false;
        msg = msg.replace("|", "&");
        String[] defineMSG = msg.split("&");
        int i = 0;
        while (i < defineMSG.length) {
            if (defineMSG[i].equalsIgnoreCase("0061")) {
                isPossible = false;
                this.isNoMemberRaon = true;
                break;
            }
            if (defineMSG[i].equalsIgnoreCase("0041")) {
                isPossible = true;
                this.mUsimMember = 14;
                this.mResultCode.setResultCode(2010, 3010);
            } else if (defineMSG[i].equalsIgnoreCase("0042")) {
                isPossible = true;
                this.mUsimMember = 14;
                this.mResultCode.setResultCode(2009, 3009);
            } else if (defineMSG[i].equalsIgnoreCase("0043")) {
                isPossible = true;
                this.mUsimMember = 14;
                this.mResultCode.setResultCode(2005, 3005);
            } else if (defineMSG[i].equalsIgnoreCase("0044")) {
                isPossible = true;
                this.mUsimMember = 14;
                this.mResultCode.setResultCode(2006, 3006);
            } else if (defineMSG[i].equalsIgnoreCase("0045")) {
                isPossible = true;
                this.mUsimMember = 14;
                this.mResultCode.setResultCode(2007, 3007);
            } else if (defineMSG[i].equalsIgnoreCase("0046")) {
                isPossible = true;
                this.mUsimMember = 14;
                this.mResultCode.setResultCode(2004, 38);
            } else if (defineMSG[i].equalsIgnoreCase("0049")) {
                isPossible = true;
                this.mUsimMember = 14;
                this.mResultCode.setResultCode(2004, 3004);
            }
            ++i;
        }
        return isPossible;
    }

    private void setMemberUseDreamAPI(Map<String, Object> resMember) throws Exception {
        this.mResultCode.setResultCode(0, 0);
        String resultCode = (String)resMember.get("resultCode");
        String resultMsg = (String)resMember.get("resultMessage");
        if (resultCode.equalsIgnoreCase("0000")) {
            if (!this.isPossibleState(resultMsg)) {
                this.mServiceVendor = 2;
                this.mUsimMember = 12;
            }
        } else if (resultCode.equalsIgnoreCase("0001")) {
            if (!this.isPossibleState(resultMsg)) {
                if (this.isNoMemberRaon) {
                    this.mServiceVendor = 1;
                    this.mUsimMember = 13;
                } else {
                    this.mServiceVendor = 2;
                    this.mUsimMember = 13;
                }
            }
        } else if (resultCode.equalsIgnoreCase("0002")) {
            this.mServiceVendor = 0;
            this.mUsimMember = 14;
            this.mResultCode.setResultCode(2004, 2004);
        } else if (resultCode.equalsIgnoreCase("0003")) {
            this.mServiceVendor = 1;
            this.mUsimMember = 12;
        } else if (resultCode.equalsIgnoreCase("1001")) {
            this.mServiceVendor = 0;
            this.mUsimMember = 11;
            this.mResultCode.setResultCode(3001, 1001);
        } else if (resultCode.equalsIgnoreCase("1002") || resultCode.equalsIgnoreCase("1003") || resultCode.equalsIgnoreCase("1004")) {
            this.mServiceVendor = 0;
            this.mUsimMember = 11;
            this.mResultCode.setResultCode(9001, 9001);
        } else if (resultCode.equalsIgnoreCase("1005")) {
            this.mServiceVendor = 1;
            this.mUsimMember = 15;
        } else if (resultCode.equalsIgnoreCase("9000")) {
            this.mServiceVendor = 0;
            this.mUsimMember = 11;
            this.mResultCode.setResultCode(2004, 9999);
        } else {
            this.mResultCode.setResultCode(2004, 3004);
            this.mServiceVendor = 0;
            this.mUsimMember = 14;
        }
    }

    private SmartCertSignType getDream_SignType(int signType) {
        SmartCertSignType dsSignType = null;
        switch (signType) {
            case 4: {
                dsSignType = SmartCertSignType.SIGNATURE;
                break;
            }
            case 2: {
                dsSignType = SmartCertSignType.SIGNEDDATA_PKCS7;
                break;
            }
            case 1: {
                dsSignType = SmartCertSignType.SIGNEDDATA_CMS;
                break;
            }
            case 3: {
                dsSignType = SmartCertSignType.SIGNEDDATA_KOSCOM;
                break;
            }
        }
        return dsSignType;
    }

    private boolean getDream_LoginResult(byte[] pin) throws RemoteException {
        boolean result = false;
        SmartCertResult scResult = this.dream_Aidl.login(pin);
        int loginResult = scResult.getResultCode();
        if (loginResult == 0) {
            result = true;
        } else if (loginResult == 5002) {
            this.mResultCode.setResultCode(5001, loginResult);
        } else if (loginResult == 5003) {
            this.mResultCode.setResultCode(5002, loginResult);
        } else if (loginResult == 5004) {
            this.mResultCode.setResultCode(5003, loginResult);
        } else if (loginResult == 5001) {
            this.mResultCode.setResultCode(5004, loginResult);
        } else {
            this.mResultCode.setResultCode(7014, loginResult);
        }
        return result;
    }

    private void getDream_Logout() throws RemoteException {
        this.dream_Aidl.logout();
        SmartCertResult scResult = this.dream_Aidl.getResultCode();
        int logoutResult = scResult.getResultCode();
        if (logoutResult != 0) {
            this.mResultCode.setResultCode(7015, logoutResult);
        }
    }

    private int setDream_Filter() throws RemoteException {
        if (this.mFlagFilterCert == 0) {
            this.dream_Aidl.setFilter(SmartCertFilterType.FILTER_OFF, null);
        } else {
            StringBuffer sbFilter;
            if ((this.mFlagFilterCert & 1) == 1) {
                this.dream_Aidl.setFilter(SmartCertFilterType.OID, this.mMapFilterCert.get(1));
            }
            if ((this.mFlagFilterCert & 0x40) == 64) {
                this.dream_Aidl.setFilter(SmartCertFilterType.SPECIFIC, this.mMapFilterCert.get(64));
            }
            if ((this.mFlagFilterCert & 0x20) == 32) {
                sbFilter = new StringBuffer();
                sbFilter.append("subject=" + this.mMapFilterCert.get(32));
                if (sbFilter.length() != 0) {
                    this.dream_Aidl.setFilter(SmartCertFilterType.SPECIFIC, sbFilter.toString());
                }
            }
            if ((this.mFlagFilterCert & 8) == 8) {
                sbFilter = new StringBuffer();
                sbFilter.append("serial=" + this.mMapFilterCert.get(8));
                if (sbFilter.length() != 0) {
                    this.dream_Aidl.setFilter(SmartCertFilterType.SPECIFIC, sbFilter.toString());
                }
            }
        }
        SmartCertResult filterResult = this.dream_Aidl.getResultCode();
        return filterResult.getResultCode();
    }

    private String changeDateDREAMAPI(String date) {
        String result = null;
        try {
            SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
            Date formatTo = format.parse(date);
            SimpleDateFormat changeDate = new SimpleDateFormat("yyyy\ub144 MM\uc6d4 dd\uc77c");
            result = changeDate.format(formatTo);
        }
        catch (ParseException e) {
            e.printStackTrace();
            result = date;
        }
        return result;
    }

    private String parseISSUER(String Issuer) {
        int nIndex = 0;
        nIndex = 0;
        while (nIndex < this.ISSUERTABLE.length) {
            if (this.ISSUERTABLE[nIndex][0].toLowerCase().equals(Issuer.toLowerCase())) {
                return this.ISSUERTABLE[nIndex][1];
            }
            ++nIndex;
        }
        return Issuer;
    }

    private String CERT_GeCN(String DN) {
        int start = -1;
        int end = -1;
        String ret = null;
        String CN = "cn=";
        start = DN.indexOf(CN);
        if (start < 0) {
            return ret;
        }
        end = DN.indexOf(",", start += CN.length());
        if (end < 0) {
            ret = DN.substring(start);
        }
        ret = end < 0 ? DN.substring(start) : DN.substring(start, end);
        return ret;
    }

    private boolean setMemberState(int userResult) {
        boolean setResult = true;
        switch (userResult) {
            case 3001: {
                this.mUsimMember = 13;
                this.mResultCode.setResultCode(2001, userResult);
                break;
            }
            case 3002: {
                this.mUsimMember = 12;
                this.mServiceVendor = 1;
                this.mResultCode.setResultCode(2002, userResult);
                break;
            }
            case 3003: {
                this.mResultCode.setResultCode(2003, userResult);
                break;
            }
            case 3004: {
                this.mResultCode.setResultCode(2004, userResult);
                break;
            }
            case 3005: {
                this.mResultCode.setResultCode(2005, userResult);
                break;
            }
            case 3006: {
                this.mResultCode.setResultCode(2006, userResult);
                break;
            }
            case 3007: {
                this.mResultCode.setResultCode(2007, userResult);
                break;
            }
            case 3008: {
                this.mResultCode.setResultCode(2008, userResult);
                break;
            }
            case 3009: {
                this.mResultCode.setResultCode(2009, userResult);
                break;
            }
            case 1001: 
            case 1004: {
                this.mResultCode.setResultCode(3001, userResult);
                break;
            }
            case 4002: {
                this.mResultCode.setResultCode(4001, userResult);
                break;
            }
            default: {
                setResult = false;
            }
        }
        return setResult;
    }

    private boolean setPossibleState(int serviceResult) {
        boolean possibleResult = true;
        switch (serviceResult) {
            case 1001: 
            case 1004: {
                this.mResultCode.setResultCode(3001, serviceResult);
                break;
            }
            case 2002: {
                this.mIsUpdateApp = true;
                this.mResultCode.setResultCode(3002, serviceResult);
                break;
            }
            case 4002: {
                this.mResultCode.setResultCode(4002, serviceResult);
                break;
            }
            case 4003: {
                this.mResultCode.setResultCode(4001, serviceResult);
                break;
            }
            case 1015: {
                this.mResultCode.setResultCode(6004, serviceResult);
                break;
            }
            case 6001: 
            case 6002: {
                this.mResultCode.setResultCode(9004, serviceResult);
                break;
            }
            default: {
                possibleResult = false;
            }
        }
        return possibleResult;
    }

    private boolean setServiceState(int serviceState) {
        boolean serviceResult = true;
        switch (serviceState) {
            case 1010: {
                this.mResultCode.setResultCode(1004, serviceState);
                break;
            }
            case 9001: {
                this.mResultCode.setResultCode(9001, serviceState);
                break;
            }
            case 6001: 
            case 6002: {
                this.mResultCode.setResultCode(9004, serviceState);
                break;
            }
            case 1007: {
                this.mResultCode.setResultCode(6002, serviceState);
                break;
            }
            case 1006: {
                this.mResultCode.setResultCode(6001, serviceState);
                break;
            }
            case 1013: {
                this.mResultCode.setResultCode(6003, serviceState);
                break;
            }
            default: {
                serviceResult = false;
            }
        }
        return serviceResult;
    }
}

