/*
 * Decompiled with CFR 0.152.
 */
package kr.co.skplanet.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;

public class Telephone {
    protected Telephone() {
    }

    public static boolean isEmulator() {
        String model = Build.MODEL;
        return model.contains("sdk") || model.contains("SDK");
    }

    public static String getMdn(Context context) {
        String mdn = ((TelephonyManager)context.getSystemService("phone")).getLine1Number();
        if (mdn != null && mdn.startsWith("+")) {
            mdn = mdn.replace("+82", "0");
        }
        return mdn;
    }

    public static boolean isAirplaneModeOn(Context context) {
        return Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"airplane_mode_on", (int)0) != 0;
    }

    public static boolean isInsertedUsim(Context context) {
        String strMdn = Telephone.getMdn(context);
        return strMdn != null && strMdn.length() > 0;
    }

    public static boolean isRoaming(Context context) {
        return ((TelephonyManager)context.getSystemService("phone")).isNetworkRoaming();
    }

    public static void setAirplaneMode(Context context, boolean bEnable) {
        int nStatus;
        boolean bAirplaneMode = Telephone.isAirplaneModeOn(context);
        if (bAirplaneMode == bEnable) {
            return;
        }
        int n = nStatus = bEnable ? 1 : 0;
        if (nStatus == 1 && bAirplaneMode || nStatus == 0 && !bAirplaneMode) {
            return;
        }
        ContentResolver contentresolver = context.getContentResolver();
        Settings.System.putInt((ContentResolver)contentresolver, (String)"airplane_mode_on", (int)nStatus);
        Intent intent = new Intent("android.intent.action.AIRPLANE_MODE");
        intent.putExtra("state", nStatus);
        context.sendBroadcast(intent);
    }
}

