/*
 * Decompiled with CFR 0.152.
 */
package kr.or.kftc.crypto;

import java.util.Arrays;
import kr.or.kftc.crypto.HSMCryptException;
import kr.or.kftc.crypto.RSAPublicKey;
import kr.or.kftc.mobiletoken_lib.util.LibLog;

public class HSMCrypt {
    static final String TAG = HSMCrypt.class.getSimpleName();
    private static final String LIB_NAME = "MTKCrypto";
    private static final byte DEBUG_MODE_OFF = 0;
    private static final byte DEBUG_MODE_ON = 1;
    public static final byte HSMCRYPT_ALG_TDES = 16;
    public static final byte HSMCRYPT_ALG_SEED = 32;
    public static final byte HSMCRYPT_ALG_AES128 = 64;
    public static final byte HSMCRYPT_ALG_RSA = -128;
    public static final long CKM_RSA_PKCS = 1L;
    public static final long CKM_RSA_PKCS_OAEP = 9L;
    public static final long CKM_RSA_PKCS_PSS = 13L;
    public static final int HSMCRYPT_MODE_ECB = 0;
    public static final int HSMCRYPT_MODE_CBC = 1;
    private byte[] sKey;
    private byte algorithm;

    static {
        System.loadLibrary(LIB_NAME);
    }

    private native int JNISetLibraryParam(int var1, byte[] var2, int var3);

    private native byte[] JNIRSAPubEncryptPIN(byte[] var1, byte[] var2, byte[] var3, byte[] var4, int var5);

    private native byte[] JNIRSAPubEncryptSymmKey(byte[] var1, byte[] var2, byte[] var3, int var4);

    private native byte[] JNIAES128EncryptPINVerify(byte[] var1, byte[] var2, byte[] var3, int var4, byte[] var5);

    private native byte[] JNIAES128EncryptPINPutpin(byte[] var1, int var2, byte[] var3);

    private native byte[] JNIAES128EncryptPrivateKey(int var1, byte[] var2, byte[] var3, int var4);

    private native byte[] JNITDESEncryptPINVerify(byte[] var1, byte[] var2, byte[] var3, int var4, byte[] var5);

    private native byte[] JNITDESEncryptPINPutpin(byte[] var1, int var2, byte[] var3);

    private native byte[] JNITDESEncryptPrivateKey(int var1, byte[] var2, byte[] var3, int var4);

    private native byte[] JNISEEDEncryptPINVerify(byte[] var1, byte[] var2, byte[] var3, int var4, byte[] var5);

    private native byte[] JNISEEDEncryptPINPutpin(byte[] var1, int var2, byte[] var3);

    private native byte[] JNISEEDEncryptPrivateKey(int var1, byte[] var2, byte[] var3, int var4);

    private native byte[] JNIGenerateRandom(int var1);

    public HSMCrypt(byte alg) throws HSMCryptException {
        switch (alg) {
            case -128: 
            case 16: 
            case 32: 
            case 64: {
                this.algorithm = alg;
                break;
            }
            default: {
                throw new HSMCryptException("Unsupported Algorithm", 4050);
            }
        }
        this.sKey = null;
        try {
            this.JNISetLibraryParam(0, null, 0);
        }
        catch (Exception e) {
            LibLog.e(TAG, "!! HSMCrypt Constructor Exception");
            e.printStackTrace();
            throw new HSMCryptException("Internal error", 4063);
        }
    }

    public HSMCrypt(byte alg, String debug) throws HSMCryptException {
        switch (alg) {
            case -128: 
            case 16: 
            case 32: 
            case 64: {
                this.algorithm = alg;
                break;
            }
            default: {
                throw new HSMCryptException("Unsupported Algorithm", 4050);
            }
        }
        this.sKey = null;
        if (debug == null) {
            throw new HSMCryptException("'debug' can't be null", 4049);
        }
        try {
            this.JNISetLibraryParam(1, debug.getBytes(), debug.length());
        }
        catch (Exception e) {
            LibLog.e(TAG, "!! HSMCrypt Constructor Exception");
            e.printStackTrace();
            throw new HSMCryptException("Internal error", 4063);
        }
    }

    public byte[] EncryptPINVerify(byte[] cardRand, byte[] appRand, byte[] PIN) throws HSMCryptException {
        byte[] temp = null;
        try {
            if (cardRand == null) {
                throw new HSMCryptException("Card Random can't be null", 4049);
            }
            if (appRand == null) {
                throw new HSMCryptException("Application Random can't be null", 4049);
            }
            if (PIN == null) {
                throw new HSMCryptException("PIN can't be null", 4049);
            }
            if (cardRand.length != 16) {
                throw new HSMCryptException("Invalid card random length", 4049);
            }
            if (appRand.length != 16) {
                throw new HSMCryptException("Invalid application random length", 4049);
            }
            byte[] tmpSKey = new byte[16];
            switch (this.algorithm) {
                case 16: {
                    temp = this.JNITDESEncryptPINVerify(cardRand, appRand, PIN, PIN.length, tmpSKey);
                    if (temp != null) break;
                    throw new HSMCryptException("JNITDESEncryptPINVerify() returns null", 4063);
                }
                case 32: {
                    temp = this.JNISEEDEncryptPINVerify(cardRand, appRand, PIN, PIN.length, tmpSKey);
                    if (temp != null) break;
                    throw new HSMCryptException("JNISEEDEncryptPINVerify() returns null", 4063);
                }
                case 64: {
                    temp = this.JNIAES128EncryptPINVerify(cardRand, appRand, PIN, PIN.length, tmpSKey);
                    if (temp != null) break;
                    throw new HSMCryptException("JNIAES128EncryptPINVerify() returns null", 4063);
                }
                default: {
                    throw new HSMCryptException("Unsupported Algorithm", 4050);
                }
            }
            this.sKey = new byte[tmpSKey.length];
            System.arraycopy(tmpSKey, 0, this.sKey, 0, tmpSKey.length);
        }
        catch (Exception e) {
            LibLog.e(TAG, "!! EncryptPINVerify Exception");
            e.printStackTrace();
            throw new HSMCryptException("Internal error", 4063);
        }
        return temp;
    }

    public byte[] EncryptPINVerify(byte[] cardRand, byte[] PIN, RSAPublicKey pubKey) throws HSMCryptException {
        byte[] temp = null;
        try {
            if (this.algorithm != -128) {
                throw new HSMCryptException("Unsupported Algorithm", 4050);
            }
            if (cardRand == null) {
                throw new HSMCryptException("Card Random can't be null", 4049);
            }
            if (PIN == null) {
                throw new HSMCryptException("PIN can't be null", 4049);
            }
            if (pubKey.getKeyLength() != 128) {
                throw new HSMCryptException("Invalid key length", 4049);
            }
            if (cardRand.length != 16) {
                throw new HSMCryptException("Invalid card random length", 4049);
            }
            temp = this.JNIRSAPubEncryptPIN(pubKey.getModulus(), pubKey.getExponent(), cardRand, PIN, PIN.length);
            if (temp == null) {
                throw new HSMCryptException("JNIRSAPubEncryptPIN() returns null", 4063);
            }
        }
        catch (Exception e) {
            LibLog.e(TAG, "!! EncryptPINVerify for RSA Exception");
            e.printStackTrace();
            throw new HSMCryptException("Internal error", 4063);
        }
        return temp;
    }

    public byte[] EncryptSymmKey(byte[] SymmKey, RSAPublicKey pubKey) throws HSMCryptException {
        byte[] temp = null;
        try {
            if (this.algorithm != -128) {
                throw new HSMCryptException("Unsupported Algorithm", 4050);
            }
            if (SymmKey == null) {
                throw new HSMCryptException("Symmetric Key can't be null", 4049);
            }
            if (pubKey.getKeyLength() != 128 && pubKey.getKeyLength() != 256) {
                throw new HSMCryptException("Invalid key length", 4049);
            }
            if (SymmKey.length != 16) {
                throw new HSMCryptException("Invalid Symmetric Key length", 4049);
            }
            temp = this.JNIRSAPubEncryptSymmKey(pubKey.getModulus(), pubKey.getExponent(), SymmKey, SymmKey.length);
            if (temp == null) {
                throw new HSMCryptException("JNIRSAPubEncryptSymmKey() returns null", 4063);
            }
        }
        catch (Exception e) {
            LibLog.e(TAG, "!! EncryptSymmKey Exception");
            e.printStackTrace();
            throw new HSMCryptException("Internal error", 4063);
        }
        return temp;
    }

    public byte[] EncryptPINPutpin(byte[] PIN) throws HSMCryptException {
        byte[] temp = null;
        try {
            if (PIN == null) {
                throw new HSMCryptException("PIN can't be null", 4049);
            }
            if (this.sKey == null) {
                throw new HSMCryptException("Session key not found", 4049);
            }
            switch (this.algorithm) {
                case 16: {
                    temp = this.JNITDESEncryptPINPutpin(PIN, PIN.length, this.sKey);
                    if (temp == null) {
                        throw new HSMCryptException("JNITDESEncryptPINPutpin() returns null", 4063);
                    }
                    break;
                }
                case 32: {
                    temp = this.JNISEEDEncryptPINPutpin(PIN, PIN.length, this.sKey);
                    if (temp == null) {
                        throw new HSMCryptException("JNISEEDEncryptPINPutpin() returns null", 4063);
                    }
                    break;
                }
                case 64: {
                    temp = this.JNIAES128EncryptPINPutpin(PIN, PIN.length, this.sKey);
                    if (temp == null) {
                        throw new HSMCryptException("JNIAES128EncryptPINPutpin() returns null", 4063);
                    }
                    break;
                }
                default: {
                    throw new HSMCryptException("Unsupported Algorithm", 4050);
                }
            }
        }
        catch (Exception e) {
            LibLog.e(TAG, "!! EncryptPINPutpin Exception");
            e.printStackTrace();
            throw new HSMCryptException("Internal error", 4063);
        }
        return temp;
    }

    public byte[] EncryptPrivateKey(int mode, byte[] key, byte[] priKey) throws HSMCryptException {
        byte[] temp = null;
        try {
            if (key == null) {
                throw new HSMCryptException("key can't be null", 4049);
            }
            if (priKey == null) {
                throw new HSMCryptException("priKey can't be null", 4049);
            }
            switch (this.algorithm) {
                case 16: {
                    temp = this.JNITDESEncryptPrivateKey(mode, key, priKey, priKey.length);
                    if (temp == null) {
                        throw new HSMCryptException("JNITDESEncryptPrivateKey() returns null", 4063);
                    }
                    break;
                }
                case 32: {
                    temp = this.JNISEEDEncryptPrivateKey(mode, key, priKey, priKey.length);
                    if (temp == null) {
                        throw new HSMCryptException("JNISEEDEncryptPrivateKey() returns null", 4063);
                    }
                    break;
                }
                case 64: {
                    temp = this.JNIAES128EncryptPrivateKey(mode, key, priKey, priKey.length);
                    if (temp == null) {
                        throw new HSMCryptException("JNIAES128EncryptPrivateKey() returns null", 4063);
                    }
                    break;
                }
                default: {
                    throw new HSMCryptException("Unsupported Algorithm", 4050);
                }
            }
        }
        catch (Exception e) {
            LibLog.e(TAG, "!! EncryptPrivateKey Exception");
            e.printStackTrace();
            throw new HSMCryptException("Internal error", 4063);
        }
        return temp;
    }

    public byte[] EncryptPINPutpin(byte[] cardRand, byte[] PIN, RSAPublicKey pubKey) throws HSMCryptException {
        byte[] temp = null;
        try {
            if (this.algorithm != -128) {
                throw new HSMCryptException("Unsupported Algorithm", 4050);
            }
            if (cardRand == null) {
                throw new HSMCryptException("Card Random can't be null", 4049);
            }
            if (PIN == null) {
                throw new HSMCryptException("PIN can't be null", 4049);
            }
            if (pubKey.getKeyLength() != 128) {
                throw new HSMCryptException("Invalid key length", 4049);
            }
            if (cardRand.length != 16) {
                throw new HSMCryptException("Invalid card random length", 4049);
            }
            temp = this.JNIRSAPubEncryptPIN(pubKey.getModulus(), pubKey.getExponent(), cardRand, PIN, PIN.length);
            if (temp == null) {
                throw new HSMCryptException("JNIRSAPubEncryptPIN() returns null", 4063);
            }
        }
        catch (Exception e) {
            LibLog.e(TAG, "!! EncryptPINPutpin Exception");
            e.printStackTrace();
            throw new HSMCryptException("Internal error", 4063);
        }
        return temp;
    }

    public byte[] RSAPaddingForSign(long mechanism, int key_len, byte[] digestInfo) throws HSMCryptException {
        byte[] temp = null;
        try {
            if (mechanism != 1L) {
                throw new HSMCryptException("Not supported mechanism", 4049);
            }
            if (key_len != 128 && key_len != 256) {
                throw new HSMCryptException("key_len must be 128 or 256", 4049);
            }
            if (digestInfo.length + 11 > key_len) {
                throw new HSMCryptException("key_len too short", 4049);
            }
            temp = new byte[key_len];
            Arrays.fill(temp, (byte)-1);
            temp[0] = 0;
            temp[1] = 1;
            temp[key_len - digestInfo.length - 1] = 0;
            System.arraycopy(digestInfo, 0, temp, key_len - digestInfo.length, digestInfo.length);
        }
        catch (Exception e) {
            LibLog.e(TAG, "!! RSAPaddingForSign Exception");
            e.printStackTrace();
            throw new HSMCryptException("Internal error", 4063);
        }
        return temp;
    }

    public byte[] RSAPaddingForEncrypt(long mechanism, int key_len, byte[] message) throws HSMCryptException {
        byte[] temp = null;
        try {
            if (mechanism != 1L) {
                throw new HSMCryptException("Not supported mechanism", 4049);
            }
            if (key_len != 128 && key_len != 256) {
                throw new HSMCryptException("key_len must be 128 or 256", 4049);
            }
            if (message.length > key_len - 11) {
                throw new HSMCryptException("message too long", 4049);
            }
            temp = new byte[key_len];
            temp[0] = 0;
            temp[1] = 2;
            this.generateRandom(temp, 2, key_len - message.length - 3);
            temp[key_len - message.length - 1] = 0;
            System.arraycopy(message, 0, temp, key_len - message.length, message.length);
        }
        catch (Exception e) {
            LibLog.e(TAG, "!! RSAPaddingForEncrypt Exception");
            e.printStackTrace();
            throw new HSMCryptException("Internal error", 4063);
        }
        return temp;
    }

    public byte[] RSAUnpaddingForDecrypt(long mechanism, int key_len, byte[] message) throws HSMCryptException {
        try {
            if (mechanism != 1L) {
                throw new HSMCryptException("\uc9c0\uc6d0\ub418\uc9c0 \uc54a\ub294 \uba54\ucee4\ub2c8\uc998 \uc0ac\uc6a9", 4049);
            }
            if (key_len != 128 && key_len != 256) {
                throw new HSMCryptException("\ud0a4 \uae38\uc774 \uc624\ub958(\ud0a4 \uae38\uc774\ub294 128 \ub610\ub294 256 \uc0ac\uc6a9)", 4049);
            }
            if (message.length != key_len) {
                throw new HSMCryptException("\ubcf5\ud638\ud654\ub41c \ub370\uc774\ud130\uc758 \uae38\uc774\uc640 \ud0a4\uc758 \uae38\uc774\uac00 \uc0c1\uc774", 4049);
            }
            if (message[0] != 0 || message[1] != 2) {
                throw new HSMCryptException("\ubcf5\ud638\ud654\ub41c \ub370\uc774\ud0c0 \uc720\ud6a8\uc131 \ud655\uc778 \uc2e4\ud328(\uc554\ubcf5\ud638\uc5d0 \uc0ac\uc6a9\ub41c \ud0a4\ub098 \uc804\ub2ec\ub41c \uc554\ud638\ubb38 \ud655\uc778 \ud544\uc694)", 4052);
            }
            int ps_len = 0;
            int i = 2;
            while (i < message.length) {
                if (message[i] == 0) {
                    ++i;
                    if (ps_len < 8) {
                        throw new HSMCryptException("\ubcf5\ud638\ud654\ub41c \ub370\uc774\ud0c0 \uc720\ud6a8\uc131 \ud655\uc778 \uc2e4\ud328(the length of PS is less than 8 octets)", 4052);
                    }
                    byte[] temp = new byte[message.length - i];
                    System.arraycopy(message, i, temp, 0, temp.length);
                    return temp;
                }
                ++ps_len;
                ++i;
            }
        }
        catch (Exception e) {
            LibLog.e(TAG, "!! RSAUnpaddingForDecrypt Exception");
            e.printStackTrace();
            throw new HSMCryptException("Internal error", 4063);
        }
        throw new HSMCryptException("\ubcf5\ud638\ud654\ub41c \ub370\uc774\ud0c0 \uc720\ud6a8\uc131 \ud655\uc778 \uc2e4\ud328(\uc554\ubcf5\ud638\uc5d0 \uc0ac\uc6a9\ub41c \ud0a4\ub098 \uc804\ub2ec\ub41c \uc554\ud638\ubb38 \ud655\uc778 \ud544\uc694)", 4052);
    }

    public void generateRandom(byte[] target, int offset, int length) {
        try {
            byte[] temp = this.JNIGenerateRandom(length);
            System.arraycopy(temp, 0, target, offset, length);
        }
        catch (Exception e) {
            LibLog.e(TAG, "!! generateRandom Exception");
            e.printStackTrace();
            throw new HSMCryptException("Internal error", 4063);
        }
    }

    public byte[] getSessionKey() {
        return this.sKey;
    }
}

