/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecurekeypad;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import com.softforum.xecurekeypad.XKCoreWrapper;
import com.softforum.xecurekeypad.XKEditText;
import com.softforum.xecurekeypad.XKKeyButton;
import com.softforum.xecurekeypad.XKKeypadInterface;
import com.softforum.xecurekeypad.XKKeypadResources;
import com.softforum.xecurekeypad.XKKeypadTopLayout;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;

public class XKQwertyKeypad {
    private final int QWERTY_KEYPAD_SHIFT_INDEX = 33;
    private final int QWERTY_KEYPAD_SPACE_INDEX = 42;
    private final int QWERTY_KEYPAD_DELETE_INDEX = 43;
    private final int QWERTY_KEYPAD_REFRESH_INDEX = 44;
    private final int QWERTY_KEYPAD_SYMBOL_INDEX = 45;
    private final int QWERTY_KEYPAD_COMPLETE_INDEX = 47;
    private final int QWERTY_KEYPAD_FUNCTION_KEY_COUNT = 6;
    private final int QWERTY_KEYPAD_NUMBER_KEY_COUNT = 10;
    private final int QWERTY_KEYPAD_QWERTY_KEY_COUNT = 26;
    private final int QWERTY_KEYPAD_SYMBOL_KEY_COUNT = 32;
    private final int QWERTY_KEYPAD_NUMBER_BLANK_COUNT = 1;
    private final int QWERTY_KEYPAD_QWERTY_BLANK_COUNT = 5;
    private final int QWERTY_KEYPAD_SYMBOL_BLANK_COUNT = 10;
    private final int QWERTY_KEYPAD_KEY_COUNT = 36;
    private final int QWERTY_KEYPAD_BLANK_COUNT = 6;
    private int mXKViewType = 0;
    private int mKeypadRowCount = 0;
    private int mKeypadColumnCount = 0;
    private int[] mXKKeypadIndex = null;
    private int mXKKeypadHeight = 0;
    private int mXKKeyWidth = 0;
    private int mXKKeyHeight = 0;
    private int mXKKeyWidthMargin = 0;
    private int mXKKeyHeightMargin = 0;
    private int mPopupWindowBackgroundID = 0;
    private String[] mXKKeypadIndexText = null;
    private boolean mSymbolMode = false;
    private boolean mShiftMode = false;
    private ImageView mInputImageView = null;
    private Drawable mXKBlankLogoImage = null;
    private XKEditText mXKEditText = null;
    private EditText mDummyEditText = null;
    private StringBuffer mDummyBuffer = new StringBuffer();
    private XKCoreWrapper mXKCoreWrapper = null;
    private XKKeypadInterface mXKKeypadInterface = null;
    private XKKeypadResources mXKKeypadResources = null;
    private XKKeypadTopLayout mXKKeypadTopLayout = null;
    private Timer mInputKeyTimer = null;
    private PopupWindow mXKPopupWindow = null;
    private ArrayList<LinearLayout> mKeypadLayoutList = null;
    private ArrayList<XKKeyButton> mXKKeyList = null;
    private XKKeyButton mShiftButton = null;
    private XKKeyButton mDeleteButton = null;
    private XKKeyButton mRefreshButton = null;
    private XKKeyButton mSymbolButton = null;
    private XKKeyButton mCompleteButton = null;
    private Context mContext = null;
    private Activity mActivity = null;

    public XKQwertyKeypad(Context pContext) {
        this.mContext = pContext;
        this.mActivity = (Activity)this.mContext;
    }

    public void initKeypad() {
        int aRowCount = 0;
        ImageButton aCancelButton = null;
        LinearLayout aKeypadRowLayout = null;
        RelativeLayout.LayoutParams aRowLayoutParams = null;
        this.mXKViewType = this.mXKEditText.getKeypadViewType();
        this.mXKKeypadResources = new XKKeypadResources(this.mActivity);
        this.mXKKeypadInterface = new XKKeypadInterface(this.mXKEditText, this.mXKCoreWrapper);
        this.mXKKeypadInterface.clearIndex();
        this.mXKKeypadTopLayout = (XKKeypadTopLayout)this.mActivity.findViewById(this.mActivity.getResources().getIdentifier("xk_keypad_top_layout", "id", this.mActivity.getPackageName()));
        if (this.mXKKeypadTopLayout != null) {
            this.mInputImageView = this.mXKKeypadTopLayout.getInputImageView();
            this.mInputImageView.setImageResource(this.mXKKeypadResources.getClickedSpaceImageID());
        }
        if (this.mXKViewType == 1 && (aCancelButton = (ImageButton)this.mActivity.findViewById(this.mActivity.getResources().getIdentifier("cancel_button", "id", this.mActivity.getPackageName()))) != null) {
            aCancelButton.setContentDescription((CharSequence)"\ub2eb\uae30");
            aCancelButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    XKQwertyKeypad.this.inputCancel();
                }
            });
        }
        this.mKeypadLayoutList = new ArrayList();
        this.mKeypadRowCount = 5;
        this.mKeypadColumnCount = 11;
        this.initKeypadButton();
        aRowCount = 0;
        while (aRowCount < this.mKeypadRowCount) {
            aKeypadRowLayout = new LinearLayout(this.mContext);
            aRowLayoutParams = new RelativeLayout.LayoutParams(-1, -2);
            if (aRowCount != 0) {
                aRowLayoutParams.addRule(3, this.mKeypadLayoutList.get(aRowCount - 1).getId());
            }
            aRowLayoutParams.topMargin = this.mXKKeyHeightMargin;
            aKeypadRowLayout.setId(aKeypadRowLayout.hashCode());
            aKeypadRowLayout.setLayoutParams((ViewGroup.LayoutParams)aRowLayoutParams);
            if (aRowCount == this.mKeypadRowCount - 1) {
                aKeypadRowLayout.setPadding(this.mXKKeyWidthMargin, 0, this.mXKKeyWidthMargin, this.mXKKeyHeightMargin);
            } else {
                aKeypadRowLayout.setPadding(this.mXKKeyWidthMargin, 0, this.mXKKeyWidthMargin, 0);
            }
            this.mKeypadLayoutList.add(aKeypadRowLayout);
            ++aRowCount;
        }
    }

    private void initKeypadButton() {
        int aDeviceHeight = 0;
        int aDeviceWidth = 0;
        int aHeightPercent = 0;
        int aXKKeypadHeight = 0;
        int aXKKeypadWidth = 0;
        float aWidthMarginPercent = 0.0f;
        float aHeightMarginPercent = 0.0f;
        DisplayMetrics aDisplayMetrics = null;
        int aTotalKeySize = 0;
        int aKeyCount = 0;
        LinearLayout.LayoutParams aKeyButtonLayoutParams = null;
        LinearLayout.LayoutParams aFunctionKeyButtonLayoutParams = null;
        XKKeyButton aXKKeyButton = null;
        aWidthMarginPercent = 1.0f;
        aHeightMarginPercent = 0.5f;
        aHeightPercent = 38;
        aDisplayMetrics = new DisplayMetrics();
        this.mActivity.getWindowManager().getDefaultDisplay().getMetrics(aDisplayMetrics);
        aDeviceWidth = aDisplayMetrics.widthPixels;
        aDeviceHeight = aDisplayMetrics.heightPixels;
        this.mXKKeyWidthMargin = (int)((float)aDeviceWidth * aWidthMarginPercent) / 100;
        this.mXKKeyHeightMargin = (int)((float)aDeviceHeight * aHeightMarginPercent) / 100;
        this.mXKKeypadHeight = aXKKeypadHeight = aDeviceHeight * aHeightPercent / 100;
        this.mXKKeyHeight = (aXKKeypadHeight -= (this.mKeypadRowCount + 1) * this.mXKKeyHeightMargin) / this.mKeypadRowCount;
        aXKKeypadWidth = aDeviceWidth - (this.mKeypadColumnCount + 1) * this.mXKKeyWidthMargin;
        this.mXKKeyWidth = aXKKeypadWidth / this.mKeypadColumnCount;
        this.mXKKeyList = new ArrayList();
        aFunctionKeyButtonLayoutParams = new LinearLayout.LayoutParams(-2, this.mXKKeyHeight);
        aFunctionKeyButtonLayoutParams.weight = 1.0f;
        aFunctionKeyButtonLayoutParams.gravity = 17;
        this.mRefreshButton = new XKKeyButton(this.mContext);
        this.mDeleteButton = new XKKeyButton(this.mContext);
        this.mCompleteButton = new XKKeyButton(this.mContext);
        this.mShiftButton = new XKKeyButton(this.mContext);
        this.mSymbolButton = new XKKeyButton(this.mContext);
        aFunctionKeyButtonLayoutParams.rightMargin = this.mXKKeyWidthMargin;
        this.mRefreshButton.setLayoutParams((ViewGroup.LayoutParams)aFunctionKeyButtonLayoutParams);
        this.mShiftButton.setLayoutParams((ViewGroup.LayoutParams)aFunctionKeyButtonLayoutParams);
        this.mSymbolButton.setLayoutParams((ViewGroup.LayoutParams)aFunctionKeyButtonLayoutParams);
        aFunctionKeyButtonLayoutParams = new LinearLayout.LayoutParams(-2, this.mXKKeyHeight);
        aFunctionKeyButtonLayoutParams.weight = 1.0f;
        aFunctionKeyButtonLayoutParams.gravity = 17;
        aFunctionKeyButtonLayoutParams.rightMargin = 0;
        aFunctionKeyButtonLayoutParams.leftMargin = this.mXKKeyWidthMargin;
        this.mCompleteButton.setLayoutParams((ViewGroup.LayoutParams)aFunctionKeyButtonLayoutParams);
        this.mDeleteButton.setLayoutParams((ViewGroup.LayoutParams)aFunctionKeyButtonLayoutParams);
        aTotalKeySize = 43;
        aKeyCount = 0;
        while (aKeyCount < aTotalKeySize) {
            aKeyButtonLayoutParams = new LinearLayout.LayoutParams(-2, this.mXKKeyHeight);
            aKeyButtonLayoutParams.weight = 1.0f;
            aKeyButtonLayoutParams.gravity = 17;
            aKeyButtonLayoutParams.leftMargin = aKeyCount % this.mKeypadColumnCount == 0 || aKeyCount == 42 ? 0 : this.mXKKeyWidthMargin;
            aXKKeyButton = new XKKeyButton(this.mContext);
            aXKKeyButton.initKeyButton();
            aXKKeyButton.setLayoutParams((ViewGroup.LayoutParams)aKeyButtonLayoutParams);
            this.mXKKeyList.add(aXKKeyButton);
            ++aKeyCount;
        }
    }

    public void setXKKeypad() {
        int aRowCount = 0;
        int aRealIndexCount = 0;
        int aIndexCount = 0;
        String aE2EURL = null;
        LinearLayout aKeypadRowLayout = null;
        aE2EURL = this.mXKEditText.getE2EURL();
        if (aE2EURL != null) {
            this.mXKKeypadTopLayout.refreshSessionTimer(this.mXKCoreWrapper.getE2ESessionTime());
        }
        while (aIndexCount < 48) {
            aKeypadRowLayout = this.mKeypadLayoutList.get(aRowCount);
            if (aIndexCount == 33) {
                aKeypadRowLayout.addView((View)this.mShiftButton);
            } else if (aIndexCount == 46) {
                aKeypadRowLayout.addView((View)this.mXKKeyList.get(42));
                ++aRealIndexCount;
            } else if (aIndexCount == 43) {
                aKeypadRowLayout.addView((View)this.mDeleteButton);
            } else if (aIndexCount == 44) {
                aKeypadRowLayout.addView((View)this.mRefreshButton);
            } else if (aIndexCount == 45) {
                aKeypadRowLayout.addView((View)this.mSymbolButton);
            } else if (aIndexCount == 47) {
                aKeypadRowLayout.addView((View)this.mCompleteButton);
            } else {
                aKeypadRowLayout.addView((View)this.mXKKeyList.get(aRealIndexCount));
                ++aRealIndexCount;
            }
            if (++aIndexCount % this.mKeypadColumnCount != 0) continue;
            ++aRowCount;
        }
    }

    public void setXKKeypadButtonImage() {
        boolean aUseInputButton = false;
        aUseInputButton = this.mXKEditText.getUseInputButton();
        if (this.mXKViewType == 1 && aUseInputButton) {
            this.setButtonLayout();
        }
        if (this.mSymbolMode) {
            this.setSymbolButtonImages();
            this.setFunctionButtonImages();
        } else {
            this.setNumberButtonImages();
            this.setCharacterButtonImages();
            this.setFunctionButtonImages();
        }
        this.setClickedEvent();
    }

    private void clearButtonFocus() {
        int aIndexCount = 0;
        XKKeyButton aXKKeyButton = null;
        aIndexCount = 0;
        while (aIndexCount < this.mXKKeyList.size()) {
            aXKKeyButton = this.mXKKeyList.get(aIndexCount);
            aXKKeyButton.clearFocus();
            ++aIndexCount;
        }
    }

    public void setFirstButtonFocus() {
        int aIndexCount = 0;
        XKKeyButton aXKKeyButton = null;
        aIndexCount = 0;
        while (aIndexCount < this.mXKKeyList.size()) {
            aXKKeyButton = this.mXKKeyList.get(aIndexCount);
            if (aXKKeyButton.getIndex() != -1) {
                aXKKeyButton.requestFocus();
                break;
            }
            ++aIndexCount;
        }
    }

    private void setClickedEvent() {
        int aIndexCount = 0;
        boolean aUseInputButton = false;
        Button aInputCompleteButton = null;
        Button aInputCancelButton = null;
        LinearLayout aEditTextButtonLayout = null;
        XKKeyButton aXKKeyButton = null;
        aUseInputButton = this.mXKEditText.getUseInputButton();
        if (this.mXKViewType == 1 && aUseInputButton) {
            aEditTextButtonLayout = (LinearLayout)this.mActivity.findViewById(this.mActivity.getResources().getIdentifier("edittext_button_layout", "id", this.mActivity.getPackageName()));
            aInputCompleteButton = (Button)aEditTextButtonLayout.findViewWithTag((Object)"input_complete_button");
            aInputCancelButton = (Button)aEditTextButtonLayout.findViewWithTag((Object)"input_cancel_button");
            if (aInputCompleteButton != null) {
                aInputCompleteButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        XKQwertyKeypad.this.inputComplete();
                    }
                });
            }
            if (aInputCancelButton != null) {
                aInputCancelButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        XKQwertyKeypad.this.inputCancel();
                    }
                });
            }
        }
        aIndexCount = 0;
        while (aIndexCount < this.mXKKeyList.size()) {
            aXKKeyButton = this.mXKKeyList.get(aIndexCount);
            if (aXKKeyButton.getIndex() == -1) {
                aXKKeyButton.setOnClickListener(null);
                aXKKeyButton.setClickable(false);
            } else {
                aXKKeyButton.setClickable(true);
                aXKKeyButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View pView) {
                        int aXKInputMaxLength = XKQwertyKeypad.this.mXKEditText.getKeypadMaxLength();
                        TimerTask aInputKeyTimerTask = null;
                        final Handler aHandler = new Handler();
                        XKKeyButton aXKKeyButton = (XKKeyButton)pView;
                        if (XKQwertyKeypad.this.mXKCoreWrapper.getIndexCount() == aXKInputMaxLength) {
                            return;
                        }
                        if (XKQwertyKeypad.this.mInputKeyTimer != null) {
                            XKQwertyKeypad.this.mInputKeyTimer.cancel();
                            XKQwertyKeypad.this.mInputKeyTimer.purge();
                            XKQwertyKeypad.this.mInputKeyTimer = null;
                        }
                        XKQwertyKeypad.this.mInputKeyTimer = new Timer();
                        aInputKeyTimerTask = new TimerTask(){

                            @Override
                            public void run() {
                                aHandler.post(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (XKQwertyKeypad.this.mXKKeypadTopLayout != null) {
                                            XKQwertyKeypad.this.mInputImageView.setImageResource(XKQwertyKeypad.this.mXKKeypadResources.getClickedSpaceImageID());
                                        }
                                    }
                                });
                            }
                        };
                        XKQwertyKeypad.this.mInputKeyTimer.schedule(aInputKeyTimerTask, 5000L);
                        if (XKQwertyKeypad.this.mXKKeypadTopLayout != null) {
                            XKQwertyKeypad.this.mInputImageView.setImageResource(aXKKeyButton.getClickedImageID());
                        }
                        XKQwertyKeypad.this.mXKKeypadInterface.getIndexData(aXKKeyButton);
                        if (XKQwertyKeypad.this.mXKViewType == 1) {
                            XKQwertyKeypad.this.mDummyBuffer.append("*");
                            XKQwertyKeypad.this.mDummyEditText.setText((CharSequence)XKQwertyKeypad.this.mDummyBuffer);
                        }
                    }
                });
                aXKKeyButton.setOnTouchListener(new View.OnTouchListener(){

                    public boolean onTouch(View pView, MotionEvent pMotionEvent) {
                        int aAction = 0;
                        XKKeyButton aXKKeyButton = (XKKeyButton)pView;
                        aAction = pMotionEvent.getAction();
                        if (aAction == 0 && aXKKeyButton.getIndex() != -1) {
                            aXKKeyButton.showPopupWindow();
                        } else if (aAction == 1) {
                            aXKKeyButton.dismissPopupWindow();
                        }
                        return false;
                    }
                });
            }
            ++aIndexCount;
        }
        this.mRefreshButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String aE2EURL = null;
                if (XKQwertyKeypad.this.mXKViewType == 1) {
                    XKQwertyKeypad.this.mDummyBuffer.setLength(0);
                    XKQwertyKeypad.this.mDummyEditText.setText((CharSequence)XKQwertyKeypad.this.mDummyBuffer);
                }
                XKQwertyKeypad.this.mXKKeypadInterface.clearIndex();
                XKQwertyKeypad.this.makeXKKeypadIndex();
                XKQwertyKeypad.this.setXKKeypadButtonImage();
                XKQwertyKeypad.this.clearButtonFocus();
                XKQwertyKeypad.this.setFirstButtonFocus();
                if (XKQwertyKeypad.this.mXKKeypadTopLayout != null) {
                    XKQwertyKeypad.this.mInputImageView.setImageResource(XKQwertyKeypad.this.mXKKeypadResources.getClickedSpaceImageID());
                    aE2EURL = XKQwertyKeypad.this.mXKEditText.getE2EURL();
                    if (aE2EURL != null) {
                        XKQwertyKeypad.this.mXKKeypadTopLayout.refreshSessionTimer(XKQwertyKeypad.this.mXKCoreWrapper.getE2ESessionTime());
                    }
                }
            }
        });
        this.mDeleteButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int aInputLength = 0;
                if (XKQwertyKeypad.this.mXKViewType == 1 && (aInputLength = XKQwertyKeypad.this.mDummyBuffer.length()) > 0) {
                    XKQwertyKeypad.this.mDummyBuffer.deleteCharAt(aInputLength - 1);
                    XKQwertyKeypad.this.mDummyEditText.setText((CharSequence)XKQwertyKeypad.this.mDummyBuffer);
                }
                XKQwertyKeypad.this.mXKKeypadInterface.deleteIndex();
                if (XKQwertyKeypad.this.mXKKeypadTopLayout != null) {
                    XKQwertyKeypad.this.mInputImageView.setImageResource(XKQwertyKeypad.this.mXKKeypadResources.getClickedSpaceImageID());
                }
            }
        });
        this.mDeleteButton.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (XKQwertyKeypad.this.mXKViewType == 1) {
                    XKQwertyKeypad.this.mDummyBuffer.setLength(0);
                    XKQwertyKeypad.this.mDummyEditText.setText((CharSequence)XKQwertyKeypad.this.mDummyBuffer);
                }
                if (XKQwertyKeypad.this.mXKKeypadTopLayout != null) {
                    XKQwertyKeypad.this.mInputImageView.setImageResource(XKQwertyKeypad.this.mXKKeypadResources.getClickedSpaceImageID());
                }
                XKQwertyKeypad.this.mXKKeypadInterface.clearIndex();
                return false;
            }
        });
        this.mCompleteButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XKQwertyKeypad.this.inputComplete();
            }
        });
        this.mShiftButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (XKQwertyKeypad.this.mSymbolMode) {
                    return;
                }
                XKQwertyKeypad.this.mShiftMode = !XKQwertyKeypad.this.mShiftMode;
                XKQwertyKeypad.this.setXKKeypadButtonImage();
                if (XKQwertyKeypad.this.mXKKeypadTopLayout != null) {
                    XKQwertyKeypad.this.mInputImageView.setImageResource(XKQwertyKeypad.this.mXKKeypadResources.getClickedSpaceImageID());
                }
            }
        });
        this.mSymbolButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XKQwertyKeypad.this.mSymbolMode = !XKQwertyKeypad.this.mSymbolMode;
                XKQwertyKeypad.this.setXKKeypadButtonImage();
                XKQwertyKeypad.this.clearButtonFocus();
                XKQwertyKeypad.this.setFirstButtonFocus();
                if (XKQwertyKeypad.this.mXKKeypadTopLayout != null) {
                    XKQwertyKeypad.this.mInputImageView.setImageResource(XKQwertyKeypad.this.mXKKeypadResources.getClickedSpaceImageID());
                }
            }
        });
    }

    private void setPopupWindow(XKKeyButton pXKKeyButton) {
        int aIndex = 0;
        int aPopupKeyHeight = 0;
        int aPopupKeyWidth = 0;
        int aPopupPositionX = 0;
        int aPopupPositionY = 0;
        int aAnimationStyle = 0;
        int aOrientation = 0;
        Drawable aClickedImage = null;
        Drawable aBackgrounImage = null;
        LinearLayout aPopupWindowLayout = null;
        ImageView aClickedImageView = null;
        LinearLayout.LayoutParams aLayoutParams = null;
        LinearLayout.LayoutParams aImageViewLayoutParams = null;
        aIndex = this.mXKKeyList.indexOf((Object)pXKKeyButton);
        if (aIndex == 42) {
            return;
        }
        aPopupWindowLayout = new LinearLayout(this.mContext);
        aLayoutParams = new LinearLayout.LayoutParams(-2, -1);
        aPopupWindowLayout.setLayoutParams((ViewGroup.LayoutParams)aLayoutParams);
        aPopupWindowLayout.setGravity(49);
        aPopupWindowLayout.setPadding(0, 10, 0, 0);
        aClickedImage = this.resizeBackgroundImage(pXKKeyButton.getClickedImageID(), this.mXKKeyWidth, this.mXKKeyHeight);
        aClickedImageView = new ImageView(this.mContext);
        aImageViewLayoutParams = new LinearLayout.LayoutParams(-2, -2);
        aClickedImageView.setLayoutParams((ViewGroup.LayoutParams)aImageViewLayoutParams);
        aClickedImageView.setBackgroundDrawable(aClickedImage);
        aPopupWindowLayout.addView((View)aClickedImageView);
        this.mXKPopupWindow = new PopupWindow((View)aPopupWindowLayout);
        aOrientation = this.mActivity.getResources().getConfiguration().orientation;
        if (aOrientation == 2) {
            aPopupKeyHeight = this.mXKKeyHeight * 2;
            aPopupKeyWidth = this.mXKKeyWidth * 65 / 100;
            aPopupKeyWidth += this.mXKKeyWidth;
        } else {
            aPopupKeyHeight = this.mXKKeyHeight * 2;
            aPopupKeyWidth = this.mXKKeyWidth * 2;
        }
        aPopupPositionY = 0 - aPopupKeyHeight;
        this.mXKPopupWindow.setHeight(aPopupKeyHeight);
        this.mXKPopupWindow.setWidth(aPopupKeyWidth);
        if (aIndex % this.mKeypadColumnCount == 0 && aIndex != 33) {
            this.mPopupWindowBackgroundID = this.mXKKeypadResources.getQwertyLeftMagImageID();
            aPopupPositionX = 0;
        } else if (aIndex % this.mKeypadColumnCount == this.mKeypadColumnCount - 1) {
            this.mPopupWindowBackgroundID = this.mXKKeypadResources.getQwertyRightMagImageID();
            aPopupPositionX = aOrientation == 2 ? 0 - (aPopupKeyWidth - this.mXKKeyWidth) : 0 - this.mXKKeyWidth;
        } else {
            this.mPopupWindowBackgroundID = this.mXKKeypadResources.getQwertyCenterMagImageID();
            aPopupPositionX = aOrientation == 2 ? 0 - (aPopupKeyWidth - this.mXKKeyWidth) / 2 : 0 - this.mXKKeyWidth / 2;
        }
        aBackgrounImage = this.resizeBackgroundImage(this.mPopupWindowBackgroundID, aPopupKeyWidth, aPopupKeyHeight);
        aPopupWindowLayout.setBackgroundDrawable(aBackgrounImage);
        this.mXKPopupWindow.setContentView((View)aPopupWindowLayout);
        aAnimationStyle = this.mActivity.getResources().getIdentifier("XKKeypadAnimations.PopupWindow", "style", this.mActivity.getPackageName());
        this.mXKPopupWindow.setAnimationStyle(aAnimationStyle);
        pXKKeyButton.setPopupWindow(this.mXKPopupWindow, aPopupPositionX, aPopupPositionY);
    }

    private void setButtonLayout() {
        View aBeforeLayout = null;
        Button aInputCompleteButton = null;
        Button aInputCancelButton = null;
        Configuration aConfiguration = null;
        LinearLayout aEditTextButtonLayout = null;
        LinearLayout aEditTextLayout = null;
        LinearLayout aInputButtonLayout = null;
        LinearLayout.LayoutParams aEditTextLayoutParams = null;
        LinearLayout.LayoutParams aInputButtonLayoutParams = null;
        LinearLayout.LayoutParams aButtonLayoutParams = null;
        aConfiguration = this.mActivity.getResources().getConfiguration();
        aEditTextButtonLayout = (LinearLayout)this.mActivity.findViewById(this.mActivity.getResources().getIdentifier("edittext_button_layout", "id", this.mActivity.getPackageName()));
        aBeforeLayout = aEditTextButtonLayout.findViewWithTag((Object)"input_button_layout");
        if (aBeforeLayout != null) {
            aEditTextButtonLayout.removeView(aBeforeLayout);
        }
        aEditTextLayout = (LinearLayout)this.mActivity.findViewById(this.mActivity.getResources().getIdentifier("edittext_layout", "id", this.mActivity.getPackageName()));
        aEditTextLayoutParams = (LinearLayout.LayoutParams)aEditTextLayout.getLayoutParams();
        aInputButtonLayout = new LinearLayout((Context)this.mActivity);
        aInputButtonLayout.setOrientation(0);
        aInputCompleteButton = new Button((Context)this.mActivity);
        aInputCancelButton = new Button((Context)this.mActivity);
        aInputCompleteButton.setTag((Object)"input_complete_button");
        aInputCancelButton.setTag((Object)"input_cancel_button");
        if (aConfiguration.orientation == 2) {
            aEditTextButtonLayout.setOrientation(0);
            aEditTextLayoutParams.width = 0;
            aEditTextLayoutParams.weight = 5.0f;
            aEditTextLayout.setLayoutParams((ViewGroup.LayoutParams)aEditTextLayoutParams);
            aInputButtonLayoutParams = new LinearLayout.LayoutParams(0, aEditTextLayoutParams.height, 2.0f);
            aInputButtonLayoutParams.rightMargin = aEditTextLayoutParams.rightMargin;
            aInputButtonLayout.setLayoutParams((ViewGroup.LayoutParams)aInputButtonLayoutParams);
            aInputButtonLayout.setGravity(17);
            aButtonLayoutParams = new LinearLayout.LayoutParams(0, -2, 1.0f);
            aInputCompleteButton.setLayoutParams((ViewGroup.LayoutParams)aButtonLayoutParams);
            aButtonLayoutParams = new LinearLayout.LayoutParams(0, -2, 1.0f);
            aButtonLayoutParams.leftMargin = (int)(5.0f * this.mActivity.getResources().getDisplayMetrics().density);
            aInputCancelButton.setLayoutParams((ViewGroup.LayoutParams)aButtonLayoutParams);
            aInputButtonLayout.addView((View)aInputCompleteButton);
            aInputButtonLayout.addView((View)aInputCancelButton);
        } else if (aConfiguration.orientation == 1) {
            aEditTextButtonLayout.setOrientation(1);
            aEditTextLayoutParams.width = -1;
            aEditTextLayoutParams.weight = 0.0f;
            aEditTextLayout.setLayoutParams((ViewGroup.LayoutParams)aEditTextLayoutParams);
            aInputButtonLayoutParams = new LinearLayout.LayoutParams(-1, aEditTextLayoutParams.height);
            aInputButtonLayoutParams.leftMargin = aEditTextLayoutParams.leftMargin;
            aInputButtonLayoutParams.rightMargin = aEditTextLayoutParams.rightMargin;
            aInputButtonLayoutParams.topMargin = (int)(20.0f * this.mActivity.getResources().getDisplayMetrics().density);
            aInputButtonLayout.setLayoutParams((ViewGroup.LayoutParams)aInputButtonLayoutParams);
            aInputButtonLayout.setGravity(5);
            aButtonLayoutParams = new LinearLayout.LayoutParams(-2, -2);
            aInputCompleteButton.setLayoutParams((ViewGroup.LayoutParams)aButtonLayoutParams);
            aButtonLayoutParams = new LinearLayout.LayoutParams(-2, -2);
            aButtonLayoutParams.leftMargin = (int)(5.0f * this.mActivity.getResources().getDisplayMetrics().density);
            aInputCancelButton.setLayoutParams((ViewGroup.LayoutParams)aButtonLayoutParams);
            aInputButtonLayout.addView((View)aInputCompleteButton);
            aInputButtonLayout.addView((View)aInputCancelButton);
        }
        aInputButtonLayout.setTag((Object)"input_button_layout");
        aEditTextButtonLayout.addView((View)aInputButtonLayout);
        this.setButtonImage(aInputCompleteButton, aInputCancelButton);
    }

    private void setButtonImage(Button pInputCompleteButton, Button pInputCancelButton) {
        int aButtonWidth = 0;
        int aButtonHeight = 0;
        int aDeviceWidth = 0;
        DisplayMetrics aDisplayMetrics = null;
        Drawable aInputCompleteDrawable = null;
        Drawable aInputCancelDrawable = null;
        Configuration aConfiguration = null;
        LinearLayout aEditTextLayout = null;
        LinearLayout.LayoutParams aEditTextLayoutParams = null;
        LinearLayout.LayoutParams aButtonLayoutParams = null;
        aEditTextLayout = (LinearLayout)this.mActivity.findViewById(this.mActivity.getResources().getIdentifier("edittext_layout", "id", this.mActivity.getPackageName()));
        aEditTextLayoutParams = (LinearLayout.LayoutParams)aEditTextLayout.getLayoutParams();
        aButtonHeight = aEditTextLayoutParams.height;
        aConfiguration = this.mActivity.getResources().getConfiguration();
        if (aConfiguration.orientation == 2) {
            aButtonLayoutParams = (LinearLayout.LayoutParams)pInputCancelButton.getLayoutParams();
            aDisplayMetrics = new DisplayMetrics();
            this.mActivity.getWindowManager().getDefaultDisplay().getMetrics(aDisplayMetrics);
            aDeviceWidth = aDisplayMetrics.widthPixels;
            aButtonWidth = aDeviceWidth * 2 / 7;
            aButtonWidth = aButtonWidth - aEditTextLayoutParams.leftMargin - aEditTextLayoutParams.rightMargin * 2 - aButtonLayoutParams.leftMargin;
            aButtonWidth /= 2;
        } else if (aConfiguration.orientation == 1) {
            aButtonWidth = (int)(100.0f * this.mActivity.getResources().getDisplayMetrics().density);
            aButtonHeight = aEditTextLayoutParams.height;
        }
        aInputCompleteDrawable = this.resizeBackgroundImage(this.mActivity.getResources().getIdentifier("fullview_ok", "drawable", this.mActivity.getPackageName()), aButtonWidth, aButtonHeight);
        if (aInputCompleteDrawable != null) {
            pInputCompleteButton.setBackgroundDrawable(aInputCompleteDrawable);
            pInputCompleteButton.setVisibility(0);
        } else {
            pInputCompleteButton.setVisibility(8);
        }
        aInputCancelDrawable = this.resizeBackgroundImage(this.mActivity.getResources().getIdentifier("fullview_cancel", "drawable", this.mActivity.getPackageName()), aButtonWidth, aButtonHeight);
        if (aInputCancelDrawable != null) {
            pInputCancelButton.setBackgroundDrawable(aInputCancelDrawable);
            pInputCancelButton.setVisibility(0);
        } else {
            pInputCancelButton.setVisibility(8);
        }
    }

    private void setNumberButtonImages() {
        int aIndexCount = 0;
        int aRealIndex = 0;
        int[] aNumberQwertyImagesIDs = null;
        int[] aClickedNumberQwertyImageIDs = null;
        Drawable aNumberButtonDrawable = null;
        Drawable aBlankDrawable = null;
        aNumberQwertyImagesIDs = this.mXKKeypadResources.getNumberQwertyImageIDs();
        aClickedNumberQwertyImageIDs = this.mXKKeypadResources.getClickedNumberQwertyImageIDs();
        aIndexCount = 0;
        while (aIndexCount < 11) {
            this.mXKKeyList.get(aIndexCount).setSymbolMode(this.mSymbolMode);
            if (this.mXKKeyList.get(aIndexCount).getIndex() == -1) {
                aBlankDrawable = this.mXKBlankLogoImage != null ? this.mXKBlankLogoImage : this.resizeBackgroundImage(this.mXKKeypadResources.getBlankImageID(), this.mXKKeyWidth, this.mXKKeyHeight);
                if (aBlankDrawable == null) {
                    this.mXKKeyList.get(aIndexCount).setWidth(this.mXKKeyWidth);
                    this.mXKKeyList.get(aIndexCount).setHeight(this.mXKKeyHeight);
                }
                this.mXKKeyList.get(aIndexCount).setBackgroundDrawable(aBlankDrawable);
                this.mXKKeyList.get(aIndexCount).setContentDescription(null);
            } else {
                aNumberButtonDrawable = this.resizeBackgroundImage(aNumberQwertyImagesIDs[aRealIndex], this.mXKKeyWidth, this.mXKKeyHeight);
                this.mXKKeyList.get(aIndexCount).setBackgroundDrawable(aNumberButtonDrawable);
                this.mXKKeyList.get(aIndexCount).setClickedImageID(aClickedNumberQwertyImageIDs[aRealIndex]);
                this.mXKKeyList.get(aIndexCount).setContentDescription(this.mXKKeypadIndexText[aRealIndex]);
                ++aRealIndex;
            }
            this.setPopupWindow(this.mXKKeyList.get(aIndexCount));
            ++aIndexCount;
        }
    }

    private void setCharacterButtonImages() {
        int aIndexCount = 0;
        int aRealIndex = 0;
        int aRealTextIndex = 0;
        int[] aQwertyImageIDs = null;
        int[] aClickedQwertyImageIDs = null;
        Drawable aCharaterButtonDrawable = null;
        Drawable aBlankDrawable = null;
        if (this.mShiftMode) {
            aQwertyImageIDs = this.mXKKeypadResources.getUpperQwertyImageIDs();
            aClickedQwertyImageIDs = this.mXKKeypadResources.getClickedUpperQwertyImageIDs();
            aRealTextIndex = 36;
        } else {
            aQwertyImageIDs = this.mXKKeypadResources.getLowerQwertyImageIDs();
            aClickedQwertyImageIDs = this.mXKKeypadResources.getClickedLowerQwertyImageIDs();
            aRealTextIndex = 10;
        }
        aIndexCount = 11;
        while (aIndexCount < 42) {
            this.mXKKeyList.get(aIndexCount).setShiftMode(this.mShiftMode);
            this.mXKKeyList.get(aIndexCount).setSymbolMode(this.mSymbolMode);
            if (this.mXKKeyList.get(aIndexCount).getIndex() == -1) {
                aBlankDrawable = this.mXKBlankLogoImage != null ? this.mXKBlankLogoImage : this.resizeBackgroundImage(this.mXKKeypadResources.getBlankImageID(), this.mXKKeyWidth, this.mXKKeyHeight);
                if (aBlankDrawable == null) {
                    this.mXKKeyList.get(aIndexCount).setWidth(this.mXKKeyWidth);
                    this.mXKKeyList.get(aIndexCount).setHeight(this.mXKKeyHeight);
                }
                this.mXKKeyList.get(aIndexCount).setBackgroundDrawable(aBlankDrawable);
                this.mXKKeyList.get(aIndexCount).setContentDescription(null);
            } else {
                aCharaterButtonDrawable = this.resizeBackgroundImage(aQwertyImageIDs[aRealIndex], this.mXKKeyWidth, this.mXKKeyHeight);
                this.mXKKeyList.get(aIndexCount).setBackgroundDrawable(aCharaterButtonDrawable);
                this.mXKKeyList.get(aIndexCount).setClickedImageID(aClickedQwertyImageIDs[aRealIndex]);
                this.mXKKeyList.get(aIndexCount).setContentDescription(this.mXKKeypadIndexText[aRealTextIndex]);
                ++aRealIndex;
                ++aRealTextIndex;
            }
            this.setPopupWindow(this.mXKKeyList.get(aIndexCount));
            ++aIndexCount;
        }
    }

    private void setSymbolButtonImages() {
        int aIndexCount = 0;
        int aRealIndex = 0;
        int aRealTextIndex = 0;
        int[] aSymbolImageIDs = null;
        int[] aClickedSymbolImageIDs = null;
        Drawable aSymbolButtonDrawable = null;
        Drawable aBlankDrawable = null;
        aSymbolImageIDs = this.mXKKeypadResources.getSymbolImageIDs();
        aClickedSymbolImageIDs = this.mXKKeypadResources.getClickedSymbolImageIDs();
        aRealTextIndex = 62;
        aIndexCount = 0;
        while (aIndexCount < 42) {
            this.mXKKeyList.get(aIndexCount).setSymbolMode(this.mSymbolMode);
            if (this.mXKKeyList.get(aIndexCount).getIndex() == -1) {
                aBlankDrawable = this.mXKBlankLogoImage != null ? this.mXKBlankLogoImage : this.resizeBackgroundImage(this.mXKKeypadResources.getBlankImageID(), this.mXKKeyWidth, this.mXKKeyHeight);
                if (aBlankDrawable == null) {
                    this.mXKKeyList.get(aIndexCount).setWidth(this.mXKKeyWidth);
                    this.mXKKeyList.get(aIndexCount).setHeight(this.mXKKeyHeight);
                }
                this.mXKKeyList.get(aIndexCount).setBackgroundDrawable(aBlankDrawable);
                this.mXKKeyList.get(aIndexCount).setContentDescription(null);
            } else {
                aSymbolButtonDrawable = this.resizeBackgroundImage(aSymbolImageIDs[aRealIndex], this.mXKKeyWidth, this.mXKKeyHeight);
                this.mXKKeyList.get(aIndexCount).setBackgroundDrawable(aSymbolButtonDrawable);
                this.mXKKeyList.get(aIndexCount).setClickedImageID(aClickedSymbolImageIDs[aRealIndex]);
                this.mXKKeyList.get(aIndexCount).setContentDescription(this.mXKKeypadIndexText[aRealTextIndex]);
                ++aRealIndex;
                ++aRealTextIndex;
            }
            this.setPopupWindow(this.mXKKeyList.get(aIndexCount));
            ++aIndexCount;
        }
    }

    private void setFunctionButtonImages() {
        int aFunctionButtonWidth = 0;
        Drawable aFunctionButtonDrawable = null;
        aFunctionButtonWidth = this.mXKKeyWidth * 2 + this.mXKKeyWidthMargin;
        aFunctionButtonDrawable = this.resizeBackgroundImage(this.mXKKeypadResources.getRefreshImageID(), aFunctionButtonWidth, this.mXKKeyHeight);
        this.mRefreshButton.setBackgroundDrawable(aFunctionButtonDrawable);
        this.mRefreshButton.setContentDescription("\ub9ac\ud504\ub808\uc26c");
        aFunctionButtonDrawable = this.resizeBackgroundImage(this.mXKKeypadResources.getSymbolImageID(), aFunctionButtonWidth, this.mXKKeyHeight);
        this.mSymbolButton.setBackgroundDrawable(aFunctionButtonDrawable);
        this.mSymbolButton.setContentDescription("\ud2b9\uc218\ubb38\uc790 \uc804\ud658");
        aFunctionButtonWidth = this.mXKKeyWidth * 3 + this.mXKKeyWidthMargin * 2;
        aFunctionButtonDrawable = this.resizeBackgroundImage(this.mXKKeypadResources.getCloseImageID(), aFunctionButtonWidth, this.mXKKeyHeight);
        this.mCompleteButton.setBackgroundDrawable(aFunctionButtonDrawable);
        this.mCompleteButton.setContentDescription("\uc5d4\ud130");
        aFunctionButtonWidth = this.mXKKeyWidth * 4 + this.mXKKeyWidthMargin * 3;
        aFunctionButtonDrawable = this.resizeBackgroundImage(this.mXKKeypadResources.getSpaceImageID(), aFunctionButtonWidth, this.mXKKeyHeight);
        this.mXKKeyList.get(42).setBackgroundDrawable(aFunctionButtonDrawable);
        this.mXKKeyList.get(42).setClickedImageID(this.mXKKeypadResources.getClickedSpaceImageID());
        this.mXKKeyList.get(42).setContentDescription("\uc2a4\ud398\uc774\uc2a4");
        aFunctionButtonDrawable = this.resizeBackgroundImage(this.mXKKeypadResources.getShiftImageID(), this.mXKKeyWidth, this.mXKKeyHeight);
        this.mShiftButton.setBackgroundDrawable(aFunctionButtonDrawable);
        this.mShiftButton.setContentDescription("\ub300\uc18c\ubb38\uc790 \uc804\ud658");
        aFunctionButtonDrawable = this.resizeBackgroundImage(this.mXKKeypadResources.getDeleteImageID(), this.mXKKeyWidth, this.mXKKeyHeight);
        this.mDeleteButton.setBackgroundDrawable(aFunctionButtonDrawable);
        this.mDeleteButton.setContentDescription("\ubc31\uc2a4\ud398\uc774\uc2a4");
    }

    private Drawable resizeBackgroundImage(int pImageID, int pWidth, int pHeight) {
        Bitmap aBitmapImage = null;
        Bitmap aResizedBitmap = null;
        BitmapFactory.Options aBitmapOption = null;
        BitmapDrawable aResizedDrawable = null;
        try {
            aBitmapOption = new BitmapFactory.Options();
            aBitmapOption.inPreferredConfig = Bitmap.Config.ARGB_8888;
            aBitmapImage = BitmapFactory.decodeResource((Resources)this.mActivity.getResources(), (int)pImageID, (BitmapFactory.Options)aBitmapOption);
            aResizedBitmap = Bitmap.createScaledBitmap((Bitmap)aBitmapImage, (int)pWidth, (int)pHeight, (boolean)true);
            aResizedDrawable = new BitmapDrawable(this.mActivity.getResources(), aResizedBitmap);
        }
        catch (IllegalArgumentException aException) {
            aResizedDrawable = null;
        }
        catch (NullPointerException aException) {
            aResizedDrawable = null;
        }
        return aResizedDrawable;
    }

    private void setQwertyKeyIndex(int[] pKeyIndex) {
        int aKeyCount = 0;
        int aRealIndex = 0;
        int aSymbolRealIndex = 0;
        int aIndex = 0;
        int aShiftOffIndex = 0;
        int aSymbolIndex = 0;
        int[] aQwertyBlankIndex = null;
        int[] aSymbolBlankIndex = null;
        aQwertyBlankIndex = new int[6];
        aSymbolBlankIndex = new int[10];
        aKeyCount = 0;
        while (aKeyCount < this.mXKKeyList.size()) {
            this.mXKKeyList.get(aKeyCount).initKeyButton();
            ++aKeyCount;
        }
        this.mXKKeypadInterface.initRandom();
        aQwertyBlankIndex[0] = this.mXKKeypadInterface.getRandom(0, 10);
        aQwertyBlankIndex[1] = this.mXKKeypadInterface.getRandom(11, 21);
        aQwertyBlankIndex[2] = this.mXKKeypadInterface.getRandom(22, 32);
        do {
            aQwertyBlankIndex[3] = this.mXKKeypadInterface.getRandom(22, 32);
        } while (aQwertyBlankIndex[3] == aQwertyBlankIndex[2]);
        aQwertyBlankIndex[4] = this.mXKKeypadInterface.getRandom(33, 41);
        do {
            aQwertyBlankIndex[5] = this.mXKKeypadInterface.getRandom(33, 41);
        } while (aQwertyBlankIndex[5] == aQwertyBlankIndex[4]);
        aSymbolBlankIndex[0] = this.mXKKeypadInterface.getRandom(0, 10);
        aSymbolBlankIndex[1] = this.mXKKeypadInterface.getRandom(11, 21);
        do {
            aSymbolBlankIndex[2] = this.mXKKeypadInterface.getRandom(11, 21);
        } while (aSymbolBlankIndex[2] == aSymbolBlankIndex[1]);
        do {
            aSymbolBlankIndex[3] = this.mXKKeypadInterface.getRandom(11, 21);
        } while (aSymbolBlankIndex[3] == aSymbolBlankIndex[1] || aSymbolBlankIndex[3] == aSymbolBlankIndex[2]);
        aSymbolBlankIndex[4] = this.mXKKeypadInterface.getRandom(22, 32);
        do {
            aSymbolBlankIndex[5] = this.mXKKeypadInterface.getRandom(22, 32);
        } while (aSymbolBlankIndex[5] == aSymbolBlankIndex[4]);
        do {
            aSymbolBlankIndex[6] = this.mXKKeypadInterface.getRandom(22, 32);
        } while (aSymbolBlankIndex[6] == aSymbolBlankIndex[4] || aSymbolBlankIndex[6] == aSymbolBlankIndex[5]);
        aSymbolBlankIndex[7] = this.mXKKeypadInterface.getRandom(33, 41);
        do {
            aSymbolBlankIndex[8] = this.mXKKeypadInterface.getRandom(33, 41);
        } while (aSymbolBlankIndex[8] == aSymbolBlankIndex[7]);
        do {
            aSymbolBlankIndex[9] = this.mXKKeypadInterface.getRandom(33, 41);
        } while (aSymbolBlankIndex[9] == aSymbolBlankIndex[7] || aSymbolBlankIndex[9] == aSymbolBlankIndex[8]);
        aSymbolRealIndex = 62;
        aKeyCount = 0;
        while (aKeyCount < 43) {
            if (this.isBlankIndex(aQwertyBlankIndex, 6, aKeyCount)) {
                aIndex = -1;
                aShiftOffIndex = -1;
            } else if (aKeyCount == 42) {
                aIndex = pKeyIndex[aSymbolRealIndex];
            } else {
                aIndex = pKeyIndex[aRealIndex];
                aShiftOffIndex = pKeyIndex[aRealIndex + 26];
                ++aRealIndex;
            }
            if (this.isBlankIndex(aSymbolBlankIndex, 10, aKeyCount)) {
                aSymbolIndex = -1;
            } else {
                aSymbolIndex = pKeyIndex[aSymbolRealIndex];
                ++aSymbolRealIndex;
            }
            this.mXKKeyList.get(aKeyCount).setIndex(aIndex, aShiftOffIndex, aSymbolIndex);
            ++aKeyCount;
        }
    }

    public void changeConfiguration() {
        int aDeviceHeight = 0;
        int aDeviceWidth = 0;
        int aHeightPercent = 0;
        int aXKKeypadHeight = 0;
        int aXKKeypadWidth = 0;
        int aIndexCount = 0;
        int aRowCount = 0;
        float aWidthMarginPercent = 0.0f;
        float aHeightMarginPercent = 0.0f;
        LinearLayout aKeypadRowLayout = null;
        DisplayMetrics aDisplayMetrics = null;
        LinearLayout.LayoutParams aXKButtonLayoutParams = null;
        RelativeLayout.LayoutParams aRowLayoutParams = null;
        aWidthMarginPercent = 1.0f;
        aHeightMarginPercent = 0.5f;
        aHeightPercent = 38;
        aDisplayMetrics = new DisplayMetrics();
        this.mActivity.getWindowManager().getDefaultDisplay().getMetrics(aDisplayMetrics);
        aDeviceWidth = aDisplayMetrics.widthPixels;
        aDeviceHeight = aDisplayMetrics.heightPixels;
        this.mXKKeyWidthMargin = (int)((float)aDeviceWidth * aWidthMarginPercent) / 100;
        this.mXKKeyHeightMargin = (int)((float)aDeviceHeight * aHeightMarginPercent) / 100;
        this.mXKKeypadHeight = aXKKeypadHeight = aDeviceHeight * aHeightPercent / 100;
        this.mXKKeyHeight = (aXKKeypadHeight -= (this.mKeypadRowCount + 1) * this.mXKKeyHeightMargin) / this.mKeypadRowCount;
        aXKKeypadWidth = aDeviceWidth - (this.mKeypadColumnCount + 1) * this.mXKKeyWidthMargin;
        this.mXKKeyWidth = aXKKeypadWidth / this.mKeypadColumnCount;
        aRowCount = 0;
        while (aRowCount < this.mKeypadLayoutList.size()) {
            aKeypadRowLayout = this.mKeypadLayoutList.get(aRowCount);
            aRowLayoutParams = (RelativeLayout.LayoutParams)aKeypadRowLayout.getLayoutParams();
            aRowLayoutParams.topMargin = this.mXKKeyHeightMargin;
            aKeypadRowLayout.setLayoutParams((ViewGroup.LayoutParams)aRowLayoutParams);
            if (aRowCount == this.mKeypadRowCount - 1) {
                aKeypadRowLayout.setPadding(this.mXKKeyWidthMargin, 0, this.mXKKeyWidthMargin, this.mXKKeyHeightMargin);
            } else {
                aKeypadRowLayout.setPadding(this.mXKKeyWidthMargin, 0, this.mXKKeyWidthMargin, 0);
            }
            ++aRowCount;
        }
        aIndexCount = 0;
        while (aIndexCount < this.mXKKeyList.size()) {
            aXKButtonLayoutParams = (LinearLayout.LayoutParams)this.mXKKeyList.get(aIndexCount).getLayoutParams();
            aXKButtonLayoutParams.height = this.mXKKeyHeight;
            aXKButtonLayoutParams.leftMargin = aIndexCount % this.mKeypadColumnCount == 0 || aIndexCount == 42 ? 0 : this.mXKKeyWidthMargin;
            this.mXKKeyList.get(aIndexCount).setLayoutParams((ViewGroup.LayoutParams)aXKButtonLayoutParams);
            ++aIndexCount;
        }
        aXKButtonLayoutParams = (LinearLayout.LayoutParams)this.mRefreshButton.getLayoutParams();
        aXKButtonLayoutParams.height = this.mXKKeyHeight;
        aXKButtonLayoutParams.rightMargin = this.mXKKeyWidthMargin;
        this.mRefreshButton.setLayoutParams((ViewGroup.LayoutParams)aXKButtonLayoutParams);
        aXKButtonLayoutParams = (LinearLayout.LayoutParams)this.mShiftButton.getLayoutParams();
        aXKButtonLayoutParams.height = this.mXKKeyHeight;
        aXKButtonLayoutParams.rightMargin = this.mXKKeyWidthMargin;
        this.mShiftButton.setLayoutParams((ViewGroup.LayoutParams)aXKButtonLayoutParams);
        aXKButtonLayoutParams = (LinearLayout.LayoutParams)this.mSymbolButton.getLayoutParams();
        aXKButtonLayoutParams.height = this.mXKKeyHeight;
        aXKButtonLayoutParams.rightMargin = this.mXKKeyWidthMargin;
        this.mSymbolButton.setLayoutParams((ViewGroup.LayoutParams)aXKButtonLayoutParams);
        aXKButtonLayoutParams = (LinearLayout.LayoutParams)this.mDeleteButton.getLayoutParams();
        aXKButtonLayoutParams.height = this.mXKKeyHeight;
        aXKButtonLayoutParams.leftMargin = this.mXKKeyWidthMargin;
        this.mDeleteButton.setLayoutParams((ViewGroup.LayoutParams)aXKButtonLayoutParams);
        aXKButtonLayoutParams = (LinearLayout.LayoutParams)this.mCompleteButton.getLayoutParams();
        aXKButtonLayoutParams.height = this.mXKKeyHeight;
        aXKButtonLayoutParams.leftMargin = this.mXKKeyWidthMargin;
        this.mCompleteButton.setLayoutParams((ViewGroup.LayoutParams)aXKButtonLayoutParams);
        this.setXKKeypadButtonImage();
    }

    private boolean isBlankIndex(int[] aBlankIndexArray, int aArrayLength, int aValue) {
        boolean aIsBlank = false;
        int aBlankIndexCount = 0;
        aBlankIndexCount = 0;
        while (aBlankIndexCount < aArrayLength) {
            if (aBlankIndexArray[aBlankIndexCount] == aValue) {
                aIsBlank = true;
                break;
            }
            ++aBlankIndexCount;
        }
        return aIsBlank;
    }

    public int makeXKKeypadIndex() {
        int aResult = 0;
        int aXKType = 0;
        int aXKKeypadIndexLength = 0;
        String aE2EURL = null;
        aXKKeypadIndexLength = 95;
        aXKType = 1;
        this.mXKKeypadIndex = new int[aXKKeypadIndexLength];
        aE2EURL = this.mXKEditText.getE2EURL();
        aResult = aE2EURL != null ? this.mXKKeypadInterface.makeIndexE2E(this.mXKKeypadIndex, aXKKeypadIndexLength, aXKType, aE2EURL) : this.mXKKeypadInterface.makeIndex(this.mXKKeypadIndex, aXKKeypadIndexLength, aXKType);
        if (aResult != 0) {
            return aResult;
        }
        this.setQwertyKeyIndex(this.mXKKeypadIndex);
        this.mXKKeypadIndexText = new String[aXKKeypadIndexLength];
        aResult = this.mXKKeypadInterface.getIndexText(this.mXKKeypadIndexText, aXKKeypadIndexLength, aXKType);
        return aResult;
    }

    private void inputComplete() {
        String aE2EURL = null;
        Intent aIntent = null;
        aE2EURL = this.mXKEditText.getE2EURL();
        if (this.mXKKeypadTopLayout != null && aE2EURL != null) {
            this.mXKKeypadTopLayout.endSessionTimer();
        }
        aIntent = this.mActivity.getIntent();
        this.mActivity.setResult(-1, aIntent);
        this.mActivity.finish();
    }

    private void inputCancel() {
        Intent aIntent = null;
        if (this.mInputKeyTimer != null) {
            this.mInputKeyTimer.cancel();
            this.mInputKeyTimer.purge();
            this.mInputKeyTimer = null;
        }
        this.mXKKeypadInterface.clearIndex();
        if (this.mXKEditText.getE2EURL() != null) {
            this.mXKKeypadTopLayout.endSessionTimer();
        }
        aIntent = this.mActivity.getIntent();
        this.mActivity.setResult(0, aIntent);
        this.mActivity.finish();
    }

    public int getXKKeypadHeight() {
        return this.mXKKeypadHeight;
    }

    public ArrayList<LinearLayout> getXKKeypadLayoutList() {
        return this.mKeypadLayoutList;
    }

    public void setXKEditText(XKEditText pXKEditText) {
        this.mXKEditText = pXKEditText;
    }

    public void setXKEditText(XKEditText pXKEditText, EditText pDummyEditText) {
        this.mXKEditText = pXKEditText;
        this.mDummyEditText = pDummyEditText;
    }

    public void setXKCoreWrapper(XKCoreWrapper pXKCoreWrapper) {
        this.mXKCoreWrapper = pXKCoreWrapper;
    }

    public void setXKBlankLogoImage(Drawable pXKBlankLogoImage) {
        this.mXKBlankLogoImage = pXKBlankLogoImage;
    }
}

