/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.naverlogin.connection;

import android.content.Context;
import android.util.Log;
import com.nhn.android.naverlogin.OAuthLoginDefine;
import com.nhn.android.naverlogin.connection.ResponseData;
import com.nhn.android.naverlogin.util.CookieUtil;
import com.nhn.android.naverlogin.util.DeviceAppInfo;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class CommonConnection {
    private static final String TAG = "NaverLoginOAuth|CommonConnection";
    protected static DefaultHttpClient mHttpClient = null;
    protected static boolean mCancel;

    public static ResponseData request(Context context, String strRequestUrl, String cookies, String userAgent) {
        return CommonConnection.request(context, strRequestUrl, cookies, userAgent, false);
    }

    public static ResponseData request(Context context, String strRequestUrl, String cookies, String userAgent, String authHeader) {
        return CommonConnection.request(context, strRequestUrl, cookies, userAgent, authHeader, false);
    }

    public static ResponseData request(Context context, String strRequestUrl, String cookies, String userAgent, boolean httpClientIsolated) {
        return CommonConnection.request(context, strRequestUrl, cookies, userAgent, null, httpClientIsolated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResponseData request(Context context, String strRequestUrl, String cookies, String userAgent, String authHeader, boolean httpClientIsolated) {
        HttpGet httpget = null;
        HttpResponse httpResponse = null;
        ResponseData res = new ResponseData();
        String postCookies = null;
        DefaultHttpClient httpClient = null;
        Class<CommonConnection> clazz = CommonConnection.class;
        synchronized (CommonConnection.class) {
            block32: {
                if (!httpClientIsolated && mHttpClient != null) {
                    res.setResultCode(ResponseData.ResponseDataStat.BUSY, "HttpClient already in use.");
                    // ** MonitorExit[var11_11] (shouldn't be in output)
                    return res;
                }
                if (OAuthLoginDefine.DEVELOPER_VERSION) {
                    Log.d((String)TAG, (String)("request url : " + strRequestUrl));
                }
                if (strRequestUrl == null || strRequestUrl.length() == 0) {
                    res.setResultCode(ResponseData.ResponseDataStat.URL_ERROR, "strRequestUrl is null");
                    // ** MonitorExit[var11_11] (shouldn't be in output)
                    return res;
                }
                if (httpClientIsolated) {
                    httpClient = userAgent != null && userAgent.length() > 0 ? CommonConnection.getDefaultHttpClient(userAgent) : CommonConnection.getDefaultHttpClient(context);
                } else {
                    mHttpClient = userAgent != null && userAgent.length() > 0 ? CommonConnection.getDefaultHttpClient(userAgent) : CommonConnection.getDefaultHttpClient(context);
                }
                mCancel = false;
                // ** MonitorExit[var11_11] (shouldn't be in output)
                try {
                    httpget = new HttpGet(strRequestUrl);
                    if (cookies != null && cookies.length() > 0) {
                        httpget.addHeader("Cookie", cookies);
                    }
                    if (authHeader != null) {
                        httpget.removeHeaders("Authorization");
                        httpget.setHeader("Authorization", authHeader);
                        if (OAuthLoginDefine.DEVELOPER_VERSION) {
                            Log.d((String)TAG, (String)("header:" + authHeader));
                        }
                    }
                    httpResponse = httpClientIsolated ? httpClient.execute((HttpUriRequest)httpget) : mHttpClient.execute((HttpUriRequest)httpget);
                }
                catch (ConnectTimeoutException e) {
                    res.setResultCode(ResponseData.ResponseDataStat.CONNECTION_TIMEOUT, e.getMessage());
                    e.printStackTrace();
                }
                catch (SSLPeerUnverifiedException e) {
                    res.setResultCode(ResponseData.ResponseDataStat.NO_PEER_CERTIFICATE, e.getMessage());
                    e.printStackTrace();
                }
                catch (Exception e) {
                    res.setResultCode(ResponseData.ResponseDataStat.CONNECTION_FAIL, e.getMessage());
                    e.printStackTrace();
                }
                try {
                    if (httpResponse != null) {
                        postCookies = CookieUtil.getCookie(httpResponse);
                        res.setResponseData(httpResponse, postCookies);
                    }
                }
                catch (Exception e) {
                    res.setResultCode(ResponseData.ResponseDataStat.FAIL, "setResponseData() on request() failed :" + e.getMessage());
                    e.printStackTrace();
                }
                try {
                    try {
                        if (httpClientIsolated) {
                            httpClient.getConnectionManager().shutdown();
                        } else {
                            mHttpClient.getConnectionManager().shutdown();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (httpClientIsolated) {
                            httpClient = null;
                        } else {
                            mHttpClient = null;
                        }
                        break block32;
                    }
                }
                catch (Throwable throwable) {
                    if (httpClientIsolated) {
                        httpClient = null;
                    } else {
                        mHttpClient = null;
                    }
                    throw throwable;
                }
                if (httpClientIsolated) {
                    httpClient = null;
                } else {
                    mHttpClient = null;
                }
            }
            if (mCancel) {
                ResponseData cc = new ResponseData();
                cc.setResultCode(ResponseData.ResponseDataStat.CANCEL, "User cancel");
                return cc;
            }
            return res;
        }
    }

    public static DefaultHttpClient getDefaultHttpClient(Context context) {
        String useragent = DeviceAppInfo.getBaseInstance().getUserAgent(context);
        return CommonConnection.getDefaultHttpClient(useragent);
    }

    protected static DefaultHttpClient getDefaultHttpClient(String useragent) {
        DefaultHttpClient httpClient = CommonConnection.getDefaultHttpClient();
        HttpParams params = httpClient.getParams();
        params.setParameter("http.useragent", (Object)useragent);
        if (OAuthLoginDefine.DEVELOPER_VERSION) {
            Log.d((String)TAG, (String)("user-agent:" + useragent));
        }
        return httpClient;
    }

    private static DefaultHttpClient getDefaultHttpClient() {
        DefaultHttpClient httpClient = null;
        httpClient = new DefaultHttpClient();
        HttpParams params = httpClient.getParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)OAuthLoginDefine.TIMEOUT);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)OAuthLoginDefine.TIMEOUT);
        ConnManagerParams.setTimeout((HttpParams)params, (long)OAuthLoginDefine.TIMEOUT);
        return httpClient;
    }

    public static boolean isBusy() {
        return mHttpClient != null;
    }

    public static void cancel() {
        mCancel = true;
        if (mHttpClient != null) {
            Log.e((String)TAG, (String)"httpclient operation canceled (shutdown)");
            mHttpClient.getConnectionManager().shutdown();
            mHttpClient = null;
        }
    }
}

