/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xas;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.os.Build;
import android.util.Log;
import com.android.apksig.ApkSigningBlockExtractor;
import com.android.apksig.internal.apk.v2.VerificationModule;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;

public class XecureAppShield {
    private static XecureAppShield xasInstance = new XecureAppShield();
    private boolean SO_LIVE_UPDATE = false;
    private String XAS_DOMAIN = null;
    private String XAS_APP_ID = null;
    private String XAS_APP_VER = null;
    private int nSID = 0;
    private String strToken;
    private String soUpdateUrl;
    private String identifier;
    private String mAPKPath;
    private String mSOPath;
    private String mCMVPPath;
    private int mSDKVersion;
    public final int SUCCESS_CODE = 0;
    public final int UPDATE_CODE = -1;
    public final int ROOTED_KERNEL_STATUS = 1;
    public boolean UPDATE_RESULT = false;
    public boolean LOGIN_SUCCESS = false;
    public boolean SHOW_RESULT = false;
    public final String COPY_PATH = "/files";
    public final String TEMP_PATH = "/temp";
    public final String LIB_NAME = "libXAS_jni.so";
    public final String LIB_VERSION = "library.properties";
    private boolean mLoadLibrary = false;
    private String mPhone_number = null;
    private String mPhone_imei = null;
    private String mIdentifier = null;
    private int mHashID = 2;
    private boolean mBase64Enable = false;
    private int mSslType = 1;
    private int mSslVersion = 1;

    private XecureAppShield() {
    }

    public static synchronized XecureAppShield getInstance() {
        return xasInstance;
    }

    public void setXASContext(String pDomain, String pAppId, String pAppver, boolean pIsLiveUpdateOn) {
        this.XAS_DOMAIN = pDomain;
        this.XAS_APP_ID = pAppId;
        this.XAS_APP_VER = pAppver;
        this.SO_LIVE_UPDATE = pIsLiveUpdateOn;
    }

    public void setHashFunction(int hashId) {
        this.mHashID = hashId;
    }

    public void setSSLConfig(int sslType, int sslVersion) {
        this.mSslType = sslType;
        this.mSslVersion = sslVersion;
    }

    private boolean loadXAS(Context pContext, boolean pUseLiveUpdate) {
        String aLibraryPath = null;
        boolean aResult = false;
        File aFilesLibrary = null;
        if (pUseLiveUpdate) {
            aLibraryPath = this.copyLibraryToPrivate(pContext);
        }
        try {
            System.loadLibrary("XecureCrypto");
            this.mCMVPPath = this.getSOPath(pContext) + "/libXecureCrypto.so";
            if (pUseLiveUpdate) {
                if (aLibraryPath != null) {
                    if (!this.mLoadLibrary) {
                        System.load(aLibraryPath);
                        this.mLoadLibrary = true;
                        this.mSOPath = aLibraryPath;
                    }
                } else {
                    Log.d((String)"XecureAppShield", (String)"library copy process failed!");
                }
            } else {
                aFilesLibrary = new File("/data/data/" + pContext.getPackageName() + "/files" + "/" + "libXAS_jni.so");
                if (aFilesLibrary.exists()) {
                    aFilesLibrary.delete();
                }
                System.loadLibrary("XAS_jni");
                this.mSOPath = this.getSOPath(pContext) + "/" + "libXAS_jni.so";
            }
            this.mAPKPath = this.getAPKPath(pContext);
            aResult = true;
        }
        catch (SecurityException e) {
            Log.d((String)"XecureAppShield", (String)"security exception occurred. loading library failed.");
        }
        catch (UnsatisfiedLinkError e) {
            Log.d((String)"XecureAppShield", (String)"unsatisfied link error. loading library failed.");
        }
        catch (Exception aException) {
            Log.d((String)"XecureAppShield", (String)"Exception occurred. loading library failed.");
        }
        return aResult;
    }

    private boolean loadSO(Context context, String libName) {
        StringBuilder strblibpath = new StringBuilder(128);
        strblibpath.append("/data/data/");
        strblibpath.append(context.getPackageName());
        strblibpath.append("/lib/lib");
        strblibpath.append(libName);
        strblibpath.append(".so");
        String strlibpath = strblibpath.toString();
        Log.d((String)"XecureAppShield", (String)("## strlibpath : " + strlibpath));
        File f = new File(strlibpath);
        if (f.exists()) {
            try {
                System.load(strlibpath);
                return true;
            }
            catch (UnsatisfiedLinkError ex) {
                ex.printStackTrace();
                return false;
            }
        }
        return false;
    }

    private String copyLibraryToPrivate(Context pContext) {
        BufferedInputStream aBufferedInputStream = null;
        BufferedOutputStream aBufferedOutputStream = null;
        AssetManager aAssetManager = null;
        File aFile = null;
        File aCopyFile = null;
        Properties aVersionProperties = null;
        String aLatestVersion = null;
        String aCurrentVersion = null;
        long aFileSize = 0L;
        aAssetManager = pContext.getResources().getAssets();
        try {
            aBufferedInputStream = new BufferedInputStream(aAssetManager.open("library.properties"));
            aVersionProperties = new Properties();
            aVersionProperties.load(aBufferedInputStream);
            aLatestVersion = aVersionProperties.getProperty("so.version");
            aBufferedInputStream.close();
            aCopyFile = new File("/data/data/" + pContext.getPackageName() + "/files");
            if (!aCopyFile.exists()) {
                aCopyFile.mkdirs();
            }
            if (!new File(aCopyFile.getPath(), "libXAS_jni.so").exists() || !new File(aCopyFile.getPath(), "library.properties").exists()) {
                if (this.mSDKVersion >= 9) {
                    this.copyFile(new FileInputStream(this.getSOPath(pContext) + "/" + "libXAS_jni.so"), "/data/data/" + pContext.getPackageName() + "/files" + "/libXAS_jni.so");
                } else {
                    this.copyFile(aAssetManager.open("libXAS_jni.so"), "/data/data/" + pContext.getPackageName() + "/files" + "/libXAS_jni.so");
                }
                aBufferedOutputStream = new BufferedOutputStream(new FileOutputStream(new File(aCopyFile.getPath(), "library.properties")));
                aVersionProperties.setProperty("so.version", aLatestVersion);
                aVersionProperties.store(aBufferedOutputStream, null);
                aBufferedOutputStream.close();
            } else {
                aFile = new File(aCopyFile.getPath() + "/temp");
                if (aFile.exists()) {
                    this.copyFile(new FileInputStream(aCopyFile.getPath() + "/temp" + "/libXAS_jni.so"), "/data/data/" + pContext.getPackageName() + "/files" + "/libXAS_jni.so");
                    this.deleteFolder(aFile);
                } else {
                    aBufferedInputStream = new BufferedInputStream(new FileInputStream(new File(aCopyFile.getPath(), "library.properties")));
                    aVersionProperties.load(aBufferedInputStream);
                    aCurrentVersion = aVersionProperties.getProperty("so.version");
                    aBufferedInputStream.close();
                    if (Double.parseDouble(aLatestVersion) > Double.parseDouble(aCurrentVersion)) {
                        if (this.mSDKVersion >= 9) {
                            this.copyFile(new FileInputStream(this.getSOPath(pContext) + "/" + "libXAS_jni.so"), "/data/data/" + pContext.getPackageName() + "/files" + "/libXAS_jni.so");
                        } else {
                            this.copyFile(aAssetManager.open("libXAS_jni.so"), "/data/data/" + pContext.getPackageName() + "/files" + "/libXAS_jni.so");
                        }
                        aBufferedOutputStream = new BufferedOutputStream(new FileOutputStream(new File(aCopyFile.getPath(), "library.properties")));
                        aVersionProperties.setProperty("so.version", aLatestVersion);
                        aVersionProperties.store(aBufferedOutputStream, null);
                        aBufferedOutputStream.close();
                        Log.d((String)"XecureAppShield", (String)"[ xas library updated as latest version ]");
                    }
                }
            }
        }
        catch (IOException aException) {
            Log.d((String)"XecureAppShield", (String)"IO exception occurred. Copy library failed.");
        }
        catch (Exception aException) {
            Log.d((String)"XecureAppShield", (String)"Exception occurred. Copy library failed.");
        }
        return aCopyFile.getPath() + "/" + "libXAS_jni.so";
    }

    private boolean deleteFolder(File pTargetFolder) {
        File[] aChildFile = null;
        int aSize = 0;
        aChildFile = pTargetFolder.listFiles();
        aSize = aChildFile.length;
        if (aSize > 0) {
            for (int i = 0; i < aSize; ++i) {
                if (aChildFile[i].isFile()) {
                    aChildFile[i].delete();
                    continue;
                }
                this.deleteFolder(aChildFile[i]);
            }
        }
        return pTargetFolder.delete();
    }

    private String getAPKPath(Context pContext) {
        String aResult = null;
        PackageManager pm = pContext.getPackageManager();
        try {
            ApplicationInfo ai = pm.getApplicationInfo(pContext.getApplicationContext().getPackageName(), 0);
            aResult = ai.publicSourceDir;
        }
        catch (PackageManager.NameNotFoundException aException) {
            Log.d((String)"XecureAppShield", (String)"Name Not Found exception occurred.");
        }
        catch (Exception aException) {
            Log.d((String)"XecureAppShield", (String)"Exception occurred.");
        }
        return aResult;
    }

    private String getSOPath(Context pContext) {
        if (this.mSDKVersion >= 9) {
            return pContext.getApplicationInfo().nativeLibraryDir;
        }
        return null;
    }

    public int checkApp(Context pContext) {
        int aResult;
        block8: {
            aResult = 0;
            this.mSDKVersion = Build.VERSION.SDK_INT;
            if (this.loadXAS(pContext, this.SO_LIVE_UPDATE)) {
                try {
                    byte[] digest = null;
                    Object apkFile = null;
                    try {
                        ApkSigningBlockExtractor ext = new ApkSigningBlockExtractor(new File(this.mAPKPath));
                        ext.extractSigningBlockFromApk();
                        List<VerificationModule.Result.SignerInfo.ContentDigest> extractedDigest = ext.getContentDigests();
                        for (VerificationModule.Result.SignerInfo.ContentDigest contentDigest : extractedDigest) {
                            digest = contentDigest.getValue();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.mSDKVersion >= 9) {
                        aResult = this.CheckApp(this.XAS_DOMAIN + "xasservice.do", this.XAS_APP_ID + "|" + this.XAS_APP_VER, this.mAPKPath, this.mSOPath, this.mCMVPPath, this.mHashID, this.mBase64Enable, digest, digest.length, this.mSslType, this.mSslVersion);
                        break block8;
                    }
                    aResult = this.CheckApp(this.XAS_DOMAIN + "xasservice.do", this.XAS_APP_ID + "|" + this.XAS_APP_VER, this.mAPKPath, this.mHashID, this.mBase64Enable, digest, digest.length, this.mSslType, this.mSslVersion);
                }
                catch (Exception aException) {
                    Log.d((String)"XecureAppShield", (String)"CheckApp Error");
                }
            } else {
                aResult = -100;
            }
        }
        return aResult;
    }

    public int checkApp(Context pContext, String pIdentifier) {
        int aResult;
        block9: {
            aResult = 0;
            this.mSDKVersion = Build.VERSION.SDK_INT;
            if (pIdentifier != null) {
                // empty if block
            }
            if (this.loadXAS(pContext, this.SO_LIVE_UPDATE)) {
                try {
                    byte[] digest = null;
                    Object apkFile = null;
                    try {
                        ApkSigningBlockExtractor ext = new ApkSigningBlockExtractor(new File(this.mAPKPath));
                        ext.extractSigningBlockFromApk();
                        List<VerificationModule.Result.SignerInfo.ContentDigest> extractedDigest = ext.getContentDigests();
                        for (VerificationModule.Result.SignerInfo.ContentDigest contentDigest : extractedDigest) {
                            digest = contentDigest.getValue();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.mSDKVersion >= 9) {
                        aResult = this.CheckApp(this.XAS_DOMAIN + "xasservice.do", this.XAS_APP_ID + "|" + this.XAS_APP_VER, this.mAPKPath, this.mSOPath, this.mCMVPPath, this.mHashID, this.mBase64Enable, digest, digest.length, this.mSslType, this.mSslVersion);
                        break block9;
                    }
                    aResult = this.CheckApp(this.XAS_DOMAIN + "xasservice.do", this.XAS_APP_ID + "|" + this.XAS_APP_VER, this.mAPKPath, this.mHashID, this.mBase64Enable, digest, digest.length, this.mSslType, this.mSslVersion);
                }
                catch (Exception aException) {
                    Log.d((String)"XecureAppShield", (String)"CheckApp Error");
                }
            } else {
                aResult = -100;
            }
        }
        return aResult;
    }

    public int checkAppSkip(Context pContext) {
        int aResult;
        block8: {
            aResult = 0;
            this.mSDKVersion = Build.VERSION.SDK_INT;
            if (this.loadXAS(pContext, this.SO_LIVE_UPDATE)) {
                try {
                    byte[] digest = null;
                    Object apkFile = null;
                    try {
                        ApkSigningBlockExtractor ext = new ApkSigningBlockExtractor(new File(this.mAPKPath));
                        ext.extractSigningBlockFromApk();
                        List<VerificationModule.Result.SignerInfo.ContentDigest> extractedDigest = ext.getContentDigests();
                        for (VerificationModule.Result.SignerInfo.ContentDigest contentDigest : extractedDigest) {
                            digest = contentDigest.getValue();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.mSDKVersion >= 9) {
                        aResult = this.CheckApp(this.XAS_DOMAIN + "xasservice.do", this.XAS_APP_ID + "|" + this.XAS_APP_VER, this.mAPKPath, this.mSOPath, this.mCMVPPath, this.mHashID, this.mBase64Enable, digest, digest.length, true);
                        break block8;
                    }
                    aResult = this.CheckApp(this.XAS_DOMAIN + "xasservice.do", this.XAS_APP_ID + "|" + this.XAS_APP_VER, this.mAPKPath, this.mHashID, this.mBase64Enable, digest, digest.length, true);
                }
                catch (Exception aException) {
                    Log.d((String)"XecureAppShield", (String)"CheckApp(skip) Error");
                }
            } else {
                aResult = -100;
            }
        }
        return aResult;
    }

    public int checkAppSkip(Context pContext, String pIdentifier) {
        int aResult;
        block9: {
            aResult = 0;
            this.mSDKVersion = Build.VERSION.SDK_INT;
            if (pIdentifier != null) {
                // empty if block
            }
            if (this.loadXAS(pContext, this.SO_LIVE_UPDATE)) {
                try {
                    byte[] digest = null;
                    Object apkFile = null;
                    try {
                        ApkSigningBlockExtractor ext = new ApkSigningBlockExtractor(new File(this.mAPKPath));
                        ext.extractSigningBlockFromApk();
                        List<VerificationModule.Result.SignerInfo.ContentDigest> extractedDigest = ext.getContentDigests();
                        for (VerificationModule.Result.SignerInfo.ContentDigest contentDigest : extractedDigest) {
                            digest = contentDigest.getValue();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.mSDKVersion >= 9) {
                        aResult = this.CheckApp(this.XAS_DOMAIN + "xasservice.do", this.XAS_APP_ID + "|" + this.XAS_APP_VER, this.mAPKPath, this.mSOPath, this.mCMVPPath, this.mHashID, this.mBase64Enable, digest, digest.length, true);
                        break block9;
                    }
                    aResult = this.CheckApp(this.XAS_DOMAIN + "xasservice.do", this.XAS_APP_ID + "|" + this.XAS_APP_VER, this.mAPKPath, this.mHashID, this.mBase64Enable, digest, digest.length, true);
                }
                catch (Exception aException) {
                    Log.d((String)"XecureAppShield", (String)"CheckApp(skip) Error");
                }
            } else {
                aResult = -100;
            }
        }
        return aResult;
    }

    public String getAppId() {
        return this.XAS_APP_ID;
    }

    public String getAppver() {
        return this.XAS_APP_VER;
    }

    public String getCheckSecureSessioinUrl() {
        if (this.XAS_DOMAIN == null) {
            return null;
        }
        return this.XAS_DOMAIN + "jsp/checkSecureSession.jsp";
    }

    public String getXASDomain() {
        return this.XAS_DOMAIN;
    }

    public String getSID() {
        return String.format("%08X", this.nSID);
    }

    public String getToken() {
        return this.strToken;
    }

    public String getUpdateURL() {
        return this.XAS_DOMAIN + this.soUpdateUrl;
    }

    private void copyFile(InputStream file, String target) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(target);
        BufferedInputStream bin = new BufferedInputStream(file);
        BufferedOutputStream bout = new BufferedOutputStream(outputStream);
        int bytesRead = 0;
        byte[] buffer = new byte[1024];
        while ((bytesRead = bin.read(buffer, 0, 1024)) != -1) {
            bout.write(buffer, 0, bytesRead);
        }
        bout.close();
        bin.close();
        outputStream.close();
        file.close();
    }

    private native int CheckApp(String var1, String var2, String var3, int var4, boolean var5, byte[] var6, int var7);

    private native int CheckApp(String var1, String var2, String var3, String var4, String var5, int var6, boolean var7, byte[] var8, int var9);

    private native int CheckApp(String var1, String var2, String var3, int var4, boolean var5, byte[] var6, int var7, int var8, int var9);

    private native int CheckApp(String var1, String var2, String var3, String var4, String var5, int var6, boolean var7, byte[] var8, int var9, int var10, int var11);

    private native int CheckApp(String var1, String var2, String var3, int var4, boolean var5, byte[] var6, int var7, boolean var8);

    private native int CheckApp(String var1, String var2, String var3, String var4, String var5, int var6, boolean var7, byte[] var8, int var9, boolean var10);

    public native String GetErrorMsg(int var1);

    public native int SOUpdate(String var1);
}

