/*
 * Decompiled with CFR 0.152.
 */
package com.buzzvil.buzzad.analytics;

import com.buzzvil.buzzad.analytics.volley.AuthFailureError;
import com.buzzvil.buzzad.analytics.volley.HttpHeaderParser;
import com.buzzvil.buzzad.analytics.volley.NetworkResponse;
import com.buzzvil.buzzad.analytics.volley.ParseError;
import com.buzzvil.buzzad.analytics.volley.Request;
import com.buzzvil.buzzad.analytics.volley.Response;
import com.buzzvil.buzzad.analytics.volley.VolleyLog;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class ApiRequest
extends Request<JSONObject> {
    private static final String PROTOCOL_CHARSET = "utf-8";
    private static final String BASE_URL = "https://track.buzzvil.com/";
    private Map<String, String> params;
    private String jsonParams;
    private Response.Listener<JSONObject> listener;

    static String getAbsoluteUrl(String relativeUrl) {
        return BASE_URL + relativeUrl;
    }

    public ApiRequest(String relativeUrl, Map<String, String> params, Response.Listener<JSONObject> listener, Response.ErrorListener errorListener) {
        super(1, ApiRequest.getAbsoluteUrl(relativeUrl), errorListener);
        this.params = params;
        this.listener = listener;
    }

    public ApiRequest(String relativeUrl, JSONObject jsonparams, Response.Listener<JSONObject> listener, Response.ErrorListener errorListener) {
        super(1, ApiRequest.getAbsoluteUrl(relativeUrl), errorListener);
        this.jsonParams = jsonparams.toString();
        this.listener = listener;
    }

    @Override
    protected Map<String, String> getParams() throws AuthFailureError {
        return this.params;
    }

    @Override
    public byte[] getBody() {
        try {
            return this.jsonParams == null ? super.getBody() : this.jsonParams.getBytes(PROTOCOL_CHARSET);
        }
        catch (UnsupportedEncodingException uee) {
            VolleyLog.wtf("Unsupported Encoding while trying to get the bytes of %s using %s", this.jsonParams, PROTOCOL_CHARSET);
            return null;
        }
        catch (AuthFailureError error) {
            VolleyLog.e("AuthFailureError", new Object[0]);
            return null;
        }
    }

    @Override
    protected Response<JSONObject> parseNetworkResponse(NetworkResponse response) {
        try {
            String jsonString = new String(response.data, HttpHeaderParser.parseCharset(response.headers));
            return Response.success(new JSONObject(jsonString), HttpHeaderParser.parseCacheHeaders(response));
        }
        catch (UnsupportedEncodingException e) {
            return Response.error(new ParseError(e));
        }
        catch (JSONException je) {
            return Response.error(new ParseError(je));
        }
    }

    @Override
    protected void deliverResponse(JSONObject response) {
        this.listener.onResponse(response);
    }
}

