/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.naverlogin.connection;

import android.content.Context;
import android.util.Log;
import com.nhn.android.naverlogin.OAuthLoginDefine;
import com.nhn.android.naverlogin.connection.CommonConnection;
import com.nhn.android.naverlogin.connection.ResponseData;
import com.nhn.android.naverlogin.connection.gen.OAuthQueryGenerator;
import com.nhn.android.naverlogin.data.OAuthErrorCode;
import com.nhn.android.naverlogin.data.OAuthResponse;
import com.nhn.android.naverlogin.util.DeviceAppInfo;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class OAuthLoginConnection
extends CommonConnection {
    private static final String TAG = "NaverLoginOAuth|OAuthLoginConnection";

    public static OAuthResponse requestAccessToken(Context context, String clientId, String clientSecret, String initState, String code) {
        String locale = DeviceAppInfo.getBaseInstance().getLocaleString(context);
        String requestUrl = new OAuthQueryGenerator().generateRequestAccessTokenUrl(clientId, clientSecret, initState, code, locale);
        return OAuthLoginConnection.request(context, requestUrl);
    }

    public static OAuthResponse requestRefreshToken(Context context, String clientId, String clientSecret, String refreshToken) {
        String locale = DeviceAppInfo.getBaseInstance().getLocaleString(context);
        String requestUrl = new OAuthQueryGenerator().generateRequestRefreshAccessTokenUrl(clientId, clientSecret, refreshToken, locale);
        return OAuthLoginConnection.request(context, requestUrl);
    }

    public static OAuthResponse deleteToken(Context context, String clientId, String clientSecret, String accessToken) {
        String locale = DeviceAppInfo.getBaseInstance().getLocaleString(context);
        String requestUrl = new OAuthQueryGenerator().generateRequestDeleteAccessTokenUrl(clientId, clientSecret, accessToken, locale);
        return OAuthLoginConnection.request(context, requestUrl);
    }

    private static OAuthResponse request(Context context, String requestUrl) {
        ResponseData data = CommonConnection.request(context, requestUrl, null, null);
        if (!data.mStat.equals((Object)ResponseData.ResponseDataStat.SUCCESS)) {
            if (data.mStatusCode == 503) {
                return new OAuthResponse(OAuthErrorCode.SERVER_ERROR_TEMPORARILY_UNAVAILABLE);
            }
            if (data.mStatusCode == 500) {
                return new OAuthResponse(OAuthErrorCode.SERVER_ERROR_SERVER_ERROR);
            }
            if (data.mStat.equals((Object)ResponseData.ResponseDataStat.CONNECTION_TIMEOUT) || data.mStat.equals((Object)ResponseData.ResponseDataStat.CONNECTION_FAIL)) {
                return new OAuthResponse(OAuthErrorCode.CLIENT_ERROR_CONNECTION_ERROR);
            }
            if (data.mStat.equals((Object)ResponseData.ResponseDataStat.NO_PEER_CERTIFICATE)) {
                return new OAuthResponse(OAuthErrorCode.CLIENT_ERROR_CERTIFICATION_ERROR);
            }
            return new OAuthResponse(OAuthErrorCode.ERROR_NO_CATAGORIZED);
        }
        try {
            JSONObject jsonObj = new JSONObject(data.mContent);
            if (OAuthLoginDefine.DEVELOPER_VERSION) {
                Log.d((String)TAG, (String)("len :" + jsonObj.length()));
                Log.d((String)TAG, (String)("str :" + jsonObj.toString()));
            }
            Iterator it = jsonObj.keys();
            HashMap<String, String> ret = new HashMap<String, String>();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = jsonObj.getString(key);
                ret.put(key, value);
                if (!OAuthLoginDefine.DEVELOPER_VERSION) continue;
                Log.d((String)TAG, (String)("key:" + key + ",value:" + value));
            }
            return new OAuthResponse(ret);
        }
        catch (JSONException e) {
            if (OAuthLoginDefine.DEVELOPER_VERSION && data != null) {
                Log.d((String)TAG, (String)("content:" + data.mContent));
            }
            e.printStackTrace();
            return new OAuthResponse(OAuthErrorCode.CLIENT_ERROR_PARSING_FAIL);
        }
    }

    public static ResponseData requestWithOAuthHeader(Context context, String requestUrl, String cookie, String userAgent, String authHeader) {
        ResponseData data = CommonConnection.request(context, requestUrl, null, null, authHeader, false);
        return data;
    }
}

