/*
 * Decompiled with CFR 0.152.
 */
package kr.co.cashslide;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Locale;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kr.co.cashslide.AdvertisingIdHelper;
import kr.co.cashslide.DeviceManager;
import kr.co.cashslide.EncryptManager;
import kr.co.cashslide.ReferrerReceiver;
import org.json.JSONArray;
import org.json.JSONObject;

class Request {
    private static final String LOG_TAG = "CashslideSDK";
    private static final int CPA_END = 9;
    private static final String SUCCESS_MESSAGE = "success";
    private static final String LOGIC_SERVER_URL = "https://api.cashslide.co.kr";
    private static final String CCCS_SERVER_URL = "https://cccs.cashslide.io";
    private static final String UPLOAD_CLICK_URL_WITH_AD_ID_URL = "https://cccs.cashslide.io/click_infos_sdk_with_google_ad_id";
    private static final String RECOMMEND_URL = "https://api.cashslide.co.kr/api/v2/recommend_cpas/request_reward";
    private static final String RETENTION_URL = "https://api.cashslide.co.kr/api/v2/recommend_cpas/active_launch";
    private Context mContext;
    private String mAppId;
    private int mReward;

    public Request(Context context, String appId) {
        this.mContext = context;
        this.mAppId = appId;
        this.mReward = 0;
        this.disableConnectionReuseIfNecessary();
    }

    private void disableConnectionReuseIfNecessary() {
        if (Build.VERSION.SDK_INT < 8) {
            System.setProperty("http.keepAlive", "false");
        }
    }

    private boolean sendPost(URI uri, String data) {
        String responseStr = this.sendPostHttpUrlConnection(uri, data);
        if (responseStr == null) {
            return false;
        }
        try {
            this.mReward = Integer.parseInt(responseStr.substring(SUCCESS_MESSAGE.length()).replaceAll("\n", ""));
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("error=" + e.getMessage()));
        }
        if (this.mReward == 0) {
            // empty if block
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendPostHttpUrlConnection(URI uri, String data) {
        HttpURLConnection urlConnection = null;
        OutputStream out = null;
        BufferedReader bufferedReader = null;
        String responseStr = null;
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }
            }};
            String keyStoreType = KeyStore.getDefaultType();
            KeyStore keyStore = KeyStore.getInstance(keyStoreType);
            keyStore.load(null, null);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            urlConnection = (HttpsURLConnection)uri.toURL().openConnection();
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(true);
            urlConnection.setInstanceFollowRedirects(false);
            ((HttpsURLConnection)urlConnection).setSSLSocketFactory(sslContext.getSocketFactory());
            urlConnection.setRequestMethod("POST");
            out = new BufferedOutputStream(urlConnection.getOutputStream());
            out.write(data.getBytes());
            out.flush();
            out.close();
            bufferedReader = urlConnection.getResponseCode() / 100 == 2 ? new BufferedReader(new InputStreamReader(urlConnection.getInputStream())) : new BufferedReader(new InputStreamReader(urlConnection.getErrorStream()));
            StringBuffer stringBuffer = new StringBuffer("");
            String line = "";
            String LineSeparator = System.getProperty("line.separator");
            while ((line = bufferedReader.readLine()) != null) {
                stringBuffer.append(line + LineSeparator);
            }
            bufferedReader.close();
            responseStr = stringBuffer.toString();
        }
        catch (MalformedURLException e) {
            responseStr = null;
        }
        catch (IOException e) {
            responseStr = null;
        }
        catch (NoSuchAlgorithmException e) {
            responseStr = null;
        }
        catch (CertificateException e) {
            responseStr = null;
        }
        catch (KeyStoreException e) {
            responseStr = null;
        }
        catch (KeyManagementException e) {
            responseStr = null;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    responseStr = null;
                }
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    responseStr = null;
                }
            }
        }
        if (urlConnection != null) {
            urlConnection.disconnect();
        }
        return responseStr;
    }

    private String getParams() {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("click_info[count]=1");
            sb.append("&click_info[ad_type]=").append(URLEncoder.encode(Integer.toString(9), "UTF-8"));
            sb.append("&app_id=").append(URLEncoder.encode(this.mAppId, "UTF-8"));
            sb.append("&ref=").append(URLEncoder.encode(ReferrerReceiver.getReferrer(this.mContext), "UTF-8"));
            sb.append("&c_ad_id=").append(URLEncoder.encode(EncryptManager.encryptMsg(AdvertisingIdHelper.getAdId()), "UTF-8"));
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("error=" + e.getMessage()));
        }
        return sb.toString();
    }

    public boolean sendAppFirstLaunched() {
        boolean result = false;
        try {
            if (!AdvertisingIdHelper.hasAdvertisingId()) {
                Log.w((String)LOG_TAG, (String)"Google Advertising ID is not found!");
            } else {
                result = this.sendPost(new URI(UPLOAD_CLICK_URL_WITH_AD_ID_URL), this.getParams());
            }
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("error=" + e.getMessage()));
        }
        return result;
    }

    public int getReward() {
        return this.mReward;
    }

    public boolean sendMissionCompleted() {
        boolean result = false;
        try {
            if (!AdvertisingIdHelper.hasAdvertisingId()) {
                Log.w((String)LOG_TAG, (String)"Google Advertising ID is not found!");
            } else {
                result = this.sendPost(new URI(UPLOAD_CLICK_URL_WITH_AD_ID_URL), this.getParams());
            }
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("error=" + e.getMessage()));
        }
        return result;
    }

    public boolean sendRecommend(boolean retentionEnabled) {
        boolean result = false;
        try {
            if (!AdvertisingIdHelper.hasAdvertisingId()) {
                Log.w((String)LOG_TAG, (String)"Google Advertising ID is not found!");
            } else {
                StringBuilder params = new StringBuilder();
                long timestamp = System.currentTimeMillis();
                String recommendee = String.format(Locale.ENGLISH, "%d,%s,%s,%s", timestamp, AdvertisingIdHelper.getAdId(), DeviceManager.getAndroidId(this.mContext), DeviceManager.getSerial());
                String recommender = String.format(Locale.ENGLISH, "%d,%s,%s,%s", timestamp, ReferrerReceiver.getRecommendNickname(this.mContext), ReferrerReceiver.getRecommendPath(this.mContext), this.mAppId);
                params.append("recommendee=").append(EncryptManager.encryptMsg(recommendee));
                params.append("&recommender=").append(EncryptManager.encryptMsg(recommender));
                params.append("&active=").append(retentionEnabled ? "1" : "0");
                params.append("&referrer=").append(URLEncoder.encode(ReferrerReceiver.getReferrer(this.mContext), "utf-8"));
                String response = this.sendPostHttpUrlConnection(new URI(RECOMMEND_URL), params.toString());
                JSONObject json = new JSONObject(response);
                if (!json.has("errors")) {
                    Log.i((String)LOG_TAG, (String)"recommendation success");
                    result = true;
                } else {
                    JSONArray errors = json.getJSONArray("errors");
                    for (int i = 0; i < errors.length(); ++i) {
                        JSONObject e = errors.getJSONObject(i);
                        Log.e((String)LOG_TAG, (String)String.format("rc ERROR[%d] %s", e.getInt("code"), e.getString("message")));
                    }
                    result = false;
                }
            }
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("rc error=" + e.getMessage()));
        }
        return result;
    }

    public boolean sendRetention(long retentionCount) {
        boolean result = false;
        try {
            if (!AdvertisingIdHelper.hasAdvertisingId()) {
                Log.w((String)LOG_TAG, (String)"Google Advertising ID is not found!");
            } else {
                StringBuilder params = new StringBuilder();
                long timestamp = System.currentTimeMillis();
                String recommendee = String.format(Locale.ENGLISH, "%d,%s,%s,%s", timestamp, AdvertisingIdHelper.getAdId(), DeviceManager.getAndroidId(this.mContext), DeviceManager.getSerial());
                String recommender = String.format(Locale.ENGLISH, "%d,%s,%s,%s", timestamp, ReferrerReceiver.getRecommendNickname(this.mContext), ReferrerReceiver.getRecommendPath(this.mContext), this.mAppId);
                params.append("recommendee=").append(EncryptManager.encryptMsg(recommendee));
                params.append("&recommender=").append(EncryptManager.encryptMsg(recommender));
                params.append("&count=").append(Long.toString(retentionCount));
                params.append("&referrer=").append(URLEncoder.encode(ReferrerReceiver.getReferrer(this.mContext), "utf-8"));
                String response = this.sendPostHttpUrlConnection(new URI(RETENTION_URL), params.toString());
                JSONObject json = new JSONObject(response);
                if (!json.has("errors")) {
                    Log.i((String)LOG_TAG, (String)"retention success");
                    result = true;
                } else {
                    JSONArray errors = json.getJSONArray("errors");
                    for (int i = 0; i < errors.length(); ++i) {
                        JSONObject e = errors.getJSONObject(i);
                        Log.e((String)LOG_TAG, (String)String.format("rt ERROR[%d] %s", e.getInt("code"), e.getString("message")));
                    }
                    result = false;
                }
            }
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("rt error=" + e.getMessage()));
        }
        return result;
    }
}

