/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.naverlogin.ui.view;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageButton;
import com.nhn.android.naverlogin.OAuthLogin;
import com.nhn.android.naverlogin.OAuthLoginHandler;
import com.nhn.android.naverlogin.ui.OAuthLoginImage;

public class OAuthLoginButton
extends ImageButton {
    private Context mContext;
    private static OAuthLoginHandler mOAuthLoginHandler;
    private int mBgDrawableResId = -1;

    public OAuthLoginButton(Context context) {
        super(context);
        this.init(context);
    }

    public OAuthLoginButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public OAuthLoginButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    public void setOAuthLoginHandler(OAuthLoginHandler oauthLoginHandler) {
        mOAuthLoginHandler = oauthLoginHandler;
    }

    @Deprecated
    public void setBgType(String color, String type) {
        this.setBgType();
    }

    public void setBgResourceId(int resId) {
        this.mBgDrawableResId = resId;
    }

    private void setBgType() {
        if (-1 != this.mBgDrawableResId) {
            Drawable drawableBgImage = this.getResources().getDrawable(this.mBgDrawableResId);
            if (Build.VERSION.SDK_INT >= 16) {
                this.setBackground(drawableBgImage);
            } else {
                this.setBackgroundDrawable(drawableBgImage);
            }
            return;
        }
        byte[] drawableByteBackGroundImg = null;
        drawableByteBackGroundImg = OAuthLoginImage.hexToByteArray(OAuthLoginImage.getDrawableByteStrLoginBtnImg());
        Bitmap bitmap = null;
        try {
            bitmap = BitmapFactory.decodeByteArray((byte[])drawableByteBackGroundImg, (int)0, (int)drawableByteBackGroundImg.length);
        }
        catch (Exception e) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            bitmap = BitmapFactory.decodeByteArray((byte[])drawableByteBackGroundImg, (int)0, (int)drawableByteBackGroundImg.length, (BitmapFactory.Options)options);
        }
        BitmapDrawable bt = null;
        int newHeight = 50;
        int newWidth = 0;
        try {
            newHeight = this.getLayoutParams().height;
            newWidth = 0;
            if (newHeight > 0) {
                newWidth = (int)((double)newHeight / (double)bitmap.getHeight() * (double)bitmap.getWidth());
            } else {
                newWidth = this.getLayoutParams().width;
                if (newWidth > 0) {
                    newHeight = (int)((double)newWidth / (double)bitmap.getWidth() * (double)bitmap.getHeight());
                } else {
                    newHeight = 80;
                    newWidth = (int)((double)newHeight / (double)bitmap.getHeight() * (double)bitmap.getWidth());
                }
            }
            bt = new BitmapDrawable(this.getResources(), Bitmap.createScaledBitmap((Bitmap)bitmap, (int)newWidth, (int)newHeight, (boolean)true));
        }
        catch (Exception e) {
            bt = new BitmapDrawable(this.getResources(), bitmap);
            e.printStackTrace();
        }
        try {
            if (Build.VERSION.SDK_INT >= 16) {
                this.setBackground((Drawable)bt);
            } else {
                this.setBackgroundDrawable((Drawable)bt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init(Context context) {
        this.mBgDrawableResId = -1;
        this.mContext = context;
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                OAuthLogin.getInstance().startOauthLoginActivity((Activity)OAuthLoginButton.this.mContext, mOAuthLoginHandler);
            }
        });
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (this.isInEditMode()) {
            return;
        }
        this.setBgType();
        super.onLayout(changed, left, top, right, bottom);
    }
}

