/*
 * Decompiled with CFR 0.152.
 */
package com.buzzvil.buzzad.analytics;

import android.util.Log;
import com.buzzvil.buzzad.analytics.PreferenceHelper;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class Checker {
    Checker() {
    }

    static boolean isResultReceived() {
        return PreferenceHelper.getBoolean("result_received", false);
    }

    static void resultReceived() {
        PreferenceHelper.putBoolean("result_received", true);
    }

    static boolean isNeedRetry() {
        return PreferenceHelper.getBoolean("need_retry", false);
    }

    static void setNeedRetry(boolean needRetry) {
        PreferenceHelper.putBoolean("need_retry", needRetry);
    }

    static int isFirst() {
        return PreferenceHelper.getInt("first_call", 1);
    }

    static void setFirstCall() {
        PreferenceHelper.putInt("first_call", 0);
    }

    static JSONArray getEventQueue() {
        String eventQueue = PreferenceHelper.getString("event_queue", null);
        JSONArray jsonArray = new JSONArray();
        if (eventQueue != null && !eventQueue.equals("")) {
            for (String s : eventQueue.split(";")) {
                try {
                    JSONObject obj = new JSONObject(s);
                    jsonArray.put((Object)obj);
                }
                catch (JSONException e) {
                    Log.e((String)"getEventQueue", (String)"error parsing JSON");
                }
            }
        }
        return jsonArray;
    }

    static void saveEvent(JSONObject jsonObject) {
        String eventQueue = PreferenceHelper.getString("event_queue", null);
        if (eventQueue != null) {
            eventQueue = eventQueue.equals("") ? jsonObject.toString() : eventQueue.concat(";").concat(jsonObject.toString());
            PreferenceHelper.putString("event_queue", eventQueue);
        } else {
            PreferenceHelper.putString("event_queue", jsonObject.toString());
        }
    }

    static void clearEventQueue() {
        PreferenceHelper.putString("event_queue", "");
    }
}

