/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk.v2;

import com.android.apksig.ApkVerifier;
import com.android.apksig.apk.ApkFormatException;
import com.android.apksig.apk.ApkUtils;
import com.android.apksig.internal.apk.v2.ContentDigestAlgorithm;
import com.android.apksig.internal.apk.v2.SignatureAlgorithm;
import com.android.apksig.internal.util.Pair;
import com.android.apksig.internal.zip.ZipUtils;
import com.android.apksig.util.DataSource;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VerificationModule {
    private static final long APK_SIG_BLOCK_MAGIC_HI = 3617552046287187010L;
    private static final long APK_SIG_BLOCK_MAGIC_LO = 2334950737559900225L;
    private static final int APK_SIG_BLOCK_MIN_SIZE = 32;
    private static final int APK_SIGNATURE_SCHEME_V2_BLOCK_ID = 1896449818;
    private static final char[] HEX_DIGITS = "01234567890abcdef".toCharArray();

    private VerificationModule() {
    }

    public static Result verify(DataSource apk, ApkUtils.ZipSections zipSections) throws IOException, ApkFormatException, NoSuchAlgorithmException, SignatureNotFoundException {
        Result result = new Result();
        SignatureInfo signatureInfo = VerificationModule.findSignature(apk, zipSections, result);
        DataSource beforeApkSigningBlock = apk.slice(0L, signatureInfo.apkSigningBlockOffset);
        result.setBeforeApkSigningBlock(beforeApkSigningBlock);
        DataSource centralDir = apk.slice(signatureInfo.centralDirOffset, signatureInfo.eocdOffset - signatureInfo.centralDirOffset);
        ByteBuffer eocd = signatureInfo.eocd;
        VerificationModule.verify(beforeApkSigningBlock, signatureInfo.signatureBlock, centralDir, eocd, result);
        return result;
    }

    private static void verify(DataSource beforeApkSigningBlock, ByteBuffer apkSignatureSchemeV2Block, DataSource centralDir, ByteBuffer eocd, Result result) throws IOException, NoSuchAlgorithmException {
        HashSet<ContentDigestAlgorithm> contentDigestsToVerify = new HashSet<ContentDigestAlgorithm>(1);
        VerificationModule.parseSigners(apkSignatureSchemeV2Block, contentDigestsToVerify, result);
        if (result.containsErrors()) {
            return;
        }
    }

    private static void parseSigners(ByteBuffer apkSignatureSchemeV2Block, Set<ContentDigestAlgorithm> contentDigestsToVerify, Result result) throws NoSuchAlgorithmException {
        CertificateFactory certFactory;
        ByteBuffer signers;
        try {
            signers = VerificationModule.getLengthPrefixedSlice(apkSignatureSchemeV2Block);
        }
        catch (ApkFormatException e) {
            result.addError(ApkVerifier.Result.Issue.V2_SIG_MALFORMED_SIGNERS, new Object[0]);
            return;
        }
        if (!signers.hasRemaining()) {
            result.addError(ApkVerifier.Result.Issue.V2_SIG_NO_SIGNERS, new Object[0]);
            return;
        }
        try {
            certFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException("Failed to obtain X.509 CertificateFactory", e);
        }
        int signerCount = 0;
        while (signers.hasRemaining()) {
            int signerIndex = signerCount++;
            Result.SignerInfo signerInfo = new Result.SignerInfo();
            signerInfo.index = signerIndex;
            result.signers.add(signerInfo);
            try {
                ByteBuffer signer = VerificationModule.getLengthPrefixedSlice(signers);
                VerificationModule.parseSigner(signer, certFactory, signerInfo, contentDigestsToVerify);
            }
            catch (ApkFormatException e) {
                signerInfo.addError(ApkVerifier.Result.Issue.V2_SIG_MALFORMED_SIGNER, new Object[0]);
                return;
            }
            catch (BufferUnderflowException e) {
                signerInfo.addError(ApkVerifier.Result.Issue.V2_SIG_MALFORMED_SIGNER, new Object[0]);
                return;
            }
        }
    }

    private static void parseSigner(ByteBuffer signerBlock, CertificateFactory certFactory, Result.SignerInfo result, Set<ContentDigestAlgorithm> contentDigestsToVerify) throws ApkFormatException, NoSuchAlgorithmException {
        ByteBuffer signedData = VerificationModule.getLengthPrefixedSlice(signerBlock);
        byte[] signedDataBytes = new byte[signedData.remaining()];
        signedData.get(signedDataBytes);
        signedData.flip();
        result.signedData = signedDataBytes;
        ByteBuffer signatures = VerificationModule.getLengthPrefixedSlice(signerBlock);
        byte[] publicKeyBytes = VerificationModule.readLengthPrefixedByteArray(signerBlock);
        int signatureCount = 0;
        ArrayList<SupportedSignature> supportedSignatures = new ArrayList<SupportedSignature>(1);
        while (signatures.hasRemaining()) {
            ++signatureCount;
            try {
                ByteBuffer signature = VerificationModule.getLengthPrefixedSlice(signatures);
                int sigAlgorithmId = signature.getInt();
                byte[] sigBytes = VerificationModule.readLengthPrefixedByteArray(signature);
                result.signatures.add(new Result.SignerInfo.Signature(sigAlgorithmId, sigBytes));
                SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.findById(sigAlgorithmId);
                if (signatureAlgorithm == null) {
                    result.addWarning(ApkVerifier.Result.Issue.V2_SIG_UNKNOWN_SIG_ALGORITHM, sigAlgorithmId);
                    continue;
                }
                supportedSignatures.add(new SupportedSignature(signatureAlgorithm, sigBytes));
            }
            catch (ApkFormatException e) {
                result.addError(ApkVerifier.Result.Issue.V2_SIG_MALFORMED_SIGNATURE, signatureCount);
                return;
            }
            catch (BufferUnderflowException e) {
                result.addError(ApkVerifier.Result.Issue.V2_SIG_MALFORMED_SIGNATURE, signatureCount);
                return;
            }
        }
        if (result.signatures.isEmpty()) {
            result.addError(ApkVerifier.Result.Issue.V2_SIG_NO_SIGNATURES, new Object[0]);
            return;
        }
        signedData.position(0);
        ByteBuffer digests = VerificationModule.getLengthPrefixedSlice(signedData);
        ByteBuffer certificates = VerificationModule.getLengthPrefixedSlice(signedData);
        ByteBuffer additionalAttributes = VerificationModule.getLengthPrefixedSlice(signedData);
        int digestCount = 0;
        while (digests.hasRemaining()) {
            ++digestCount;
            try {
                ByteBuffer digest = VerificationModule.getLengthPrefixedSlice(digests);
                int sigAlgorithmId = digest.getInt();
                Object digestBytes = VerificationModule.readLengthPrefixedByteArray(digest);
                result.contentDigests.add(new Result.SignerInfo.ContentDigest(sigAlgorithmId, (byte[])digestBytes));
            }
            catch (ApkFormatException e) {
                result.addError(ApkVerifier.Result.Issue.V2_SIG_MALFORMED_DIGEST, digestCount);
                return;
            }
            catch (BufferUnderflowException e) {
                result.addError(ApkVerifier.Result.Issue.V2_SIG_MALFORMED_DIGEST, digestCount);
                return;
            }
        }
        ArrayList<Integer> sigAlgsFromSignaturesRecord = new ArrayList<Integer>(result.signatures.size());
        for (Result.SignerInfo.Signature signature : result.signatures) {
            sigAlgsFromSignaturesRecord.add(signature.getAlgorithmId());
        }
        ArrayList<Integer> sigAlgsFromDigestsRecord = new ArrayList<Integer>(result.contentDigests.size());
        for (Result.SignerInfo.ContentDigest digest : result.contentDigests) {
            sigAlgsFromDigestsRecord.add(digest.getSignatureAlgorithmId());
        }
        if (!sigAlgsFromSignaturesRecord.equals(sigAlgsFromDigestsRecord)) {
            result.addError(ApkVerifier.Result.Issue.V2_SIG_SIG_ALG_MISMATCH_BETWEEN_SIGNATURES_AND_DIGESTS_RECORDS, sigAlgsFromSignaturesRecord, sigAlgsFromDigestsRecord);
            return;
        }
        int additionalAttributeCount = 0;
        while (additionalAttributes.hasRemaining()) {
            ++additionalAttributeCount;
            try {
                ByteBuffer attribute = VerificationModule.getLengthPrefixedSlice(additionalAttributes);
                int id = attribute.getInt();
                byte[] value = VerificationModule.readLengthPrefixedByteArray(attribute);
                result.additionalAttributes.add(new Result.SignerInfo.AdditionalAttribute(id, value));
                result.addWarning(ApkVerifier.Result.Issue.V2_SIG_UNKNOWN_ADDITIONAL_ATTRIBUTE, id);
            }
            catch (ApkFormatException e) {
                result.addError(ApkVerifier.Result.Issue.V2_SIG_MALFORMED_ADDITIONAL_ATTRIBUTE, additionalAttributeCount);
                return;
            }
            catch (BufferUnderflowException e) {
                result.addError(ApkVerifier.Result.Issue.V2_SIG_MALFORMED_ADDITIONAL_ATTRIBUTE, additionalAttributeCount);
                return;
            }
        }
    }

    private static List<SupportedSignature> getSignaturesToVerify(List<SupportedSignature> signatures) {
        SignatureAlgorithm bestSigAlgorithm = null;
        byte[] bestSigAlgorithmSignatureBytes = null;
        for (SupportedSignature sig : signatures) {
            SignatureAlgorithm sigAlgorithm = sig.algorithm;
            if (bestSigAlgorithm != null && VerificationModule.compareSignatureAlgorithm(sigAlgorithm, bestSigAlgorithm) <= 0) continue;
            bestSigAlgorithm = sigAlgorithm;
            bestSigAlgorithmSignatureBytes = sig.signature;
        }
        if (bestSigAlgorithm == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new SupportedSignature(bestSigAlgorithm, bestSigAlgorithmSignatureBytes));
    }

    private static int compareSignatureAlgorithm(SignatureAlgorithm alg1, SignatureAlgorithm alg2) {
        ContentDigestAlgorithm digestAlg1 = alg1.getContentDigestAlgorithm();
        ContentDigestAlgorithm digestAlg2 = alg2.getContentDigestAlgorithm();
        return VerificationModule.compareContentDigestAlgorithm(digestAlg1, digestAlg2);
    }

    private static int compareContentDigestAlgorithm(ContentDigestAlgorithm alg1, ContentDigestAlgorithm alg2) {
        switch (alg1) {
            case CHUNKED_SHA256: {
                switch (alg2) {
                    case CHUNKED_SHA256: {
                        return 0;
                    }
                    case CHUNKED_SHA512: {
                        return -1;
                    }
                }
                throw new IllegalArgumentException("Unknown alg2: " + (Object)((Object)alg2));
            }
            case CHUNKED_SHA512: {
                switch (alg2) {
                    case CHUNKED_SHA256: {
                        return 1;
                    }
                    case CHUNKED_SHA512: {
                        return 0;
                    }
                }
                throw new IllegalArgumentException("Unknown alg2: " + (Object)((Object)alg2));
            }
        }
        throw new IllegalArgumentException("Unknown alg1: " + (Object)((Object)alg1));
    }

    private static void verifyIntegrity(DataSource beforeApkSigningBlock, DataSource centralDir, ByteBuffer eocd, Set<ContentDigestAlgorithm> contentDigestAlgorithms, Result result) throws IOException, NoSuchAlgorithmException {
        if (contentDigestAlgorithms.isEmpty()) {
            throw new RuntimeException("No content digests found");
        }
        ByteBuffer modifiedEocd = ByteBuffer.allocate(eocd.remaining());
        modifiedEocd.order(ByteOrder.LITTLE_ENDIAN);
        modifiedEocd.put(eocd);
        modifiedEocd.flip();
        ZipUtils.setZipEocdCentralDirectoryOffset(modifiedEocd, beforeApkSigningBlock.size());
        HashMap actualContentDigests = new HashMap();
        if (!contentDigestAlgorithms.equals(actualContentDigests.keySet())) {
            throw new RuntimeException("Mismatch between sets of requested and computed content digests . Requested: " + contentDigestAlgorithms + ", computed: " + actualContentDigests.keySet());
        }
        for (Result.SignerInfo signerInfo : result.signers) {
            for (Result.SignerInfo.ContentDigest expected : signerInfo.contentDigests) {
                byte[] actualDigest;
                SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.findById(expected.getSignatureAlgorithmId());
                if (signatureAlgorithm == null) continue;
                ContentDigestAlgorithm contentDigestAlgorithm = signatureAlgorithm.getContentDigestAlgorithm();
                byte[] expectedDigest = expected.getValue();
                if (!Arrays.equals(expectedDigest, actualDigest = (byte[])actualContentDigests.get((Object)contentDigestAlgorithm))) {
                    signerInfo.addError(ApkVerifier.Result.Issue.V2_SIG_APK_DIGEST_DID_NOT_VERIFY, new Object[]{contentDigestAlgorithm, VerificationModule.toHex(expectedDigest), VerificationModule.toHex(actualDigest)});
                    continue;
                }
                signerInfo.verifiedContentDigests.put(contentDigestAlgorithm, actualDigest);
            }
        }
    }

    private static SignatureInfo findSignature(DataSource apk, ApkUtils.ZipSections zipSections, Result result) throws IOException, SignatureNotFoundException {
        ByteBuffer eocd = zipSections.getZipEndOfCentralDirectory();
        Pair<DataSource, Long> apkSigningBlockAndOffset = VerificationModule.findApkSigningBlock(apk, zipSections);
        DataSource apkSigningBlock = apkSigningBlockAndOffset.getFirst();
        long apkSigningBlockOffset = apkSigningBlockAndOffset.getSecond();
        ByteBuffer apkSigningBlockBuf = apkSigningBlock.getByteBuffer(0L, (int)apkSigningBlock.size());
        apkSigningBlockBuf.order(ByteOrder.LITTLE_ENDIAN);
        int len = apkSigningBlockBuf.getInt();
        ByteBuffer apkSignatureSchemeV2Block = VerificationModule.findApkSignatureSchemeV2Block(apkSigningBlockBuf, result);
        return new SignatureInfo(apkSignatureSchemeV2Block, apkSigningBlockOffset, zipSections.getZipCentralDirectoryOffset(), zipSections.getZipEndOfCentralDirectoryOffset(), eocd);
    }

    public static Pair<DataSource, Long> findApkSigningBlock(DataSource apk, ApkUtils.ZipSections zipSections) throws IOException, SignatureNotFoundException {
        long eocdStartOffset;
        long centralDirStartOffset = zipSections.getZipCentralDirectoryOffset();
        long centralDirEndOffset = centralDirStartOffset + zipSections.getZipCentralDirectorySizeBytes();
        if (centralDirEndOffset != (eocdStartOffset = zipSections.getZipEndOfCentralDirectoryOffset())) {
            throw new SignatureNotFoundException("ZIP Central Directory is not immediately followed by End of Central Directory. CD end: " + centralDirEndOffset + ", EoCD start: " + eocdStartOffset);
        }
        if (centralDirStartOffset < 32L) {
            throw new SignatureNotFoundException("APK too small for APK Signing Block. ZIP Central Directory offset: " + centralDirStartOffset);
        }
        ByteBuffer footer = apk.getByteBuffer(centralDirStartOffset - 24L, 24);
        footer.order(ByteOrder.LITTLE_ENDIAN);
        if (footer.getLong(8) != 2334950737559900225L || footer.getLong(16) != 3617552046287187010L) {
            throw new SignatureNotFoundException("No APK Signing Block before ZIP Central Directory");
        }
        long apkSigBlockSizeInFooter = footer.getLong(0);
        if (apkSigBlockSizeInFooter < (long)footer.capacity() || apkSigBlockSizeInFooter > 0x7FFFFFF7L) {
            throw new SignatureNotFoundException("APK Signing Block size out of range: " + apkSigBlockSizeInFooter);
        }
        int totalSize = (int)(apkSigBlockSizeInFooter + 8L);
        long apkSigBlockOffset = centralDirStartOffset - (long)totalSize;
        if (apkSigBlockOffset < 0L) {
            throw new SignatureNotFoundException("APK Signing Block offset out of range: " + apkSigBlockOffset);
        }
        ByteBuffer apkSigBlock = apk.getByteBuffer(apkSigBlockOffset, 8);
        apkSigBlock.order(ByteOrder.LITTLE_ENDIAN);
        long apkSigBlockSizeInHeader = apkSigBlock.getLong(0);
        if (apkSigBlockSizeInHeader != apkSigBlockSizeInFooter) {
            throw new SignatureNotFoundException("APK Signing Block sizes in header and footer do not match: " + apkSigBlockSizeInHeader + " vs " + apkSigBlockSizeInFooter);
        }
        return Pair.of(apk.slice(apkSigBlockOffset, totalSize), apkSigBlockOffset);
    }

    private static ByteBuffer findApkSignatureSchemeV2Block(ByteBuffer apkSigningBlock, Result result) throws SignatureNotFoundException {
        VerificationModule.checkByteOrderLittleEndian(apkSigningBlock);
        ByteBuffer pairs = VerificationModule.sliceFromTo(apkSigningBlock, 8, apkSigningBlock.capacity() - 24);
        int entryCount = 0;
        while (pairs.hasRemaining()) {
            ++entryCount;
            if (pairs.remaining() < 8) {
                throw new SignatureNotFoundException("Insufficient data to read size of APK Signing Block entry #" + entryCount);
            }
            long lenLong = pairs.getLong();
            if (lenLong < 4L || lenLong > Integer.MAX_VALUE) {
                throw new SignatureNotFoundException("APK Signing Block entry #" + entryCount + " size out of range: " + lenLong);
            }
            int len = (int)lenLong;
            int nextEntryPos = pairs.position() + len;
            if (len > pairs.remaining()) {
                throw new SignatureNotFoundException("APK Signing Block entry #" + entryCount + " size out of range: " + len + ", available: " + pairs.remaining());
            }
            int id = pairs.getInt();
            if (id == 1896449818) {
                return VerificationModule.getByteBuffer(pairs, len - 4);
            }
            result.addWarning(ApkVerifier.Result.Issue.APK_SIG_BLOCK_UNKNOWN_ENTRY_ID, id);
            pairs.position(nextEntryPos);
        }
        throw new SignatureNotFoundException("No APK Signature Scheme v2 block in APK Signing Block");
    }

    private static void checkByteOrderLittleEndian(ByteBuffer buffer) {
        if (buffer.order() != ByteOrder.LITTLE_ENDIAN) {
            throw new IllegalArgumentException("ByteBuffer byte order must be little endian");
        }
    }

    private static ByteBuffer sliceFromTo(ByteBuffer source, int start, int end) {
        if (start < 0) {
            throw new IllegalArgumentException("start: " + start);
        }
        if (end < start) {
            throw new IllegalArgumentException("end < start: " + end + " < " + start);
        }
        int capacity = source.capacity();
        if (end > source.capacity()) {
            throw new IllegalArgumentException("end > capacity: " + end + " > " + capacity);
        }
        int originalLimit = source.limit();
        int originalPosition = source.position();
        try {
            source.position(0);
            source.limit(end);
            source.position(start);
            ByteBuffer result = source.slice();
            result.order(source.order());
            ByteBuffer byteBuffer = result;
            return byteBuffer;
        }
        finally {
            source.position(0);
            source.limit(originalLimit);
            source.position(originalPosition);
        }
    }

    private static ByteBuffer getByteBuffer(ByteBuffer source, int size) throws BufferUnderflowException {
        if (size < 0) {
            throw new IllegalArgumentException("size: " + size);
        }
        int originalLimit = source.limit();
        int position = source.position();
        int limit = position + size;
        if (limit < position || limit > originalLimit) {
            throw new BufferUnderflowException();
        }
        source.limit(limit);
        try {
            ByteBuffer result = source.slice();
            result.order(source.order());
            source.position(limit);
            ByteBuffer byteBuffer = result;
            return byteBuffer;
        }
        finally {
            source.limit(originalLimit);
        }
    }

    private static ByteBuffer getLengthPrefixedSlice(ByteBuffer source) throws ApkFormatException {
        if (source.remaining() < 4) {
            throw new ApkFormatException("Remaining buffer too short to contain length of length-prefixed field. Remaining: " + source.remaining());
        }
        int len = source.getInt();
        if (len < 0) {
            throw new IllegalArgumentException("Negative length");
        }
        if (len > source.remaining()) {
            throw new ApkFormatException("Length-prefixed field longer than remaining buffer. Field length: " + len + ", remaining: " + source.remaining());
        }
        return VerificationModule.getByteBuffer(source, len);
    }

    private static byte[] readLengthPrefixedByteArray(ByteBuffer buf) throws ApkFormatException {
        int len = buf.getInt();
        if (len < 0) {
            throw new ApkFormatException("Negative length");
        }
        if (len > buf.remaining()) {
            throw new ApkFormatException("Underflow while reading length-prefixed value. Length: " + len + ", available: " + buf.remaining());
        }
        byte[] result = new byte[len];
        buf.get(result);
        return result;
    }

    private static String toHex(byte[] value) {
        StringBuilder sb = new StringBuilder(value.length * 2);
        int len = value.length;
        int i = 0;
        while (i < len) {
            int hi = (value[i] & 0xFF) >>> 4;
            int lo = value[i] & 0xF;
            sb.append(HEX_DIGITS[hi]).append(HEX_DIGITS[lo]);
            ++i;
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Result {
        public boolean verified;
        private DataSource beforeApkSigningBlock;
        public final List<SignerInfo> signers = new ArrayList<SignerInfo>();
        private final List<ApkVerifier.Result.IssueWithParams> mWarnings = new ArrayList<ApkVerifier.Result.IssueWithParams>();
        private final List<ApkVerifier.Result.IssueWithParams> mErrors = new ArrayList<ApkVerifier.Result.IssueWithParams>();

        public DataSource getBeforeApkSigningBlock() {
            return this.beforeApkSigningBlock;
        }

        public void setBeforeApkSigningBlock(DataSource beforeApkSigningBlock) {
            this.beforeApkSigningBlock = beforeApkSigningBlock;
        }

        public boolean containsErrors() {
            if (!this.mErrors.isEmpty()) {
                return true;
            }
            if (!this.signers.isEmpty()) {
                for (SignerInfo signer : this.signers) {
                    if (!signer.containsErrors()) continue;
                    return true;
                }
            }
            return false;
        }

        public void addError(ApkVerifier.Result.Issue msg, Object ... parameters) {
            this.mErrors.add(new ApkVerifier.Result.IssueWithParams(msg, parameters));
        }

        public void addWarning(ApkVerifier.Result.Issue msg, Object ... parameters) {
            this.mWarnings.add(new ApkVerifier.Result.IssueWithParams(msg, parameters));
        }

        public List<ApkVerifier.Result.IssueWithParams> getErrors() {
            return this.mErrors;
        }

        public List<ApkVerifier.Result.IssueWithParams> getWarnings() {
            return this.mWarnings;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class SignerInfo {
            public int index;
            public List<X509Certificate> certs = new ArrayList<X509Certificate>();
            public List<ContentDigest> contentDigests = new ArrayList<ContentDigest>();
            public Map<ContentDigestAlgorithm, byte[]> verifiedContentDigests = new HashMap<ContentDigestAlgorithm, byte[]>();
            public List<Signature> signatures = new ArrayList<Signature>();
            public Map<SignatureAlgorithm, byte[]> verifiedSignatures = new HashMap<SignatureAlgorithm, byte[]>();
            public List<AdditionalAttribute> additionalAttributes = new ArrayList<AdditionalAttribute>();
            public byte[] signedData;
            private final List<ApkVerifier.Result.IssueWithParams> mWarnings = new ArrayList<ApkVerifier.Result.IssueWithParams>();
            private final List<ApkVerifier.Result.IssueWithParams> mErrors = new ArrayList<ApkVerifier.Result.IssueWithParams>();

            public void addError(ApkVerifier.Result.Issue msg, Object ... parameters) {
                this.mErrors.add(new ApkVerifier.Result.IssueWithParams(msg, parameters));
            }

            public void addWarning(ApkVerifier.Result.Issue msg, Object ... parameters) {
                this.mWarnings.add(new ApkVerifier.Result.IssueWithParams(msg, parameters));
            }

            public boolean containsErrors() {
                return !this.mErrors.isEmpty();
            }

            public List<ApkVerifier.Result.IssueWithParams> getErrors() {
                return this.mErrors;
            }

            public List<ApkVerifier.Result.IssueWithParams> getWarnings() {
                return this.mWarnings;
            }

            public static class AdditionalAttribute {
                private final int mId;
                private final byte[] mValue;

                public AdditionalAttribute(int id, byte[] value) {
                    this.mId = id;
                    this.mValue = (byte[])value.clone();
                }

                public int getId() {
                    return this.mId;
                }

                public byte[] getValue() {
                    return (byte[])this.mValue.clone();
                }
            }

            public static class ContentDigest {
                private final int mSignatureAlgorithmId;
                private final byte[] mValue;

                public ContentDigest(int signatureAlgorithmId, byte[] value) {
                    this.mSignatureAlgorithmId = signatureAlgorithmId;
                    this.mValue = value;
                }

                public int getSignatureAlgorithmId() {
                    return this.mSignatureAlgorithmId;
                }

                public byte[] getValue() {
                    return this.mValue;
                }
            }

            public static class Signature {
                private final int mAlgorithmId;
                private final byte[] mValue;

                public Signature(int algorithmId, byte[] value) {
                    this.mAlgorithmId = algorithmId;
                    this.mValue = value;
                }

                public int getAlgorithmId() {
                    return this.mAlgorithmId;
                }

                public byte[] getValue() {
                    return this.mValue;
                }
            }
        }
    }

    private static class SignatureInfo {
        private final ByteBuffer signatureBlock;
        private final long apkSigningBlockOffset;
        private final long centralDirOffset;
        private final long eocdOffset;
        private final ByteBuffer eocd;

        private SignatureInfo(ByteBuffer signatureBlock, long apkSigningBlockOffset, long centralDirOffset, long eocdOffset, ByteBuffer eocd) {
            this.signatureBlock = signatureBlock;
            this.apkSigningBlockOffset = apkSigningBlockOffset;
            this.centralDirOffset = centralDirOffset;
            this.eocdOffset = eocdOffset;
            this.eocd = eocd;
        }
    }

    public static class SignatureNotFoundException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public SignatureNotFoundException(String message) {
            super(message);
        }

        public SignatureNotFoundException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static class SupportedSignature {
        private final SignatureAlgorithm algorithm;
        private final byte[] signature;

        private SupportedSignature(SignatureAlgorithm algorithm, byte[] signature) {
            this.algorithm = algorithm;
            this.signature = signature;
        }
    }
}

