/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksigner;

import java.nio.ByteBuffer;

class HexEncoding {
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();

    private HexEncoding() {
    }

    public static String encode(byte[] data, int offset, int length) {
        StringBuilder result = new StringBuilder(length * 2);
        int i = 0;
        while (i < length) {
            byte b = data[offset + i];
            result.append(HEX_DIGITS[b >>> 4 & 0xF]);
            result.append(HEX_DIGITS[b & 0xF]);
            ++i;
        }
        return result.toString();
    }

    public static String encode(byte[] data) {
        return HexEncoding.encode(data, 0, data.length);
    }

    public static String encodeRemaining(ByteBuffer data) {
        return HexEncoding.encode(data.array(), data.arrayOffset() + data.position(), data.remaining());
    }
}

