/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.naverlogin.connection;

import android.util.Log;
import com.nhn.android.naverlogin.OAuthLoginDefine;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpResponse;

public class ResponseData {
    private final String TAG = "NaverLoginOAuth|ResponseData";
    public ResponseDataStat mStat = ResponseDataStat.SUCCESS;
    public int mStatusCode = -1;
    public String mContent = "";
    public String mCookie = "";
    public String mErrorDetail = "";

    public void setResultCode(ResponseDataStat stat, String msg) {
        this.mStat = stat;
        this.mErrorDetail = msg;
    }

    public void setResponseData(HttpResponse httpResponse, String cookie) {
        if (cookie != null) {
            this.mCookie = cookie;
        }
        if (httpResponse == null) {
            Log.e((String)"NaverLoginOAuth|ResponseData", (String)"error : httpResponse is null !!");
            this.setResultCode(ResponseDataStat.FAIL, "setResponseData() - httpResponse is null");
            return;
        }
        InputStream responseContent = null;
        try {
            responseContent = httpResponse.getEntity().getContent();
            this.mContent = this.getContent(responseContent);
            this.mStatusCode = httpResponse.getStatusLine().getStatusCode();
            if (OAuthLoginDefine.DEVELOPER_VERSION) {
                Log.d((String)"NaverLoginOAuth|ResponseData", (String)("headers:" + httpResponse.getAllHeaders().toString()));
                Log.d((String)"NaverLoginOAuth|ResponseData", (String)("status:" + httpResponse.getStatusLine().toString()));
            }
        }
        catch (IllegalStateException e) {
            this.setResultCode(ResponseDataStat.EXCEPTION_FAIL, "setResponseData()-IllegalStateException:" + e.getMessage());
        }
        catch (Exception e) {
            this.setResultCode(ResponseDataStat.EXCEPTION_FAIL, "setResponseData()-Exception:" + e.getMessage());
        }
    }

    private String getContent(InputStream is) {
        BufferedReader reader;
        int bufferSize = 1024;
        char[] readString = new char[1024];
        try {
            reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        }
        catch (UnsupportedEncodingException e1) {
            reader = new BufferedReader(new InputStreamReader(is));
        }
        StringBuilder buf = new StringBuilder();
        try {
            int read;
            while ((read = reader.read(readString, 0, 1024)) > 0) {
                buf.append(readString, 0, read);
            }
            reader.close();
        }
        catch (IOException e) {
            this.setResultCode(ResponseDataStat.EXCEPTION_FAIL, "getContent()-IOException:" + e.getMessage());
        }
        catch (RuntimeException e) {
            this.setResultCode(ResponseDataStat.EXCEPTION_FAIL, "getContent()-RuntimeException:" + e.getMessage());
        }
        return buf.toString();
    }

    public String toString() {
        return "Statuscode:" + this.mStatusCode + ", Content:" + this.mContent + ", Cookie:" + this.mCookie + ", ErrorDetail:" + this.mErrorDetail;
    }

    public static enum ResponseDataStat {
        SUCCESS("SUCCESS", null),
        BUSY("BUSY", "BUSY"),
        CANCEL("CANCEL", "CANCEL"),
        URL_ERROR("URL_ERROR", "URL_ERROR"),
        CONNECTION_TIMEOUT("CONNECTION_TIMEOUT", "CONNECTION_TIMEOUT"),
        CONNECTION_FAIL("CONNECTION_FAIL", "CONNECTION_FAIL"),
        EXCEPTION_FAIL("EXCEPTION_FAIL", "EXCEPTION_FAIL"),
        NO_PEER_CERTIFICATE("NO_PEER_CERTIFICATE", "NO_PEER_CERTIFICATE"),
        FAIL("FAIL", "FAIL");

        private String stat;

        private ResponseDataStat(String str, String errMsg) {
            this.stat = str;
        }

        public String getValue() {
            return this.stat;
        }
    }
}

