/*
 * Decompiled with CFR 0.152.
 */
package com.nasmob.nswitch.sdk;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.nasmob.nswitch.sdk.Utils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Locale;

public class UserDevice {
    public static String getDeviceUDID(Context context, String advertisingId) {
        if (context == null) {
            return "";
        }
        String udid = "";
        if (advertisingId != null && advertisingId.length() > 0) {
            String[] array = advertisingId.split("_");
            udid = String.valueOf(udid) + Utils.md5(array[array.length - 1]);
        }
        if (udid != "") {
            return "g_" + udid;
        }
        return udid;
    }

    public static String getOS() {
        return "Android";
    }

    public static String getOSVersion() {
        return Build.VERSION.RELEASE;
    }

    public static String getDeviceModel() {
        return Build.MODEL;
    }

    public static String getResolution(Context context) {
        if (context == null) {
            return "";
        }
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        if (display != null) {
            DisplayMetrics metrics = new DisplayMetrics();
            display.getMetrics(metrics);
            return String.valueOf(metrics.widthPixels) + "x" + metrics.heightPixels;
        }
        return "";
    }

    public static String getCarrier(Context context) {
        if (context == null) {
            return "";
        }
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        return tm.getNetworkOperatorName();
    }

    public static String getLocale(Context context) {
        if (context == null) {
            return "";
        }
        Locale locale = Locale.getDefault();
        return String.valueOf(locale.getLanguage()) + "_" + locale.getCountry();
    }

    public static String getAppVersion(Context context) {
        if (context == null) {
            return "";
        }
        String version = "1.0";
        try {
            version = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return version;
    }

    public static String getOrientation(Context context) {
        if (context == null) {
            return "";
        }
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        int orien = 0;
        int sdk = Build.VERSION.SDK_INT;
        orien = sdk < 8 ? display.getOrientation() : display.getRotation();
        switch (orien) {
            case 0: {
                return "0";
            }
            case 1: {
                return "1";
            }
            case 2: {
                return "0";
            }
            case 3: {
                return "1";
            }
        }
        return "";
    }

    public static boolean isEmulator() {
        return Build.BOARD.equals("unknown") && Build.DEVICE.equals("generic") && Build.BRAND.equals("generic");
    }

    public static String getUserDeviceToJson(Context context) {
        if (context == null) {
            return "";
        }
        String json = "{";
        json = String.valueOf(json) + "\"dm\":\"" + UserDevice.getDeviceModel() + "\"";
        json = String.valueOf(json) + "\"os\":\"" + UserDevice.getOS() + "\"";
        json = String.valueOf(json) + "\"ov\":\"" + UserDevice.getOSVersion() + "\"";
        json = String.valueOf(json) + "\"cr\":\"" + UserDevice.getCarrier(context) + "\"";
        json = String.valueOf(json) + "\"rs\":\"" + UserDevice.getResolution(context) + "\"";
        json = String.valueOf(json) + "\"lo\":\"" + UserDevice.getLocale(context) + "\"";
        json = String.valueOf(json) + "\"av\":\"" + UserDevice.getAppVersion(context) + "\"";
        json = String.valueOf(json) + "\"or\":\"" + UserDevice.getOrientation(context) + "\"";
        if (UserDevice.isEmulator()) {
            json = String.valueOf(json) + "\"em\":\"1\"";
        }
        json = String.valueOf(json) + "}";
        try {
            json = URLEncoder.encode(json, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return json;
    }

    public static String getUserDeviceToUri(Context context) {
        if (context == null) {
            return "";
        }
        String uri = "";
        uri = String.valueOf(uri) + "dm=" + Utils.encodeUrl(UserDevice.getDeviceModel());
        uri = String.valueOf(uri) + "&os=" + Utils.encodeUrl(UserDevice.getOS());
        uri = String.valueOf(uri) + "&ov=" + Utils.encodeUrl(UserDevice.getOSVersion());
        uri = String.valueOf(uri) + "&cr=" + Utils.encodeUrl(UserDevice.getCarrier(context));
        uri = String.valueOf(uri) + "&rs=" + Utils.encodeUrl(UserDevice.getResolution(context));
        uri = String.valueOf(uri) + "&lo=" + Utils.encodeUrl(UserDevice.getLocale(context));
        uri = String.valueOf(uri) + "&av=" + Utils.encodeUrl(UserDevice.getAppVersion(context));
        uri = String.valueOf(uri) + "&or=" + Utils.encodeUrl(UserDevice.getOrientation(context));
        if (UserDevice.isEmulator()) {
            uri = String.valueOf(uri) + "&em=1";
        }
        return uri;
    }
}

