/*
 * Decompiled with CFR 0.152.
 */
package kr.co.cashslide;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.UrlQuerySanitizer;
import android.text.TextUtils;
import android.util.Log;
import java.net.URLDecoder;
import kr.co.cashslide.CashslideIntentService;

public class ReferrerReceiver
extends BroadcastReceiver {
    private static final String LOG_TAG = "CashslideSDK";
    private static final String INSTALL_REFERRER_ACTION = "com.android.vending.INSTALL_REFERRER";
    private static final String PREF_REFERRER = "referrer";
    private static final String ENCODING = "UTF-8";
    private static final String PREFS_NAME = "CashslideReferrer";
    private static final String PARAM_RAW_REFERRER = "raw_referrer";
    private static final String PARAM_NICKNAME = "cs_nickname";
    private static final String PARAM_RECOMMEND_PATH = "cs_recommend_path";

    public void onReceive(Context context, Intent intent) {
        try {
            String rawReferrer;
            if (intent != null && intent.getAction().equals(INSTALL_REFERRER_ACTION) && (rawReferrer = intent.getStringExtra(PREF_REFERRER)) != null) {
                String referrer = URLDecoder.decode(rawReferrer, ENCODING);
                ReferrerReceiver.setReferrer(context, referrer);
                Log.i((String)LOG_TAG, (String)String.format("ReferrerReceiver: raw referrer=%s, referrer=%s", rawReferrer, referrer));
                intent.setClass(context, CashslideIntentService.class);
                context.startService(intent);
            }
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("error=" + e.getMessage()));
        }
    }

    public static void setReferrer(Context context, String referrer) {
        try {
            SharedPreferences pref = context.getSharedPreferences(PREFS_NAME, 0);
            SharedPreferences.Editor editor = pref.edit();
            editor.putString(PARAM_RAW_REFERRER, referrer);
            editor.commit();
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("error:" + e.getMessage()));
        }
    }

    public static String getReferrer(Context context) {
        SharedPreferences pref = context.getSharedPreferences(PREFS_NAME, 0);
        return pref.getString(PARAM_RAW_REFERRER, "");
    }

    public static String getRecommendNickname(Context context) {
        return ReferrerReceiver.getValueFromReferrer(context, PARAM_NICKNAME);
    }

    public static String getRecommendPath(Context context) {
        return ReferrerReceiver.getValueFromReferrer(context, PARAM_RECOMMEND_PATH);
    }

    private static String getValueFromReferrer(Context context, String key) {
        String value = "";
        try {
            String referrer = ReferrerReceiver.getReferrer(context);
            if (!TextUtils.isEmpty((CharSequence)referrer)) {
                UrlQuerySanitizer urlQuerySanitizer = new UrlQuerySanitizer("localhost?" + referrer);
                value = urlQuerySanitizer.getValue(key);
            }
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("error:" + e.getMessage()));
        }
        return value;
    }
}

