/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.naverlogin.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import com.nhn.android.naverlogin.OAuthLogin;
import com.nhn.android.naverlogin.OAuthLoginDefine;
import com.nhn.android.naverlogin.connection.OAuthLoginConnection;
import com.nhn.android.naverlogin.data.OAuthErrorCode;
import com.nhn.android.naverlogin.data.OAuthLoginData;
import com.nhn.android.naverlogin.data.OAuthLoginPreferenceManager;
import com.nhn.android.naverlogin.data.OAuthLoginString;
import com.nhn.android.naverlogin.data.OAuthResponse;
import com.nhn.android.naverlogin.ui.OAuthLoginDialogMng;
import com.nhn.android.naverlogin.ui.OAuthLoginInAppBrowserActivity;
import com.nhn.android.naverlogin.util.DeviceAppInfo;

public class OAuthLoginActivity
extends Activity {
    private static final String TAG = "NaverLoginOAuth|OAuthLoginActivity";
    private static int REQUESTCODE_LOGIN = 100;
    private OAuthLoginDialogMng mDialogMng = new OAuthLoginDialogMng();
    private Context mContext;
    private OAuthLoginData mOAuthLoginData;
    private String mClientName;
    private boolean mIsLoginActivityStarted = false;

    private boolean initData(Bundle savedInstanceState) {
        this.mContext = this;
        OAuthLoginPreferenceManager pref = new OAuthLoginPreferenceManager(this.mContext);
        String clientId = pref.getClientId();
        String clientSecret = pref.getClientSecret();
        String callbackUrl = pref.getCallbackUrl();
        String state = savedInstanceState == null ? null : savedInstanceState.getString("OAuthLoginData_state");
        this.mClientName = pref.getClientName();
        if (TextUtils.isEmpty((CharSequence)clientId)) {
            this.finishWithErrorResult(OAuthErrorCode.CLIENT_ERROR_NO_CLIENTID);
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)clientSecret)) {
            this.finishWithErrorResult(OAuthErrorCode.CLIENT_ERROR_NO_CLIENTSECRET);
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.mClientName)) {
            this.finishWithErrorResult(OAuthErrorCode.CLIENT_ERROR_NO_CLIENTNAME);
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)callbackUrl)) {
            this.finishWithErrorResult(OAuthErrorCode.CLIENT_ERROR_NO_CALLBACKURL);
            return false;
        }
        this.mOAuthLoginData = new OAuthLoginData(clientId, clientSecret, callbackUrl, state);
        return true;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (OAuthLoginDefine.DEVELOPER_VERSION) {
            Log.d((String)TAG, (String)"onCreate()");
        }
        if (!this.initData(savedInstanceState)) {
            return;
        }
        if (savedInstanceState != null) {
            this.mIsLoginActivityStarted = savedInstanceState.getBoolean("IsLoginActivityStarted");
        }
        if (!this.mIsLoginActivityStarted) {
            this.mIsLoginActivityStarted = true;
            if (OAuthLoginDefine.DEVELOPER_VERSION) {
                Log.d((String)TAG, (String)"onCreate() first");
            }
            this.runOnlyOnce();
        }
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        if (OAuthLoginDefine.DEVELOPER_VERSION) {
            Log.d((String)TAG, (String)"onRestoreInstanceState()");
        }
        if (savedInstanceState != null) {
            this.mIsLoginActivityStarted = savedInstanceState.getBoolean("IsLoginActivityStarted");
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (OAuthLoginDefine.DEVELOPER_VERSION) {
            Log.d((String)TAG, (String)"Login onSaveInstanceState()");
        }
        outState.putBoolean("IsLoginActivityStarted", this.mIsLoginActivityStarted);
        outState.putString("OAuthLoginData_state", this.mOAuthLoginData.getInitState());
    }

    private void startLoginActivity() {
        if (OAuthLoginDefine.DEVELOPER_VERSION) {
            Log.d((String)TAG, (String)"startLoginActivity()");
        }
        try {
            Intent intent = new Intent();
            intent.putExtra("ClientId", this.mOAuthLoginData.getClientId());
            intent.putExtra("ClientCallbackUrl", this.mOAuthLoginData.getCallbackUrl());
            intent.putExtra("state", this.mOAuthLoginData.getInitState());
            intent.putExtra("app_name", this.mClientName);
            intent.putExtra("oauth_sdk_version", "4.1.4.1");
            if (DeviceAppInfo.isIntentFilterExist(this.mContext, "com.nhn.android.search.action.OAUTH2_LOGIN")) {
                if (OAuthLoginDefine.DEVELOPER_VERSION) {
                    Log.d((String)TAG, (String)"startLoginActivity() with naapp");
                }
                intent.setPackage("com.nhn.android.search");
                intent.setAction("com.nhn.android.search.action.OAUTH2_LOGIN");
                this.startActivityForResult(intent, REQUESTCODE_LOGIN);
                return;
            }
            if (DeviceAppInfo.isIntentFilterExist(this.mContext, "com.naver.android.action.OAUTH2_LOGIN")) {
                if (OAuthLoginDefine.DEVELOPER_VERSION) {
                    Log.d((String)TAG, (String)"startLoginActivity() with appstore");
                }
                intent.setAction("com.naver.android.action.OAUTH2_LOGIN");
                String appName = DeviceAppInfo.getPrimaryNaverOAuth2ndAppPackageName(this.mContext);
                if (!TextUtils.isEmpty((CharSequence)appName)) {
                    intent.setPackage(appName);
                }
                this.startActivityForResult(intent, REQUESTCODE_LOGIN);
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (OAuthLoginDefine.DEVELOPER_VERSION) {
            Log.d((String)TAG, (String)"startLoginActivity() with webview");
        }
        this.startLoginWebviewActivity((Activity)this.mContext, REQUESTCODE_LOGIN, this.mOAuthLoginData.getClientId(), this.mOAuthLoginData.getInitState(), this.mOAuthLoginData.getCallbackUrl());
    }

    private void startLoginWebviewActivity(Activity callerActivity, int requestCode, String clientId, String state, String callbackUrl) {
        Intent intent = new Intent((Context)callerActivity, OAuthLoginInAppBrowserActivity.class);
        intent.putExtra("ClientId", clientId);
        intent.putExtra("ClientCallbackUrl", callbackUrl);
        intent.putExtra("state", state);
        intent.putExtra("oauth_sdk_version", "4.1.4.1");
        callerActivity.startActivityForResult(intent, requestCode);
    }

    protected void onResume() {
        super.onResume();
        if (OAuthLoginDefine.DEVELOPER_VERSION) {
            Log.d((String)TAG, (String)"onResume()");
        }
    }

    public void onPause() {
        super.onPause();
        if (OAuthLoginDefine.DEVELOPER_VERSION) {
            Log.d((String)TAG, (String)"onPause()");
        }
    }

    private void runOnlyOnce() {
        if (this.mOAuthLoginData == null) {
            this.finishWithErrorResult(OAuthErrorCode.CLIENT_ERROR_NO_CLIENTID);
            return;
        }
        this.startLoginActivity();
    }

    private void finishWithErrorResult(OAuthErrorCode errCode) {
        if (OAuthLoginDefine.DEVELOPER_VERSION) {
            Log.d((String)"GILSUB", (String)"Login finishWithErrorResult()");
        }
        Intent intent = new Intent();
        OAuthLoginPreferenceManager prefMng = new OAuthLoginPreferenceManager(this.mContext);
        prefMng.setLastErrorCode(errCode);
        prefMng.setLastErrorDesc(errCode.getDesc());
        intent.putExtra("oauth_error_code", errCode.getCode());
        intent.putExtra("oauth_error_desc", errCode.getDesc());
        this.setResult(0, intent);
        this.finish();
        this.propagationResult(false);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (data == null) {
            this.finishWithErrorResult(OAuthErrorCode.CLIENT_USER_CANCEL);
            return;
        }
        String state = data.getStringExtra("oauth_state");
        String code = data.getStringExtra("oauth_code");
        String errorCode = data.getStringExtra("oauth_error_code");
        String errorDesc = data.getStringExtra("oauth_error_desc");
        this.mOAuthLoginData.setMiddleResult(code, state, errorCode, errorDesc);
        if (OAuthLoginDefine.DEVELOPER_VERSION) {
            Log.d((String)"GILSUB", (String)"Login onActivityResult()");
        }
        if (TextUtils.isEmpty((CharSequence)code)) {
            OAuthLoginPreferenceManager prefMng = new OAuthLoginPreferenceManager(this.mContext);
            prefMng.setLastErrorCode(OAuthErrorCode.fromString(errorCode));
            prefMng.setLastErrorDesc(errorDesc);
            this.setResult(0, data);
            this.finish();
            this.propagationResult(false);
            return;
        }
        new GetAccessTokenTask().execute(new Void[0]);
    }

    private void propagationResult(boolean b) {
        if (OAuthLogin.mOAuthLoginHandler != null) {
            Message msg = new Message();
            msg.what = b ? 1 : 0;
            OAuthLogin.mOAuthLoginHandler.sendMessage(msg);
        }
    }

    private class GetAccessTokenTask
    extends AsyncTask<Void, Void, OAuthResponse> {
        private GetAccessTokenTask() {
        }

        protected void onPreExecute() {
            try {
                OAuthLoginActivity.this.mDialogMng.showProgressDlg(OAuthLoginActivity.this.mContext, OAuthLoginString.naveroauthlogin_string_getting_token.getString(OAuthLoginActivity.this.mContext), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected OAuthResponse doInBackground(Void ... params) {
            try {
                return OAuthLoginConnection.requestAccessToken(OAuthLoginActivity.this.mContext, OAuthLoginActivity.this.mOAuthLoginData.getClientId(), OAuthLoginActivity.this.mOAuthLoginData.getClientSecret(), OAuthLoginActivity.this.mOAuthLoginData.getState(), OAuthLoginActivity.this.mOAuthLoginData.getCode());
            }
            catch (Exception e) {
                return new OAuthResponse(OAuthErrorCode.CLIENT_ERROR_CONNECTION_ERROR);
            }
        }

        protected void onPostExecute(OAuthResponse res) {
            try {
                OAuthLoginActivity.this.mDialogMng.hideProgressDlg();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Intent intent = new Intent();
                OAuthLoginPreferenceManager prefMng = new OAuthLoginPreferenceManager(OAuthLoginActivity.this.mContext);
                if (res.isSuccess()) {
                    prefMng.setAccessToken(res.getAccessToken());
                    prefMng.setRefreshToken(res.getRefreshToken());
                    prefMng.setExpiresAt(System.currentTimeMillis() / 1000L + res.getExpiresIn());
                    prefMng.setTokenType(res.getTokenType());
                    prefMng.setLastErrorCode(OAuthErrorCode.NONE);
                    prefMng.setLastErrorDesc(OAuthErrorCode.NONE.getDesc());
                    intent.putExtra("oauth_access_token", res.getAccessToken());
                    intent.putExtra("oauth_refresh_token", res.getRefreshToken());
                    intent.putExtra("oauth_expires_in", res.getExpiresIn());
                    intent.putExtra("oauth_token_type", res.getTokenType());
                    OAuthLoginActivity.this.setResult(-1, intent);
                } else {
                    if (res.getErrorCode() == OAuthErrorCode.NONE) {
                        OAuthLoginActivity.this.finishWithErrorResult(OAuthErrorCode.CLIENT_USER_CANCEL);
                        return;
                    }
                    prefMng.setLastErrorCode(res.getErrorCode());
                    prefMng.setLastErrorDesc(res.getErrorDesc());
                    intent.putExtra("oauth_error_code", res.getErrorCode().getCode());
                    intent.putExtra("oauth_error_desc", res.getErrorDesc());
                    OAuthLoginActivity.this.setResult(0, intent);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            OAuthLoginActivity.this.finish();
            try {
                OAuthLoginActivity.this.propagationResult(res.isSuccess());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

