/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.naverlogin.util;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.nhn.android.naverlogin.OAuthLogin;
import com.nhn.android.naverlogin.OAuthLoginDefine;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class DeviceAppInfo {
    private static final String TAG = "NaverLoginOAuth|DeviceAppInfo";
    private static final DeviceAppInfo mInstance = new DeviceAppInfo();

    public static DeviceAppInfo getBaseInstance() {
        return mInstance;
    }

    private DeviceAppInfo() {
    }

    public boolean isKorean(Context context) {
        Locale systemLocale = context.getResources().getConfiguration().locale;
        String strLanguage = systemLocale.getLanguage();
        return strLanguage.startsWith("ko");
    }

    public String getUserAgent(Context context) {
        String androidVersionInfo = "Android/" + Build.VERSION.RELEASE;
        String modelInfo = "Model/" + Build.MODEL;
        String useragent = String.valueOf(androidVersionInfo.replaceAll("\\s", "")) + " " + modelInfo.replaceAll("\\s", "");
        String packageName = "";
        try {
            PackageManager pm = context.getPackageManager();
            packageName = context.getPackageName();
            PackageInfo info = pm.getPackageInfo(packageName, 448);
            String appId = "";
            if (info.applicationInfo.loadDescription(pm) != null) {
                appId = ",appId:" + info.applicationInfo.loadDescription(pm);
            }
            String appInfo = String.format("%s/%s(%d,uid:%d%s)", packageName, info.versionName, info.versionCode, info.applicationInfo.uid, appId);
            String loginModuleInfo = "OAuthLoginMod/" + OAuthLogin.getVersion();
            useragent = String.valueOf(useragent) + " " + appInfo.replaceAll("\\s", "") + " " + loginModuleInfo.replaceAll("\\s", "");
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)("not installed app : " + packageName));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return useragent;
    }

    public String getLocaleString(Context context) {
        String strLanguage = "ko_KR";
        try {
            Locale systemLocale = context.getResources().getConfiguration().locale;
            strLanguage = systemLocale.toString();
            if (TextUtils.isEmpty((CharSequence)strLanguage)) {
                return "ko_KR";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strLanguage;
    }

    public static boolean isAppExist(Context context, String packageName) {
        block4: {
            try {
                if (!TextUtils.isEmpty((CharSequence)packageName)) break block4;
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        Intent intent = context.getPackageManager().getLaunchIntentForPackage(packageName);
        if (intent == null) {
            Log.i((String)TAG, (String)(String.valueOf(packageName) + " is not installed."));
            return false;
        }
        return true;
    }

    public static boolean isIntentFilterExist(Context context, String intentName) {
        List list = context.getPackageManager().queryIntentActivities(new Intent(intentName), 128);
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            ResolveInfo resolveInfo = (ResolveInfo)iterator.next();
            if (OAuthLoginDefine.DEVELOPER_VERSION) {
                Log.d((String)TAG, (String)("intent filter name:" + intentName));
                Log.d((String)TAG, (String)("package name:" + resolveInfo.activityInfo.packageName + ", " + resolveInfo.activityInfo.name));
            }
            return true;
        }
        return false;
    }

    public static String getPrimaryNaverOAuth2ndAppPackageName(Context context) {
        try {
            String[] appList = new String[]{"com.nhn.android.appstore"};
            List list = context.getPackageManager().queryIntentActivities(new Intent("com.naver.android.action.OAUTH2_LOGIN"), 128);
            String[] stringArray = appList;
            int n = appList.length;
            int n2 = 0;
            while (n2 < n) {
                String appName = stringArray[n2];
                for (ResolveInfo resolveInfo : list) {
                    if (OAuthLoginDefine.DEVELOPER_VERSION) {
                        Log.d((String)TAG, (String)("package name:" + resolveInfo.activityInfo.packageName + ", " + resolveInfo.activityInfo.name));
                    }
                    if (!resolveInfo.activityInfo.packageName.equals(appName)) continue;
                    return resolveInfo.activityInfo.packageName;
                }
                ++n2;
            }
            if (OAuthLoginDefine.DEVELOPER_VERSION) {
                Log.d((String)TAG, (String)("no app assinged in order-list. package name:" + ((ResolveInfo)list.get((int)0)).activityInfo.packageName + ", " + ((ResolveInfo)list.get((int)0)).activityInfo.name));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getApplicationName(Context context) {
        PackageManager lPackageManager = context.getPackageManager();
        String appName = "NAVER";
        try {
            ApplicationInfo lApplicationInfo = lPackageManager.getApplicationInfo(context.getApplicationInfo().packageName, 0);
            appName = (String)lPackageManager.getApplicationLabel(lApplicationInfo);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return appName;
    }

    public static String getPackageName(Context context) {
        String packageName = context.getPackageName();
        return packageName;
    }
}

