/*
 * Decompiled with CFR 0.152.
 */
package kr.co.cashslide;

import android.content.Context;
import android.os.Looper;
import android.util.Log;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import java.io.IOException;

class AdvertisingIdHelper {
    private static final String TAG = "CashslideSDK";
    private static String adId;
    private static boolean isLimitAdTrackingEnabled;
    private static boolean hasAdvertisingId;

    private AdvertisingIdHelper() {
    }

    public static String getAdId() {
        return adId;
    }

    public static boolean hasAdvertisingId() {
        return hasAdvertisingId;
    }

    public static boolean isLimitAdTrackingEnabled() {
        return isLimitAdTrackingEnabled;
    }

    private static void setAdInfo(String id, boolean isLimit) {
        if (adId != null && adId.equals(id) && isLimitAdTrackingEnabled == isLimit) {
            return;
        }
        adId = id;
        isLimitAdTrackingEnabled = isLimit;
        hasAdvertisingId = true;
    }

    public static void updateAdIdSynchronized(Context context) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            Log.e((String)TAG, (String)"cannot update advertising id from main thread!");
            return;
        }
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)context);
            AdvertisingIdHelper.setAdInfo(info.getId(), info.isLimitAdTrackingEnabled());
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)("Google Play Services not available - " + e.getMessage()));
        }
        catch (GooglePlayServicesNotAvailableException e) {
            Log.w((String)TAG, (String)("Google Play Services not available - " + e.getMessage()));
        }
        catch (GooglePlayServicesRepairableException e) {
            Log.w((String)TAG, (String)("Google Play Services not available - " + e.getMessage()));
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)("Google Play Services not available - " + e.getMessage()));
        }
    }

    public static void updateAdId(final Context context) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                AdvertisingIdHelper.updateAdIdSynchronized(context);
            }
        }).start();
    }

    static {
        hasAdvertisingId = false;
    }
}

