/*
 * Decompiled with CFR 0.152.
 */
package com.nasmob.nswitch.sdk;

import java.lang.ref.WeakReference;
import java.util.Timer;
import java.util.TimerTask;

abstract class ThreadCommand {
    protected int errorCode = 0;
    private TimerTask task;
    private Timer timer;
    protected WeakReference<OnCommandCompletedListener> onCommandCompletedListener;
    protected Thread thread = null;

    ThreadCommand() {
    }

    public abstract void handleCommand();

    public void setOnCommandResult(OnCommandCompletedListener onCommandCompletedListener) {
        this.onCommandCompletedListener = new WeakReference<OnCommandCompletedListener>(onCommandCompletedListener);
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void execute() {
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                ThreadCommand.this.handleCommand();
            }
        });
        this.task = new TimerTask(){

            @Override
            public void run() {
                if (ThreadCommand.this.thread.isAlive()) {
                    ThreadCommand.this.errorCode = -1;
                    this.cancel();
                    ThreadCommand.this.fire();
                }
            }
        };
        this.timer = new Timer();
        this.thread.start();
        this.timer.schedule(this.task, 2000L);
    }

    public void fire() {
        OnCommandCompletedListener ref;
        if (this.onCommandCompletedListener != null && (ref = (OnCommandCompletedListener)this.onCommandCompletedListener.get()) != null) {
            ref.onCommandCompleted(this);
        }
    }

    public void cancel() {
        this.thread.interrupt();
    }

    public static interface OnCommandCompletedListener {
        public void onCommandCompleted(ThreadCommand var1);
    }
}

