/*
 * Decompiled with CFR 0.152.
 */
package kr.co.cashslide;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Log;
import java.util.Date;
import java.util.Locale;
import org.json.JSONObject;

class ActionCache {
    private static final String LOG_TAG = "CashslideSDK";
    private static final String PREFS_NAME = "CashslideActions";
    private static final String RESID_APP_FIRST_LAUNCHED = "appFirstLaunched";
    private static final String RESID_MISSION_COMPLETED = "missionCompleted";
    private static final String RESID_RECOMMEND_APP_ID = "recommendAppId";
    private static final String RESID_RECOMMEND_DATE = "recommendDate";
    private static final String RESID_RETENTION_TRACKING = "retentionTracking";
    private static final int MAX_RECOMMEND_DAY = 8;
    private Context mContext;
    private long retentionCount = 0L;

    public ActionCache(Context context) {
        this.mContext = context;
    }

    public boolean isAppFirstLaunched(String appId) {
        boolean result = true;
        try {
            SharedPreferences cache = this.mContext.getSharedPreferences(PREFS_NAME, 0);
            String key = String.format("%s_%s", RESID_APP_FIRST_LAUNCHED, appId);
            result = cache.getBoolean(key, true);
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("error:" + e.getMessage()));
        }
        return result;
    }

    public void saveAppFirstLaunched(String appId) {
        try {
            SharedPreferences cache = this.mContext.getSharedPreferences(PREFS_NAME, 0);
            SharedPreferences.Editor editor = cache.edit();
            String key = String.format("%s_%s", RESID_APP_FIRST_LAUNCHED, appId);
            editor.putBoolean(key, false);
            editor.commit();
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("error:" + e.getMessage()));
        }
    }

    public boolean isMissionCompleted(String appId) {
        boolean result = true;
        try {
            SharedPreferences cache = this.mContext.getSharedPreferences(PREFS_NAME, 0);
            String key = String.format("%s_%s", RESID_MISSION_COMPLETED, appId);
            result = cache.getBoolean(key, false);
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("error:" + e.getMessage()));
        }
        return result;
    }

    public void saveMissionCompleted(String appId) {
        try {
            SharedPreferences cache = this.mContext.getSharedPreferences(PREFS_NAME, 0);
            SharedPreferences.Editor editor = cache.edit();
            String key = String.format("%s_%s", RESID_MISSION_COMPLETED, appId);
            editor.putBoolean(key, true);
            editor.commit();
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("error:" + e.getMessage()));
        }
    }

    public void saveRecommendAppId(String appId) {
        try {
            SharedPreferences cache = this.mContext.getSharedPreferences(PREFS_NAME, 0);
            SharedPreferences.Editor editor = cache.edit();
            editor.putString(RESID_RECOMMEND_APP_ID, appId);
            editor.commit();
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("error:" + e.getMessage()));
        }
    }

    public String getRecommendAppId() {
        String result = "";
        try {
            SharedPreferences cache = this.mContext.getSharedPreferences(PREFS_NAME, 0);
            result = cache.getString(RESID_RECOMMEND_APP_ID, "");
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("error:" + e.getMessage()));
        }
        return result;
    }

    private void setRecommendDate(String appId, String json) {
        try {
            SharedPreferences cache = this.mContext.getSharedPreferences(PREFS_NAME, 0);
            SharedPreferences.Editor editor = cache.edit();
            String key = String.format("%s_%s", RESID_RECOMMEND_DATE, appId);
            editor.putString(key, json);
            editor.commit();
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("error:" + e.getMessage()));
        }
    }

    private String getRecommendDate(String appId) {
        String result = "";
        try {
            SharedPreferences cache = this.mContext.getSharedPreferences(PREFS_NAME, 0);
            String key = String.format("%s_%s", RESID_RECOMMEND_DATE, appId);
            result = cache.getString(key, "");
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("error:" + e.getMessage()));
        }
        return result;
    }

    public void setRetentionTracking(boolean enable) {
        try {
            SharedPreferences cache = this.mContext.getSharedPreferences(PREFS_NAME, 0);
            SharedPreferences.Editor editor = cache.edit();
            editor.putBoolean(RESID_RETENTION_TRACKING, enable);
            editor.commit();
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("error:" + e.getMessage()));
        }
    }

    public boolean isRetentionTrackingEnabled() {
        boolean result = true;
        try {
            SharedPreferences cache = this.mContext.getSharedPreferences(PREFS_NAME, 0);
            result = cache.getBoolean(RESID_RETENTION_TRACKING, true);
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("error:" + e.getMessage()));
        }
        return result;
    }

    public boolean isRecommendAvailable(String appId) {
        try {
            String jsonString = this.getRecommendDate(appId);
            if (TextUtils.isEmpty((CharSequence)jsonString)) {
                return true;
            }
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("error:" + e.getMessage()));
        }
        return false;
    }

    public boolean isRetentionAvailable(String appId) {
        try {
            if (!this.isRetentionTrackingEnabled()) {
                return false;
            }
            String jsonString = this.getRecommendDate(appId);
            if (TextUtils.isEmpty((CharSequence)jsonString)) {
                return false;
            }
            JSONObject json = new JSONObject(jsonString);
            long day = 86400000L;
            long now = System.currentTimeMillis() / 86400000L;
            long start = json.getLong("start") / 86400000L;
            long last = json.getLong("last") / 86400000L;
            boolean differentDay = now != last;
            boolean withinLimit = now < start + 8L;
            this.retentionCount = now - start;
            return differentDay && withinLimit;
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("error:" + e.getMessage()));
            return false;
        }
    }

    public void saveRecommend(String appId) {
        try {
            String jsonString = this.getRecommendDate(appId);
            if (TextUtils.isEmpty((CharSequence)jsonString)) {
                jsonString = String.format(Locale.ENGLISH, "{'start':%d,'last':%d}", new Date().getTime(), 0);
            }
            JSONObject json = new JSONObject(jsonString);
            json.put("last", new Date().getTime());
            this.setRecommendDate(appId, json.toString());
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("error:" + e.getMessage()));
        }
    }

    public long getRetentionCount() {
        return this.retentionCount;
    }
}

