/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig;

import com.android.apksig.apk.ApkFormatException;
import com.android.apksig.apk.ApkUtils;
import com.android.apksig.internal.apk.v2.VerificationModule;
import com.android.apksig.util.DataSource;
import com.android.apksig.util.DataSources;
import com.android.apksig.zip.ZipFormatException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApkSigningBlockExtractor {
    private File mApkFile;
    private DataSource mApkDataSource;
    private List<VerificationModule.Result.SignerInfo.ContentDigest> mContentDigests = new ArrayList<VerificationModule.Result.SignerInfo.ContentDigest>();

    public ApkSigningBlockExtractor(File apkFile) {
        this.mApkFile = apkFile;
    }

    public List<VerificationModule.Result.SignerInfo.ContentDigest> getContentDigests() {
        return this.mContentDigests;
    }

    public String findById(int id) {
        String algId = null;
        switch (id) {
            case 257: {
                algId = "SHA256";
            }
            case 258: {
                algId = "SHA512";
            }
            case 259: {
                algId = "SHA256";
            }
            case 260: {
                algId = "SHA512";
            }
            case 513: {
                algId = "SHA256";
            }
            case 514: {
                algId = "SHA512";
            }
            case 769: {
                algId = "SHA512";
            }
        }
        return algId;
    }

    public void extractSigningBlockFromApk() throws IOException, ApkFormatException, VerificationModule.SignatureNotFoundException, NoSuchAlgorithmException {
        Closeable in = null;
        try {
            DataSource apk;
            if (this.mApkDataSource != null) {
                apk = this.mApkDataSource;
            } else if (this.mApkFile != null) {
                RandomAccessFile f = new RandomAccessFile(this.mApkFile, "r");
                in = f;
                apk = DataSources.asDataSource(f, 0L, f.length());
            } else {
                throw new IllegalStateException("APK not provided");
            }
            this.extract(apk);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private void extract(DataSource apk) throws IOException, ApkFormatException, NoSuchAlgorithmException {
        ApkUtils.ZipSections zipSections;
        try {
            zipSections = ApkUtils.findZipSections(apk);
        }
        catch (ZipFormatException e) {
            throw new ApkFormatException("Malformed APK: not a ZIP archive", e);
        }
        VerificationModule.Result v2Result = null;
        try {
            v2Result = VerificationModule.verify(apk, zipSections);
            for (VerificationModule.Result.SignerInfo signerInfo : v2Result.signers) {
                for (VerificationModule.Result.SignerInfo.ContentDigest expected : signerInfo.contentDigests) {
                    this.mContentDigests.add(expected);
                }
            }
        }
        catch (VerificationModule.SignatureNotFoundException signatureNotFoundException) {
            // empty catch block
        }
        if (!v2Result.containsErrors()) {
            // empty if block
        }
    }
}

